/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.List;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.Struct;
import org.hibernate.boot.model.internal.AggregateComponentSecondPass;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameImpl;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.type.descriptor.java.spi.EmbeddableAggregateJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public final class AggregateComponentBinder {
    private AggregateComponentBinder() {
    }

    public static void processAggregate(Component component, PropertyHolder propertyHolder, PropertyData inferredData, ClassDetails componentClassDetails, AnnotatedColumns columns, MetadataBuildingContext context) {
        if (AggregateComponentBinder.isAggregate(inferredData.getAttributeMember(), componentClassDetails, context)) {
            InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
            TypeConfiguration typeConfiguration = metadataCollector.getTypeConfiguration();
            QualifiedName structQualifiedName = AggregateComponentBinder.determineStructName(columns, inferredData, componentClassDetails, context);
            String structName = structQualifiedName == null ? null : structQualifiedName.render();
            typeConfiguration.getJavaTypeRegistry().resolveDescriptor(component.getComponentClass(), () -> new EmbeddableAggregateJavaType(component.getComponentClass(), structName));
            component.setStructName(structQualifiedName);
            component.setStructColumnNames(AggregateComponentBinder.determineStructAttributeNames(inferredData, componentClassDetails));
            BasicValueBinder basicValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ATTRIBUTE, component, context);
            basicValueBinder.setReturnedClassName(inferredData.getClassOrElementType().getName());
            basicValueBinder.setColumns(columns);
            basicValueBinder.setPersistentClassName(propertyHolder.getClassName());
            basicValueBinder.setType(inferredData.getAttributeMember(), inferredData.getPropertyType(), inferredData.getDeclaringClass().getName(), null);
            BasicValue propertyValue = basicValueBinder.make();
            AggregateColumn aggregateColumn = (AggregateColumn)propertyValue.getColumn();
            if (structName != null && aggregateColumn.getSqlType() == null) {
                if (inferredData.getAttributeMember().isArray() || inferredData.getAttributeMember().isPlural()) {
                    aggregateColumn.setSqlTypeCode(AggregateComponentBinder.getStructPluralSqlTypeCode(context));
                    aggregateColumn.setSqlType(context.getMetadataCollector().getDatabase().getDialect().getArrayTypeName(null, structName, null));
                } else {
                    aggregateColumn.setSqlTypeCode(2002);
                    aggregateColumn.setSqlType(structName);
                }
            }
            component.setAggregateColumn(aggregateColumn);
            context.getMetadataCollector().addSecondPass(new AggregateComponentSecondPass(propertyHolder, component, componentClassDetails, inferredData.getPropertyName(), context));
        }
    }

    private static int getStructPluralSqlTypeCode(MetadataBuildingContext context) {
        int arrayTypeCode = context.getPreferredSqlTypeCodeForArray();
        switch (arrayTypeCode) {
            case 2003: {
                return 3016;
            }
            case 4000: {
                return 3017;
            }
        }
        throw new UnsupportedOperationException("Dialect does not support structured array types: " + context.getMetadataCollector().getDatabase().getDialect().getClass().getName());
    }

    private static QualifiedName determineStructName(AnnotatedColumns columns, PropertyData inferredData, ClassDetails returnedClassOrElement, MetadataBuildingContext context) {
        Struct struct;
        MemberDetails property = inferredData.getAttributeMember();
        if (property != null) {
            String sqlType;
            List<AnnotatedColumn> columnList;
            struct = (Struct)property.getDirectAnnotationUsage(Struct.class);
            if (struct != null) {
                return AggregateComponentBinder.toQualifiedName(struct, context);
            }
            JdbcTypeCode jdbcTypeCodeAnn = (JdbcTypeCode)property.getDirectAnnotationUsage(JdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null && (jdbcTypeCodeAnn.value() == 2002 || jdbcTypeCodeAnn.value() == 3016 || jdbcTypeCodeAnn.value() == 3017) && columns != null && (columnList = columns.getColumns()).size() == 1 && (sqlType = columnList.get(0).getSqlType()) != null) {
                if (sqlType.contains(".")) {
                    return QualifiedNameParser.INSTANCE.parse(sqlType);
                }
                return new QualifiedNameParser.NameParts(null, null, context.getMetadataCollector().getDatabase().toIdentifier(sqlType));
            }
        }
        if ((struct = (Struct)returnedClassOrElement.getDirectAnnotationUsage(Struct.class)) != null) {
            return AggregateComponentBinder.toQualifiedName(struct, context);
        }
        return null;
    }

    private static QualifiedName toQualifiedName(Struct struct, MetadataBuildingContext context) {
        Database database = context.getMetadataCollector().getDatabase();
        return new QualifiedNameImpl(database.toIdentifier(struct.catalog()), database.toIdentifier(struct.schema()), database.toIdentifier(struct.name()));
    }

    private static String[] determineStructAttributeNames(PropertyData inferredData, ClassDetails returnedClassOrElement) {
        Struct struct;
        MemberDetails property = inferredData.getAttributeMember();
        if (property != null && (struct = (Struct)property.getDirectAnnotationUsage(Struct.class)) != null) {
            return struct.attributes();
        }
        struct = (Struct)returnedClassOrElement.getDirectAnnotationUsage(Struct.class);
        if (struct != null) {
            return struct.attributes();
        }
        return null;
    }

    private static boolean isAggregate(MemberDetails property, ClassDetails returnedClass, MetadataBuildingContext context) {
        if (property != null) {
            if (property.hasDirectAnnotationUsage(Struct.class)) {
                return true;
            }
            JdbcTypeCode jdbcTypeCode = (JdbcTypeCode)property.getDirectAnnotationUsage(JdbcTypeCode.class);
            if (jdbcTypeCode != null) {
                switch (jdbcTypeCode.value()) {
                    case 2002: 
                    case 2009: 
                    case 3001: 
                    case 3016: 
                    case 3017: 
                    case 3018: 
                    case 3019: {
                        return true;
                    }
                }
            }
        }
        if (returnedClass != null) {
            return returnedClass.hasDirectAnnotationUsage(Struct.class);
        }
        return false;
    }
}

