---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token RubyGems API token'
---

## Description

The response body contains content that matches the pattern of a RubyGems API token was identified. RubyGems tokens are used for accessing the API or publishing packages. RubyGems tokens can be created with specific permissions or scopes. Depending on the permissions and scope, a malicious actor with access to this token can add or remove packages, add or remove owners, or view the dashboard.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke the API token:

- Sign in to your RubyGems account and access <https://rubygems.org/settings/edit>
- Scroll down to and select "API Keys" or go to <https://rubygems.org/profile/api_keys>
- Find the identified token and select "Delete"
- When prompted, select "OK" in the dialog.

For more information, please see the [RubyGems documentation on API tokens](https://guides.rubygems.org/api-key-scopes/).

## Details

| ID     | Aggregated | CWE | Type | Risk |
|:-------|:-----------|:----|:-----|:-----|
| 798.97 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
