/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.tools.plugin.edit;

import javax.swing.SwingUtilities;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.tools.api.EditWindowController;
import org.gephi.ui.tools.plugin.edit.EditToolTopComponent;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class EditWindowControllerImpl
implements EditWindowController {
    public EditToolTopComponent findInstance() {
        return (EditToolTopComponent)WindowManager.getDefault().findTopComponent("EditToolTopComponent");
    }

    private void runAction(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void openEditWindow() {
        this.runAction(new Runnable(){

            @Override
            public void run() {
                EditToolTopComponent topComponent = EditWindowControllerImpl.this.findInstance();
                topComponent.open();
                topComponent.requestActive();
            }
        });
    }

    public void closeEditWindow() {
        this.runAction(new Runnable(){

            @Override
            public void run() {
                EditToolTopComponent topComponent = EditWindowControllerImpl.this.findInstance();
                topComponent.disableEdit();
                topComponent.close();
            }
        });
    }

    public boolean isOpen() {
        IsOpenRunnable runnable = new IsOpenRunnable();
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return runnable.open;
    }

    public void editNode(final Node node) {
        this.runAction(new Runnable(){

            @Override
            public void run() {
                EditToolTopComponent topComponent = EditWindowControllerImpl.this.findInstance();
                topComponent.editNode(node);
            }
        });
    }

    public void editNodes(final Node[] nodes) {
        this.runAction(new Runnable(){

            @Override
            public void run() {
                EditToolTopComponent topComponent = EditWindowControllerImpl.this.findInstance();
                topComponent.editNodes(nodes);
            }
        });
    }

    public void editEdge(final Edge edge) {
        this.runAction(new Runnable(){

            @Override
            public void run() {
                EditToolTopComponent topComponent = EditWindowControllerImpl.this.findInstance();
                topComponent.editEdge(edge);
            }
        });
    }

    public void editEdges(final Edge[] edges) {
        this.runAction(new Runnable(){

            @Override
            public void run() {
                EditToolTopComponent topComponent = EditWindowControllerImpl.this.findInstance();
                topComponent.editEdges(edges);
            }
        });
    }

    public void disableEdit() {
        this.runAction(new Runnable(){

            @Override
            public void run() {
                EditToolTopComponent topComponent = EditWindowControllerImpl.this.findInstance();
                topComponent.disableEdit();
            }
        });
    }

    class IsOpenRunnable
    implements Runnable {
        boolean open = false;

        IsOpenRunnable() {
        }

        @Override
        public void run() {
            EditToolTopComponent topComponent = EditWindowControllerImpl.this.findInstance();
            this.open = topComponent != null && topComponent.isOpened();
        }
    }
}

