﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WellArchitected {
namespace Model {
class CreateLensVersionResult {
 public:
  AWS_WELLARCHITECTED_API CreateLensVersionResult() = default;
  AWS_WELLARCHITECTED_API CreateLensVersionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WELLARCHITECTED_API CreateLensVersionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN for the lens.</p>
   */
  inline const Aws::String& GetLensArn() const { return m_lensArn; }
  template <typename LensArnT = Aws::String>
  void SetLensArn(LensArnT&& value) {
    m_lensArnHasBeenSet = true;
    m_lensArn = std::forward<LensArnT>(value);
  }
  template <typename LensArnT = Aws::String>
  CreateLensVersionResult& WithLensArn(LensArnT&& value) {
    SetLensArn(std::forward<LensArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the lens.</p>
   */
  inline const Aws::String& GetLensVersion() const { return m_lensVersion; }
  template <typename LensVersionT = Aws::String>
  void SetLensVersion(LensVersionT&& value) {
    m_lensVersionHasBeenSet = true;
    m_lensVersion = std::forward<LensVersionT>(value);
  }
  template <typename LensVersionT = Aws::String>
  CreateLensVersionResult& WithLensVersion(LensVersionT&& value) {
    SetLensVersion(std::forward<LensVersionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateLensVersionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_lensArn;
  bool m_lensArnHasBeenSet = false;

  Aws::String m_lensVersion;
  bool m_lensVersionHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
