// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32wb55.svd, see https://github.com/tinygo-org/stm32-svd

// +build stm32,stm32wb55

// STM32WBxx_CM4
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32WB55"
	CPU          = "CM4"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// System window watchdog
	IRQ_WWDG = 0

	// External interrupt/event controller
	IRQ_PVD = 1

	// Real-time clock
	IRQ_RTC_TAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// Flash
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// Direct memory access controller
	IRQ_DMA1_Channel1 = 11

	// Direct memory access controller
	IRQ_DMA1_Channel2 = 12

	// Direct memory access controller
	IRQ_DMA1_Channel3 = 13

	// Direct memory access controller
	IRQ_DMA1_Channel4 = 14

	// Direct memory access controller
	IRQ_DMA1_Channel5 = 15

	// Direct memory access controller
	IRQ_DMA1_Channel6 = 16

	// Direct memory access controller
	IRQ_DMA1_Channel7 = 17

	// Analog to Digital Converter instance 1
	IRQ_ADC1 = 18

	// Universal serial bus full-speed device interface
	IRQ_USB_HP = 19

	// Universal serial bus full-speed device interface
	IRQ_USB_LP = 20

	// External interrupt/event controller
	IRQ_C2SEV = 21

	// Comparator instance 1
	IRQ_COMP = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// Advanced-timers
	IRQ_TIM1_BRK = 24

	// Advanced-timers
	IRQ_TIM1_UP = 25

	// Advanced-timers
	IRQ_TIM1_TRG_COM_TIM17 = 26

	// Advanced-timers
	IRQ_TIM1_CC = 27

	// General-purpose-timers
	IRQ_TIM2 = 28

	// PKA
	IRQ_PKA = 29

	// Inter-integrated circuit
	IRQ_I2C1_EV = 30

	// Inter-integrated circuit
	IRQ_I2C1_ER = 31

	IRQ_I2C3_EV = 32

	IRQ_I2C3_ER = 33

	// Serial peripheral interface/Inter-IC sound
	IRQ_SPI1 = 34

	IRQ_SPI2 = 35

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 36

	IRQ_LPUART1 = 37

	// Serial audio interface
	IRQ_SAI1 = 38

	// Touch sensing controller
	IRQ_TSC = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Real-time clock
	IRQ_RTC_ALARM = 41

	// Clock recovery system
	IRQ_CRS_IT = 42

	// Power control
	IRQ_PWR_SOTF = 43

	// IPCC
	IRQ_IPCC_C1_RX_IT = 44

	// IPCC
	IRQ_IPCC_C1_TX_IT = 45

	// HSEM
	IRQ_HSEM = 46

	// Low power timer
	IRQ_LPTIM1 = 47

	IRQ_LPTIM2 = 48

	// Liquid crystal display controller
	IRQ_LCD = 49

	// QuadSPI interface
	IRQ_QUADSPI = 50

	// Advanced encryption standard hardware accelerator 1
	IRQ_AES1 = 51

	// Advanced encryption standard hardware accelerator 1
	IRQ_AES2 = 52

	// Random number generator
	IRQ_True_RNG = 53

	// Floting point unit
	IRQ_FPU = 54

	// Direct memory access controller
	IRQ_DMA2_CH1 = 55

	// Direct memory access controller
	IRQ_DMA2_CH2 = 56

	// Direct memory access controller
	IRQ_DMA2_CH3 = 57

	// Direct memory access controller
	IRQ_DMA2_CH4 = 58

	// Direct memory access controller
	IRQ_DMA2_CH5 = 59

	// Direct memory access controller
	IRQ_DMA2_CH6 = 60

	// Direct memory access controller
	IRQ_DMA2_CH7 = 61

	// Direct memory access Multiplexer
	IRQ_DMAMUX_OVR = 62

	// Highest interrupt number on this device.
	IRQ_max = 62
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export RTC_TAMP_IRQHandler
func interruptRTC_TAMP() {
	callHandlers(IRQ_RTC_TAMP)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_Channel1_IRQHandler
func interruptDMA1_Channel1() {
	callHandlers(IRQ_DMA1_Channel1)
}

//export DMA1_Channel2_IRQHandler
func interruptDMA1_Channel2() {
	callHandlers(IRQ_DMA1_Channel2)
}

//export DMA1_Channel3_IRQHandler
func interruptDMA1_Channel3() {
	callHandlers(IRQ_DMA1_Channel3)
}

//export DMA1_Channel4_IRQHandler
func interruptDMA1_Channel4() {
	callHandlers(IRQ_DMA1_Channel4)
}

//export DMA1_Channel5_IRQHandler
func interruptDMA1_Channel5() {
	callHandlers(IRQ_DMA1_Channel5)
}

//export DMA1_Channel6_IRQHandler
func interruptDMA1_Channel6() {
	callHandlers(IRQ_DMA1_Channel6)
}

//export DMA1_Channel7_IRQHandler
func interruptDMA1_Channel7() {
	callHandlers(IRQ_DMA1_Channel7)
}

//export ADC1_IRQHandler
func interruptADC1() {
	callHandlers(IRQ_ADC1)
}

//export USB_HP_IRQHandler
func interruptUSB_HP() {
	callHandlers(IRQ_USB_HP)
}

//export USB_LP_IRQHandler
func interruptUSB_LP() {
	callHandlers(IRQ_USB_LP)
}

//export C2SEV_IRQHandler
func interruptC2SEV() {
	callHandlers(IRQ_C2SEV)
}

//export COMP_IRQHandler
func interruptCOMP() {
	callHandlers(IRQ_COMP)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_IRQHandler
func interruptTIM1_BRK() {
	callHandlers(IRQ_TIM1_BRK)
}

//export TIM1_UP_IRQHandler
func interruptTIM1_UP() {
	callHandlers(IRQ_TIM1_UP)
}

//export TIM1_TRG_COM_TIM17_IRQHandler
func interruptTIM1_TRG_COM_TIM17() {
	callHandlers(IRQ_TIM1_TRG_COM_TIM17)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export PKA_IRQHandler
func interruptPKA() {
	callHandlers(IRQ_PKA)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export LPUART1_IRQHandler
func interruptLPUART1() {
	callHandlers(IRQ_LPUART1)
}

//export SAI1_IRQHandler
func interruptSAI1() {
	callHandlers(IRQ_SAI1)
}

//export TSC_IRQHandler
func interruptTSC() {
	callHandlers(IRQ_TSC)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_ALARM_IRQHandler
func interruptRTC_ALARM() {
	callHandlers(IRQ_RTC_ALARM)
}

//export CRS_IT_IRQHandler
func interruptCRS_IT() {
	callHandlers(IRQ_CRS_IT)
}

//export PWR_SOTF_IRQHandler
func interruptPWR_SOTF() {
	callHandlers(IRQ_PWR_SOTF)
}

//export IPCC_C1_RX_IT_IRQHandler
func interruptIPCC_C1_RX_IT() {
	callHandlers(IRQ_IPCC_C1_RX_IT)
}

//export IPCC_C1_TX_IT_IRQHandler
func interruptIPCC_C1_TX_IT() {
	callHandlers(IRQ_IPCC_C1_TX_IT)
}

//export HSEM_IRQHandler
func interruptHSEM() {
	callHandlers(IRQ_HSEM)
}

//export LPTIM1_IRQHandler
func interruptLPTIM1() {
	callHandlers(IRQ_LPTIM1)
}

//export LPTIM2_IRQHandler
func interruptLPTIM2() {
	callHandlers(IRQ_LPTIM2)
}

//export LCD_IRQHandler
func interruptLCD() {
	callHandlers(IRQ_LCD)
}

//export QUADSPI_IRQHandler
func interruptQUADSPI() {
	callHandlers(IRQ_QUADSPI)
}

//export AES1_IRQHandler
func interruptAES1() {
	callHandlers(IRQ_AES1)
}

//export AES2_IRQHandler
func interruptAES2() {
	callHandlers(IRQ_AES2)
}

//export True_RNG_IRQHandler
func interruptTrue_RNG() {
	callHandlers(IRQ_True_RNG)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export DMA2_CH1_IRQHandler
func interruptDMA2_CH1() {
	callHandlers(IRQ_DMA2_CH1)
}

//export DMA2_CH2_IRQHandler
func interruptDMA2_CH2() {
	callHandlers(IRQ_DMA2_CH2)
}

//export DMA2_CH3_IRQHandler
func interruptDMA2_CH3() {
	callHandlers(IRQ_DMA2_CH3)
}

//export DMA2_CH4_IRQHandler
func interruptDMA2_CH4() {
	callHandlers(IRQ_DMA2_CH4)
}

//export DMA2_CH5_IRQHandler
func interruptDMA2_CH5() {
	callHandlers(IRQ_DMA2_CH5)
}

//export DMA2_CH6_IRQHandler
func interruptDMA2_CH6() {
	callHandlers(IRQ_DMA2_CH6)
}

//export DMA2_CH7_IRQHandler
func interruptDMA2_CH7() {
	callHandlers(IRQ_DMA2_CH7)
}

//export DMAMUX_OVR_IRQHandler
func interruptDMAMUX_OVR() {
	callHandlers(IRQ_DMAMUX_OVR)
}

// Peripherals.
var (
	// Direct memory access controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Direct memory access controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// Direct memory access Multiplexer
	DMAMUX1 = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Liquid crystal display controller
	LCD = (*LCD_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Touch sensing controller
	TSC = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Comparator instance 1
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010200)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Flash
	Flash = (*Flash_Type)(unsafe.Pointer(uintptr(0x58004000)))

	// QuadSPI interface
	QUADSPI = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x58000000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x58000400)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x58001000)))

	// Advanced encryption standard hardware accelerator 1
	AES1 = (*AES1_Type)(unsafe.Pointer(uintptr(0x50060000)))

	// Advanced encryption standard hardware accelerator 1
	AES2 = (*AES1_Type)(unsafe.Pointer(uintptr(0x58001800)))

	// HSEM
	HSEM = (*Hardware_Semaphore_Type)(unsafe.Pointer(uintptr(0x58001400)))

	// Analog to Digital Converter instance 1
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040000)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001000)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001c00)))

	// Serial audio interface
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015400)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Serial peripheral interface/Inter-IC sound
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Voltage reference buffer
	VREFBUF = (*VREF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Debug support
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// PKA
	PKA = (*PKA_Type)(unsafe.Pointer(uintptr(0x58002000)))

	// IPCC
	IPCC = (*IPCC_Type)(unsafe.Pointer(uintptr(0x58000c00)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x58000800)))

	// Clock recovery system
	CRS = (*CRS_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Universal serial bus full-speed device interface
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x40006800)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// ADC common registers
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040300)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000c00)))

	// Low power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// Universal synchronous asynchronous receiver transmitter
	LPUART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Serial peripheral interface/Inter-IC sound
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))
)

// Direct memory access controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
}

// DMA.ISR: interrupt status register
func (o *DMA_Type) SetISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetISR_GIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetISR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetISR_GIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetISR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// DMA.IFCR: interrupt flag clear register
func (o *DMA_Type) SetIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetIFCR_CGIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIFCR_CGIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIFCR_CGIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIFCR_CGIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetIFCR_CGIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetIFCR_CGIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetIFCR_CGIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIFCR_CGIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetIFCR_CGIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIFCR_CGIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIFCR_CGIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIFCR_CGIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIFCR_CGIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIFCR_CGIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}

// DMA.CCR1: channel x configuration register
func (o *DMA_Type) SetCCR1_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR1_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR1_PL(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR1_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR1_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR1_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR1_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR1_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR1_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR1_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR1_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR1_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR1_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR1_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR1_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR1_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR1_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR1_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR1_EN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR1_EN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}

// DMA.CNDTR1: channel x number of data register
func (o *DMA_Type) SetCNDTR1_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR1.Reg, volatile.LoadUint32(&o.CNDTR1.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR1_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR1.Reg) & 0xffff
}

// DMA.CPAR1: channel x peripheral address register
func (o *DMA_Type) SetCPAR1(value uint32) {
	volatile.StoreUint32(&o.CPAR1.Reg, value)
}
func (o *DMA_Type) GetCPAR1() uint32 {
	return volatile.LoadUint32(&o.CPAR1.Reg)
}

// DMA.CMAR1: channel x memory address register
func (o *DMA_Type) SetCMAR1(value uint32) {
	volatile.StoreUint32(&o.CMAR1.Reg, value)
}
func (o *DMA_Type) GetCMAR1() uint32 {
	return volatile.LoadUint32(&o.CMAR1.Reg)
}

// DMA.CCR2: channel x configuration register
func (o *DMA_Type) SetCCR2_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR2_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR2_PL(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR2_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR2_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR2_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR2_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR2_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR2_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR2_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR2_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR2_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR2_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR2_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR2_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR2_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR2_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR2_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR2_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR2_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR2_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR2_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR2_EN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR2_EN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}

// DMA.CNDTR2: channel x number of data register
func (o *DMA_Type) SetCNDTR2_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR2.Reg, volatile.LoadUint32(&o.CNDTR2.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR2_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR2.Reg) & 0xffff
}

// DMA.CPAR2: channel x peripheral address register
func (o *DMA_Type) SetCPAR2(value uint32) {
	volatile.StoreUint32(&o.CPAR2.Reg, value)
}
func (o *DMA_Type) GetCPAR2() uint32 {
	return volatile.LoadUint32(&o.CPAR2.Reg)
}

// DMA.CMAR2: channel x memory address register
func (o *DMA_Type) SetCMAR2(value uint32) {
	volatile.StoreUint32(&o.CMAR2.Reg, value)
}
func (o *DMA_Type) GetCMAR2() uint32 {
	return volatile.LoadUint32(&o.CMAR2.Reg)
}

// DMA.CCR3: channel x configuration register
func (o *DMA_Type) SetCCR3_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR3_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR3_PL(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR3_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR3_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR3_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR3_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR3_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR3_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR3_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR3_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR3_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR3_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR3_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR3_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR3_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR3_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR3_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR3_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR3_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR3_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR3_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR3_EN(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR3_EN() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0x1
}

// DMA.CNDTR3: channel x number of data register
func (o *DMA_Type) SetCNDTR3_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR3.Reg, volatile.LoadUint32(&o.CNDTR3.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR3_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR3.Reg) & 0xffff
}

// DMA.CPAR3: channel x peripheral address register
func (o *DMA_Type) SetCPAR3(value uint32) {
	volatile.StoreUint32(&o.CPAR3.Reg, value)
}
func (o *DMA_Type) GetCPAR3() uint32 {
	return volatile.LoadUint32(&o.CPAR3.Reg)
}

// DMA.CMAR3: channel x memory address register
func (o *DMA_Type) SetCMAR3(value uint32) {
	volatile.StoreUint32(&o.CMAR3.Reg, value)
}
func (o *DMA_Type) GetCMAR3() uint32 {
	return volatile.LoadUint32(&o.CMAR3.Reg)
}

// DMA.CCR4: channel x configuration register
func (o *DMA_Type) SetCCR4_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR4_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR4_PL(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR4_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR4_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR4_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR4_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR4_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR4_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR4_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR4_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR4_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR4_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR4_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR4_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR4_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR4_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR4_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR4_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR4_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR4_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR4_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR4_EN(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR4_EN() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0x1
}

// DMA.CNDTR4: channel x number of data register
func (o *DMA_Type) SetCNDTR4_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR4.Reg, volatile.LoadUint32(&o.CNDTR4.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR4_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR4.Reg) & 0xffff
}

// DMA.CPAR4: channel x peripheral address register
func (o *DMA_Type) SetCPAR4(value uint32) {
	volatile.StoreUint32(&o.CPAR4.Reg, value)
}
func (o *DMA_Type) GetCPAR4() uint32 {
	return volatile.LoadUint32(&o.CPAR4.Reg)
}

// DMA.CMAR4: channel x memory address register
func (o *DMA_Type) SetCMAR4(value uint32) {
	volatile.StoreUint32(&o.CMAR4.Reg, value)
}
func (o *DMA_Type) GetCMAR4() uint32 {
	return volatile.LoadUint32(&o.CMAR4.Reg)
}

// DMA.CCR5: channel x configuration register
func (o *DMA_Type) SetCCR5_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR5_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR5_PL(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR5_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR5_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR5_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR5_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR5_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR5_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR5_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR5_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR5_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR5_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR5_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR5_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR5_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR5_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR5_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR5_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR5_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR5_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR5_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR5_EN(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR5_EN() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0x1
}

// DMA.CNDTR5: channel x number of data register
func (o *DMA_Type) SetCNDTR5_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR5.Reg, volatile.LoadUint32(&o.CNDTR5.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR5_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR5.Reg) & 0xffff
}

// DMA.CPAR5: channel x peripheral address register
func (o *DMA_Type) SetCPAR5(value uint32) {
	volatile.StoreUint32(&o.CPAR5.Reg, value)
}
func (o *DMA_Type) GetCPAR5() uint32 {
	return volatile.LoadUint32(&o.CPAR5.Reg)
}

// DMA.CMAR5: channel x memory address register
func (o *DMA_Type) SetCMAR5(value uint32) {
	volatile.StoreUint32(&o.CMAR5.Reg, value)
}
func (o *DMA_Type) GetCMAR5() uint32 {
	return volatile.LoadUint32(&o.CMAR5.Reg)
}

// DMA.CCR6: channel x configuration register
func (o *DMA_Type) SetCCR6_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR6_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR6_PL(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR6_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR6_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR6_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR6_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR6_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR6_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR6_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR6_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR6_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR6_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR6_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR6_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR6_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR6_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR6_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR6_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR6_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR6_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR6_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR6_EN(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR6_EN() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0x1
}

// DMA.CNDTR6: channel x number of data register
func (o *DMA_Type) SetCNDTR6_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR6.Reg, volatile.LoadUint32(&o.CNDTR6.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR6_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR6.Reg) & 0xffff
}

// DMA.CPAR6: channel x peripheral address register
func (o *DMA_Type) SetCPAR6(value uint32) {
	volatile.StoreUint32(&o.CPAR6.Reg, value)
}
func (o *DMA_Type) GetCPAR6() uint32 {
	return volatile.LoadUint32(&o.CPAR6.Reg)
}

// DMA.CMAR6: channel x memory address register
func (o *DMA_Type) SetCMAR6(value uint32) {
	volatile.StoreUint32(&o.CMAR6.Reg, value)
}
func (o *DMA_Type) GetCMAR6() uint32 {
	return volatile.LoadUint32(&o.CMAR6.Reg)
}

// DMA.CCR7: channel x configuration register
func (o *DMA_Type) SetCCR7_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR7_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR7_PL(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR7_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR7_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR7_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR7_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR7_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR7_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR7_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR7_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR7_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR7_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR7_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR7_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR7_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR7_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR7_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR7_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR7_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR7_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR7_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR7_EN(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR7_EN() uint32 {
	return volatile.LoadUint32(&o.CCR7.Reg) & 0x1
}

// DMA.CNDTR7: channel x number of data register
func (o *DMA_Type) SetCNDTR7_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR7.Reg, volatile.LoadUint32(&o.CNDTR7.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR7_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR7.Reg) & 0xffff
}

// DMA.CPAR7: channel x peripheral address register
func (o *DMA_Type) SetCPAR7(value uint32) {
	volatile.StoreUint32(&o.CPAR7.Reg, value)
}
func (o *DMA_Type) GetCPAR7() uint32 {
	return volatile.LoadUint32(&o.CPAR7.Reg)
}

// DMA.CMAR7: channel x memory address register
func (o *DMA_Type) SetCMAR7(value uint32) {
	volatile.StoreUint32(&o.CMAR7.Reg, value)
}
func (o *DMA_Type) GetCMAR7() uint32 {
	return volatile.LoadUint32(&o.CMAR7.Reg)
}

// Direct memory access Multiplexer
type DMAMUX_Type struct {
	C0CR  volatile.Register32 // 0x0
	C1CR  volatile.Register32 // 0x4
	C2CR  volatile.Register32 // 0x8
	C3CR  volatile.Register32 // 0xC
	C4CR  volatile.Register32 // 0x10
	C5CR  volatile.Register32 // 0x14
	C6CR  volatile.Register32 // 0x18
	C7CR  volatile.Register32 // 0x1C
	C8CR  volatile.Register32 // 0x20
	C9CR  volatile.Register32 // 0x24
	C10CR volatile.Register32 // 0x28
	C11CR volatile.Register32 // 0x2C
	C12CR volatile.Register32 // 0x30
	C13CR volatile.Register32 // 0x34
	_     [72]byte
	CSR   volatile.Register32 // 0x80
	CFR   volatile.Register32 // 0x84
	_     [120]byte
	RG0CR volatile.Register32 // 0x100
	RG1CR volatile.Register32 // 0x104
	RG2CR volatile.Register32 // 0x108
	RG3CR volatile.Register32 // 0x10C
	_     [48]byte
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// DMAMUX.C0CR: DMA Multiplexer Channel 0 Control register
func (o *DMAMUX_Type) SetC0CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC0CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC0CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC0CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC0CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC0CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC0CR_SE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC0CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC0CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC0CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC0CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC0CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC0CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC0CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C0CR.Reg) & 0xff
}

// DMAMUX.C1CR: DMA Multiplexer Channel 1 Control register
func (o *DMAMUX_Type) SetC1CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC1CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC1CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC1CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC1CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC1CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC1CR_SE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC1CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC1CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC1CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC1CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC1CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC1CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC1CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C1CR.Reg) & 0xff
}

// DMAMUX.C2CR: DMA Multiplexer Channel 2 Control register
func (o *DMAMUX_Type) SetC2CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC2CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC2CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC2CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC2CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC2CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC2CR_SE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC2CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC2CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC2CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC2CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC2CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC2CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC2CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C2CR.Reg) & 0xff
}

// DMAMUX.C3CR: DMA Multiplexer Channel 3 Control register
func (o *DMAMUX_Type) SetC3CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC3CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC3CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC3CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC3CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC3CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC3CR_SE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC3CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC3CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC3CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC3CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC3CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC3CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC3CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C3CR.Reg) & 0xff
}

// DMAMUX.C4CR: DMA Multiplexer Channel 4 Control register
func (o *DMAMUX_Type) SetC4CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC4CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC4CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC4CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC4CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC4CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC4CR_SE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC4CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC4CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC4CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC4CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC4CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC4CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC4CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C4CR.Reg) & 0xff
}

// DMAMUX.C5CR: DMA Multiplexer Channel 5 Control register
func (o *DMAMUX_Type) SetC5CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC5CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC5CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC5CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC5CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC5CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC5CR_SE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC5CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC5CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC5CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC5CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC5CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC5CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC5CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C5CR.Reg) & 0xff
}

// DMAMUX.C6CR: DMA Multiplexer Channel 6 Control register
func (o *DMAMUX_Type) SetC6CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC6CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC6CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC6CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC6CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC6CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC6CR_SE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC6CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC6CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC6CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC6CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC6CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC6CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC6CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C6CR.Reg) & 0xff
}

// DMAMUX.C7CR: DMA Multiplexer Channel 7 Control register
func (o *DMAMUX_Type) SetC7CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC7CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC7CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC7CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC7CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC7CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC7CR_SE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC7CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC7CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC7CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC7CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC7CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC7CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC7CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C7CR.Reg) & 0xff
}

// DMAMUX.C8CR: DMA Multiplexer Channel 8 Control register
func (o *DMAMUX_Type) SetC8CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC8CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC8CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC8CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC8CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC8CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC8CR_SE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC8CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC8CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC8CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC8CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC8CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC8CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC8CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C8CR.Reg) & 0xff
}

// DMAMUX.C9CR: DMA Multiplexer Channel 9 Control register
func (o *DMAMUX_Type) SetC9CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC9CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC9CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC9CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC9CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC9CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC9CR_SE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC9CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC9CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC9CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC9CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC9CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC9CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC9CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C9CR.Reg) & 0xff
}

// DMAMUX.C10CR: DMA Multiplexer Channel 10 Control register
func (o *DMAMUX_Type) SetC10CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC10CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC10CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC10CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC10CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC10CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC10CR_SE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC10CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC10CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC10CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC10CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC10CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC10CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC10CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C10CR.Reg) & 0xff
}

// DMAMUX.C11CR: DMA Multiplexer Channel 11 Control register
func (o *DMAMUX_Type) SetC11CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC11CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC11CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC11CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC11CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC11CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC11CR_SE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC11CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC11CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC11CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC11CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC11CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC11CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC11CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C11CR.Reg) & 0xff
}

// DMAMUX.C12CR: DMA Multiplexer Channel 12 Control register
func (o *DMAMUX_Type) SetC12CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC12CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC12CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC12CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC12CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC12CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC12CR_SE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC12CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC12CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC12CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC12CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC12CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC12CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC12CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C12CR.Reg) & 0xff
}

// DMAMUX.C13CR: DMA Multiplexer Channel 13 Control register
func (o *DMAMUX_Type) SetC13CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC13CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC13CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC13CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC13CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC13CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC13CR_SE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC13CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC13CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC13CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC13CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC13CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC13CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetC13CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C13CR.Reg) & 0xff
}

// DMAMUX.CSR: DMA Multiplexer Channel Status register
func (o *DMAMUX_Type) SetCSR_SOF0(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCSR_SOF0() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCSR_SOF1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCSR_SOF1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCSR_SOF2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCSR_SOF2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCSR_SOF3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCSR_SOF3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCSR_SOF4(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCSR_SOF4() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCSR_SOF5(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCSR_SOF5() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCSR_SOF6(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCSR_SOF6() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCSR_SOF7(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCSR_SOF7() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *DMAMUX_Type) SetCSR_SOF8(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCSR_SOF8() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCSR_SOF9(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCSR_SOF9() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCSR_SOF10(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *DMAMUX_Type) GetCSR_SOF10() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *DMAMUX_Type) SetCSR_SOF11(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *DMAMUX_Type) GetCSR_SOF11() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *DMAMUX_Type) SetCSR_SOF12(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAMUX_Type) GetCSR_SOF12() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *DMAMUX_Type) SetCSR_SOF13(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAMUX_Type) GetCSR_SOF13() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}

// DMAMUX.CFR: DMA Channel Clear Flag Register
func (o *DMAMUX_Type) SetCFR_CSOF0(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCFR_CSOF0() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCFR_CSOF1(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCFR_CSOF1() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCFR_CSOF2(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCFR_CSOF2() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCFR_CSOF3(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCFR_CSOF3() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCFR_CSOF4(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCFR_CSOF4() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCFR_CSOF5(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCFR_CSOF5() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCFR_CSOF6(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCFR_CSOF6() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCFR_CSOF7(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCFR_CSOF7() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x80) >> 7
}
func (o *DMAMUX_Type) SetCFR_CSOF8(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCFR_CSOF8() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCFR_CSOF9(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCFR_CSOF9() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCFR_CSOF10(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x400)|value<<10)
}
func (o *DMAMUX_Type) GetCFR_CSOF10() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x400) >> 10
}
func (o *DMAMUX_Type) SetCFR_CSOF11(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x800)|value<<11)
}
func (o *DMAMUX_Type) GetCFR_CSOF11() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x800) >> 11
}
func (o *DMAMUX_Type) SetCFR_CSOF12(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAMUX_Type) GetCFR_CSOF12() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x1000) >> 12
}
func (o *DMAMUX_Type) SetCFR_CSOF13(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAMUX_Type) GetCFR_CSOF13() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x2000) >> 13
}

// DMAMUX.RG0CR: DMA Request Generator 0 Control Register
func (o *DMAMUX_Type) SetRG0CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG0CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG0CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG0CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG0CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG0CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG0CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG0CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG0CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG0CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG0CR.Reg) & 0x1f
}

// DMAMUX.RG1CR: DMA Request Generator 1 Control Register
func (o *DMAMUX_Type) SetRG1CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG1CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG1CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG1CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG1CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG1CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG1CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG1CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG1CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG1CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG1CR.Reg) & 0x1f
}

// DMAMUX.RG2CR: DMA Request Generator 2 Control Register
func (o *DMAMUX_Type) SetRG2CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG2CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG2CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG2CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG2CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG2CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG2CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG2CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG2CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG2CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG2CR.Reg) & 0x1f
}

// DMAMUX.RG3CR: DMA Request Generator 3 Control Register
func (o *DMAMUX_Type) SetRG3CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG3CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG3CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG3CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG3CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG3CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG3CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG3CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG3CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG3CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG3CR.Reg) & 0x1f
}

// DMAMUX.RGSR: DMA Request Generator Status Register
func (o *DMAMUX_Type) SetRGSR_OF0(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGSR_OF0() uint32 {
	return volatile.LoadUint32(&o.RGSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGSR_OF1(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGSR_OF1() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGSR_OF2(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGSR_OF2() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGSR_OF3(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGSR_OF3() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x8) >> 3
}

// DMAMUX.RGCFR: DMA Request Generator Clear Flag Register
func (o *DMAMUX_Type) SetRGCFR_CSOF0(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGCFR_CSOF0() uint32 {
	return volatile.LoadUint32(&o.RGCFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGCFR_CSOF1(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGCFR_CSOF1() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGCFR_CSOF2(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGCFR_CSOF2() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGCFR_CSOF3(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGCFR_CSOF3() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x8) >> 3
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg)
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// Liquid crystal display controller
type LCD_Type struct {
	CR       volatile.Register32 // 0x0
	FCR      volatile.Register32 // 0x4
	SR       volatile.Register32 // 0x8
	CLR      volatile.Register32 // 0xC
	_        [4]byte
	RAM_COM0 volatile.Register32 // 0x14
	_        [4]byte
	RAM_COM1 volatile.Register32 // 0x1C
	_        [4]byte
	RAM_COM2 volatile.Register32 // 0x24
	_        [4]byte
	RAM_COM3 volatile.Register32 // 0x2C
	_        [4]byte
	RAM_COM4 volatile.Register32 // 0x34
	_        [4]byte
	RAM_COM5 volatile.Register32 // 0x3C
	_        [4]byte
	RAM_COM6 volatile.Register32 // 0x44
	_        [4]byte
	RAM_COM7 volatile.Register32 // 0x4C
}

// LCD.CR: control register
func (o *LCD_Type) SetCR_BIAS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *LCD_Type) GetCR_BIAS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *LCD_Type) SetCR_DUTY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1c)|value<<2)
}
func (o *LCD_Type) GetCR_DUTY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1c) >> 2
}
func (o *LCD_Type) SetCR_VSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetCR_VSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetCR_LCDEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCR_LCDEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *LCD_Type) SetCR_MUX_SEG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetCR_MUX_SEG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetCR_BUFEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetCR_BUFEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// LCD.FCR: frame control register
func (o *LCD_Type) SetFCR_PS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3c00000)|value<<22)
}
func (o *LCD_Type) GetFCR_PS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x3c00000) >> 22
}
func (o *LCD_Type) SetFCR_DIV(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3c0000)|value<<18)
}
func (o *LCD_Type) GetFCR_DIV() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x3c0000) >> 18
}
func (o *LCD_Type) SetFCR_BLINK(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x30000)|value<<16)
}
func (o *LCD_Type) GetFCR_BLINK() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x30000) >> 16
}
func (o *LCD_Type) SetFCR_BLINKF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xe000)|value<<13)
}
func (o *LCD_Type) GetFCR_BLINKF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xe000) >> 13
}
func (o *LCD_Type) SetFCR_CC(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1c00)|value<<10)
}
func (o *LCD_Type) GetFCR_CC() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x1c00) >> 10
}
func (o *LCD_Type) SetFCR_DEAD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x380)|value<<7)
}
func (o *LCD_Type) GetFCR_DEAD() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x380) >> 7
}
func (o *LCD_Type) SetFCR_PON(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x70)|value<<4)
}
func (o *LCD_Type) GetFCR_PON() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x70) >> 4
}
func (o *LCD_Type) SetFCR_UDDIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetFCR_UDDIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetFCR_SOFIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetFCR_SOFIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetFCR_HD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetFCR_HD() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x1
}

// LCD.SR: status register
func (o *LCD_Type) SetSR_FCRSF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetSR_FCRSF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetSR_RDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetSR_RDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetSR_UDD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetSR_UDD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetSR_SOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetSR_SOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetSR_ENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetSR_ENS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// LCD.CLR: clear register
func (o *LCD_Type) SetCLR_UDDC(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetCLR_UDDC() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetCLR_SOFC(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetCLR_SOFC() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x2) >> 1
}

// LCD.RAM_COM0: display memory
func (o *LCD_Type) SetRAM_COM0_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM0_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM0_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM0_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM0_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM0_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM0_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM0_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM0_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM0_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM0_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM0_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM0_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM0_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM0_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM0_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM0_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM0_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM0_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM0_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM0_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM0_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM0_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM0_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM0_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM0_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM0_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM0_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM0_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM0_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM0_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM0_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM0_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM0_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM0_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM0_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM0_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM0_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM0_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM0_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM0_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM0_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM0_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM0_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM0_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM0_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM0_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM0_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM0_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM0_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM0_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM0_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM0_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM0_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM0_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM0_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM0_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM0_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM0_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM0_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM0_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM0_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM0_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM0_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x1
}

// LCD.RAM_COM1: display memory
func (o *LCD_Type) SetRAM_COM1_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM1_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM1_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM1_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM1_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM1_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM1_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM1_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM1_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM1_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM1_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM1_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM1_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM1_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM1_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM1_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM1_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM1_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM1_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM1_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM1_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM1_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM1_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM1_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM1_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM1_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM1_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM1_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM1_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM1_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM1_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM1_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM1_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM1_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM1_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM1_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM1_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM1_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM1_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM1_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM1_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM1_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM1_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM1_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM1_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM1_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM1_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM1_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM1_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM1_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM1_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM1_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM1_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM1_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM1_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM1_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM1_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM1_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM1_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM1_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM1_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM1_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM1_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM1_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x1
}

// LCD.RAM_COM2: display memory
func (o *LCD_Type) SetRAM_COM2_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM2_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM2_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM2_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM2_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM2_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM2_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM2_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM2_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM2_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM2_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM2_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM2_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM2_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM2_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM2_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM2_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM2_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM2_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM2_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM2_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM2_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM2_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM2_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM2_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM2_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM2_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM2_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM2_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM2_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM2_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM2_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM2_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM2_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM2_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM2_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM2_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM2_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM2_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM2_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM2_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM2_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM2_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM2_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM2_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM2_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM2_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM2_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM2_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM2_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM2_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM2_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM2_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM2_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM2_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM2_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM2_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM2_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM2_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM2_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM2_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM2_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM2_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM2_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x1
}

// LCD.RAM_COM3: display memory
func (o *LCD_Type) SetRAM_COM3_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM3_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM3_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM3_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM3_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM3_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM3_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM3_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM3_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM3_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM3_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM3_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM3_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM3_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM3_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM3_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM3_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM3_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM3_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM3_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM3_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM3_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM3_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM3_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM3_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM3_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM3_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM3_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM3_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM3_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM3_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM3_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM3_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM3_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM3_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM3_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM3_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM3_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM3_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM3_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM3_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM3_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM3_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM3_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM3_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM3_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM3_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM3_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM3_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM3_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM3_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM3_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM3_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM3_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM3_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM3_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM3_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM3_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM3_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM3_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM3_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM3_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM3_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM3_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x1
}

// LCD.RAM_COM4: display memory
func (o *LCD_Type) SetRAM_COM4_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM4_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM4_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM4_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM4_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM4_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM4_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM4_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM4_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM4_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM4_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM4_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM4_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM4_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM4_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM4_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM4_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM4_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM4_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM4_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM4_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM4_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM4_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM4_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM4_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM4_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM4_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM4_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM4_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM4_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM4_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM4_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM4_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM4_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM4_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM4_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM4_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM4_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM4_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM4_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM4_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM4_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM4_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM4_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM4_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM4_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM4_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM4_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM4_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM4_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM4_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM4_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM4_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM4_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM4_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM4_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM4_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM4_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM4_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM4_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM4_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM4_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM4_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM4_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x1
}

// LCD.RAM_COM5: display memory
func (o *LCD_Type) SetRAM_COM5_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM5_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM5_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM5_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM5_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM5_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM5_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM5_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM5_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM5_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM5_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM5_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM5_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM5_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM5_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM5_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM5_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM5_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM5_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM5_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM5_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM5_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM5_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM5_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM5_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM5_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM5_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM5_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM5_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM5_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM5_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM5_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM5_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM5_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM5_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM5_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM5_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM5_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM5_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM5_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM5_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM5_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM5_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM5_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM5_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM5_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM5_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM5_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM5_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM5_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM5_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM5_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM5_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM5_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM5_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM5_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM5_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM5_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM5_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM5_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM5_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM5_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM5_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM5_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x1
}

// LCD.RAM_COM6: display memory
func (o *LCD_Type) SetRAM_COM6_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM6_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM6_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM6_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM6_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM6_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM6_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM6_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM6_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM6_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM6_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM6_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM6_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM6_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM6_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM6_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM6_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM6_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM6_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM6_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM6_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM6_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM6_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM6_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM6_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM6_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM6_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM6_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM6_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM6_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM6_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM6_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM6_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM6_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM6_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM6_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM6_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM6_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM6_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM6_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM6_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM6_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM6_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM6_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM6_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM6_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM6_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM6_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM6_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM6_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM6_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM6_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM6_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM6_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM6_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM6_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM6_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM6_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM6_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM6_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM6_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM6_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM6_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM6_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x1
}

// LCD.RAM_COM7: display memory
func (o *LCD_Type) SetRAM_COM7_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM7_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM7_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM7_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM7_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM7_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM7_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM7_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM7_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM7_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM7_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM7_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM7_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM7_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM7_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM7_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM7_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM7_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM7_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM7_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM7_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM7_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM7_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM7_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM7_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM7_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM7_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM7_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM7_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM7_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM7_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM7_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM7_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM7_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM7_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM7_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM7_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM7_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM7_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM7_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM7_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM7_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM7_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM7_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM7_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM7_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM7_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM7_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM7_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM7_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM7_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM7_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM7_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM7_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM7_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM7_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM7_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM7_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM7_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM7_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM7_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM7_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM7_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM7_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x1
}

// Touch sensing controller
type TSC_Type struct {
	CR     volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	ICR    volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	IOHCR  volatile.Register32 // 0x10
	_      [4]byte
	IOASCR volatile.Register32 // 0x18
	_      [4]byte
	IOSCR  volatile.Register32 // 0x20
	_      [4]byte
	IOCCR  volatile.Register32 // 0x28
	_      [4]byte
	IOGCSR volatile.Register32 // 0x30
	IOG1CR volatile.Register32 // 0x34
	IOG2CR volatile.Register32 // 0x38
	IOG3CR volatile.Register32 // 0x3C
	IOG4CR volatile.Register32 // 0x40
	IOG5CR volatile.Register32 // 0x44
	IOG6CR volatile.Register32 // 0x48
	IOG7CR volatile.Register32 // 0x4C
}

// TSC.CR: control register
func (o *TSC_Type) SetCR_CTPH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0000000)|value<<28)
}
func (o *TSC_Type) GetCR_CTPH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0000000) >> 28
}
func (o *TSC_Type) SetCR_CTPL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *TSC_Type) GetCR_CTPL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *TSC_Type) SetCR_SSD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xfe0000)|value<<17)
}
func (o *TSC_Type) GetCR_SSD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xfe0000) >> 17
}
func (o *TSC_Type) SetCR_SSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetCR_SSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetCR_SSPSC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetCR_SSPSC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetCR_PGPSC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7000)|value<<12)
}
func (o *TSC_Type) GetCR_PGPSC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x7000) >> 12
}
func (o *TSC_Type) SetCR_MCV(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe0)|value<<5)
}
func (o *TSC_Type) GetCR_MCV() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe0) >> 5
}
func (o *TSC_Type) SetCR_IODEF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetCR_IODEF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetCR_SYNCPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetCR_SYNCPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetCR_AM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetCR_AM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetCR_TSCE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetCR_TSCE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// TSC.IER: interrupt enable register
func (o *TSC_Type) SetIER_MCEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIER_MCEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIER_EOAIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIER_EOAIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// TSC.ICR: interrupt clear register
func (o *TSC_Type) SetICR_MCEIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetICR_MCEIC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetICR_EOAIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetICR_EOAIC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// TSC.ISR: interrupt status register
func (o *TSC_Type) SetISR_MCEF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetISR_MCEF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetISR_EOAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetISR_EOAF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// TSC.IOHCR: I/O hysteresis control register
func (o *TSC_Type) SetIOHCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOHCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOHCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOHCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOHCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOHCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOHCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOHCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOHCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOHCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOHCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOHCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOHCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOHCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOHCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOHCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOHCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOHCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOHCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOHCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOHCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOHCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOHCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOHCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOHCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOHCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOHCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOHCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOHCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOHCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOHCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOHCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOHCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOHCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOHCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOHCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOHCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOHCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOHCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOHCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOHCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOHCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOHCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOHCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOHCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOHCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOHCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOHCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOHCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOHCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOHCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOHCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOHCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOHCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOHCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOHCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOHCR.Reg) & 0x1
}

// TSC.IOASCR: I/O analog switch control register
func (o *TSC_Type) SetIOASCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOASCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOASCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOASCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOASCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOASCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOASCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOASCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOASCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOASCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOASCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOASCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOASCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOASCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOASCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOASCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOASCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOASCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOASCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOASCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOASCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOASCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOASCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOASCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOASCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOASCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOASCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOASCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOASCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOASCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOASCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOASCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOASCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOASCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOASCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOASCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOASCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOASCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOASCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOASCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOASCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOASCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOASCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOASCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOASCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOASCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOASCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOASCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOASCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOASCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOASCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOASCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOASCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOASCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOASCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOASCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOASCR.Reg) & 0x1
}

// TSC.IOSCR: I/O sampling control register
func (o *TSC_Type) SetIOSCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOSCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOSCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOSCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOSCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOSCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOSCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOSCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOSCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOSCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOSCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOSCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOSCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOSCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOSCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOSCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOSCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOSCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOSCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOSCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOSCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOSCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOSCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOSCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOSCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOSCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOSCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOSCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOSCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOSCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOSCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOSCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOSCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOSCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOSCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOSCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOSCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOSCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOSCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOSCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOSCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOSCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOSCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOSCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOSCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOSCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOSCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOSCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOSCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOSCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOSCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOSCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOSCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOSCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOSCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOSCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOSCR.Reg) & 0x1
}

// TSC.IOCCR: I/O channel control register
func (o *TSC_Type) SetIOCCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOCCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOCCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOCCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOCCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOCCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOCCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOCCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOCCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOCCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOCCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOCCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOCCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOCCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOCCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOCCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOCCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOCCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOCCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOCCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOCCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOCCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOCCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOCCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOCCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOCCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOCCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOCCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOCCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOCCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOCCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOCCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOCCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOCCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOCCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOCCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOCCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOCCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOCCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOCCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOCCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOCCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOCCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOCCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOCCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOCCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOCCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOCCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOCCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOCCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOCCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOCCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOCCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOCCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOCCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOCCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOCCR.Reg) & 0x1
}

// TSC.IOGCSR: I/O group control status register
func (o *TSC_Type) SetIOGCSR_G7S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOGCSR_G7S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOGCSR_G6S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOGCSR_G6S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOGCSR_G5S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOGCSR_G5S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOGCSR_G4S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOGCSR_G4S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOGCSR_G3S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOGCSR_G3S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOGCSR_G2S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOGCSR_G2S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOGCSR_G1S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOGCSR_G1S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOGCSR_G7E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOGCSR_G7E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOGCSR_G6E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOGCSR_G6E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOGCSR_G5E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOGCSR_G5E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOGCSR_G4E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOGCSR_G4E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOGCSR_G3E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOGCSR_G3E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOGCSR_G2E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOGCSR_G2E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOGCSR_G1E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOGCSR_G1E() uint32 {
	return volatile.LoadUint32(&o.IOGCSR.Reg) & 0x1
}

// TSC.IOG1CR: I/O group x counter register
func (o *TSC_Type) SetIOG1CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG1CR.Reg, volatile.LoadUint32(&o.IOG1CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG1CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG1CR.Reg) & 0x3fff
}

// TSC.IOG2CR: I/O group x counter register
func (o *TSC_Type) SetIOG2CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG2CR.Reg, volatile.LoadUint32(&o.IOG2CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG2CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG2CR.Reg) & 0x3fff
}

// TSC.IOG3CR: I/O group x counter register
func (o *TSC_Type) SetIOG3CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG3CR.Reg, volatile.LoadUint32(&o.IOG3CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG3CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG3CR.Reg) & 0x3fff
}

// TSC.IOG4CR: I/O group x counter register
func (o *TSC_Type) SetIOG4CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG4CR.Reg, volatile.LoadUint32(&o.IOG4CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG4CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG4CR.Reg) & 0x3fff
}

// TSC.IOG5CR: I/O group x counter register
func (o *TSC_Type) SetIOG5CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG5CR.Reg, volatile.LoadUint32(&o.IOG5CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG5CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG5CR.Reg) & 0x3fff
}

// TSC.IOG6CR: I/O group x counter register
func (o *TSC_Type) SetIOG6CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG6CR.Reg, volatile.LoadUint32(&o.IOG6CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG6CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG6CR.Reg) & 0x3fff
}

// TSC.IOG7CR: I/O group x counter register
func (o *TSC_Type) SetIOG7CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG7CR.Reg, volatile.LoadUint32(&o.IOG7CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG7CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG7CR.Reg) & 0x3fff
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x3800)|value<<11)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x3800) >> 11
}
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Comparator instance 1
type COMP_Type struct {
	COMP1_CSR volatile.Register32 // 0x0
	COMP2_CSR volatile.Register32 // 0x4
}

// COMP.COMP1_CSR: Comparator control and status register
func (o *COMP_Type) SetCOMP1_CSR_COMP1_EN(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_EN() uint32 {
	return volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x1
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0xc)|value<<2)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0xc) >> 2
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_INPSEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x180)|value<<7)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x180) >> 7
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_POLARITY(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_HYST(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x30000)|value<<16)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x30000) >> 16
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_BLANKING(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x1c0000)|value<<18)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x1c0000) >> 18
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_BRGEN(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x400000)|value<<22)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x400000) >> 22
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_SCALEN(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x800000)|value<<23)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x800000) >> 23
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_INMESEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x6000000)|value<<25)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_INMESEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x6000000) >> 25
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_VALUE(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_VALUE() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x80000000) >> 31
}

// COMP.COMP2_CSR: Comparator 2 control and status register
func (o *COMP_Type) SetCOMP2_CSR_COMP2_EN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_EN() uint32 {
	return volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x1
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0xc)|value<<2)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0xc) >> 2
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x30)|value<<4)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x30) >> 4
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_INPSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x180)|value<<7)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x180) >> 7
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_WINMODE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x200)|value<<9)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_WINMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x200) >> 9
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_POLARITY(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_HYST(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x30000)|value<<16)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x30000) >> 16
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_BLANKING(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x1c0000)|value<<18)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x1c0000) >> 18
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_BRGEN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x400000)|value<<22)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x400000) >> 22
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_SCALEN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x800000)|value<<23)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x800000) >> 23
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_INMESEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x6000000)|value<<25)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_INMESEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x6000000) >> 25
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_VALUE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_VALUE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x80000000) >> 31
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetCR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Timing register
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Status register 1
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Interrupt and Status register
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// I2C.ICR: Interrupt clear register
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// I2C.PECR: PEC register
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Receive data register
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Transmit data register
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// Flash
type Flash_Type struct {
	ACR       volatile.Register32 // 0x0
	_         [4]byte
	KEYR      volatile.Register32 // 0x8
	OPTKEYR   volatile.Register32 // 0xC
	SR        volatile.Register32 // 0x10
	CR        volatile.Register32 // 0x14
	ECCR      volatile.Register32 // 0x18
	_         [4]byte
	OPTR      volatile.Register32 // 0x20
	PCROP1ASR volatile.Register32 // 0x24
	PCROP1AER volatile.Register32 // 0x28
	WRP1AR    volatile.Register32 // 0x2C
	WRP1BR    volatile.Register32 // 0x30
	PCROP1BSR volatile.Register32 // 0x34
	PCROP1BER volatile.Register32 // 0x38
	IPCCBR    volatile.Register32 // 0x3C
	_         [28]byte
	C2ACR     volatile.Register32 // 0x5C
	C2SR      volatile.Register32 // 0x60
	C2CR      volatile.Register32 // 0x64
	_         [24]byte
	SFR       volatile.Register32 // 0x80
	SRRVR     volatile.Register32 // 0x84
}

// Flash.ACR: Access control register
func (o *Flash_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x7)|value)
}
func (o *Flash_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x7
}
func (o *Flash_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetACR_ICEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetACR_ICEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetACR_DCEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x400)|value<<10)
}
func (o *Flash_Type) GetACR_DCEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x400) >> 10
}
func (o *Flash_Type) SetACR_ICRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetACR_ICRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetACR_DCRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetACR_DCRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetACR_PES(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetACR_PES() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetACR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetACR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x10000) >> 16
}

// Flash.KEYR: Flash key register
func (o *Flash_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *Flash_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// Flash.OPTKEYR: Option byte key register
func (o *Flash_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *Flash_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// Flash.SR: Status register
func (o *Flash_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSR_EOP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *Flash_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetSR_PROGERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetSR_PROGERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetSR_SIZERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *Flash_Type) GetSR_SIZERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *Flash_Type) SetSR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetSR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetSR_MISERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetSR_MISERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetSR_FASTERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetSR_FASTERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetSR_OPTNV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetSR_OPTNV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetSR_OPTVERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetSR_OPTVERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetSR_CFGBSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetSR_CFGBSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetSR_PESD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetSR_PESD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}

// Flash.CR: Flash control register
func (o *Flash_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *Flash_Type) SetCR_PER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetCR_PER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetCR_MER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetCR_MER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetCR_PNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f8)|value<<3)
}
func (o *Flash_Type) GetCR_PNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x7f8) >> 3
}
func (o *Flash_Type) SetCR_STRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetCR_STRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetCR_FSTPG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetCR_FSTPG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetCR_RDERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetCR_RDERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetCR_OBL_LAUNCH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetCR_OBL_LAUNCH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *Flash_Type) SetCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetCR_OPTLOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// Flash.ECCR: Flash ECC register
func (o *Flash_Type) SetECCR_ADDR_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x1ffff)|value)
}
func (o *Flash_Type) GetECCR_ADDR_ECC() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg) & 0x1ffff
}
func (o *Flash_Type) SetECCR_SYSF_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x100000)|value<<20)
}
func (o *Flash_Type) GetECCR_SYSF_ECC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x100000) >> 20
}
func (o *Flash_Type) SetECCR_ECCCIE(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetECCR_ECCCIE() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetECCR_CPUID(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x1c000000)|value<<26)
}
func (o *Flash_Type) GetECCR_CPUID() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x1c000000) >> 26
}
func (o *Flash_Type) SetECCR_ECCC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetECCR_ECCC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetECCR_ECCD(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetECCR_ECCD() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x80000000) >> 31
}

// Flash.OPTR: Flash option register
func (o *Flash_Type) SetOPTR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetOPTR_RDP() uint32 {
	return volatile.LoadUint32(&o.OPTR.Reg) & 0xff
}
func (o *Flash_Type) SetOPTR_ESE(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetOPTR_ESE() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetOPTR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0xe00)|value<<9)
}
func (o *Flash_Type) GetOPTR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0xe00) >> 9
}
func (o *Flash_Type) SetOPTR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetOPTR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetOPTR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetOPTR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetOPTR_NRST_SHDW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetOPTR_NRST_SHDW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetOPTR_IDWG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetOPTR_IDWG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetOPTR_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetOPTR_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetOPTR_IWDG_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetOPTR_IWDG_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetOPTR_WWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetOPTR_WWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x80000) >> 19
}
func (o *Flash_Type) SetOPTR_NBOOT1(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x800000)|value<<23)
}
func (o *Flash_Type) GetOPTR_NBOOT1() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x800000) >> 23
}
func (o *Flash_Type) SetOPTR_SRAM2_PE(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetOPTR_SRAM2_PE() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetOPTR_SRAM2_RST(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetOPTR_SRAM2_RST() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetOPTR_NSWBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetOPTR_NSWBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetOPTR_NBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetOPTR_NBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x8000000) >> 27
}
func (o *Flash_Type) SetOPTR_AGC_TRIM(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0xe0000000)|value<<29)
}
func (o *Flash_Type) GetOPTR_AGC_TRIM() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0xe0000000) >> 29
}

// Flash.PCROP1ASR: Flash Bank 1 PCROP Start address zone A register
func (o *Flash_Type) SetPCROP1ASR_PCROP1A_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP1ASR.Reg, volatile.LoadUint32(&o.PCROP1ASR.Reg)&^(0x1ff)|value)
}
func (o *Flash_Type) GetPCROP1ASR_PCROP1A_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP1ASR.Reg) & 0x1ff
}

// Flash.PCROP1AER: Flash Bank 1 PCROP End address zone A register
func (o *Flash_Type) SetPCROP1AER_PCROP1A_END(value uint32) {
	volatile.StoreUint32(&o.PCROP1AER.Reg, volatile.LoadUint32(&o.PCROP1AER.Reg)&^(0x1ff)|value)
}
func (o *Flash_Type) GetPCROP1AER_PCROP1A_END() uint32 {
	return volatile.LoadUint32(&o.PCROP1AER.Reg) & 0x1ff
}
func (o *Flash_Type) SetPCROP1AER_PCROP_RDP(value uint32) {
	volatile.StoreUint32(&o.PCROP1AER.Reg, volatile.LoadUint32(&o.PCROP1AER.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetPCROP1AER_PCROP_RDP() uint32 {
	return (volatile.LoadUint32(&o.PCROP1AER.Reg) & 0x80000000) >> 31
}

// Flash.WRP1AR: Flash Bank 1 WRP area A address register
func (o *Flash_Type) SetWRP1AR_WRP1A_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP1AR.Reg) & 0xff
}
func (o *Flash_Type) SetWRP1AR_WRP1A_END(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0xff0000)|value<<16)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_END() uint32 {
	return (volatile.LoadUint32(&o.WRP1AR.Reg) & 0xff0000) >> 16
}

// Flash.WRP1BR: Flash Bank 1 WRP area B address register
func (o *Flash_Type) SetWRP1BR_WRP1B_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0xff0000)|value<<16)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_STRT() uint32 {
	return (volatile.LoadUint32(&o.WRP1BR.Reg) & 0xff0000) >> 16
}
func (o *Flash_Type) SetWRP1BR_WRP1B_END(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_END() uint32 {
	return volatile.LoadUint32(&o.WRP1BR.Reg) & 0xff
}

// Flash.PCROP1BSR: Flash Bank 1 PCROP Start address area B register
func (o *Flash_Type) SetPCROP1BSR_PCROP1B_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP1BSR.Reg, volatile.LoadUint32(&o.PCROP1BSR.Reg)&^(0x1ff)|value)
}
func (o *Flash_Type) GetPCROP1BSR_PCROP1B_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP1BSR.Reg) & 0x1ff
}

// Flash.PCROP1BER: Flash Bank 1 PCROP End address area B register
func (o *Flash_Type) SetPCROP1BER_PCROP1B_END(value uint32) {
	volatile.StoreUint32(&o.PCROP1BER.Reg, volatile.LoadUint32(&o.PCROP1BER.Reg)&^(0x1ff)|value)
}
func (o *Flash_Type) GetPCROP1BER_PCROP1B_END() uint32 {
	return volatile.LoadUint32(&o.PCROP1BER.Reg) & 0x1ff
}

// Flash.IPCCBR: IPCC mailbox data buffer address register
func (o *Flash_Type) SetIPCCBR_IPCCDBA(value uint32) {
	volatile.StoreUint32(&o.IPCCBR.Reg, volatile.LoadUint32(&o.IPCCBR.Reg)&^(0x3fff)|value)
}
func (o *Flash_Type) GetIPCCBR_IPCCDBA() uint32 {
	return volatile.LoadUint32(&o.IPCCBR.Reg) & 0x3fff
}

// Flash.C2ACR: CPU2 cortex M0 access control register
func (o *Flash_Type) SetC2ACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.C2ACR.Reg, volatile.LoadUint32(&o.C2ACR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetC2ACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.C2ACR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetC2ACR_ICEN(value uint32) {
	volatile.StoreUint32(&o.C2ACR.Reg, volatile.LoadUint32(&o.C2ACR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetC2ACR_ICEN() uint32 {
	return (volatile.LoadUint32(&o.C2ACR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetC2ACR_ICRST(value uint32) {
	volatile.StoreUint32(&o.C2ACR.Reg, volatile.LoadUint32(&o.C2ACR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetC2ACR_ICRST() uint32 {
	return (volatile.LoadUint32(&o.C2ACR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetC2ACR_PES(value uint32) {
	volatile.StoreUint32(&o.C2ACR.Reg, volatile.LoadUint32(&o.C2ACR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetC2ACR_PES() uint32 {
	return (volatile.LoadUint32(&o.C2ACR.Reg) & 0x8000) >> 15
}

// Flash.C2SR: CPU2 cortex M0 status register
func (o *Flash_Type) SetC2SR_EOP(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetC2SR_EOP() uint32 {
	return volatile.LoadUint32(&o.C2SR.Reg) & 0x1
}
func (o *Flash_Type) SetC2SR_OPERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetC2SR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetC2SR_PROGERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetC2SR_PROGERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetC2SR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetC2SR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetC2SR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetC2SR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetC2SR_SIZERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x40)|value<<6)
}
func (o *Flash_Type) GetC2SR_SIZERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x40) >> 6
}
func (o *Flash_Type) SetC2SR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetC2SR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetC2SR_MISSERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetC2SR_MISSERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetC2SR_FASTERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetC2SR_FASTERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetC2SR_RDERR(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetC2SR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetC2SR_BSY(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetC2SR_BSY() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetC2SR_CFGBSY(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetC2SR_CFGBSY() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetC2SR_PESD(value uint32) {
	volatile.StoreUint32(&o.C2SR.Reg, volatile.LoadUint32(&o.C2SR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetC2SR_PESD() uint32 {
	return (volatile.LoadUint32(&o.C2SR.Reg) & 0x80000) >> 19
}

// Flash.C2CR: CPU2 cortex M0 control register
func (o *Flash_Type) SetC2CR_PG(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetC2CR_PG() uint32 {
	return volatile.LoadUint32(&o.C2CR.Reg) & 0x1
}
func (o *Flash_Type) SetC2CR_PER(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetC2CR_PER() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetC2CR_MER(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetC2CR_MER() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetC2CR_PNB(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x7f8)|value<<3)
}
func (o *Flash_Type) GetC2CR_PNB() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x7f8) >> 3
}
func (o *Flash_Type) SetC2CR_STRT(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetC2CR_STRT() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetC2CR_FSTPG(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetC2CR_FSTPG() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetC2CR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetC2CR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetC2CR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetC2CR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetC2CR_RDERRIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetC2CR_RDERRIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x4000000) >> 26
}

// Flash.SFR: Secure flash start address register
func (o *Flash_Type) SetSFR_SFSA(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetSFR_SFSA() uint32 {
	return volatile.LoadUint32(&o.SFR.Reg) & 0xff
}
func (o *Flash_Type) SetSFR_DDS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetSFR_DDS() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetSFR_FSD(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetSFR_FSD() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x100) >> 8
}

// Flash.SRRVR: Secure SRAM2 start address and cortex M0 reset vector register
func (o *Flash_Type) SetSRRVR_SBRV(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x3ffff)|value)
}
func (o *Flash_Type) GetSRRVR_SBRV() uint32 {
	return volatile.LoadUint32(&o.SRRVR.Reg) & 0x3ffff
}
func (o *Flash_Type) SetSRRVR_SBRSA(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x7c0000)|value<<18)
}
func (o *Flash_Type) GetSRRVR_SBRSA() uint32 {
	return (volatile.LoadUint32(&o.SRRVR.Reg) & 0x7c0000) >> 18
}
func (o *Flash_Type) SetSRRVR_BRSD(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x800000)|value<<23)
}
func (o *Flash_Type) GetSRRVR_BRSD() uint32 {
	return (volatile.LoadUint32(&o.SRRVR.Reg) & 0x800000) >> 23
}
func (o *Flash_Type) SetSRRVR_SNBRSA(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x3e000000)|value<<25)
}
func (o *Flash_Type) GetSRRVR_SNBRSA() uint32 {
	return (volatile.LoadUint32(&o.SRRVR.Reg) & 0x3e000000) >> 25
}
func (o *Flash_Type) SetSRRVR_C2OPT(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetSRRVR_C2OPT() uint32 {
	return (volatile.LoadUint32(&o.SRRVR.Reg) & 0x80000000) >> 31
}
func (o *Flash_Type) SetSRRVR_NBRSD(value uint32) {
	volatile.StoreUint32(&o.SRRVR.Reg, volatile.LoadUint32(&o.SRRVR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetSRRVR_NBRSD() uint32 {
	return (volatile.LoadUint32(&o.SRRVR.Reg) & 0x40000000) >> 30
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// QUADSPI.CR: control register
func (o *QUADSPI_Type) SetCR_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *QUADSPI_Type) GetCR_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}
func (o *QUADSPI_Type) SetCR_PMM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *QUADSPI_Type) GetCR_PMM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *QUADSPI_Type) SetCR_APMS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *QUADSPI_Type) GetCR_APMS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *QUADSPI_Type) SetCR_TOIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *QUADSPI_Type) GetCR_TOIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *QUADSPI_Type) SetCR_SMIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *QUADSPI_Type) GetCR_SMIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *QUADSPI_Type) SetCR_FTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *QUADSPI_Type) GetCR_FTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *QUADSPI_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *QUADSPI_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *QUADSPI_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *QUADSPI_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *QUADSPI_Type) SetCR_FTHRES(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *QUADSPI_Type) GetCR_FTHRES() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *QUADSPI_Type) SetCR_SSHIFT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetCR_SSHIFT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetCR_TCEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetCR_TCEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetCR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetCR_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// QUADSPI.DCR: device configuration register
func (o *QUADSPI_Type) SetDCR_FSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *QUADSPI_Type) GetDCR_FSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f0000) >> 16
}
func (o *QUADSPI_Type) SetDCR_CSHT(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x700)|value<<8)
}
func (o *QUADSPI_Type) GetDCR_CSHT() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x700) >> 8
}
func (o *QUADSPI_Type) SetDCR_CKMODE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetDCR_CKMODE() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1
}

// QUADSPI.SR: status register
func (o *QUADSPI_Type) SetSR_FLEVEL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1f00)|value<<8)
}
func (o *QUADSPI_Type) GetSR_FLEVEL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1f00) >> 8
}
func (o *QUADSPI_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *QUADSPI_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *QUADSPI_Type) SetSR_TOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetSR_TOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetSR_SMF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetSR_SMF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetSR_FTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetSR_FTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetSR_TCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetSR_TEF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetSR_TEF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// QUADSPI.FCR: flag clear register
func (o *QUADSPI_Type) SetFCR_CTOF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetFCR_CTOF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetFCR_CSMF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetFCR_CSMF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetFCR_CTCF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetFCR_CTCF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetFCR_CTEF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetFCR_CTEF() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x1
}

// QUADSPI.DLR: data length register
func (o *QUADSPI_Type) SetDLR(value uint32) {
	volatile.StoreUint32(&o.DLR.Reg, value)
}
func (o *QUADSPI_Type) GetDLR() uint32 {
	return volatile.LoadUint32(&o.DLR.Reg)
}

// QUADSPI.CCR: communication configuration register
func (o *QUADSPI_Type) SetCCR_DDRM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000000)|value<<31)
}
func (o *QUADSPI_Type) GetCCR_DDRM() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000000) >> 31
}
func (o *QUADSPI_Type) SetCCR_SIOO(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10000000)|value<<28)
}
func (o *QUADSPI_Type) GetCCR_SIOO() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10000000) >> 28
}
func (o *QUADSPI_Type) SetCCR_FMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000000)|value<<26)
}
func (o *QUADSPI_Type) GetCCR_FMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000000) >> 26
}
func (o *QUADSPI_Type) SetCCR_DMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000000)|value<<24)
}
func (o *QUADSPI_Type) GetCCR_DMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000000) >> 24
}
func (o *QUADSPI_Type) SetCCR_DCYC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x7c0000)|value<<18)
}
func (o *QUADSPI_Type) GetCCR_DCYC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x7c0000) >> 18
}
func (o *QUADSPI_Type) SetCCR_ABSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x30000)|value<<16)
}
func (o *QUADSPI_Type) GetCCR_ABSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x30000) >> 16
}
func (o *QUADSPI_Type) SetCCR_ABMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000)|value<<14)
}
func (o *QUADSPI_Type) GetCCR_ABMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000) >> 14
}
func (o *QUADSPI_Type) SetCCR_ADSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000)|value<<12)
}
func (o *QUADSPI_Type) GetCCR_ADSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000) >> 12
}
func (o *QUADSPI_Type) SetCCR_ADMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc00)|value<<10)
}
func (o *QUADSPI_Type) GetCCR_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc00) >> 10
}
func (o *QUADSPI_Type) SetCCR_IMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x300)|value<<8)
}
func (o *QUADSPI_Type) GetCCR_IMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x300) >> 8
}
func (o *QUADSPI_Type) SetCCR_INSTRUCTION(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xff)|value)
}
func (o *QUADSPI_Type) GetCCR_INSTRUCTION() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0xff
}

// QUADSPI.AR: address register
func (o *QUADSPI_Type) SetAR(value uint32) {
	volatile.StoreUint32(&o.AR.Reg, value)
}
func (o *QUADSPI_Type) GetAR() uint32 {
	return volatile.LoadUint32(&o.AR.Reg)
}

// QUADSPI.ABR: ABR
func (o *QUADSPI_Type) SetABR(value uint32) {
	volatile.StoreUint32(&o.ABR.Reg, value)
}
func (o *QUADSPI_Type) GetABR() uint32 {
	return volatile.LoadUint32(&o.ABR.Reg)
}

// QUADSPI.DR: data register
func (o *QUADSPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *QUADSPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// QUADSPI.PSMKR: polling status mask register
func (o *QUADSPI_Type) SetPSMKR(value uint32) {
	volatile.StoreUint32(&o.PSMKR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMKR() uint32 {
	return volatile.LoadUint32(&o.PSMKR.Reg)
}

// QUADSPI.PSMAR: polling status match register
func (o *QUADSPI_Type) SetPSMAR(value uint32) {
	volatile.StoreUint32(&o.PSMAR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMAR() uint32 {
	return volatile.LoadUint32(&o.PSMAR.Reg)
}

// QUADSPI.PIR: polling interval register
func (o *QUADSPI_Type) SetPIR_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.PIR.Reg, volatile.LoadUint32(&o.PIR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetPIR_INTERVAL() uint32 {
	return volatile.LoadUint32(&o.PIR.Reg) & 0xffff
}

// QUADSPI.LPTR: low-power timeout register
func (o *QUADSPI_Type) SetLPTR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LPTR.Reg, volatile.LoadUint32(&o.LPTR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetLPTR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.LPTR.Reg) & 0xffff
}

// Reset and clock control
type RCC_Type struct {
	CR           volatile.Register32 // 0x0
	ICSCR        volatile.Register32 // 0x4
	CFGR         volatile.Register32 // 0x8
	PLLCFGR      volatile.Register32 // 0xC
	PLLSAI1CFGR  volatile.Register32 // 0x10
	_            [4]byte
	CIER         volatile.Register32 // 0x18
	CIFR         volatile.Register32 // 0x1C
	CICR         volatile.Register32 // 0x20
	SMPSCR       volatile.Register32 // 0x24
	AHB1RSTR     volatile.Register32 // 0x28
	AHB2RSTR     volatile.Register32 // 0x2C
	AHB3RSTR     volatile.Register32 // 0x30
	_            [4]byte
	APB1RSTR1    volatile.Register32 // 0x38
	APB1RSTR2    volatile.Register32 // 0x3C
	APB2RSTR     volatile.Register32 // 0x40
	APB3RSTR     volatile.Register32 // 0x44
	AHB1ENR      volatile.Register32 // 0x48
	AHB2ENR      volatile.Register32 // 0x4C
	AHB3ENR      volatile.Register32 // 0x50
	_            [4]byte
	APB1ENR1     volatile.Register32 // 0x58
	APB1ENR2     volatile.Register32 // 0x5C
	APB2ENR      volatile.Register32 // 0x60
	_            [4]byte
	AHB1SMENR    volatile.Register32 // 0x68
	AHB2SMENR    volatile.Register32 // 0x6C
	AHB3SMENR    volatile.Register32 // 0x70
	_            [4]byte
	APB1SMENR1   volatile.Register32 // 0x78
	APB1SMENR2   volatile.Register32 // 0x7C
	APB2SMENR    volatile.Register32 // 0x80
	_            [4]byte
	CCIPR        volatile.Register32 // 0x88
	_            [4]byte
	BDCR         volatile.Register32 // 0x90
	CSR          volatile.Register32 // 0x94
	CRRCR        volatile.Register32 // 0x98
	HSECR        volatile.Register32 // 0x9C
	_            [104]byte
	EXTCFGR      volatile.Register32 // 0x108
	_            [60]byte
	C2AHB1ENR    volatile.Register32 // 0x148
	C2AHB2ENR    volatile.Register32 // 0x14C
	C2AHB3ENR    volatile.Register32 // 0x150
	_            [4]byte
	C2APB1ENR1   volatile.Register32 // 0x158
	C2APB1ENR2   volatile.Register32 // 0x15C
	C2APB2ENR    volatile.Register32 // 0x160
	C2APB3ENR    volatile.Register32 // 0x164
	C2AHB1SMENR  volatile.Register32 // 0x168
	C2AHB2SMENR  volatile.Register32 // 0x16C
	C2AHB3SMENR  volatile.Register32 // 0x170
	_            [4]byte
	C2APB1SMENR1 volatile.Register32 // 0x178
	C2APB1SMENR2 volatile.Register32 // 0x17C
	C2APB2SMENR  volatile.Register32 // 0x180
	C2APB3SMENR  volatile.Register32 // 0x184
}

// RCC.CR: Clock control register
func (o *RCC_Type) SetCR_PLLSAI1RDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCR_PLLSAI1RDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCR_PLLSAI1ON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCR_PLLSAI1ON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_HSEPRE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetCR_HSEPRE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSIKERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCR_HSIKERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetCR_HSIASFS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCR_HSIASFS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCR_HSIKERON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCR_HSIKERON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCR_MSIRANGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCR_MSIRANGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCR_MSIPLLEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCR_MSIPLLEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCR_MSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_MSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_MSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_MSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// RCC.ICSCR: Internal clock sources calibration register
func (o *RCC_Type) SetICSCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0x7f000000)|value<<24)
}
func (o *RCC_Type) GetICSCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0x7f000000) >> 24
}
func (o *RCC_Type) SetICSCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff0000)|value<<16)
}
func (o *RCC_Type) GetICSCR_HSICAL() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0xff0000) >> 16
}
func (o *RCC_Type) SetICSCR_MSITRIM(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff00)|value<<8)
}
func (o *RCC_Type) GetICSCR_MSITRIM() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0xff00) >> 8
}
func (o *RCC_Type) SetICSCR_MSICAL(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff)|value)
}
func (o *RCC_Type) GetICSCR_MSICAL() uint32 {
	return volatile.LoadUint32(&o.ICSCR.Reg) & 0xff
}

// RCC.CFGR: Clock configuration register
func (o *RCC_Type) SetCFGR_MCOPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetCFGR_MCOPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetCFGR_MCOSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCOSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf000000) >> 24
}
func (o *RCC_Type) SetCFGR_PPRE2F(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCFGR_PPRE2F() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCFGR_PPRE1F(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCFGR_PPRE1F() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCFGR_HPREF(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCFGR_HPREF() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCFGR_STOPWUCK(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetCFGR_STOPWUCK() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3800)|value<<11)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3800) >> 11
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x700)|value<<8)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x700) >> 8
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}

// RCC.PLLCFGR: PLLSYS configuration register
func (o *RCC_Type) SetPLLCFGR_PLLR(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xe0000000)|value<<29)
}
func (o *RCC_Type) GetPLLCFGR_PLLR() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xe0000000) >> 29
}
func (o *RCC_Type) SetPLLCFGR_PLLREN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetPLLCFGR_PLLREN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetPLLCFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xe000000)|value<<25)
}
func (o *RCC_Type) GetPLLCFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xe000000) >> 25
}
func (o *RCC_Type) SetPLLCFGR_PLLQEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_PLLQEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetPLLCFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3e0000)|value<<17)
}
func (o *RCC_Type) GetPLLCFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3e0000) >> 17
}
func (o *RCC_Type) SetPLLCFGR_PLLPEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_PLLPEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x7f00)|value<<8)
}
func (o *RCC_Type) GetPLLCFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x7f00) >> 8
}
func (o *RCC_Type) SetPLLCFGR_PLLM(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x70)|value<<4)
}
func (o *RCC_Type) GetPLLCFGR_PLLM() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x70) >> 4
}
func (o *RCC_Type) SetPLLCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLLSRC() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3
}

// RCC.PLLSAI1CFGR: PLLSAI1 configuration register
func (o *RCC_Type) SetPLLSAI1CFGR_PLLR(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0xe0000000)|value<<29)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLR() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0xe0000000) >> 29
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLREN(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLREN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0xe000000)|value<<25)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0xe000000) >> 25
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLQEN(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLQEN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x3e0000)|value<<17)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x3e0000) >> 17
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLPEN(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLPEN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x7f00)|value<<8)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x7f00) >> 8
}

// RCC.CIER: Clock interrupt enable register
func (o *RCC_Type) SetCIER_LSI2RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCIER_LSI2RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCIER_HSI48RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIER_HSI48RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCIER_LSECSSIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIER_LSECSSIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIER_PLLSAI1RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCIER_PLLSAI1RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCIER_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIER_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIER_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIER_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIER_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIER_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIER_MSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIER_MSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIER_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIER_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIER_LSI1RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIER_LSI1RDYIE() uint32 {
	return volatile.LoadUint32(&o.CIER.Reg) & 0x1
}

// RCC.CIFR: Clock interrupt flag register
func (o *RCC_Type) SetCIFR_LSI2RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCIFR_LSI2RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCIFR_HSI48RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIFR_HSI48RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCIFR_LSECSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIFR_LSECSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIFR_HSECSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIFR_HSECSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIFR_PLLSAI1RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCIFR_PLLSAI1RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCIFR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIFR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIFR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIFR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIFR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIFR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIFR_MSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIFR_MSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIFR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIFR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIFR_LSI1RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIFR_LSI1RDYF() uint32 {
	return volatile.LoadUint32(&o.CIFR.Reg) & 0x1
}

// RCC.CICR: Clock interrupt clear register
func (o *RCC_Type) SetCICR_LSI2RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCICR_LSI2RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCICR_HSI48RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCICR_HSI48RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCICR_LSECSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCICR_LSECSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCICR_HSECSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCICR_HSECSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCICR_PLLSAI1RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCICR_PLLSAI1RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCICR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCICR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCICR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCICR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCICR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCICR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCICR_MSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCICR_MSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCICR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCICR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCICR_LSI1RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCICR_LSI1RDYC() uint32 {
	return volatile.LoadUint32(&o.CICR.Reg) & 0x1
}

// RCC.SMPSCR: Step Down converter control register
func (o *RCC_Type) SetSMPSCR_SMPSSWS(value uint32) {
	volatile.StoreUint32(&o.SMPSCR.Reg, volatile.LoadUint32(&o.SMPSCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetSMPSCR_SMPSSWS() uint32 {
	return (volatile.LoadUint32(&o.SMPSCR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetSMPSCR_SMPSDIV(value uint32) {
	volatile.StoreUint32(&o.SMPSCR.Reg, volatile.LoadUint32(&o.SMPSCR.Reg)&^(0x30)|value<<4)
}
func (o *RCC_Type) GetSMPSCR_SMPSDIV() uint32 {
	return (volatile.LoadUint32(&o.SMPSCR.Reg) & 0x30) >> 4
}
func (o *RCC_Type) SetSMPSCR_SMPSSEL(value uint32) {
	volatile.StoreUint32(&o.SMPSCR.Reg, volatile.LoadUint32(&o.SMPSCR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetSMPSCR_SMPSSEL() uint32 {
	return volatile.LoadUint32(&o.SMPSCR.Reg) & 0x3
}

// RCC.AHB1RSTR: AHB1 peripheral reset register
func (o *RCC_Type) SetAHB1RSTR_TSCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1RSTR_TSCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1RSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1RSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1RSTR_DMAMUXRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1RSTR_DMAMUXRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1RSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1RSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1RSTR_DMA1RST() uint32 {
	return volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1
}

// RCC.AHB2RSTR: AHB2 peripheral reset register
func (o *RCC_Type) SetAHB2RSTR_AES1RST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB2RSTR_AES1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB2RSTR_ADCRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB2RSTR_ADCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB2RSTR_GPIOHRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2RSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2RSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB2RSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB2RSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2RSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2RSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x1
}

// RCC.AHB3RSTR: AHB3 peripheral reset register
func (o *RCC_Type) SetAHB3RSTR_FLASHRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB3RSTR_FLASHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB3RSTR_IPCCRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAHB3RSTR_IPCCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAHB3RSTR_HSEMRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB3RSTR_HSEMRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB3RSTR_RNGRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB3RSTR_RNGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB3RSTR_AES2RST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB3RSTR_AES2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB3RSTR_PKARST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB3RSTR_PKARST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB3RSTR_QSPIRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB3RSTR_QSPIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x100) >> 8
}

// RCC.APB1RSTR1: APB1 peripheral reset register 1
func (o *RCC_Type) SetAPB1RSTR1_LPTIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1RSTR1_LPTIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1RSTR1_USBFSRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1RSTR1_USBFSRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1RSTR1_CRSRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1RSTR1_CRSRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB1RSTR1_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1RSTR1_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR1_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR1_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR1_LCDRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1RSTR1_LCDRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1RSTR1_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x1
}

// RCC.APB1RSTR2: APB1 peripheral reset register 2
func (o *RCC_Type) SetAPB1RSTR2_LPTIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1RSTR2_LPTIM2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1RSTR2_LPUART1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR2_LPUART1RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x1
}

// RCC.APB2RSTR: APB2 peripheral reset register
func (o *RCC_Type) SetAPB2RSTR_SAI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2RSTR_SAI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2RSTR_TIM17RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM17RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2RSTR_TIM16RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM16RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}

// RCC.APB3RSTR: APB3 peripheral reset register
func (o *RCC_Type) SetAPB3RSTR_RFRST(value uint32) {
	volatile.StoreUint32(&o.APB3RSTR.Reg, volatile.LoadUint32(&o.APB3RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB3RSTR_RFRST() uint32 {
	return volatile.LoadUint32(&o.APB3RSTR.Reg) & 0x1
}

// RCC.AHB1ENR: AHB1 peripheral clock enable register
func (o *RCC_Type) SetAHB1ENR_TSCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1ENR_TSCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1ENR_DMAMUXEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1ENR_DMAMUXEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1ENR_DMA1EN() uint32 {
	return volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1
}

// RCC.AHB2ENR: AHB2 peripheral clock enable register
func (o *RCC_Type) SetAHB2ENR_AES1EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB2ENR_AES1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB2ENR_ADCEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB2ENR_ADCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB2ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB2ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB2ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x1
}

// RCC.AHB3ENR: AHB3 peripheral clock enable register
func (o *RCC_Type) SetAHB3ENR_FLASHEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB3ENR_FLASHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB3ENR_IPCCEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAHB3ENR_IPCCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAHB3ENR_HSEMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB3ENR_HSEMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB3ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB3ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB3ENR_AES2EN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB3ENR_AES2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB3ENR_PKAEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB3ENR_PKAEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB3ENR_QSPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB3ENR_QSPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x100) >> 8
}

// RCC.APB1ENR1: APB1ENR1
func (o *RCC_Type) SetAPB1ENR1_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1ENR1_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1ENR1_USBEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1ENR1_USBEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1ENR1_CRSEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1ENR1_CRSEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB1ENR1_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1ENR1_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1ENR1_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR1_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR1_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR1_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR1_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR1_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR1_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1ENR1_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB1ENR1_LCDEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1ENR1_LCDEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1ENR1_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR1_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x1
}

// RCC.APB1ENR2: APB1 peripheral clock enable register 2
func (o *RCC_Type) SetAPB1ENR2_LPTIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1ENR2_LPTIM2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1ENR2_LPUART1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR2_LPUART1EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x1
}

// RCC.APB2ENR: APB2ENR
func (o *RCC_Type) SetAPB2ENR_SAI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2ENR_SAI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2ENR_TIM17EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM17EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2ENR_TIM16EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM16EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}

// RCC.AHB1SMENR: AHB1 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetAHB1SMENR_TSCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1SMENR_TSCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1SMENR_CRCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1SMENR_CRCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1SMENR_SRAM1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB1SMENR_SRAM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB1SMENR_DMAMUXSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1SMENR_DMAMUXSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1SMENR_DMA2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1SMENR_DMA2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1SMENR_DMA1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1SMENR_DMA1SMEN() uint32 {
	return volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x1
}

// RCC.AHB2SMENR: AHB2 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetAHB2SMENR_AES1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB2SMENR_AES1SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB2SMENR_ADCFSSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB2SMENR_ADCFSSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB2SMENR_GPIOHSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOHSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2SMENR_GPIOESMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOESMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2SMENR_GPIODSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB2SMENR_GPIODSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB2SMENR_GPIOCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2SMENR_GPIOBSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOBSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2SMENR_GPIOASMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOASMEN() uint32 {
	return volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x1
}

// RCC.AHB3SMENR: AHB3 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetAHB3SMENR_FLASHSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB3SMENR_FLASHSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB3SMENR_SRAM2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHB3SMENR_SRAM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHB3SMENR_RNGSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB3SMENR_RNGSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB3SMENR_AES2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB3SMENR_AES2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB3SMENR_PKASMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB3SMENR_PKASMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB3SMENR_QSPISMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB3SMENR_QSPISMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x100) >> 8
}

// RCC.APB1SMENR1: APB1SMENR1
func (o *RCC_Type) SetAPB1SMENR1_LPTIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1SMENR1_LPTIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1SMENR1_USBSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1SMENR1_USBSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1SMENR1_CRSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1SMENR1_CRSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB1SMENR1_I2C3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1SMENR1_I2C1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1SMENR1_SPI2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1SMENR1_SPI2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1SMENR1_WWDGSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1SMENR1_WWDGSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1SMENR1_RTCAPBSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1SMENR1_RTCAPBSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB1SMENR1_LCDSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1SMENR1_LCDSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1SMENR1_TIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM2SMEN() uint32 {
	return volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x1
}

// RCC.APB1SMENR2: APB1 peripheral clocks enable in Sleep and Stop modes register 2
func (o *RCC_Type) SetAPB1SMENR2_LPTIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1SMENR2_LPTIM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1SMENR2_LPUART1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1SMENR2_LPUART1SMEN() uint32 {
	return volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x1
}

// RCC.APB2SMENR: APB2SMENR
func (o *RCC_Type) SetAPB2SMENR_SAI1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2SMENR_SAI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2SMENR_TIM17SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2SMENR_TIM17SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2SMENR_TIM16SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2SMENR_TIM16SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2SMENR_USART1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2SMENR_USART1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2SMENR_SPI1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2SMENR_SPI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2SMENR_TIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2SMENR_TIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x800) >> 11
}

// RCC.CCIPR: CCIPR
func (o *RCC_Type) SetCCIPR_RNGSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0000000)|value<<30)
}
func (o *RCC_Type) GetCCIPR_RNGSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0000000) >> 30
}
func (o *RCC_Type) SetCCIPR_ADCSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30000000)|value<<28)
}
func (o *RCC_Type) GetCCIPR_ADCSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30000000) >> 28
}
func (o *RCC_Type) SetCCIPR_CLK48SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc000000)|value<<26)
}
func (o *RCC_Type) GetCCIPR_CLK48SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc000000) >> 26
}
func (o *RCC_Type) SetCCIPR_SAI1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetCCIPR_SAI1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetCCIPR_LPTIM2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetCCIPR_LPTIM2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetCCIPR_LPTIM1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0000)|value<<18)
}
func (o *RCC_Type) GetCCIPR_LPTIM1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0000) >> 18
}
func (o *RCC_Type) SetCCIPR_I2C3SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetCCIPR_I2C3SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetCCIPR_I2C1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3000)|value<<12)
}
func (o *RCC_Type) GetCCIPR_I2C1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x3000) >> 12
}
func (o *RCC_Type) SetCCIPR_LPUART1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc00)|value<<10)
}
func (o *RCC_Type) GetCCIPR_LPUART1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc00) >> 10
}
func (o *RCC_Type) SetCCIPR_USART1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCCIPR_USART1SEL() uint32 {
	return volatile.LoadUint32(&o.CCIPR.Reg) & 0x3
}

// RCC.BDCR: BDCR
func (o *RCC_Type) SetBDCR_LSCOSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x6000000)|value<<25)
}
func (o *RCC_Type) GetBDCR_LSCOSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x6000000) >> 25
}
func (o *RCC_Type) SetBDCR_LSCOEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetBDCR_LSCOEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetBDCR_LSECSSD_(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetBDCR_LSECSSD_() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetBDCR_LSECSSON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetBDCR_LSECSSON() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetBDCR_LSEDRV(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x18)|value<<3)
}
func (o *RCC_Type) GetBDCR_LSEDRV() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x18) >> 3
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}

// RCC.CSR: CSR
func (o *RCC_Type) SetCSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_IWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_IWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_PINRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PINRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_OBLRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_OBLRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCSR_RFWKPSEL(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xc000)|value<<14)
}
func (o *RCC_Type) GetCSR_RFWKPSEL() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0xc000) >> 14
}
func (o *RCC_Type) SetCSR_LSI2BW(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xf00)|value<<8)
}
func (o *RCC_Type) GetCSR_LSI2BW() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0xf00) >> 8
}
func (o *RCC_Type) SetCSR_LSI2TRIMOK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCSR_LSI2TRIMOK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCSR_LSI2TRIMEN(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCSR_LSI2TRIMEN() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCSR_LSI2RDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCSR_LSI2RDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCSR_LSI2ON(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCSR_LSI2ON() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCSR_LSI1RDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSI1RDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_LSI1ON(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSI1ON() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *RCC_Type) SetCSR_RFRSTS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCSR_RFRSTS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000) >> 16
}

// RCC.CRRCR: Clock recovery RC register
func (o *RCC_Type) SetCRRCR_HSI48CAL(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0xff80)|value<<7)
}
func (o *RCC_Type) GetCRRCR_HSI48CAL() uint32 {
	return (volatile.LoadUint32(&o.CRRCR.Reg) & 0xff80) >> 7
}
func (o *RCC_Type) SetCRRCR_HSI48RDY(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCRRCR_HSI48RDY() uint32 {
	return (volatile.LoadUint32(&o.CRRCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCRRCR_HSI48ON(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCRRCR_HSI48ON() uint32 {
	return volatile.LoadUint32(&o.CRRCR.Reg) & 0x1
}

// RCC.HSECR: Clock HSE register
func (o *RCC_Type) SetHSECR_HSETUNE(value uint32) {
	volatile.StoreUint32(&o.HSECR.Reg, volatile.LoadUint32(&o.HSECR.Reg)&^(0x3f00)|value<<8)
}
func (o *RCC_Type) GetHSECR_HSETUNE() uint32 {
	return (volatile.LoadUint32(&o.HSECR.Reg) & 0x3f00) >> 8
}
func (o *RCC_Type) SetHSECR_HSEGMC(value uint32) {
	volatile.StoreUint32(&o.HSECR.Reg, volatile.LoadUint32(&o.HSECR.Reg)&^(0x70)|value<<4)
}
func (o *RCC_Type) GetHSECR_HSEGMC() uint32 {
	return (volatile.LoadUint32(&o.HSECR.Reg) & 0x70) >> 4
}
func (o *RCC_Type) SetHSECR_HSES(value uint32) {
	volatile.StoreUint32(&o.HSECR.Reg, volatile.LoadUint32(&o.HSECR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetHSECR_HSES() uint32 {
	return (volatile.LoadUint32(&o.HSECR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetHSECR_UNLOCKED(value uint32) {
	volatile.StoreUint32(&o.HSECR.Reg, volatile.LoadUint32(&o.HSECR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetHSECR_UNLOCKED() uint32 {
	return volatile.LoadUint32(&o.HSECR.Reg) & 0x1
}

// RCC.EXTCFGR: Extended clock recovery register
func (o *RCC_Type) SetEXTCFGR_RFCSS(value uint32) {
	volatile.StoreUint32(&o.EXTCFGR.Reg, volatile.LoadUint32(&o.EXTCFGR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetEXTCFGR_RFCSS() uint32 {
	return (volatile.LoadUint32(&o.EXTCFGR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetEXTCFGR_C2HPREF(value uint32) {
	volatile.StoreUint32(&o.EXTCFGR.Reg, volatile.LoadUint32(&o.EXTCFGR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetEXTCFGR_C2HPREF() uint32 {
	return (volatile.LoadUint32(&o.EXTCFGR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetEXTCFGR_SHDHPREF(value uint32) {
	volatile.StoreUint32(&o.EXTCFGR.Reg, volatile.LoadUint32(&o.EXTCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetEXTCFGR_SHDHPREF() uint32 {
	return (volatile.LoadUint32(&o.EXTCFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetEXTCFGR_C2HPRE(value uint32) {
	volatile.StoreUint32(&o.EXTCFGR.Reg, volatile.LoadUint32(&o.EXTCFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetEXTCFGR_C2HPRE() uint32 {
	return (volatile.LoadUint32(&o.EXTCFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetEXTCFGR_SHDHPRE(value uint32) {
	volatile.StoreUint32(&o.EXTCFGR.Reg, volatile.LoadUint32(&o.EXTCFGR.Reg)&^(0xf)|value)
}
func (o *RCC_Type) GetEXTCFGR_SHDHPRE() uint32 {
	return volatile.LoadUint32(&o.EXTCFGR.Reg) & 0xf
}

// RCC.C2AHB1ENR: CPU2 AHB1 peripheral clock enable register
func (o *RCC_Type) SetC2AHB1ENR_TSCEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1ENR.Reg, volatile.LoadUint32(&o.C2AHB1ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC2AHB1ENR_TSCEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC2AHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1ENR.Reg, volatile.LoadUint32(&o.C2AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC2AHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC2AHB1ENR_SRAM1EN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1ENR.Reg, volatile.LoadUint32(&o.C2AHB1ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC2AHB1ENR_SRAM1EN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC2AHB1ENR_DMAMUXEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1ENR.Reg, volatile.LoadUint32(&o.C2AHB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC2AHB1ENR_DMAMUXEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC2AHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1ENR.Reg, volatile.LoadUint32(&o.C2AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC2AHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC2AHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1ENR.Reg, volatile.LoadUint32(&o.C2AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2AHB1ENR_DMA1EN() uint32 {
	return volatile.LoadUint32(&o.C2AHB1ENR.Reg) & 0x1
}

// RCC.C2AHB2ENR: CPU2 AHB2 peripheral clock enable register
func (o *RCC_Type) SetC2AHB2ENR_AES1EN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC2AHB2ENR_AES1EN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC2AHB2ENR_ADCEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetC2AHB2ENR_ADCEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetC2AHB2ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetC2AHB2ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetC2AHB2ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC2AHB2ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC2AHB2ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetC2AHB2ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetC2AHB2ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC2AHB2ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC2AHB2ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC2AHB2ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC2AHB2ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2ENR.Reg, volatile.LoadUint32(&o.C2AHB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2AHB2ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.C2AHB2ENR.Reg) & 0x1
}

// RCC.C2AHB3ENR: CPU2 AHB3 peripheral clock enable register
func (o *RCC_Type) SetC2AHB3ENR_FLASHEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetC2AHB3ENR_FLASHEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetC2AHB3ENR_IPCCEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetC2AHB3ENR_IPCCEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetC2AHB3ENR_HSEMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetC2AHB3ENR_HSEMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetC2AHB3ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC2AHB3ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC2AHB3ENR_AES2EN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC2AHB3ENR_AES2EN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC2AHB3ENR_PKAEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3ENR.Reg, volatile.LoadUint32(&o.C2AHB3ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC2AHB3ENR_PKAEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3ENR.Reg) & 0x10000) >> 16
}

// RCC.C2APB1ENR1: CPU2 APB1ENR1
func (o *RCC_Type) SetC2APB1ENR1_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetC2APB1ENR1_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetC2APB1ENR1_USBEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetC2APB1ENR1_USBEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetC2APB1ENR1_CRSEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetC2APB1ENR1_CRSEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetC2APB1ENR1_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetC2APB1ENR1_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetC2APB1ENR1_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC2APB1ENR1_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC2APB1ENR1_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC2APB1ENR1_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC2APB1ENR1_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetC2APB1ENR1_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetC2APB1ENR1_LCDEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC2APB1ENR1_LCDEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC2APB1ENR1_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR1.Reg, volatile.LoadUint32(&o.C2APB1ENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB1ENR1_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.C2APB1ENR1.Reg) & 0x1
}

// RCC.C2APB1ENR2: CPU2 APB1 peripheral clock enable register 2
func (o *RCC_Type) SetC2APB1ENR2_LPTIM2EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR2.Reg, volatile.LoadUint32(&o.C2APB1ENR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC2APB1ENR2_LPTIM2EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1ENR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC2APB1ENR2_LPUART1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB1ENR2.Reg, volatile.LoadUint32(&o.C2APB1ENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB1ENR2_LPUART1EN() uint32 {
	return volatile.LoadUint32(&o.C2APB1ENR2.Reg) & 0x1
}

// RCC.C2APB2ENR: CPU2 APB2ENR
func (o *RCC_Type) SetC2APB2ENR_SAI1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC2APB2ENR_SAI1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC2APB2ENR_TIM17EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC2APB2ENR_TIM17EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC2APB2ENR_TIM16EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC2APB2ENR_TIM16EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC2APB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC2APB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC2APB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC2APB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC2APB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.C2APB2ENR.Reg, volatile.LoadUint32(&o.C2APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetC2APB2ENR_TIM1EN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2ENR.Reg) & 0x800) >> 11
}

// RCC.C2APB3ENR: CPU2 APB3ENR
func (o *RCC_Type) SetC2APB3ENR_EN802(value uint32) {
	volatile.StoreUint32(&o.C2APB3ENR.Reg, volatile.LoadUint32(&o.C2APB3ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC2APB3ENR_EN802() uint32 {
	return (volatile.LoadUint32(&o.C2APB3ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC2APB3ENR_BLEEN(value uint32) {
	volatile.StoreUint32(&o.C2APB3ENR.Reg, volatile.LoadUint32(&o.C2APB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB3ENR_BLEEN() uint32 {
	return volatile.LoadUint32(&o.C2APB3ENR.Reg) & 0x1
}

// RCC.C2AHB1SMENR: CPU2 AHB1 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetC2AHB1SMENR_TSCSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1SMENR.Reg, volatile.LoadUint32(&o.C2AHB1SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC2AHB1SMENR_TSCSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1SMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC2AHB1SMENR_CRCSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1SMENR.Reg, volatile.LoadUint32(&o.C2AHB1SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC2AHB1SMENR_CRCSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC2AHB1SMENR_SRAM1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1SMENR.Reg, volatile.LoadUint32(&o.C2AHB1SMENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC2AHB1SMENR_SRAM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1SMENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC2AHB1SMENR_DMAMUXSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1SMENR.Reg, volatile.LoadUint32(&o.C2AHB1SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC2AHB1SMENR_DMAMUXSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC2AHB1SMENR_DMA2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1SMENR.Reg, volatile.LoadUint32(&o.C2AHB1SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC2AHB1SMENR_DMA2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB1SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC2AHB1SMENR_DMA1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB1SMENR.Reg, volatile.LoadUint32(&o.C2AHB1SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2AHB1SMENR_DMA1SMEN() uint32 {
	return volatile.LoadUint32(&o.C2AHB1SMENR.Reg) & 0x1
}

// RCC.C2AHB2SMENR: CPU2 AHB2 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetC2AHB2SMENR_AES1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC2AHB2SMENR_AES1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetC2AHB2SMENR_ADCFSSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetC2AHB2SMENR_ADCFSSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetC2AHB2SMENR_GPIOHSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetC2AHB2SMENR_GPIOHSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetC2AHB2SMENR_GPIOESMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetC2AHB2SMENR_GPIOESMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetC2AHB2SMENR_GPIODSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetC2AHB2SMENR_GPIODSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetC2AHB2SMENR_GPIOCSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetC2AHB2SMENR_GPIOCSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetC2AHB2SMENR_GPIOBSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC2AHB2SMENR_GPIOBSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC2AHB2SMENR_GPIOASMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB2SMENR.Reg, volatile.LoadUint32(&o.C2AHB2SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2AHB2SMENR_GPIOASMEN() uint32 {
	return volatile.LoadUint32(&o.C2AHB2SMENR.Reg) & 0x1
}

// RCC.C2AHB3SMENR: CPU2 AHB3 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetC2AHB3SMENR_FLASHSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetC2AHB3SMENR_FLASHSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetC2AHB3SMENR_SRAM2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetC2AHB3SMENR_SRAM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetC2AHB3SMENR_RNGSMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC2AHB3SMENR_RNGSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC2AHB3SMENR_AES2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC2AHB3SMENR_AES2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC2AHB3SMENR_PKASMEN(value uint32) {
	volatile.StoreUint32(&o.C2AHB3SMENR.Reg, volatile.LoadUint32(&o.C2AHB3SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetC2AHB3SMENR_PKASMEN() uint32 {
	return (volatile.LoadUint32(&o.C2AHB3SMENR.Reg) & 0x10000) >> 16
}

// RCC.C2APB1SMENR1: CPU2 APB1SMENR1
func (o *RCC_Type) SetC2APB1SMENR1_LPTIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetC2APB1SMENR1_LPTIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetC2APB1SMENR1_USBSMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetC2APB1SMENR1_USBSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetC2APB1SMENR1_CRSMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetC2APB1SMENR1_CRSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetC2APB1SMENR1_I2C3SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetC2APB1SMENR1_I2C3SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetC2APB1SMENR1_I2C1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC2APB1SMENR1_I2C1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC2APB1SMENR1_SPI2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC2APB1SMENR1_SPI2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC2APB1SMENR1_RTCAPBSMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetC2APB1SMENR1_RTCAPBSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetC2APB1SMENR1_LCDSMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetC2APB1SMENR1_LCDSMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetC2APB1SMENR1_TIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR1.Reg, volatile.LoadUint32(&o.C2APB1SMENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB1SMENR1_TIM2SMEN() uint32 {
	return volatile.LoadUint32(&o.C2APB1SMENR1.Reg) & 0x1
}

// RCC.C2APB1SMENR2: CPU2 APB1 peripheral clocks enable in Sleep and Stop modes register 2
func (o *RCC_Type) SetC2APB1SMENR2_LPTIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR2.Reg, volatile.LoadUint32(&o.C2APB1SMENR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetC2APB1SMENR2_LPTIM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB1SMENR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetC2APB1SMENR2_LPUART1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB1SMENR2.Reg, volatile.LoadUint32(&o.C2APB1SMENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB1SMENR2_LPUART1SMEN() uint32 {
	return volatile.LoadUint32(&o.C2APB1SMENR2.Reg) & 0x1
}

// RCC.C2APB2SMENR: CPU2 APB2SMENR
func (o *RCC_Type) SetC2APB2SMENR_SAI1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetC2APB2SMENR_SAI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetC2APB2SMENR_TIM17SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetC2APB2SMENR_TIM17SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetC2APB2SMENR_TIM16SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetC2APB2SMENR_TIM16SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetC2APB2SMENR_USART1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetC2APB2SMENR_USART1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetC2APB2SMENR_SPI1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetC2APB2SMENR_SPI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetC2APB2SMENR_TIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB2SMENR.Reg, volatile.LoadUint32(&o.C2APB2SMENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetC2APB2SMENR_TIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.C2APB2SMENR.Reg) & 0x800) >> 11
}

// RCC.C2APB3SMENR: CPU2 APB3SMENR
func (o *RCC_Type) SetC2APB3SMENR_SMEN802(value uint32) {
	volatile.StoreUint32(&o.C2APB3SMENR.Reg, volatile.LoadUint32(&o.C2APB3SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetC2APB3SMENR_SMEN802() uint32 {
	return (volatile.LoadUint32(&o.C2APB3SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetC2APB3SMENR_BLESMEN(value uint32) {
	volatile.StoreUint32(&o.C2APB3SMENR.Reg, volatile.LoadUint32(&o.C2APB3SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetC2APB3SMENR_BLESMEN() uint32 {
	return volatile.LoadUint32(&o.C2APB3SMENR.Reg) & 0x1
}

// Power control
type PWR_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	CR3    volatile.Register32 // 0x8
	CR4    volatile.Register32 // 0xC
	SR1    volatile.Register32 // 0x10
	SR2    volatile.Register32 // 0x14
	SCR    volatile.Register32 // 0x18
	CR5    volatile.Register32 // 0x1C
	PUCRA  volatile.Register32 // 0x20
	PDCRA  volatile.Register32 // 0x24
	PUCRB  volatile.Register32 // 0x28
	PDCRB  volatile.Register32 // 0x2C
	PUCRC  volatile.Register32 // 0x30
	PDCRC  volatile.Register32 // 0x34
	PUCRD  volatile.Register32 // 0x38
	PDCRD  volatile.Register32 // 0x3C
	PUCRE  volatile.Register32 // 0x40
	PDCRE  volatile.Register32 // 0x44
	_      [16]byte
	PUCRH  volatile.Register32 // 0x58
	PDCRH  volatile.Register32 // 0x5C
	_      [32]byte
	C2CR1  volatile.Register32 // 0x80
	C2CR3  volatile.Register32 // 0x84
	EXTSCR volatile.Register32 // 0x88
}

// PWR.CR1: Power control register 1
func (o *PWR_Type) SetCR1_LPR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR1_LPR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR1_VOS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x600)|value<<9)
}
func (o *PWR_Type) GetCR1_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x600) >> 9
}
func (o *PWR_Type) SetCR1_DBP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR1_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR1_FPDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCR1_FPDS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCR1_FPDR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR1_FPDR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR1_LPMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x7)|value)
}
func (o *PWR_Type) GetCR1_LPMS() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x7
}

// PWR.CR2: Power control register 2
func (o *PWR_Type) SetCR2_USV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR2_USV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR2_PVME3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetCR2_PVME3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetCR2_PVME1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR2_PVME1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR2_PLS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xe)|value<<1)
}
func (o *PWR_Type) GetCR2_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xe) >> 1
}
func (o *PWR_Type) SetCR2_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR2_PVDE() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// PWR.CR3: Power control register 3
func (o *PWR_Type) SetCR3_EIWUL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetCR3_EIWUL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetCR3_EC2H(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR3_EC2H() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR3_E802A(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR3_E802A() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetCR3_EBLEA(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCR3_EBLEA() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetCR3_ECRPE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetCR3_ECRPE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetCR3_APC(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR3_APC() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR3_RRS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR3_RRS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR3_EBORHSDFB(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR3_EBORHSDFB() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR3_EWUP5(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR3_EWUP5() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR3_EWUP4(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR3_EWUP4() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR3_EWUP3(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR3_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR3_EWUP2(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR3_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR3_EWUP1(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR3_EWUP1() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// PWR.CR4: Power control register 4
func (o *PWR_Type) SetCR4_C2BOOT(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetCR4_C2BOOT() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetCR4_VBRS(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR4_VBRS() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR4_VBE(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR4_VBE() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR4_WP5(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR4_WP5() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR4_WP4(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR4_WP4() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR4_WP3(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR4_WP3() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR4_WP2(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR4_WP2() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR4_WP1(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR4_WP1() uint32 {
	return volatile.LoadUint32(&o.CR4.Reg) & 0x1
}

// PWR.SR1: Power status register 1
func (o *PWR_Type) SetSR1_WUFI(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSR1_WUFI() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetSR1_C2HF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetSR1_C2HF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetSR1_AF802(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetSR1_AF802() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetSR1_BLEAF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetSR1_BLEAF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetSR1_CRPEF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetSR1_CRPEF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetSR1__802WUF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetSR1__802WUF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetSR1_BLEWUF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetSR1_BLEWUF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetSR1_BORHF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR1_BORHF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSR1_SDFBF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetSR1_SDFBF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetSR1_CWUF5(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSR1_CWUF5() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSR1_CWUF4(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSR1_CWUF4() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSR1_CWUF3(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSR1_CWUF3() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSR1_CWUF2(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSR1_CWUF2() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSR1_CWUF1(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSR1_CWUF1() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}

// PWR.SR2: Power status register 2
func (o *PWR_Type) SetSR2_PVMO3(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetSR2_PVMO3() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetSR2_PVMO1(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetSR2_PVMO1() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetSR2_PVDO(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetSR2_PVDO() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetSR2_VOSF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetSR2_VOSF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetSR2_REGLPF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetSR2_REGLPF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetSR2_REGLPS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR2_REGLPS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSR2_SDSMPSF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSR2_SDSMPSF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSR2_SDBF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSR2_SDBF() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}

// PWR.SCR: Power status clear register
func (o *PWR_Type) SetSCR_CC2HF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetSCR_CC2HF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetSCR_C802AF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetSCR_C802AF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetSCR_CBLEAF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetSCR_CBLEAF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetSCR_CCRPEF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetSCR_CCRPEF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetSCR_C802WUF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetSCR_C802WUF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetSCR_CBLEWUF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetSCR_CBLEWUF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetSCR_CBORHF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSCR_CBORHF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSCR_CSMPSFBF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetSCR_CSMPSFBF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetSCR_CWUF5(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSCR_CWUF5() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSCR_CWUF4(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSCR_CWUF4() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSCR_CWUF3(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSCR_CWUF3() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSCR_CWUF2(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSCR_CWUF2() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSCR_CWUF1(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSCR_CWUF1() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}

// PWR.CR5: Power control register 5
func (o *PWR_Type) SetCR5_SDEB(value uint32) {
	volatile.StoreUint32(&o.CR5.Reg, volatile.LoadUint32(&o.CR5.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetCR5_SDEB() uint32 {
	return (volatile.LoadUint32(&o.CR5.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetCR5_SDBEN(value uint32) {
	volatile.StoreUint32(&o.CR5.Reg, volatile.LoadUint32(&o.CR5.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR5_SDBEN() uint32 {
	return (volatile.LoadUint32(&o.CR5.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR5_SMPSCFG(value uint32) {
	volatile.StoreUint32(&o.CR5.Reg, volatile.LoadUint32(&o.CR5.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR5_SMPSCFG() uint32 {
	return (volatile.LoadUint32(&o.CR5.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR5_BORHC(value uint32) {
	volatile.StoreUint32(&o.CR5.Reg, volatile.LoadUint32(&o.CR5.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR5_BORHC() uint32 {
	return (volatile.LoadUint32(&o.CR5.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR5_SDSC(value uint32) {
	volatile.StoreUint32(&o.CR5.Reg, volatile.LoadUint32(&o.CR5.Reg)&^(0x70)|value<<4)
}
func (o *PWR_Type) GetCR5_SDSC() uint32 {
	return (volatile.LoadUint32(&o.CR5.Reg) & 0x70) >> 4
}
func (o *PWR_Type) SetCR5_SDVOS(value uint32) {
	volatile.StoreUint32(&o.CR5.Reg, volatile.LoadUint32(&o.CR5.Reg)&^(0xf)|value)
}
func (o *PWR_Type) GetCR5_SDVOS() uint32 {
	return volatile.LoadUint32(&o.CR5.Reg) & 0xf
}

// PWR.PUCRA: Power Port A pull-up control register
func (o *PWR_Type) SetPUCRA_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRA_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRA_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRA_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRA_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRA_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRA_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRA_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRA_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRA_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRA_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRA_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRA_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRA_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRA_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRA_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRA_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRA_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRA_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRA_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRA_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRA_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRA_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRA_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRA_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRA_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRA_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRA_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRA_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRA_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRA.Reg) & 0x1
}

// PWR.PDCRA: Power Port A pull-down control register
func (o *PWR_Type) SetPDCRA_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRA_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRA_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRA_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRA_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRA_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRA_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRA_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRA_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRA_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRA_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRA_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRA_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRA_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRA_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRA_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRA_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRA_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRA_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRA_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRA_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRA_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRA_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRA_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRA_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRA_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRA_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRA_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRA.Reg) & 0x1
}

// PWR.PUCRB: Power Port B pull-up control register
func (o *PWR_Type) SetPUCRB_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRB_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRB_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRB_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRB_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRB_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRB_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRB_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRB_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRB_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRB_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRB_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRB_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRB_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRB_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRB_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRB_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRB_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRB_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRB_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRB_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRB_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRB_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRB_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRB_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRB_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRB_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRB_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRB_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRB_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRB_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRB_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRB.Reg) & 0x1
}

// PWR.PDCRB: Power Port B pull-down control register
func (o *PWR_Type) SetPDCRB_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRB_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRB_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRB_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRB_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRB_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRB_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRB_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRB_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRB_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRB_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRB_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRB_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRB_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRB_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRB_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRB_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRB_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRB_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRB_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRB_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRB_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRB_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRB_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRB_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRB_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRB_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRB_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRB_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRB_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRB.Reg) & 0x1
}

// PWR.PUCRC: Power Port C pull-up control register
func (o *PWR_Type) SetPUCRC_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRC_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRC_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRC_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRC_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRC_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRC_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRC_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRC_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRC_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRC_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRC_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRC_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRC_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRC_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRC_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRC_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRC_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRC_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRC_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRC_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRC_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRC_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRC_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRC_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRC_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRC_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRC_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRC_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRC_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRC_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRC_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRC.Reg) & 0x1
}

// PWR.PDCRC: Power Port C pull-down control register
func (o *PWR_Type) SetPDCRC_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRC_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRC_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRC_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRC_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRC_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRC_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRC_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRC_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRC_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRC_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRC_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRC_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRC_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRC_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRC_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRC_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRC_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRC_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRC_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRC_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRC_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRC_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRC_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRC_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRC_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRC_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRC_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRC_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRC_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRC_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRC_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRC.Reg) & 0x1
}

// PWR.PUCRD: Power Port D pull-up control register
func (o *PWR_Type) SetPUCRD_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRD_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRD_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRD_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRD_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRD_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRD_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRD_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRD_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRD_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRD_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRD_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRD_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRD_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRD_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRD_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRD_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRD_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRD_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRD_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRD_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRD_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRD_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRD_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRD_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRD_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRD_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRD_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRD_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRD_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRD_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRD_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRD.Reg) & 0x1
}

// PWR.PDCRD: Power Port D pull-down control register
func (o *PWR_Type) SetPDCRD_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRD_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRD_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRD_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRD_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRD_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRD_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRD_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRD_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRD_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRD_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRD_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRD_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRD_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRD_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRD_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRD_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRD_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRD_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRD_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRD_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRD_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRD_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRD_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRD_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRD_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRD_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRD_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRD_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRD_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRD_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRD_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRD.Reg) & 0x1
}

// PWR.PUCRE: Power Port E pull-up control register
func (o *PWR_Type) SetPUCRE_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRE_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRE_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRE_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRE_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRE_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRE_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRE_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRE_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRE_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRE.Reg) & 0x1
}

// PWR.PDCRE: Power Port E pull-down control register
func (o *PWR_Type) SetPDCRE_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRE_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRE_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRE_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRE_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRE_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRE_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRE_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRE_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRE_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRE.Reg) & 0x1
}

// PWR.PUCRH: Power Port H pull-up control register
func (o *PWR_Type) SetPUCRH_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRH.Reg, volatile.LoadUint32(&o.PUCRH.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRH_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRH.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRH_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRH.Reg, volatile.LoadUint32(&o.PUCRH.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRH_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRH.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRH_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRH.Reg, volatile.LoadUint32(&o.PUCRH.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRH_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRH.Reg) & 0x1
}

// PWR.PDCRH: Power Port H pull-down control register
func (o *PWR_Type) SetPDCRH_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRH.Reg, volatile.LoadUint32(&o.PDCRH.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRH_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRH.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRH_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRH.Reg, volatile.LoadUint32(&o.PDCRH.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRH_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRH.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRH_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRH.Reg, volatile.LoadUint32(&o.PDCRH.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRH_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRH.Reg) & 0x1
}

// PWR.C2CR1: CPU2 Power control register 1
func (o *PWR_Type) SetC2CR1__802EWKUP(value uint32) {
	volatile.StoreUint32(&o.C2CR1.Reg, volatile.LoadUint32(&o.C2CR1.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetC2CR1__802EWKUP() uint32 {
	return (volatile.LoadUint32(&o.C2CR1.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetC2CR1_BLEEWKUP(value uint32) {
	volatile.StoreUint32(&o.C2CR1.Reg, volatile.LoadUint32(&o.C2CR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetC2CR1_BLEEWKUP() uint32 {
	return (volatile.LoadUint32(&o.C2CR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetC2CR1_FPDS(value uint32) {
	volatile.StoreUint32(&o.C2CR1.Reg, volatile.LoadUint32(&o.C2CR1.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetC2CR1_FPDS() uint32 {
	return (volatile.LoadUint32(&o.C2CR1.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetC2CR1_FPDR(value uint32) {
	volatile.StoreUint32(&o.C2CR1.Reg, volatile.LoadUint32(&o.C2CR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetC2CR1_FPDR() uint32 {
	return (volatile.LoadUint32(&o.C2CR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetC2CR1_LPMS(value uint32) {
	volatile.StoreUint32(&o.C2CR1.Reg, volatile.LoadUint32(&o.C2CR1.Reg)&^(0x7)|value)
}
func (o *PWR_Type) GetC2CR1_LPMS() uint32 {
	return volatile.LoadUint32(&o.C2CR1.Reg) & 0x7
}

// PWR.C2CR3: CPU2 Power control register 3
func (o *PWR_Type) SetC2CR3_EIWUL(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetC2CR3_EIWUL() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetC2CR3_APC(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetC2CR3_APC() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetC2CR3_E802WUP(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetC2CR3_E802WUP() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetC2CR3_EBLEWUP(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetC2CR3_EBLEWUP() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetC2CR3_EWUP5(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetC2CR3_EWUP5() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetC2CR3_EWUP4(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetC2CR3_EWUP4() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetC2CR3_EWUP3(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetC2CR3_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetC2CR3_EWUP2(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetC2CR3_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.C2CR3.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetC2CR3_EWUP1(value uint32) {
	volatile.StoreUint32(&o.C2CR3.Reg, volatile.LoadUint32(&o.C2CR3.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetC2CR3_EWUP1() uint32 {
	return volatile.LoadUint32(&o.C2CR3.Reg) & 0x1
}

// PWR.EXTSCR: Power status clear register
func (o *PWR_Type) SetEXTSCR_C2DS(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetEXTSCR_C2DS() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetEXTSCR_C1DS(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetEXTSCR_C1DS() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetEXTSCR_CRPF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetEXTSCR_CRPF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetEXTSCR_C2STOPF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetEXTSCR_C2STOPF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetEXTSCR_C2SBF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetEXTSCR_C2SBF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetEXTSCR_C1STOPF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetEXTSCR_C1STOPF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetEXTSCR_C1SBF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetEXTSCR_C1SBF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetEXTSCR_CCRPF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetEXTSCR_CCRPF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetEXTSCR_C2CSSF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetEXTSCR_C2CSSF() uint32 {
	return (volatile.LoadUint32(&o.EXTSCR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetEXTSCR_C1CSSF(value uint32) {
	volatile.StoreUint32(&o.EXTSCR.Reg, volatile.LoadUint32(&o.EXTSCR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetEXTSCR_C1CSSF() uint32 {
	return volatile.LoadUint32(&o.EXTSCR.Reg) & 0x1
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	CFGR1   volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	SCSR    volatile.Register32 // 0x18
	CFGR2   volatile.Register32 // 0x1C
	SWPR    volatile.Register32 // 0x20
	SKR     volatile.Register32 // 0x24
	SWPR2   volatile.Register32 // 0x28
	_       [212]byte
	IMR1    volatile.Register32 // 0x100
	IMR2    volatile.Register32 // 0x104
	C2IMR1  volatile.Register32 // 0x108
	C2IMR2  volatile.Register32 // 0x10C
	SIPCR   volatile.Register32 // 0x110
}

// SYSCFG.MEMRMP: memory remap register
func (o *SYSCFG_Type) SetMEMRMP_MEM_MODE(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetMEMRMP_MEM_MODE() uint32 {
	return volatile.LoadUint32(&o.MEMRMP.Reg) & 0x7
}

// SYSCFG.CFGR1: configuration register 1
func (o *SYSCFG_Type) SetCFGR1_FPU_IE(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xfc000000)|value<<26)
}
func (o *SYSCFG_Type) GetCFGR1_FPU_IE() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xfc000000) >> 26
}
func (o *SYSCFG_Type) SetCFGR1_I2C3_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetCFGR1_I2C3_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetCFGR1_I2C1_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetCFGR1_I2C1_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB9_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB9_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB8_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB8_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB7_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB7_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB6_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB6_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetCFGR1_BOOSTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCFGR1_BOOSTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100) >> 8
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0x7
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0x7
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0x7
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0x7
}

// SYSCFG.SCSR: SCSR
func (o *SYSCFG_Type) SetSCSR_SRAM2BSY(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetSCSR_SRAM2BSY() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetSCSR_SRAM2ER(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetSCSR_SRAM2ER() uint32 {
	return volatile.LoadUint32(&o.SCSR.Reg) & 0x1
}
func (o *SYSCFG_Type) SetSCSR_C2RFD(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCFG_Type) GetSCSR_C2RFD() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x80000000) >> 31
}

// SYSCFG.CFGR2: CFGR2
func (o *SYSCFG_Type) SetCFGR2_SPF(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCFGR2_SPF() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetCFGR2_ECCL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetCFGR2_ECCL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetCFGR2_PVDL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetCFGR2_PVDL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetCFGR2_SPL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetCFGR2_SPL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetCFGR2_CLL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCFGR2_CLL() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}

// SYSCFG.SWPR: SRAM2 write protection register
func (o *SYSCFG_Type) SetSWPR_P31WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCFG_Type) GetSWPR_P31WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80000000) >> 31
}
func (o *SYSCFG_Type) SetSWPR_P30WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCFG_Type) GetSWPR_P30WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40000000) >> 30
}
func (o *SYSCFG_Type) SetSWPR_P29WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCFG_Type) GetSWPR_P29WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20000000) >> 29
}
func (o *SYSCFG_Type) SetSWPR_P28WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCFG_Type) GetSWPR_P28WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10000000) >> 28
}
func (o *SYSCFG_Type) SetSWPR_P27WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCFG_Type) GetSWPR_P27WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8000000) >> 27
}
func (o *SYSCFG_Type) SetSWPR_P26WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCFG_Type) GetSWPR_P26WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4000000) >> 26
}
func (o *SYSCFG_Type) SetSWPR_P25WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCFG_Type) GetSWPR_P25WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2000000) >> 25
}
func (o *SYSCFG_Type) SetSWPR_P24WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCFG_Type) GetSWPR_P24WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x1000000) >> 24
}
func (o *SYSCFG_Type) SetSWPR_P23WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetSWPR_P23WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x800000) >> 23
}
func (o *SYSCFG_Type) SetSWPR_P22WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetSWPR_P22WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetSWPR_P21WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetSWPR_P21WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetSWPR_P20WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetSWPR_P20WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetSWPR_P19WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetSWPR_P19WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetSWPR_P18WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetSWPR_P18WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetSWPR_P17WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetSWPR_P17WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetSWPR_P16WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetSWPR_P16WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetSWPR_P15WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCFG_Type) GetSWPR_P15WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8000) >> 15
}
func (o *SYSCFG_Type) SetSWPR_P14WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCFG_Type) GetSWPR_P14WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4000) >> 14
}
func (o *SYSCFG_Type) SetSWPR_P13WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCFG_Type) GetSWPR_P13WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2000) >> 13
}
func (o *SYSCFG_Type) SetSWPR_P12WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCFG_Type) GetSWPR_P12WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x1000) >> 12
}
func (o *SYSCFG_Type) SetSWPR_P11WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x800)|value<<11)
}
func (o *SYSCFG_Type) GetSWPR_P11WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x800) >> 11
}
func (o *SYSCFG_Type) SetSWPR_P10WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x400)|value<<10)
}
func (o *SYSCFG_Type) GetSWPR_P10WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x400) >> 10
}
func (o *SYSCFG_Type) SetSWPR_P9WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x200)|value<<9)
}
func (o *SYSCFG_Type) GetSWPR_P9WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x200) >> 9
}
func (o *SYSCFG_Type) SetSWPR_P8WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetSWPR_P8WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetSWPR_P7WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80)|value<<7)
}
func (o *SYSCFG_Type) GetSWPR_P7WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80) >> 7
}
func (o *SYSCFG_Type) SetSWPR_P6WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetSWPR_P6WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetSWPR_P5WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetSWPR_P5WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetSWPR_P4WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetSWPR_P4WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetSWPR_P3WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetSWPR_P3WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetSWPR_P2WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetSWPR_P2WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetSWPR_P1WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetSWPR_P1WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetSWPR_P0WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetSWPR_P0WP() uint32 {
	return volatile.LoadUint32(&o.SWPR.Reg) & 0x1
}

// SYSCFG.SKR: SKR
func (o *SYSCFG_Type) SetSKR_KEY(value uint32) {
	volatile.StoreUint32(&o.SKR.Reg, volatile.LoadUint32(&o.SKR.Reg)&^(0xff)|value)
}
func (o *SYSCFG_Type) GetSKR_KEY() uint32 {
	return volatile.LoadUint32(&o.SKR.Reg) & 0xff
}

// SYSCFG.SWPR2: SRAM2 write protection register 2
func (o *SYSCFG_Type) SetSWPR2_P63WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCFG_Type) GetSWPR2_P63WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x80000000) >> 31
}
func (o *SYSCFG_Type) SetSWPR2_P62WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCFG_Type) GetSWPR2_P62WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x40000000) >> 30
}
func (o *SYSCFG_Type) SetSWPR2_P61WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCFG_Type) GetSWPR2_P61WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x20000000) >> 29
}
func (o *SYSCFG_Type) SetSWPR2_P60WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCFG_Type) GetSWPR2_P60WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x10000000) >> 28
}
func (o *SYSCFG_Type) SetSWPR2_P59WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCFG_Type) GetSWPR2_P59WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x8000000) >> 27
}
func (o *SYSCFG_Type) SetSWPR2_P58WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCFG_Type) GetSWPR2_P58WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x4000000) >> 26
}
func (o *SYSCFG_Type) SetSWPR2_P57WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCFG_Type) GetSWPR2_P57WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x2000000) >> 25
}
func (o *SYSCFG_Type) SetSWPR2_P56WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCFG_Type) GetSWPR2_P56WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x1000000) >> 24
}
func (o *SYSCFG_Type) SetSWPR2_P55WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetSWPR2_P55WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x800000) >> 23
}
func (o *SYSCFG_Type) SetSWPR2_P54WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetSWPR2_P54WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetSWPR2_P53WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetSWPR2_P53WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetSWPR2_P52WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetSWPR2_P52WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetSWPR2_P51WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetSWPR2_P51WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetSWPR2_P50WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetSWPR2_P50WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetSWPR2_P49WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetSWPR2_P49WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetSWPR2_P48WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetSWPR2_P48WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetSWPR2_P47WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCFG_Type) GetSWPR2_P47WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x8000) >> 15
}
func (o *SYSCFG_Type) SetSWPR2_P46WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCFG_Type) GetSWPR2_P46WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x4000) >> 14
}
func (o *SYSCFG_Type) SetSWPR2_P45WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCFG_Type) GetSWPR2_P45WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x2000) >> 13
}
func (o *SYSCFG_Type) SetSWPR2_P44WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCFG_Type) GetSWPR2_P44WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x1000) >> 12
}
func (o *SYSCFG_Type) SetSWPR2_P43WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x800)|value<<11)
}
func (o *SYSCFG_Type) GetSWPR2_P43WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x800) >> 11
}
func (o *SYSCFG_Type) SetSWPR2_P42WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x400)|value<<10)
}
func (o *SYSCFG_Type) GetSWPR2_P42WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x400) >> 10
}
func (o *SYSCFG_Type) SetSWPR2_P41WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x200)|value<<9)
}
func (o *SYSCFG_Type) GetSWPR2_P41WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x200) >> 9
}
func (o *SYSCFG_Type) SetSWPR2_P40WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetSWPR2_P40WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetSWPR2_P39WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x80)|value<<7)
}
func (o *SYSCFG_Type) GetSWPR2_P39WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x80) >> 7
}
func (o *SYSCFG_Type) SetSWPR2_P38WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetSWPR2_P38WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetSWPR2_P37WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetSWPR2_P37WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetSWPR2_P36WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetSWPR2_P36WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetSWPR2_P35WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetSWPR2_P35WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetSWPR2_P34WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetSWPR2_P34WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetSWPR2_P33WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetSWPR2_P33WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR2.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetSWPR2_P32WP(value uint32) {
	volatile.StoreUint32(&o.SWPR2.Reg, volatile.LoadUint32(&o.SWPR2.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetSWPR2_P32WP() uint32 {
	return volatile.LoadUint32(&o.SWPR2.Reg) & 0x1
}

// SYSCFG.IMR1: CPU1 interrupt mask register 1
func (o *SYSCFG_Type) SetIMR1_TIM1IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCFG_Type) GetIMR1_TIM1IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000) >> 13
}
func (o *SYSCFG_Type) SetIMR1_TIM16IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCFG_Type) GetIMR1_TIM16IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000) >> 14
}
func (o *SYSCFG_Type) SetIMR1_TIM17IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCFG_Type) GetIMR1_TIM17IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000) >> 15
}
func (o *SYSCFG_Type) SetIMR1_EXIT5IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetIMR1_EXIT5IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetIMR1_EXIT6IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetIMR1_EXIT6IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetIMR1_EXIT7IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetIMR1_EXIT7IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800000) >> 23
}
func (o *SYSCFG_Type) SetIMR1_EXIT8IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCFG_Type) GetIMR1_EXIT8IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000000) >> 24
}
func (o *SYSCFG_Type) SetIMR1_EXIT9IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCFG_Type) GetIMR1_EXIT9IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000000) >> 25
}
func (o *SYSCFG_Type) SetIMR1_EXIT10IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCFG_Type) GetIMR1_EXIT10IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000000) >> 26
}
func (o *SYSCFG_Type) SetIMR1_EXIT11IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCFG_Type) GetIMR1_EXIT11IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000000) >> 27
}
func (o *SYSCFG_Type) SetIMR1_EXIT12IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCFG_Type) GetIMR1_EXIT12IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000000) >> 28
}
func (o *SYSCFG_Type) SetIMR1_EXIT13IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCFG_Type) GetIMR1_EXIT13IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000000) >> 29
}
func (o *SYSCFG_Type) SetIMR1_EXIT14IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCFG_Type) GetIMR1_EXIT14IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000000) >> 30
}
func (o *SYSCFG_Type) SetIMR1_EXIT15IM(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCFG_Type) GetIMR1_EXIT15IM() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000000) >> 31
}

// SYSCFG.IMR2: CPU1 interrupt mask register 2
func (o *SYSCFG_Type) SetIMR2_PVM3IM(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetIMR2_PVM3IM() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetIMR2_PVM1IM(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetIMR2_PVM1IM() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetIMR2_PVDIM(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetIMR2_PVDIM() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100000) >> 20
}

// SYSCFG.C2IMR1: CPU2 interrupt mask register 1
func (o *SYSCFG_Type) SetC2IMR1_RTCSTAMP(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetC2IMR1_RTCSTAMP() uint32 {
	return volatile.LoadUint32(&o.C2IMR1.Reg) & 0x1
}
func (o *SYSCFG_Type) SetC2IMR1_RTCWKUP(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetC2IMR1_RTCWKUP() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetC2IMR1_RTCALARM(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetC2IMR1_RTCALARM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetC2IMR1_RCC(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetC2IMR1_RCC() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetC2IMR1_FLASH(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetC2IMR1_FLASH() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetC2IMR1_PKA(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetC2IMR1_PKA() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetC2IMR1_RNG(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x200)|value<<9)
}
func (o *SYSCFG_Type) GetC2IMR1_RNG() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x200) >> 9
}
func (o *SYSCFG_Type) SetC2IMR1_AES1(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x400)|value<<10)
}
func (o *SYSCFG_Type) GetC2IMR1_AES1() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x400) >> 10
}
func (o *SYSCFG_Type) SetC2IMR1_COMP(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x800)|value<<11)
}
func (o *SYSCFG_Type) GetC2IMR1_COMP() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x800) >> 11
}
func (o *SYSCFG_Type) SetC2IMR1_ADC(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCFG_Type) GetC2IMR1_ADC() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x1000) >> 12
}

// SYSCFG.C2IMR2: CPU2 interrupt mask register 1
func (o *SYSCFG_Type) SetC2IMR2_DMA1_CH1_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1_CH1_IM() uint32 {
	return volatile.LoadUint32(&o.C2IMR2.Reg) & 0x1
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1_CH2_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1_CH2_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1_CH3_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1_CH3_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1_CH4_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1_CH4_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1_CH5_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1_CH5_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1_CH6_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1_CH6_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetC2IMR2_DMA1_CH7_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA1_CH7_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2_CH1_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2_CH1_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2_CH2_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x200)|value<<9)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2_CH2_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x200) >> 9
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2_CH3_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x400)|value<<10)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2_CH3_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x400) >> 10
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2_CH4_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x800)|value<<11)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2_CH4_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x800) >> 11
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2_CH5_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2_CH5_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x1000) >> 12
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2_CH6_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2_CH6_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x2000) >> 13
}
func (o *SYSCFG_Type) SetC2IMR2_DMA2_CH7_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCFG_Type) GetC2IMR2_DMA2_CH7_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x4000) >> 14
}
func (o *SYSCFG_Type) SetC2IMR2_DMAM_UX1_IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCFG_Type) GetC2IMR2_DMAM_UX1_IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x8000) >> 15
}
func (o *SYSCFG_Type) SetC2IMR2_PVM1IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetC2IMR2_PVM1IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetC2IMR2_PVM3IM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetC2IMR2_PVM3IM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetC2IMR2_PVDIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetC2IMR2_PVDIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetC2IMR2_TSCIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetC2IMR2_TSCIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetC2IMR2_LCDIM(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetC2IMR2_LCDIM() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x400000) >> 22
}

// SYSCFG.SIPCR: secure IP control register
func (o *SYSCFG_Type) SetSIPCR_SAES1(value uint32) {
	volatile.StoreUint32(&o.SIPCR.Reg, volatile.LoadUint32(&o.SIPCR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetSIPCR_SAES1() uint32 {
	return volatile.LoadUint32(&o.SIPCR.Reg) & 0x1
}
func (o *SYSCFG_Type) SetSIPCR_SAES2(value uint32) {
	volatile.StoreUint32(&o.SIPCR.Reg, volatile.LoadUint32(&o.SIPCR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetSIPCR_SAES2() uint32 {
	return (volatile.LoadUint32(&o.SIPCR.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetSIPCR_SPKA(value uint32) {
	volatile.StoreUint32(&o.SIPCR.Reg, volatile.LoadUint32(&o.SIPCR.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetSIPCR_SPKA() uint32 {
	return (volatile.LoadUint32(&o.SIPCR.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetSIPCR_SRNG(value uint32) {
	volatile.StoreUint32(&o.SIPCR.Reg, volatile.LoadUint32(&o.SIPCR.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetSIPCR_SRNG() uint32 {
	return (volatile.LoadUint32(&o.SIPCR.Reg) & 0x8) >> 3
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// RNG.CR: control register
func (o *RNG_Type) SetCR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetCR_IE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_IE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_BYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetCR_BYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}

// RNG.SR: status register
func (o *RNG_Type) SetSR_SEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetSR_SEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *RNG_Type) SetSR_CEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetSR_CEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetSR_SECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_SECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_CECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_CECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_DRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// RNG.DR: data register
func (o *RNG_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *RNG_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// Advanced encryption standard hardware accelerator 1
type AES1_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	DINR   volatile.Register32 // 0x8
	DOUTR  volatile.Register32 // 0xC
	KEYR0  volatile.Register32 // 0x10
	KEYR1  volatile.Register32 // 0x14
	KEYR2  volatile.Register32 // 0x18
	KEYR3  volatile.Register32 // 0x1C
	IVR0   volatile.Register32 // 0x20
	IVR1   volatile.Register32 // 0x24
	IVR2   volatile.Register32 // 0x28
	IVR3   volatile.Register32 // 0x2C
	KEYR4  volatile.Register32 // 0x30
	KEYR5  volatile.Register32 // 0x34
	KEYR6  volatile.Register32 // 0x38
	KEYR7  volatile.Register32 // 0x3C
	SUSP0R volatile.Register32 // 0x40
	SUSP1R volatile.Register32 // 0x44
	SUSP2R volatile.Register32 // 0x48
	SUSP3R volatile.Register32 // 0x4C
	SUSP4R volatile.Register32 // 0x50
	SUSP5R volatile.Register32 // 0x54
	SUSP6R volatile.Register32 // 0x58
	SUSP7R volatile.Register32 // 0x5C
	_      [912]byte
	HWCFR  volatile.Register32 // 0x3F0
	VERR   volatile.Register32 // 0x3F4
	IPIDR  volatile.Register32 // 0x3F8
	SIDR   volatile.Register32 // 0x3FC
}

// AES1.CR: control register
func (o *AES1_Type) SetCR_NPBLB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00000)|value<<20)
}
func (o *AES1_Type) GetCR_NPBLB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00000) >> 20
}
func (o *AES1_Type) SetCR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *AES1_Type) GetCR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *AES1_Type) SetCR_CHMOD2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *AES1_Type) GetCR_CHMOD2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *AES1_Type) SetCR_GCMPH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6000)|value<<13)
}
func (o *AES1_Type) GetCR_GCMPH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6000) >> 13
}
func (o *AES1_Type) SetCR_DMAOUTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *AES1_Type) GetCR_DMAOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *AES1_Type) SetCR_DMAINEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *AES1_Type) GetCR_DMAINEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *AES1_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *AES1_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *AES1_Type) SetCR_CCFIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *AES1_Type) GetCR_CCFIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *AES1_Type) SetCR_ERRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *AES1_Type) GetCR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *AES1_Type) SetCR_CCFC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *AES1_Type) GetCR_CCFC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *AES1_Type) SetCR_CHMOD10(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *AES1_Type) GetCR_CHMOD10() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *AES1_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *AES1_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *AES1_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6)|value<<1)
}
func (o *AES1_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6) >> 1
}
func (o *AES1_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AES1_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// AES1.SR: status register
func (o *AES1_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *AES1_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *AES1_Type) SetSR_WRERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *AES1_Type) GetSR_WRERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *AES1_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *AES1_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *AES1_Type) SetSR_CCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *AES1_Type) GetSR_CCF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// AES1.DINR: data input register
func (o *AES1_Type) SetDINR(value uint32) {
	volatile.StoreUint32(&o.DINR.Reg, value)
}
func (o *AES1_Type) GetDINR() uint32 {
	return volatile.LoadUint32(&o.DINR.Reg)
}

// AES1.DOUTR: data output register
func (o *AES1_Type) SetDOUTR(value uint32) {
	volatile.StoreUint32(&o.DOUTR.Reg, value)
}
func (o *AES1_Type) GetDOUTR() uint32 {
	return volatile.LoadUint32(&o.DOUTR.Reg)
}

// AES1.KEYR0: key register 0
func (o *AES1_Type) SetKEYR0(value uint32) {
	volatile.StoreUint32(&o.KEYR0.Reg, value)
}
func (o *AES1_Type) GetKEYR0() uint32 {
	return volatile.LoadUint32(&o.KEYR0.Reg)
}

// AES1.KEYR1: key register 1
func (o *AES1_Type) SetKEYR1(value uint32) {
	volatile.StoreUint32(&o.KEYR1.Reg, value)
}
func (o *AES1_Type) GetKEYR1() uint32 {
	return volatile.LoadUint32(&o.KEYR1.Reg)
}

// AES1.KEYR2: key register 2
func (o *AES1_Type) SetKEYR2(value uint32) {
	volatile.StoreUint32(&o.KEYR2.Reg, value)
}
func (o *AES1_Type) GetKEYR2() uint32 {
	return volatile.LoadUint32(&o.KEYR2.Reg)
}

// AES1.KEYR3: key register 3
func (o *AES1_Type) SetKEYR3(value uint32) {
	volatile.StoreUint32(&o.KEYR3.Reg, value)
}
func (o *AES1_Type) GetKEYR3() uint32 {
	return volatile.LoadUint32(&o.KEYR3.Reg)
}

// AES1.IVR0: initialization vector register 0
func (o *AES1_Type) SetIVR0(value uint32) {
	volatile.StoreUint32(&o.IVR0.Reg, value)
}
func (o *AES1_Type) GetIVR0() uint32 {
	return volatile.LoadUint32(&o.IVR0.Reg)
}

// AES1.IVR1: initialization vector register 1
func (o *AES1_Type) SetIVR1(value uint32) {
	volatile.StoreUint32(&o.IVR1.Reg, value)
}
func (o *AES1_Type) GetIVR1() uint32 {
	return volatile.LoadUint32(&o.IVR1.Reg)
}

// AES1.IVR2: initialization vector register 2
func (o *AES1_Type) SetIVR2(value uint32) {
	volatile.StoreUint32(&o.IVR2.Reg, value)
}
func (o *AES1_Type) GetIVR2() uint32 {
	return volatile.LoadUint32(&o.IVR2.Reg)
}

// AES1.IVR3: initialization vector register 3
func (o *AES1_Type) SetIVR3(value uint32) {
	volatile.StoreUint32(&o.IVR3.Reg, value)
}
func (o *AES1_Type) GetIVR3() uint32 {
	return volatile.LoadUint32(&o.IVR3.Reg)
}

// AES1.KEYR4: key register 4
func (o *AES1_Type) SetKEYR4(value uint32) {
	volatile.StoreUint32(&o.KEYR4.Reg, value)
}
func (o *AES1_Type) GetKEYR4() uint32 {
	return volatile.LoadUint32(&o.KEYR4.Reg)
}

// AES1.KEYR5: key register 5
func (o *AES1_Type) SetKEYR5(value uint32) {
	volatile.StoreUint32(&o.KEYR5.Reg, value)
}
func (o *AES1_Type) GetKEYR5() uint32 {
	return volatile.LoadUint32(&o.KEYR5.Reg)
}

// AES1.KEYR6: key register 6
func (o *AES1_Type) SetKEYR6(value uint32) {
	volatile.StoreUint32(&o.KEYR6.Reg, value)
}
func (o *AES1_Type) GetKEYR6() uint32 {
	return volatile.LoadUint32(&o.KEYR6.Reg)
}

// AES1.KEYR7: key register 7
func (o *AES1_Type) SetKEYR7(value uint32) {
	volatile.StoreUint32(&o.KEYR7.Reg, value)
}
func (o *AES1_Type) GetKEYR7() uint32 {
	return volatile.LoadUint32(&o.KEYR7.Reg)
}

// AES1.SUSP0R: AES suspend register 0
func (o *AES1_Type) SetSUSP0R(value uint32) {
	volatile.StoreUint32(&o.SUSP0R.Reg, value)
}
func (o *AES1_Type) GetSUSP0R() uint32 {
	return volatile.LoadUint32(&o.SUSP0R.Reg)
}

// AES1.SUSP1R: AES suspend register 1
func (o *AES1_Type) SetSUSP1R(value uint32) {
	volatile.StoreUint32(&o.SUSP1R.Reg, value)
}
func (o *AES1_Type) GetSUSP1R() uint32 {
	return volatile.LoadUint32(&o.SUSP1R.Reg)
}

// AES1.SUSP2R: AES suspend register 2
func (o *AES1_Type) SetSUSP2R(value uint32) {
	volatile.StoreUint32(&o.SUSP2R.Reg, value)
}
func (o *AES1_Type) GetSUSP2R() uint32 {
	return volatile.LoadUint32(&o.SUSP2R.Reg)
}

// AES1.SUSP3R: AES suspend register 3
func (o *AES1_Type) SetSUSP3R(value uint32) {
	volatile.StoreUint32(&o.SUSP3R.Reg, value)
}
func (o *AES1_Type) GetSUSP3R() uint32 {
	return volatile.LoadUint32(&o.SUSP3R.Reg)
}

// AES1.SUSP4R: AES suspend register 4
func (o *AES1_Type) SetSUSP4R(value uint32) {
	volatile.StoreUint32(&o.SUSP4R.Reg, value)
}
func (o *AES1_Type) GetSUSP4R() uint32 {
	return volatile.LoadUint32(&o.SUSP4R.Reg)
}

// AES1.SUSP5R: AES suspend register 5
func (o *AES1_Type) SetSUSP5R(value uint32) {
	volatile.StoreUint32(&o.SUSP5R.Reg, value)
}
func (o *AES1_Type) GetSUSP5R() uint32 {
	return volatile.LoadUint32(&o.SUSP5R.Reg)
}

// AES1.SUSP6R: AES suspend register 6
func (o *AES1_Type) SetSUSP6R(value uint32) {
	volatile.StoreUint32(&o.SUSP6R.Reg, value)
}
func (o *AES1_Type) GetSUSP6R() uint32 {
	return volatile.LoadUint32(&o.SUSP6R.Reg)
}

// AES1.SUSP7R: AES suspend register 7
func (o *AES1_Type) SetSUSP7R(value uint32) {
	volatile.StoreUint32(&o.SUSP7R.Reg, value)
}
func (o *AES1_Type) GetSUSP7R() uint32 {
	return volatile.LoadUint32(&o.SUSP7R.Reg)
}

// AES1.HWCFR: AES hardware configuration register
func (o *AES1_Type) SetHWCFR_CFG4(value uint32) {
	volatile.StoreUint32(&o.HWCFR.Reg, volatile.LoadUint32(&o.HWCFR.Reg)&^(0xf000)|value<<12)
}
func (o *AES1_Type) GetHWCFR_CFG4() uint32 {
	return (volatile.LoadUint32(&o.HWCFR.Reg) & 0xf000) >> 12
}
func (o *AES1_Type) SetHWCFR_CFG3(value uint32) {
	volatile.StoreUint32(&o.HWCFR.Reg, volatile.LoadUint32(&o.HWCFR.Reg)&^(0xf00)|value<<8)
}
func (o *AES1_Type) GetHWCFR_CFG3() uint32 {
	return (volatile.LoadUint32(&o.HWCFR.Reg) & 0xf00) >> 8
}
func (o *AES1_Type) SetHWCFR_CFG2(value uint32) {
	volatile.StoreUint32(&o.HWCFR.Reg, volatile.LoadUint32(&o.HWCFR.Reg)&^(0xf0)|value<<4)
}
func (o *AES1_Type) GetHWCFR_CFG2() uint32 {
	return (volatile.LoadUint32(&o.HWCFR.Reg) & 0xf0) >> 4
}
func (o *AES1_Type) SetHWCFR_CFG1(value uint32) {
	volatile.StoreUint32(&o.HWCFR.Reg, volatile.LoadUint32(&o.HWCFR.Reg)&^(0xf)|value)
}
func (o *AES1_Type) GetHWCFR_CFG1() uint32 {
	return volatile.LoadUint32(&o.HWCFR.Reg) & 0xf
}

// AES1.VERR: AES version register
func (o *AES1_Type) SetVERR_MAJREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf0)|value<<4)
}
func (o *AES1_Type) GetVERR_MAJREV() uint32 {
	return (volatile.LoadUint32(&o.VERR.Reg) & 0xf0) >> 4
}
func (o *AES1_Type) SetVERR_MINREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf)|value)
}
func (o *AES1_Type) GetVERR_MINREV() uint32 {
	return volatile.LoadUint32(&o.VERR.Reg) & 0xf
}

// AES1.IPIDR: AES identification register
func (o *AES1_Type) SetIPIDR(value uint32) {
	volatile.StoreUint32(&o.IPIDR.Reg, value)
}
func (o *AES1_Type) GetIPIDR() uint32 {
	return volatile.LoadUint32(&o.IPIDR.Reg)
}

// AES1.SIDR: AES size ID register
func (o *AES1_Type) SetSIDR(value uint32) {
	volatile.StoreUint32(&o.SIDR.Reg, value)
}
func (o *AES1_Type) GetSIDR() uint32 {
	return volatile.LoadUint32(&o.SIDR.Reg)
}

// HSEM
type Hardware_Semaphore_Type struct {
	R0      volatile.Register32 // 0x0
	R1      volatile.Register32 // 0x4
	R2      volatile.Register32 // 0x8
	R3      volatile.Register32 // 0xC
	R4      volatile.Register32 // 0x10
	R5      volatile.Register32 // 0x14
	R6      volatile.Register32 // 0x18
	R7      volatile.Register32 // 0x1C
	R8      volatile.Register32 // 0x20
	R9      volatile.Register32 // 0x24
	R10     volatile.Register32 // 0x28
	R11     volatile.Register32 // 0x2C
	R12     volatile.Register32 // 0x30
	R13     volatile.Register32 // 0x34
	R14     volatile.Register32 // 0x38
	R15     volatile.Register32 // 0x3C
	R16     volatile.Register32 // 0x40
	R17     volatile.Register32 // 0x44
	R18     volatile.Register32 // 0x48
	R19     volatile.Register32 // 0x4C
	R20     volatile.Register32 // 0x50
	R21     volatile.Register32 // 0x54
	R22     volatile.Register32 // 0x58
	R23     volatile.Register32 // 0x5C
	R24     volatile.Register32 // 0x60
	R25     volatile.Register32 // 0x64
	R26     volatile.Register32 // 0x68
	R27     volatile.Register32 // 0x6C
	R28     volatile.Register32 // 0x70
	R29     volatile.Register32 // 0x74
	R30     volatile.Register32 // 0x78
	R31     volatile.Register32 // 0x7C
	RLR0    volatile.Register32 // 0x80
	RLR1    volatile.Register32 // 0x84
	RLR2    volatile.Register32 // 0x88
	RLR3    volatile.Register32 // 0x8C
	RLR4    volatile.Register32 // 0x90
	RLR5    volatile.Register32 // 0x94
	RLR6    volatile.Register32 // 0x98
	RLR7    volatile.Register32 // 0x9C
	RLR8    volatile.Register32 // 0xA0
	RLR9    volatile.Register32 // 0xA4
	RLR10   volatile.Register32 // 0xA8
	RLR11   volatile.Register32 // 0xAC
	RLR12   volatile.Register32 // 0xB0
	RLR13   volatile.Register32 // 0xB4
	RLR14   volatile.Register32 // 0xB8
	RLR15   volatile.Register32 // 0xBC
	RLR16   volatile.Register32 // 0xC0
	RLR17   volatile.Register32 // 0xC4
	RLR18   volatile.Register32 // 0xC8
	RLR19   volatile.Register32 // 0xCC
	RLR20   volatile.Register32 // 0xD0
	RLR21   volatile.Register32 // 0xD4
	RLR22   volatile.Register32 // 0xD8
	RLR23   volatile.Register32 // 0xDC
	RLR24   volatile.Register32 // 0xE0
	RLR25   volatile.Register32 // 0xE4
	RLR26   volatile.Register32 // 0xE8
	RLR27   volatile.Register32 // 0xEC
	RLR28   volatile.Register32 // 0xF0
	RLR29   volatile.Register32 // 0xF4
	RLR30   volatile.Register32 // 0xF8
	RLR31   volatile.Register32 // 0xFC
	C1IER   volatile.Register32 // 0x100
	C1ICR   volatile.Register32 // 0x104
	C1ISR   volatile.Register32 // 0x108
	C1MISR  volatile.Register32 // 0x10C
	C2IER   volatile.Register32 // 0x110
	C2ICR   volatile.Register32 // 0x114
	C2ISR   volatile.Register32 // 0x118
	C2MISR  volatile.Register32 // 0x11C
	_       [32]byte
	CR      volatile.Register32 // 0x140
	KEYR    volatile.Register32 // 0x144
	_       [676]byte
	HWCFGR2 volatile.Register32 // 0x3EC
	HWCFGR1 volatile.Register32 // 0x3F0
	VERR    volatile.Register32 // 0x3F4
	IPIDR   volatile.Register32 // 0x3F8
	SIDR    volatile.Register32 // 0x3FC
}

// Hardware_Semaphore.R0: Semaphore 0 register
func (o *Hardware_Semaphore_Type) SetR0_LOCK(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R0.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR0_COREID(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR0_COREID() uint32 {
	return (volatile.LoadUint32(&o.R0.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR0_PROCID(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR0_PROCID() uint32 {
	return volatile.LoadUint32(&o.R0.Reg) & 0xff
}

// Hardware_Semaphore.R1: Semaphore 1 register
func (o *Hardware_Semaphore_Type) SetR1_LOCK(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R1.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR1_COREID(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR1_COREID() uint32 {
	return (volatile.LoadUint32(&o.R1.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR1_PROCID(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR1_PROCID() uint32 {
	return volatile.LoadUint32(&o.R1.Reg) & 0xff
}

// Hardware_Semaphore.R2: Semaphore 2 register
func (o *Hardware_Semaphore_Type) SetR2_LOCK(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R2.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR2_COREID(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR2_COREID() uint32 {
	return (volatile.LoadUint32(&o.R2.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR2_PROCID(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR2_PROCID() uint32 {
	return volatile.LoadUint32(&o.R2.Reg) & 0xff
}

// Hardware_Semaphore.R3: Semaphore 3 register
func (o *Hardware_Semaphore_Type) SetR3_LOCK(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR3_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R3.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR3_COREID(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR3_COREID() uint32 {
	return (volatile.LoadUint32(&o.R3.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR3_PROCID(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR3_PROCID() uint32 {
	return volatile.LoadUint32(&o.R3.Reg) & 0xff
}

// Hardware_Semaphore.R4: Semaphore 4 register
func (o *Hardware_Semaphore_Type) SetR4_LOCK(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR4_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R4.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR4_COREID(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR4_COREID() uint32 {
	return (volatile.LoadUint32(&o.R4.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR4_PROCID(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR4_PROCID() uint32 {
	return volatile.LoadUint32(&o.R4.Reg) & 0xff
}

// Hardware_Semaphore.R5: Semaphore 5 register
func (o *Hardware_Semaphore_Type) SetR5_LOCK(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR5_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R5.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR5_COREID(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR5_COREID() uint32 {
	return (volatile.LoadUint32(&o.R5.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR5_PROCID(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR5_PROCID() uint32 {
	return volatile.LoadUint32(&o.R5.Reg) & 0xff
}

// Hardware_Semaphore.R6: Semaphore 6 register
func (o *Hardware_Semaphore_Type) SetR6_LOCK(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR6_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R6.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR6_COREID(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR6_COREID() uint32 {
	return (volatile.LoadUint32(&o.R6.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR6_PROCID(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR6_PROCID() uint32 {
	return volatile.LoadUint32(&o.R6.Reg) & 0xff
}

// Hardware_Semaphore.R7: Semaphore 7 register
func (o *Hardware_Semaphore_Type) SetR7_LOCK(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR7_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R7.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR7_COREID(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR7_COREID() uint32 {
	return (volatile.LoadUint32(&o.R7.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR7_PROCID(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR7_PROCID() uint32 {
	return volatile.LoadUint32(&o.R7.Reg) & 0xff
}

// Hardware_Semaphore.R8: Semaphore 8 register
func (o *Hardware_Semaphore_Type) SetR8_LOCK(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR8_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R8.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR8_COREID(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR8_COREID() uint32 {
	return (volatile.LoadUint32(&o.R8.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR8_PROCID(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR8_PROCID() uint32 {
	return volatile.LoadUint32(&o.R8.Reg) & 0xff
}

// Hardware_Semaphore.R9: Semaphore 9 register
func (o *Hardware_Semaphore_Type) SetR9_LOCK(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR9_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R9.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR9_COREID(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR9_COREID() uint32 {
	return (volatile.LoadUint32(&o.R9.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR9_PROCID(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR9_PROCID() uint32 {
	return volatile.LoadUint32(&o.R9.Reg) & 0xff
}

// Hardware_Semaphore.R10: Semaphore 10 register
func (o *Hardware_Semaphore_Type) SetR10_LOCK(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR10_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R10.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR10_COREID(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR10_COREID() uint32 {
	return (volatile.LoadUint32(&o.R10.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR10_PROCID(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR10_PROCID() uint32 {
	return volatile.LoadUint32(&o.R10.Reg) & 0xff
}

// Hardware_Semaphore.R11: Semaphore 11 register
func (o *Hardware_Semaphore_Type) SetR11_LOCK(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR11_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R11.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR11_COREID(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR11_COREID() uint32 {
	return (volatile.LoadUint32(&o.R11.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR11_PROCID(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR11_PROCID() uint32 {
	return volatile.LoadUint32(&o.R11.Reg) & 0xff
}

// Hardware_Semaphore.R12: Semaphore 12 register
func (o *Hardware_Semaphore_Type) SetR12_LOCK(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR12_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R12.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR12_COREID(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR12_COREID() uint32 {
	return (volatile.LoadUint32(&o.R12.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR12_PROCID(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR12_PROCID() uint32 {
	return volatile.LoadUint32(&o.R12.Reg) & 0xff
}

// Hardware_Semaphore.R13: Semaphore 13 register
func (o *Hardware_Semaphore_Type) SetR13_LOCK(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR13_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R13.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR13_COREID(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR13_COREID() uint32 {
	return (volatile.LoadUint32(&o.R13.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR13_PROCID(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR13_PROCID() uint32 {
	return volatile.LoadUint32(&o.R13.Reg) & 0xff
}

// Hardware_Semaphore.R14: Semaphore 14 register
func (o *Hardware_Semaphore_Type) SetR14_LOCK(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR14_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R14.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR14_COREID(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR14_COREID() uint32 {
	return (volatile.LoadUint32(&o.R14.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR14_PROCID(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR14_PROCID() uint32 {
	return volatile.LoadUint32(&o.R14.Reg) & 0xff
}

// Hardware_Semaphore.R15: Semaphore 15 register
func (o *Hardware_Semaphore_Type) SetR15_LOCK(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR15_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R15.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR15_COREID(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR15_COREID() uint32 {
	return (volatile.LoadUint32(&o.R15.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR15_PROCID(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR15_PROCID() uint32 {
	return volatile.LoadUint32(&o.R15.Reg) & 0xff
}

// Hardware_Semaphore.R16: Semaphore 16 register
func (o *Hardware_Semaphore_Type) SetR16_LOCK(value uint32) {
	volatile.StoreUint32(&o.R16.Reg, volatile.LoadUint32(&o.R16.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR16_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R16.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR16_COREID(value uint32) {
	volatile.StoreUint32(&o.R16.Reg, volatile.LoadUint32(&o.R16.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR16_COREID() uint32 {
	return (volatile.LoadUint32(&o.R16.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR16_PROCID(value uint32) {
	volatile.StoreUint32(&o.R16.Reg, volatile.LoadUint32(&o.R16.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR16_PROCID() uint32 {
	return volatile.LoadUint32(&o.R16.Reg) & 0xff
}

// Hardware_Semaphore.R17: Semaphore 17 register
func (o *Hardware_Semaphore_Type) SetR17_LOCK(value uint32) {
	volatile.StoreUint32(&o.R17.Reg, volatile.LoadUint32(&o.R17.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR17_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R17.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR17_COREID(value uint32) {
	volatile.StoreUint32(&o.R17.Reg, volatile.LoadUint32(&o.R17.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR17_COREID() uint32 {
	return (volatile.LoadUint32(&o.R17.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR17_PROCID(value uint32) {
	volatile.StoreUint32(&o.R17.Reg, volatile.LoadUint32(&o.R17.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR17_PROCID() uint32 {
	return volatile.LoadUint32(&o.R17.Reg) & 0xff
}

// Hardware_Semaphore.R18: Semaphore 18 register
func (o *Hardware_Semaphore_Type) SetR18_LOCK(value uint32) {
	volatile.StoreUint32(&o.R18.Reg, volatile.LoadUint32(&o.R18.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR18_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R18.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR18_COREID(value uint32) {
	volatile.StoreUint32(&o.R18.Reg, volatile.LoadUint32(&o.R18.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR18_COREID() uint32 {
	return (volatile.LoadUint32(&o.R18.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR18_PROCID(value uint32) {
	volatile.StoreUint32(&o.R18.Reg, volatile.LoadUint32(&o.R18.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR18_PROCID() uint32 {
	return volatile.LoadUint32(&o.R18.Reg) & 0xff
}

// Hardware_Semaphore.R19: Semaphore 19 register
func (o *Hardware_Semaphore_Type) SetR19_LOCK(value uint32) {
	volatile.StoreUint32(&o.R19.Reg, volatile.LoadUint32(&o.R19.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR19_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R19.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR19_COREID(value uint32) {
	volatile.StoreUint32(&o.R19.Reg, volatile.LoadUint32(&o.R19.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR19_COREID() uint32 {
	return (volatile.LoadUint32(&o.R19.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR19_PROCID(value uint32) {
	volatile.StoreUint32(&o.R19.Reg, volatile.LoadUint32(&o.R19.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR19_PROCID() uint32 {
	return volatile.LoadUint32(&o.R19.Reg) & 0xff
}

// Hardware_Semaphore.R20: Semaphore 20 register
func (o *Hardware_Semaphore_Type) SetR20_LOCK(value uint32) {
	volatile.StoreUint32(&o.R20.Reg, volatile.LoadUint32(&o.R20.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR20_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R20.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR20_COREID(value uint32) {
	volatile.StoreUint32(&o.R20.Reg, volatile.LoadUint32(&o.R20.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR20_COREID() uint32 {
	return (volatile.LoadUint32(&o.R20.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR20_PROCID(value uint32) {
	volatile.StoreUint32(&o.R20.Reg, volatile.LoadUint32(&o.R20.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR20_PROCID() uint32 {
	return volatile.LoadUint32(&o.R20.Reg) & 0xff
}

// Hardware_Semaphore.R21: Semaphore 21 register
func (o *Hardware_Semaphore_Type) SetR21_LOCK(value uint32) {
	volatile.StoreUint32(&o.R21.Reg, volatile.LoadUint32(&o.R21.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR21_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R21.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR21_COREID(value uint32) {
	volatile.StoreUint32(&o.R21.Reg, volatile.LoadUint32(&o.R21.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR21_COREID() uint32 {
	return (volatile.LoadUint32(&o.R21.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR21_PROCID(value uint32) {
	volatile.StoreUint32(&o.R21.Reg, volatile.LoadUint32(&o.R21.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR21_PROCID() uint32 {
	return volatile.LoadUint32(&o.R21.Reg) & 0xff
}

// Hardware_Semaphore.R22: Semaphore 22 register
func (o *Hardware_Semaphore_Type) SetR22_LOCK(value uint32) {
	volatile.StoreUint32(&o.R22.Reg, volatile.LoadUint32(&o.R22.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR22_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R22.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR22_COREID(value uint32) {
	volatile.StoreUint32(&o.R22.Reg, volatile.LoadUint32(&o.R22.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR22_COREID() uint32 {
	return (volatile.LoadUint32(&o.R22.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR22_PROCID(value uint32) {
	volatile.StoreUint32(&o.R22.Reg, volatile.LoadUint32(&o.R22.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR22_PROCID() uint32 {
	return volatile.LoadUint32(&o.R22.Reg) & 0xff
}

// Hardware_Semaphore.R23: Semaphore 23 register
func (o *Hardware_Semaphore_Type) SetR23_LOCK(value uint32) {
	volatile.StoreUint32(&o.R23.Reg, volatile.LoadUint32(&o.R23.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR23_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R23.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR23_COREID(value uint32) {
	volatile.StoreUint32(&o.R23.Reg, volatile.LoadUint32(&o.R23.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR23_COREID() uint32 {
	return (volatile.LoadUint32(&o.R23.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR23_PROCID(value uint32) {
	volatile.StoreUint32(&o.R23.Reg, volatile.LoadUint32(&o.R23.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR23_PROCID() uint32 {
	return volatile.LoadUint32(&o.R23.Reg) & 0xff
}

// Hardware_Semaphore.R24: Semaphore 24 register
func (o *Hardware_Semaphore_Type) SetR24_LOCK(value uint32) {
	volatile.StoreUint32(&o.R24.Reg, volatile.LoadUint32(&o.R24.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR24_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R24.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR24_COREID(value uint32) {
	volatile.StoreUint32(&o.R24.Reg, volatile.LoadUint32(&o.R24.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR24_COREID() uint32 {
	return (volatile.LoadUint32(&o.R24.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR24_PROCID(value uint32) {
	volatile.StoreUint32(&o.R24.Reg, volatile.LoadUint32(&o.R24.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR24_PROCID() uint32 {
	return volatile.LoadUint32(&o.R24.Reg) & 0xff
}

// Hardware_Semaphore.R25: Semaphore 25 register
func (o *Hardware_Semaphore_Type) SetR25_LOCK(value uint32) {
	volatile.StoreUint32(&o.R25.Reg, volatile.LoadUint32(&o.R25.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR25_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R25.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR25_COREID(value uint32) {
	volatile.StoreUint32(&o.R25.Reg, volatile.LoadUint32(&o.R25.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR25_COREID() uint32 {
	return (volatile.LoadUint32(&o.R25.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR25_PROCID(value uint32) {
	volatile.StoreUint32(&o.R25.Reg, volatile.LoadUint32(&o.R25.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR25_PROCID() uint32 {
	return volatile.LoadUint32(&o.R25.Reg) & 0xff
}

// Hardware_Semaphore.R26: Semaphore 26 register
func (o *Hardware_Semaphore_Type) SetR26_LOCK(value uint32) {
	volatile.StoreUint32(&o.R26.Reg, volatile.LoadUint32(&o.R26.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR26_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R26.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR26_COREID(value uint32) {
	volatile.StoreUint32(&o.R26.Reg, volatile.LoadUint32(&o.R26.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR26_COREID() uint32 {
	return (volatile.LoadUint32(&o.R26.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR26_PROCID(value uint32) {
	volatile.StoreUint32(&o.R26.Reg, volatile.LoadUint32(&o.R26.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR26_PROCID() uint32 {
	return volatile.LoadUint32(&o.R26.Reg) & 0xff
}

// Hardware_Semaphore.R27: Semaphore 27 register
func (o *Hardware_Semaphore_Type) SetR27_LOCK(value uint32) {
	volatile.StoreUint32(&o.R27.Reg, volatile.LoadUint32(&o.R27.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR27_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R27.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR27_COREID(value uint32) {
	volatile.StoreUint32(&o.R27.Reg, volatile.LoadUint32(&o.R27.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR27_COREID() uint32 {
	return (volatile.LoadUint32(&o.R27.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR27_PROCID(value uint32) {
	volatile.StoreUint32(&o.R27.Reg, volatile.LoadUint32(&o.R27.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR27_PROCID() uint32 {
	return volatile.LoadUint32(&o.R27.Reg) & 0xff
}

// Hardware_Semaphore.R28: Semaphore 28 register
func (o *Hardware_Semaphore_Type) SetR28_LOCK(value uint32) {
	volatile.StoreUint32(&o.R28.Reg, volatile.LoadUint32(&o.R28.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR28_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R28.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR28_COREID(value uint32) {
	volatile.StoreUint32(&o.R28.Reg, volatile.LoadUint32(&o.R28.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR28_COREID() uint32 {
	return (volatile.LoadUint32(&o.R28.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR28_PROCID(value uint32) {
	volatile.StoreUint32(&o.R28.Reg, volatile.LoadUint32(&o.R28.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR28_PROCID() uint32 {
	return volatile.LoadUint32(&o.R28.Reg) & 0xff
}

// Hardware_Semaphore.R29: Semaphore 29 register
func (o *Hardware_Semaphore_Type) SetR29_LOCK(value uint32) {
	volatile.StoreUint32(&o.R29.Reg, volatile.LoadUint32(&o.R29.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR29_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R29.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR29_COREID(value uint32) {
	volatile.StoreUint32(&o.R29.Reg, volatile.LoadUint32(&o.R29.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR29_COREID() uint32 {
	return (volatile.LoadUint32(&o.R29.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR29_PROCID(value uint32) {
	volatile.StoreUint32(&o.R29.Reg, volatile.LoadUint32(&o.R29.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR29_PROCID() uint32 {
	return volatile.LoadUint32(&o.R29.Reg) & 0xff
}

// Hardware_Semaphore.R30: Semaphore 30 register
func (o *Hardware_Semaphore_Type) SetR30_LOCK(value uint32) {
	volatile.StoreUint32(&o.R30.Reg, volatile.LoadUint32(&o.R30.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR30_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R30.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR30_COREID(value uint32) {
	volatile.StoreUint32(&o.R30.Reg, volatile.LoadUint32(&o.R30.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR30_COREID() uint32 {
	return (volatile.LoadUint32(&o.R30.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR30_PROCID(value uint32) {
	volatile.StoreUint32(&o.R30.Reg, volatile.LoadUint32(&o.R30.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR30_PROCID() uint32 {
	return volatile.LoadUint32(&o.R30.Reg) & 0xff
}

// Hardware_Semaphore.R31: Semaphore 31 register
func (o *Hardware_Semaphore_Type) SetR31_LOCK(value uint32) {
	volatile.StoreUint32(&o.R31.Reg, volatile.LoadUint32(&o.R31.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetR31_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R31.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetR31_COREID(value uint32) {
	volatile.StoreUint32(&o.R31.Reg, volatile.LoadUint32(&o.R31.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetR31_COREID() uint32 {
	return (volatile.LoadUint32(&o.R31.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetR31_PROCID(value uint32) {
	volatile.StoreUint32(&o.R31.Reg, volatile.LoadUint32(&o.R31.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetR31_PROCID() uint32 {
	return volatile.LoadUint32(&o.R31.Reg) & 0xff
}

// Hardware_Semaphore.RLR0: Semaphore 0 read lock register
func (o *Hardware_Semaphore_Type) SetRLR0_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR0.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR0_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR0_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR0.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR0_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR0_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR0.Reg) & 0xff
}

// Hardware_Semaphore.RLR1: Semaphore 1 read lock register
func (o *Hardware_Semaphore_Type) SetRLR1_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR1.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR1_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR1_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR1.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR1_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR1_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR1.Reg) & 0xff
}

// Hardware_Semaphore.RLR2: Semaphore 2 read lock register
func (o *Hardware_Semaphore_Type) SetRLR2_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR2.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR2_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR2_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR2.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR2_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR2_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR2.Reg) & 0xff
}

// Hardware_Semaphore.RLR3: Semaphore 3 read lock register
func (o *Hardware_Semaphore_Type) SetRLR3_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR3_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR3.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR3_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR3_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR3.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR3_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR3_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR3.Reg) & 0xff
}

// Hardware_Semaphore.RLR4: Semaphore 4 read lock read lock register
func (o *Hardware_Semaphore_Type) SetRLR4_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR4_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR4.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR4_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR4_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR4.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR4_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR4_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR4.Reg) & 0xff
}

// Hardware_Semaphore.RLR5: Semaphore 5 read lock register
func (o *Hardware_Semaphore_Type) SetRLR5_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR5_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR5.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR5_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR5_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR5.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR5_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR5_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR5.Reg) & 0xff
}

// Hardware_Semaphore.RLR6: Semaphore 6 read lock register
func (o *Hardware_Semaphore_Type) SetRLR6_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR6_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR6.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR6_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR6_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR6.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR6_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR6_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR6.Reg) & 0xff
}

// Hardware_Semaphore.RLR7: Semaphore 7 read lock register
func (o *Hardware_Semaphore_Type) SetRLR7_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR7_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR7.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR7_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR7_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR7.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR7_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR7_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR7.Reg) & 0xff
}

// Hardware_Semaphore.RLR8: Semaphore 8 read lock register
func (o *Hardware_Semaphore_Type) SetRLR8_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR8_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR8.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR8_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR8_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR8.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR8_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR8_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR8.Reg) & 0xff
}

// Hardware_Semaphore.RLR9: Semaphore 9 read lock register
func (o *Hardware_Semaphore_Type) SetRLR9_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR9_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR9.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR9_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR9_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR9.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR9_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR9_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR9.Reg) & 0xff
}

// Hardware_Semaphore.RLR10: Semaphore 10 read lock register
func (o *Hardware_Semaphore_Type) SetRLR10_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR10_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR10.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR10_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR10_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR10.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR10_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR10_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR10.Reg) & 0xff
}

// Hardware_Semaphore.RLR11: Semaphore 11 read lock register
func (o *Hardware_Semaphore_Type) SetRLR11_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR11_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR11.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR11_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR11_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR11.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR11_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR11_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR11.Reg) & 0xff
}

// Hardware_Semaphore.RLR12: Semaphore 12 read lock register
func (o *Hardware_Semaphore_Type) SetRLR12_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR12_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR12.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR12_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR12_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR12.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR12_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR12_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR12.Reg) & 0xff
}

// Hardware_Semaphore.RLR13: Semaphore 13 read lock register
func (o *Hardware_Semaphore_Type) SetRLR13_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR13_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR13.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR13_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR13_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR13.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR13_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR13_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR13.Reg) & 0xff
}

// Hardware_Semaphore.RLR14: Semaphore 14 read lock register
func (o *Hardware_Semaphore_Type) SetRLR14_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR14_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR14.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR14_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR14_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR14.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR14_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR14_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR14.Reg) & 0xff
}

// Hardware_Semaphore.RLR15: Semaphore 15 read lock register
func (o *Hardware_Semaphore_Type) SetRLR15_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR15_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR15.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR15_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR15_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR15.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR15_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR15_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR15.Reg) & 0xff
}

// Hardware_Semaphore.RLR16: Semaphore 16 read lock register
func (o *Hardware_Semaphore_Type) SetRLR16_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR16.Reg, volatile.LoadUint32(&o.RLR16.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR16_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR16.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR16_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR16.Reg, volatile.LoadUint32(&o.RLR16.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR16_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR16.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR16_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR16.Reg, volatile.LoadUint32(&o.RLR16.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR16_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR16.Reg) & 0xff
}

// Hardware_Semaphore.RLR17: Semaphore 17 read lock register
func (o *Hardware_Semaphore_Type) SetRLR17_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR17.Reg, volatile.LoadUint32(&o.RLR17.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR17_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR17.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR17_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR17.Reg, volatile.LoadUint32(&o.RLR17.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR17_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR17.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR17_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR17.Reg, volatile.LoadUint32(&o.RLR17.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR17_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR17.Reg) & 0xff
}

// Hardware_Semaphore.RLR18: Semaphore 18 read lock register
func (o *Hardware_Semaphore_Type) SetRLR18_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR18.Reg, volatile.LoadUint32(&o.RLR18.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR18_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR18.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR18_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR18.Reg, volatile.LoadUint32(&o.RLR18.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR18_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR18.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR18_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR18.Reg, volatile.LoadUint32(&o.RLR18.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR18_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR18.Reg) & 0xff
}

// Hardware_Semaphore.RLR19: Semaphore 19 read lock register
func (o *Hardware_Semaphore_Type) SetRLR19_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR19.Reg, volatile.LoadUint32(&o.RLR19.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR19_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR19.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR19_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR19.Reg, volatile.LoadUint32(&o.RLR19.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR19_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR19.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR19_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR19.Reg, volatile.LoadUint32(&o.RLR19.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR19_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR19.Reg) & 0xff
}

// Hardware_Semaphore.RLR20: Semaphore 20 read lock register
func (o *Hardware_Semaphore_Type) SetRLR20_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR20.Reg, volatile.LoadUint32(&o.RLR20.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR20_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR20.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR20_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR20.Reg, volatile.LoadUint32(&o.RLR20.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR20_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR20.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR20_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR20.Reg, volatile.LoadUint32(&o.RLR20.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR20_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR20.Reg) & 0xff
}

// Hardware_Semaphore.RLR21: Semaphore 21 read lock register
func (o *Hardware_Semaphore_Type) SetRLR21_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR21.Reg, volatile.LoadUint32(&o.RLR21.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR21_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR21.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR21_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR21.Reg, volatile.LoadUint32(&o.RLR21.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR21_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR21.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR21_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR21.Reg, volatile.LoadUint32(&o.RLR21.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR21_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR21.Reg) & 0xff
}

// Hardware_Semaphore.RLR22: Semaphore 22 read lock register
func (o *Hardware_Semaphore_Type) SetRLR22_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR22.Reg, volatile.LoadUint32(&o.RLR22.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR22_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR22.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR22_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR22.Reg, volatile.LoadUint32(&o.RLR22.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR22_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR22.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR22_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR22.Reg, volatile.LoadUint32(&o.RLR22.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR22_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR22.Reg) & 0xff
}

// Hardware_Semaphore.RLR23: Semaphore 23 read lock register
func (o *Hardware_Semaphore_Type) SetRLR23_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR23.Reg, volatile.LoadUint32(&o.RLR23.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR23_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR23.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR23_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR23.Reg, volatile.LoadUint32(&o.RLR23.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR23_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR23.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR23_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR23.Reg, volatile.LoadUint32(&o.RLR23.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR23_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR23.Reg) & 0xff
}

// Hardware_Semaphore.RLR24: Semaphore 24 read lock register
func (o *Hardware_Semaphore_Type) SetRLR24_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR24.Reg, volatile.LoadUint32(&o.RLR24.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR24_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR24.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR24_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR24.Reg, volatile.LoadUint32(&o.RLR24.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR24_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR24.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR24_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR24.Reg, volatile.LoadUint32(&o.RLR24.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR24_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR24.Reg) & 0xff
}

// Hardware_Semaphore.RLR25: Semaphore 25 read lock register
func (o *Hardware_Semaphore_Type) SetRLR25_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR25.Reg, volatile.LoadUint32(&o.RLR25.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR25_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR25.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR25_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR25.Reg, volatile.LoadUint32(&o.RLR25.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR25_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR25.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR25_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR25.Reg, volatile.LoadUint32(&o.RLR25.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR25_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR25.Reg) & 0xff
}

// Hardware_Semaphore.RLR26: Semaphore 26 read lock register
func (o *Hardware_Semaphore_Type) SetRLR26_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR26.Reg, volatile.LoadUint32(&o.RLR26.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR26_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR26.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR26_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR26.Reg, volatile.LoadUint32(&o.RLR26.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR26_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR26.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR26_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR26.Reg, volatile.LoadUint32(&o.RLR26.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR26_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR26.Reg) & 0xff
}

// Hardware_Semaphore.RLR27: Semaphore 27 read lock register
func (o *Hardware_Semaphore_Type) SetRLR27_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR27.Reg, volatile.LoadUint32(&o.RLR27.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR27_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR27.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR27_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR27.Reg, volatile.LoadUint32(&o.RLR27.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR27_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR27.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR27_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR27.Reg, volatile.LoadUint32(&o.RLR27.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR27_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR27.Reg) & 0xff
}

// Hardware_Semaphore.RLR28: Semaphore 28 read lock register
func (o *Hardware_Semaphore_Type) SetRLR28_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR28.Reg, volatile.LoadUint32(&o.RLR28.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR28_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR28.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR28_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR28.Reg, volatile.LoadUint32(&o.RLR28.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR28_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR28.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR28_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR28.Reg, volatile.LoadUint32(&o.RLR28.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR28_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR28.Reg) & 0xff
}

// Hardware_Semaphore.RLR29: Semaphore 29 read lock register
func (o *Hardware_Semaphore_Type) SetRLR29_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR29.Reg, volatile.LoadUint32(&o.RLR29.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR29_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR29.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR29_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR29.Reg, volatile.LoadUint32(&o.RLR29.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR29_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR29.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR29_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR29.Reg, volatile.LoadUint32(&o.RLR29.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR29_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR29.Reg) & 0xff
}

// Hardware_Semaphore.RLR30: Semaphore 30 read lock register
func (o *Hardware_Semaphore_Type) SetRLR30_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR30.Reg, volatile.LoadUint32(&o.RLR30.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR30_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR30.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR30_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR30.Reg, volatile.LoadUint32(&o.RLR30.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR30_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR30.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR30_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR30.Reg, volatile.LoadUint32(&o.RLR30.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR30_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR30.Reg) & 0xff
}

// Hardware_Semaphore.RLR31: Semaphore 31 read lock register
func (o *Hardware_Semaphore_Type) SetRLR31_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR31.Reg, volatile.LoadUint32(&o.RLR31.Reg)&^(0x80000000)|value<<31)
}
func (o *Hardware_Semaphore_Type) GetRLR31_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR31.Reg) & 0x80000000) >> 31
}
func (o *Hardware_Semaphore_Type) SetRLR31_COREID(value uint32) {
	volatile.StoreUint32(&o.RLR31.Reg, volatile.LoadUint32(&o.RLR31.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetRLR31_COREID() uint32 {
	return (volatile.LoadUint32(&o.RLR31.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetRLR31_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR31.Reg, volatile.LoadUint32(&o.RLR31.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetRLR31_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR31.Reg) & 0xff
}

// Hardware_Semaphore.C1IER: HSEM Interrupt enable register
func (o *Hardware_Semaphore_Type) SetC1IER(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, value)
}
func (o *Hardware_Semaphore_Type) GetC1IER() uint32 {
	return volatile.LoadUint32(&o.C1IER.Reg)
}

// Hardware_Semaphore.C1ICR: HSEM Interrupt clear register
func (o *Hardware_Semaphore_Type) SetC1ICR(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, value)
}
func (o *Hardware_Semaphore_Type) GetC1ICR() uint32 {
	return volatile.LoadUint32(&o.C1ICR.Reg)
}

// Hardware_Semaphore.C1ISR: HSEM Interrupt status register
func (o *Hardware_Semaphore_Type) SetC1ISR(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, value)
}
func (o *Hardware_Semaphore_Type) GetC1ISR() uint32 {
	return volatile.LoadUint32(&o.C1ISR.Reg)
}

// Hardware_Semaphore.C1MISR: HSEM Masked interrupt status register
func (o *Hardware_Semaphore_Type) SetC1MISR(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, value)
}
func (o *Hardware_Semaphore_Type) GetC1MISR() uint32 {
	return volatile.LoadUint32(&o.C1MISR.Reg)
}

// Hardware_Semaphore.C2IER: HSEM Interrupt enable register
func (o *Hardware_Semaphore_Type) SetC2IER(value uint32) {
	volatile.StoreUint32(&o.C2IER.Reg, value)
}
func (o *Hardware_Semaphore_Type) GetC2IER() uint32 {
	return volatile.LoadUint32(&o.C2IER.Reg)
}

// Hardware_Semaphore.C2ICR: HSEM Interrupt clear register
func (o *Hardware_Semaphore_Type) SetC2ICR(value uint32) {
	volatile.StoreUint32(&o.C2ICR.Reg, value)
}
func (o *Hardware_Semaphore_Type) GetC2ICR() uint32 {
	return volatile.LoadUint32(&o.C2ICR.Reg)
}

// Hardware_Semaphore.C2ISR: HSEM Interrupt status register
func (o *Hardware_Semaphore_Type) SetC2ISR(value uint32) {
	volatile.StoreUint32(&o.C2ISR.Reg, value)
}
func (o *Hardware_Semaphore_Type) GetC2ISR() uint32 {
	return volatile.LoadUint32(&o.C2ISR.Reg)
}

// Hardware_Semaphore.C2MISR: HSEM Masked interrupt status register
func (o *Hardware_Semaphore_Type) SetC2MISR(value uint32) {
	volatile.StoreUint32(&o.C2MISR.Reg, value)
}
func (o *Hardware_Semaphore_Type) GetC2MISR() uint32 {
	return volatile.LoadUint32(&o.C2MISR.Reg)
}

// Hardware_Semaphore.CR: Semaphore Clear register
func (o *Hardware_Semaphore_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xffff0000)|value<<16)
}
func (o *Hardware_Semaphore_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xffff0000) >> 16
}
func (o *Hardware_Semaphore_Type) SetCR_COREID(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetCR_COREID() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}

// Hardware_Semaphore.KEYR: Interrupt clear register
func (o *Hardware_Semaphore_Type) SetKEYR_KEY(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, volatile.LoadUint32(&o.KEYR.Reg)&^(0xffff0000)|value<<16)
}
func (o *Hardware_Semaphore_Type) GetKEYR_KEY() uint32 {
	return (volatile.LoadUint32(&o.KEYR.Reg) & 0xffff0000) >> 16
}

// Hardware_Semaphore.HWCFGR2: Semaphore hardware configuration register 2
func (o *Hardware_Semaphore_Type) SetHWCFGR2_MASTERID4(value uint32) {
	volatile.StoreUint32(&o.HWCFGR2.Reg, volatile.LoadUint32(&o.HWCFGR2.Reg)&^(0xf000)|value<<12)
}
func (o *Hardware_Semaphore_Type) GetHWCFGR2_MASTERID4() uint32 {
	return (volatile.LoadUint32(&o.HWCFGR2.Reg) & 0xf000) >> 12
}
func (o *Hardware_Semaphore_Type) SetHWCFGR2_MASTERID3(value uint32) {
	volatile.StoreUint32(&o.HWCFGR2.Reg, volatile.LoadUint32(&o.HWCFGR2.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetHWCFGR2_MASTERID3() uint32 {
	return (volatile.LoadUint32(&o.HWCFGR2.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetHWCFGR2_MASTERID2(value uint32) {
	volatile.StoreUint32(&o.HWCFGR2.Reg, volatile.LoadUint32(&o.HWCFGR2.Reg)&^(0xf0)|value<<4)
}
func (o *Hardware_Semaphore_Type) GetHWCFGR2_MASTERID2() uint32 {
	return (volatile.LoadUint32(&o.HWCFGR2.Reg) & 0xf0) >> 4
}
func (o *Hardware_Semaphore_Type) SetHWCFGR2_MASTERID1(value uint32) {
	volatile.StoreUint32(&o.HWCFGR2.Reg, volatile.LoadUint32(&o.HWCFGR2.Reg)&^(0xf)|value)
}
func (o *Hardware_Semaphore_Type) GetHWCFGR2_MASTERID1() uint32 {
	return volatile.LoadUint32(&o.HWCFGR2.Reg) & 0xf
}

// Hardware_Semaphore.HWCFGR1: Semaphore hardware configuration register 1
func (o *Hardware_Semaphore_Type) SetHWCFGR1_NBINT(value uint32) {
	volatile.StoreUint32(&o.HWCFGR1.Reg, volatile.LoadUint32(&o.HWCFGR1.Reg)&^(0xf00)|value<<8)
}
func (o *Hardware_Semaphore_Type) GetHWCFGR1_NBINT() uint32 {
	return (volatile.LoadUint32(&o.HWCFGR1.Reg) & 0xf00) >> 8
}
func (o *Hardware_Semaphore_Type) SetHWCFGR1_NBSEM(value uint32) {
	volatile.StoreUint32(&o.HWCFGR1.Reg, volatile.LoadUint32(&o.HWCFGR1.Reg)&^(0xff)|value)
}
func (o *Hardware_Semaphore_Type) GetHWCFGR1_NBSEM() uint32 {
	return volatile.LoadUint32(&o.HWCFGR1.Reg) & 0xff
}

// Hardware_Semaphore.VERR: HSEM version register
func (o *Hardware_Semaphore_Type) SetVERR_MAJREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf0)|value<<4)
}
func (o *Hardware_Semaphore_Type) GetVERR_MAJREV() uint32 {
	return (volatile.LoadUint32(&o.VERR.Reg) & 0xf0) >> 4
}
func (o *Hardware_Semaphore_Type) SetVERR_MINREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf)|value)
}
func (o *Hardware_Semaphore_Type) GetVERR_MINREV() uint32 {
	return volatile.LoadUint32(&o.VERR.Reg) & 0xf
}

// Hardware_Semaphore.IPIDR: HSEM indentification register
func (o *Hardware_Semaphore_Type) SetIPIDR(value uint32) {
	volatile.StoreUint32(&o.IPIDR.Reg, value)
}
func (o *Hardware_Semaphore_Type) GetIPIDR() uint32 {
	return volatile.LoadUint32(&o.IPIDR.Reg)
}

// Hardware_Semaphore.SIDR: HSEM size indentification register
func (o *Hardware_Semaphore_Type) SetSIDR(value uint32) {
	volatile.StoreUint32(&o.SIDR.Reg, value)
}
func (o *Hardware_Semaphore_Type) GetSIDR() uint32 {
	return volatile.LoadUint32(&o.SIDR.Reg)
}

// Analog to Digital Converter instance 1
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR    volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR1   volatile.Register32 // 0x14
	SMPR2   volatile.Register32 // 0x18
	_       [4]byte
	TR1     volatile.Register32 // 0x20
	TR2     volatile.Register32 // 0x24
	TR3     volatile.Register32 // 0x28
	_       [4]byte
	SQR1    volatile.Register32 // 0x30
	SQR2    volatile.Register32 // 0x34
	SQR3    volatile.Register32 // 0x38
	SQR4    volatile.Register32 // 0x3C
	DR      volatile.Register32 // 0x40
	_       [8]byte
	JSQR    volatile.Register32 // 0x4C
	_       [16]byte
	OFR1    volatile.Register32 // 0x60
	OFR2    volatile.Register32 // 0x64
	OFR3    volatile.Register32 // 0x68
	OFR4    volatile.Register32 // 0x6C
	_       [16]byte
	JDR1    volatile.Register32 // 0x80
	JDR2    volatile.Register32 // 0x84
	JDR3    volatile.Register32 // 0x88
	JDR4    volatile.Register32 // 0x8C
	_       [16]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [8]byte
	DIFSEL  volatile.Register32 // 0xB0
	CALFACT volatile.Register32 // 0xB4
}

// ADC.ISR: ADC interrupt and status register
func (o *ADC_Type) SetISR_JQOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_JQOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_AWD3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_AWD3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_AWD2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_AWD2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_AWD1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_AWD1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_JEOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_JEOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_JEOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOSMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOSMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_ADRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_ADRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// ADC.IER: ADC interrupt enable register
func (o *ADC_Type) SetIER_JQOVFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_JQOVFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_AWD3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_AWD3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_AWD2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_AWD2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_AWD1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_AWD1IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_JEOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_JEOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOSMPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOSMPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_ADRDYIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_ADRDYIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// ADC.CR: ADC control register
func (o *ADC_Type) SetCR_ADCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCR_ADCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCR_ADCALDIF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR_ADCALDIF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR_DEEPPWD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetCR_DEEPPWD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetCR_ADVREGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetCR_ADVREGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetCR_JADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR_JADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR_ADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCR_ADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCR_JADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCR_JADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCR_ADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_ADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCR_ADDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_ADDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_ADEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_ADEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// ADC.CFGR: ADC configuration register 1
func (o *ADC_Type) SetCFGR_JQDIS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCFGR_JQDIS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCFGR_AWDCH1CH(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetCFGR_AWDCH1CH() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetCFGR_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCFGR_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCFGR_JAWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCFGR_JAWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCFGR_AWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCFGR_AWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCFGR_AWD1SGL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCFGR_AWD1SGL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCFGR_JQM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCFGR_JQM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCFGR_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCFGR_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCFGR_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe0000)|value<<17)
}
func (o *ADC_Type) GetCFGR_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe0000) >> 17
}
func (o *ADC_Type) SetCFGR_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCFGR_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCFGR_AUTDLY(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCFGR_AUTDLY() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCFGR_CONT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCFGR_CONT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCFGR_OVRMOD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCFGR_OVRMOD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCFGR_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCFGR_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCFGR_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3c0)|value<<6)
}
func (o *ADC_Type) GetCFGR_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3c0) >> 6
}
func (o *ADC_Type) SetCFGR_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCFGR_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCFGR_RES(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *ADC_Type) GetCFGR_RES() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *ADC_Type) SetCFGR_DMACFG(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR_DMACFG() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR_DMAEN() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// ADC.CFGR2: ADC configuration register 2
func (o *ADC_Type) SetCFGR2_ROVSM(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCFGR2_ROVSM() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCFGR2_TOVS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCFGR2_TOVS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCFGR2_OVSS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1e0)|value<<5)
}
func (o *ADC_Type) GetCFGR2_OVSS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1e0) >> 5
}
func (o *ADC_Type) SetCFGR2_OVSR(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1c)|value<<2)
}
func (o *ADC_Type) GetCFGR2_OVSR() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1c) >> 2
}
func (o *ADC_Type) SetCFGR2_JOVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR2_JOVSE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR2_ROVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR2_ROVSE() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}

// ADC.SMPR1: ADC sampling time register 1
func (o *ADC_Type) SetSMPR1_SMP9(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR1_SMP9() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetSMPR1_SMP8(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR1_SMP8() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR1_SMP7(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR1_SMP7() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR1_SMP6(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR1_SMP6() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR1_SMP5(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR1_SMP5() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR1_SMP4(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR1_SMP4() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR1_SMP3(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR1_SMP3() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR1_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR1_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR1_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR1_SMP1() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR1_SMP0(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR1_SMP0() uint32 {
	return volatile.LoadUint32(&o.SMPR1.Reg) & 0x7
}

// ADC.SMPR2: ADC sampling time register 2
func (o *ADC_Type) SetSMPR2_SMP18(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR2_SMP18() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR2_SMP17(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR2_SMP17() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR2_SMP16(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR2_SMP16() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR2_SMP15(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR2_SMP15() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR2_SMP14(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR2_SMP14() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR2_SMP13(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR2_SMP13() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR2_SMP12(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR2_SMP12() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR2_SMP11(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR2_SMP11() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR2_SMP10(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR2_SMP10() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg) & 0x7
}

// ADC.TR1: ADC analog watchdog 1 threshold register
func (o *ADC_Type) SetTR1_HT1(value uint32) {
	volatile.StoreUint32(&o.TR1.Reg, volatile.LoadUint32(&o.TR1.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetTR1_HT1() uint32 {
	return (volatile.LoadUint32(&o.TR1.Reg) & 0xfff0000) >> 16
}
func (o *ADC_Type) SetTR1_LT1(value uint32) {
	volatile.StoreUint32(&o.TR1.Reg, volatile.LoadUint32(&o.TR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetTR1_LT1() uint32 {
	return volatile.LoadUint32(&o.TR1.Reg) & 0xfff
}

// ADC.TR2: ADC analog watchdog 2 threshold register
func (o *ADC_Type) SetTR2_HT2(value uint32) {
	volatile.StoreUint32(&o.TR2.Reg, volatile.LoadUint32(&o.TR2.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetTR2_HT2() uint32 {
	return (volatile.LoadUint32(&o.TR2.Reg) & 0xff0000) >> 16
}
func (o *ADC_Type) SetTR2_LT2(value uint32) {
	volatile.StoreUint32(&o.TR2.Reg, volatile.LoadUint32(&o.TR2.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetTR2_LT2() uint32 {
	return volatile.LoadUint32(&o.TR2.Reg) & 0xff
}

// ADC.TR3: ADC analog watchdog 3 threshold register
func (o *ADC_Type) SetTR3_HT3(value uint32) {
	volatile.StoreUint32(&o.TR3.Reg, volatile.LoadUint32(&o.TR3.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetTR3_HT3() uint32 {
	return (volatile.LoadUint32(&o.TR3.Reg) & 0xff0000) >> 16
}
func (o *ADC_Type) SetTR3_LT3(value uint32) {
	volatile.StoreUint32(&o.TR3.Reg, volatile.LoadUint32(&o.TR3.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetTR3_LT3() uint32 {
	return volatile.LoadUint32(&o.TR3.Reg) & 0xff
}

// ADC.SQR1: ADC group regular sequencer ranks register 1
func (o *ADC_Type) SetSQR1_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR1_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR1_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR1_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR1_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR1_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR1_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR1_SQ1() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0xf
}

// ADC.SQR2: ADC group regular sequencer ranks register 2
func (o *ADC_Type) SetSQR2_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR2_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR2_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR2_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR2_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR2_SQ7() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR2_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR2_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR2_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ5() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: ADC group regular sequencer ranks register 3
func (o *ADC_Type) SetSQR3_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR3_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR3_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR3_SQ13() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR3_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR3_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR3_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR3_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR3_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ10() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.SQR4: ADC group regular sequencer ranks register 4
func (o *ADC_Type) SetSQR4_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR4_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR4_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR4_SQ15() uint32 {
	return volatile.LoadUint32(&o.SQR4.Reg) & 0x1f
}

// ADC.DR: ADC group regular conversion data register
func (o *ADC_Type) SetDR_RDATA_0_6(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetDR_RDATA_0_6() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0x3f
}
func (o *ADC_Type) SetDR_RDATA_7_15(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff80)|value<<7)
}
func (o *ADC_Type) GetDR_RDATA_7_15() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff80) >> 7
}

// ADC.JSQR: ADC group injected sequencer register
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c000)|value<<14)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c000) >> 14
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f00)|value<<8)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x1f00) >> 8
}
func (o *ADC_Type) SetJSQR_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xc0)|value<<6)
}
func (o *ADC_Type) GetJSQR_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xc0) >> 6
}
func (o *ADC_Type) SetJSQR_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3c)|value<<2)
}
func (o *ADC_Type) GetJSQR_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3c) >> 2
}
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x3
}

// ADC.OFR1: ADC offset number 1 register
func (o *ADC_Type) SetOFR1_OFFSET1_EN(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR1_OFFSET1_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR1_OFFSET1_CH(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR1_OFFSET1_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR1_OFFSET1(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR1_OFFSET1() uint32 {
	return volatile.LoadUint32(&o.OFR1.Reg) & 0xfff
}

// ADC.OFR2: ADC offset number 2 register
func (o *ADC_Type) SetOFR2_OFFSET2_EN(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR2_OFFSET2_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR2_OFFSET2_CH(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR2_OFFSET2_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR2_OFFSET2(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR2_OFFSET2() uint32 {
	return volatile.LoadUint32(&o.OFR2.Reg) & 0xfff
}

// ADC.OFR3: ADC offset number 3 register
func (o *ADC_Type) SetOFR3_OFFSET3_EN(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR3_OFFSET3_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR3_OFFSET3_CH(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR3_OFFSET3_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR3_OFFSET3(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR3_OFFSET3() uint32 {
	return volatile.LoadUint32(&o.OFR3.Reg) & 0xfff
}

// ADC.OFR4: ADC offset number 4 register
func (o *ADC_Type) SetOFR4_OFFSET4_EN(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR4_OFFSET4_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR4_OFFSET4_CH(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR4_OFFSET4_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR4_OFFSET4(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR4_OFFSET4() uint32 {
	return volatile.LoadUint32(&o.OFR4.Reg) & 0xfff
}

// ADC.JDR1: ADC group injected sequencer rank 1 register
func (o *ADC_Type) SetJDR1_JDATA1(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, volatile.LoadUint32(&o.JDR1.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR1_JDATA1() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg) & 0xffff
}

// ADC.JDR2: ADC group injected sequencer rank 2 register
func (o *ADC_Type) SetJDR2_JDATA2(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, volatile.LoadUint32(&o.JDR2.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR2_JDATA2() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg) & 0xffff
}

// ADC.JDR3: ADC group injected sequencer rank 3 register
func (o *ADC_Type) SetJDR3_JDATA3(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, volatile.LoadUint32(&o.JDR3.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR3_JDATA3() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg) & 0xffff
}

// ADC.JDR4: ADC group injected sequencer rank 4 register
func (o *ADC_Type) SetJDR4_JDATA4(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, volatile.LoadUint32(&o.JDR4.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR4_JDATA4() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg) & 0xffff
}

// ADC.AWD2CR: ADC analog watchdog 2 configuration register
func (o *ADC_Type) SetAWD2CR_AWD2CH(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x7ffff)|value)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH() uint32 {
	return volatile.LoadUint32(&o.AWD2CR.Reg) & 0x7ffff
}

// ADC.AWD3CR: ADC analog watchdog 3 configuration register
func (o *ADC_Type) SetAWD3CR_AWD3CH(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x7ffff)|value)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH() uint32 {
	return volatile.LoadUint32(&o.AWD3CR.Reg) & 0x7ffff
}

// ADC.DIFSEL: ADC channel differential or single-ended mode selection register
func (o *ADC_Type) SetDIFSEL_DIFSEL_0(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_0() uint32 {
	return volatile.LoadUint32(&o.DIFSEL.Reg) & 0x1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_1_15(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0xfffe)|value<<1)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_1_15() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0xfffe) >> 1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_16_18(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x70000)|value<<16)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_16_18() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x70000) >> 16
}

// ADC.CALFACT: ADC calibration factors register
func (o *ADC_Type) SetCALFACT_CALFACT_D(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7f0000)|value<<16)
}
func (o *ADC_Type) GetCALFACT_CALFACT_D() uint32 {
	return (volatile.LoadUint32(&o.CALFACT.Reg) & 0x7f0000) >> 16
}
func (o *ADC_Type) SetCALFACT_CALFACT_S(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7f)|value)
}
func (o *ADC_Type) GetCALFACT_CALFACT_S() uint32 {
	return volatile.LoadUint32(&o.CALFACT.Reg) & 0x7f
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFSEL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFSEL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFSEL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFSEL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFSEL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFSEL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFSEL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFSEL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFSEL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFSEL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFSEL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFSEL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFSEL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFSEL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFSEL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFSEL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFSEL15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFSEL15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFSEL14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFSEL14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFSEL13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFSEL13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFSEL12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFSEL12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFSEL11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFSEL11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFSEL10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFSEL10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFSEL9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFSEL9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFSEL8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFSEL8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// GPIO.BRR: port bit reset register
func (o *GPIO_Type) SetBRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBRR_BR0() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8000) >> 15
}

// Serial audio interface
type SAI_Type struct {
	GCR    volatile.Register32 // 0x0
	CH     [2]SAI_CH_Type      // 0x4
	PDMCR  volatile.Register32 // 0x44
	PDMDLY volatile.Register32 // 0x48
}

// SAI.GCR: Global configuration register
func (o *SAI_Type) SetGCR_SYNCOUT(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x30)|value<<4)
}
func (o *SAI_Type) GetGCR_SYNCOUT() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x30) >> 4
}
func (o *SAI_Type) SetGCR_SYNCIN(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x3)|value)
}
func (o *SAI_Type) GetGCR_SYNCIN() uint32 {
	return volatile.LoadUint32(&o.GCR.Reg) & 0x3
}

// SAI.PDMCR: PDM control register
func (o *SAI_Type) SetPDMCR_CKEN4(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x800)|value<<11)
}
func (o *SAI_Type) GetPDMCR_CKEN4() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x800) >> 11
}
func (o *SAI_Type) SetPDMCR_CKEN3(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x400)|value<<10)
}
func (o *SAI_Type) GetPDMCR_CKEN3() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x400) >> 10
}
func (o *SAI_Type) SetPDMCR_CKEN2(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x200)|value<<9)
}
func (o *SAI_Type) GetPDMCR_CKEN2() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x200) >> 9
}
func (o *SAI_Type) SetPDMCR_CKEN1(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x100)|value<<8)
}
func (o *SAI_Type) GetPDMCR_CKEN1() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x100) >> 8
}
func (o *SAI_Type) SetPDMCR_MICNBR(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x30)|value<<4)
}
func (o *SAI_Type) GetPDMCR_MICNBR() uint32 {
	return (volatile.LoadUint32(&o.PDMCR.Reg) & 0x30) >> 4
}
func (o *SAI_Type) SetPDMCR_PDMEN(value uint32) {
	volatile.StoreUint32(&o.PDMCR.Reg, volatile.LoadUint32(&o.PDMCR.Reg)&^(0x1)|value)
}
func (o *SAI_Type) GetPDMCR_PDMEN() uint32 {
	return volatile.LoadUint32(&o.PDMCR.Reg) & 0x1
}

// SAI.PDMDLY: PDM delay register
func (o *SAI_Type) SetPDMDLY_DLYM4R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x70000000)|value<<28)
}
func (o *SAI_Type) GetPDMDLY_DLYM4R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x70000000) >> 28
}
func (o *SAI_Type) SetPDMDLY_DLYM4L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x7000000)|value<<24)
}
func (o *SAI_Type) GetPDMDLY_DLYM4L() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x7000000) >> 24
}
func (o *SAI_Type) SetPDMDLY_DLYM3R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x700000)|value<<20)
}
func (o *SAI_Type) GetPDMDLY_DLYM3R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x700000) >> 20
}
func (o *SAI_Type) SetPDMDLY_DLYM3L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_Type) GetPDMDLY_DLYM3L() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x70000) >> 16
}
func (o *SAI_Type) SetPDMDLY_DLYM2R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x7000)|value<<12)
}
func (o *SAI_Type) GetPDMDLY_DLYM2R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x7000) >> 12
}
func (o *SAI_Type) SetPDMDLY_DLYM2L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x700)|value<<8)
}
func (o *SAI_Type) GetPDMDLY_DLYM2L() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x700) >> 8
}
func (o *SAI_Type) SetPDMDLY_DLYM1R(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x70)|value<<4)
}
func (o *SAI_Type) GetPDMDLY_DLYM1R() uint32 {
	return (volatile.LoadUint32(&o.PDMDLY.Reg) & 0x70) >> 4
}
func (o *SAI_Type) SetPDMDLY_DLYM1L(value uint32) {
	volatile.StoreUint32(&o.PDMDLY.Reg, volatile.LoadUint32(&o.PDMDLY.Reg)&^(0x7)|value)
}
func (o *SAI_Type) GetPDMDLY_DLYM1L() uint32 {
	return volatile.LoadUint32(&o.PDMDLY.Reg) & 0x7
}

type SAI_CH_Type struct {
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	FRCR  volatile.Register32 // 0xC
	SLOTR volatile.Register32 // 0x10
	IM    volatile.Register32 // 0x14
	SR    volatile.Register32 // 0x18
	CLRFR volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
}

// SAI_CH.CR1: AConfiguration register 1
func (o *SAI_CH_Type) SetCR1_MCKEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000000)|value<<27)
}
func (o *SAI_CH_Type) GetCR1_MCKEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000000) >> 27
}
func (o *SAI_CH_Type) SetCR1_OSR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SAI_CH_Type) GetCR1_OSR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *SAI_CH_Type) SetCR1_MCKDIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3f00000)|value<<20)
}
func (o *SAI_CH_Type) GetCR1_MCKDIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3f00000) >> 20
}
func (o *SAI_CH_Type) SetCR1_NODIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *SAI_CH_Type) GetCR1_NODIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *SAI_CH_Type) SetCR1_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetCR1_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetCR1_SAIEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetCR1_SAIEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetCR1_OUTDRIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR1_OUTDRIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR1_MONO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SAI_CH_Type) GetCR1_MONO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SAI_CH_Type) SetCR1_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc00)|value<<10)
}
func (o *SAI_CH_Type) GetCR1_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc00) >> 10
}
func (o *SAI_CH_Type) SetCR1_CKSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SAI_CH_Type) GetCR1_CKSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SAI_CH_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SAI_CH_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SAI_CH_Type) SetCR1_DS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe0)|value<<5)
}
func (o *SAI_CH_Type) GetCR1_DS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe0) >> 5
}
func (o *SAI_CH_Type) SetCR1_PRTCFG(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc)|value<<2)
}
func (o *SAI_CH_Type) GetCR1_PRTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc) >> 2
}
func (o *SAI_CH_Type) SetCR1_MODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3)|value)
}
func (o *SAI_CH_Type) GetCR1_MODE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x3
}

// SAI_CH.CR2: AConfiguration register 2
func (o *SAI_CH_Type) SetCR2_COMP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xc000)|value<<14)
}
func (o *SAI_CH_Type) GetCR2_COMP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xc000) >> 14
}
func (o *SAI_CH_Type) SetCR2_CPL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR2_CPL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR2_MUTECN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1f80)|value<<7)
}
func (o *SAI_CH_Type) GetCR2_MUTECN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1f80) >> 7
}
func (o *SAI_CH_Type) SetCR2_MUTEVAL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCR2_MUTEVAL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCR2_MUTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCR2_MUTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCR2_TRIS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCR2_TRIS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCR2_FFLUSH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetCR2_FFLUSH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetCR2_FTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x7)|value)
}
func (o *SAI_CH_Type) GetCR2_FTH() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x7
}

// SAI_CH.FRCR: AFRCR
func (o *SAI_CH_Type) SetFRCR_FSOFF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x40000)|value<<18)
}
func (o *SAI_CH_Type) GetFRCR_FSOFF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x40000) >> 18
}
func (o *SAI_CH_Type) SetFRCR_FSPOL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetFRCR_FSPOL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetFRCR_FSDEF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetFRCR_FSDEF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetFRCR_FSALL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x7f00)|value<<8)
}
func (o *SAI_CH_Type) GetFRCR_FSALL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x7f00) >> 8
}
func (o *SAI_CH_Type) SetFRCR_FRL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0xff)|value)
}
func (o *SAI_CH_Type) GetFRCR_FRL() uint32 {
	return volatile.LoadUint32(&o.FRCR.Reg) & 0xff
}

// SAI_CH.SLOTR: ASlot register
func (o *SAI_CH_Type) SetSLOTR_SLOTEN(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTEN() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xffff0000) >> 16
}
func (o *SAI_CH_Type) SetSLOTR_NBSLOT(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xf00)|value<<8)
}
func (o *SAI_CH_Type) GetSLOTR_NBSLOT() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xf00) >> 8
}
func (o *SAI_CH_Type) SetSLOTR_SLOTSZ(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xc0)|value<<6)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTSZ() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xc0) >> 6
}
func (o *SAI_CH_Type) SetSLOTR_FBOFF(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0x1f)|value)
}
func (o *SAI_CH_Type) GetSLOTR_FBOFF() uint32 {
	return volatile.LoadUint32(&o.SLOTR.Reg) & 0x1f
}

// SAI_CH.IM: AInterrupt mask register2
func (o *SAI_CH_Type) SetIM_LFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetIM_LFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetIM_AFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetIM_AFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetIM_CNRDYIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetIM_CNRDYIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetIM_FREQIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetIM_FREQIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetIM_WCKCFGIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetIM_WCKCFGIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetIM_MUTEDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetIM_MUTEDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetIM_OVRUDRIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetIM_OVRUDRIE() uint32 {
	return volatile.LoadUint32(&o.IM.Reg) & 0x1
}

// SAI_CH.SR: AStatus register
func (o *SAI_CH_Type) SetSR_FLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_CH_Type) GetSR_FLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000) >> 16
}
func (o *SAI_CH_Type) SetSR_LFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetSR_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetSR_AFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetSR_AFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetSR_CNRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetSR_CNRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetSR_FREQ(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetSR_FREQ() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetSR_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetSR_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetSR_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetSR_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetSR_OVRUDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetSR_OVRUDR() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// SAI_CH.CLRFR: AClear flag register
func (o *SAI_CH_Type) SetCLRFR_CLFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCLRFR_CLFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCLRFR_CAFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCLRFR_CAFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCLRFR_CCNRDY(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCLRFR_CCNRDY() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCLRFR_CWCKCFG(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetCLRFR_CWCKCFG() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetCLRFR_CMUTEDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetCLRFR_CMUTEDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetCLRFR_COVRUDR(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetCLRFR_COVRUDR() uint32 {
	return volatile.LoadUint32(&o.CLRFR.Reg) & 0x1
}

// SAI_CH.DR: AData register
func (o *SAI_CH_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *SAI_CH_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// General-purpose-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	_            [4]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	OR           volatile.Register32 // 0x50
	_            [12]byte
	AF           volatile.Register32 // 0x60
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_UIFREMAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR1_UIFREMAP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_SMS_3(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSMCR_SMS_3() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_OCCS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSMCR_OCCS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}

// TIM.CCMR1_Output: capture/compare mode register 1 (output mode)
func (o *TIM_Type) SetCCMR1_Output_OC2M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR1_Output_OC1M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}

// TIM.CCMR2_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR2_Output_OC4M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR2_Output_OC3M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC4NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCER_CC4NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg)
}
func (o *TIM_Type) SetCNT_UIFCPY(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCNT_UIFCPY() uint32 {
	return (volatile.LoadUint32(&o.CNT.Reg) & 0x80000000) >> 31
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR_ARR_H(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff0000)|value<<16)
}
func (o *TIM_Type) GetARR_ARR_H() uint32 {
	return (volatile.LoadUint32(&o.ARR.Reg) & 0xffff0000) >> 16
}
func (o *TIM_Type) SetARR_ARR_L(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetARR_ARR_L() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIM.CCR1: capture/compare register 1
func (o *TIM_Type) SetCCR1_CCR1_H(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *TIM_Type) GetCCR1_CCR1_H() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0xffff0000) >> 16
}
func (o *TIM_Type) SetCCR1_CCR1_L(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR1_CCR1_L() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIM.CCR2: capture/compare register 2
func (o *TIM_Type) SetCCR2_CCR2_H(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *TIM_Type) GetCCR2_CCR2_H() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0xffff0000) >> 16
}
func (o *TIM_Type) SetCCR2_CCR2_L(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR2_CCR2_L() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIM.CCR3: capture/compare register 3
func (o *TIM_Type) SetCCR3_CCR3_H(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *TIM_Type) GetCCR3_CCR3_H() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0xffff0000) >> 16
}
func (o *TIM_Type) SetCCR3_CCR3_L(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR3_CCR3_L() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xffff
}

// TIM.CCR4: capture/compare register 4
func (o *TIM_Type) SetCCR4_CCR4_H(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff0000)|value<<16)
}
func (o *TIM_Type) GetCCR4_CCR4_H() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0xffff0000) >> 16
}
func (o *TIM_Type) SetCCR4_CCR4_L(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR4_CCR4_L() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xffff
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR_DMAB(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, volatile.LoadUint32(&o.DMAR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetDMAR_DMAB() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg) & 0xffff
}

// TIM.OR: TIM2 option register
func (o *TIM_Type) SetOR_TI4_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0xc)|value<<2)
}
func (o *TIM_Type) GetOR_TI4_RMP() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0xc) >> 2
}
func (o *TIM_Type) SetOR_ETR_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetOR_ETR_RMP() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetOR_ITR_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetOR_ITR_RMP() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x1
}

// TIM.AF: TIM2 alternate function option register 1
func (o *TIM_Type) SetAF_ETRSEL(value uint32) {
	volatile.StoreUint32(&o.AF.Reg, volatile.LoadUint32(&o.AF.Reg)&^(0x1c000)|value<<14)
}
func (o *TIM_Type) GetAF_ETRSEL() uint32 {
	return (volatile.LoadUint32(&o.AF.Reg) & 0x1c000) >> 14
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
	OR   volatile.Register32 // 0x20
}

// LPTIM.ISR: Interrupt and Status Register
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPTIM.ICR: Interrupt Clear Register
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPTIM.IER: Interrupt Enable Register
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LPTIM.CFGR: Configuration Register
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// LPTIM.CR: Control Register
func (o *LPTIM_Type) SetCR_RSTARE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetCR_RSTARE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetCR_COUNTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetCR_COUNTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LPTIM.CMP: Compare Register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: Autoreload Register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: Counter Register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// LPTIM.OR: Option Register
func (o *LPTIM_Type) SetOR_OR1(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetOR_OR1() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x1
}
func (o *LPTIM_Type) SetOR_OR2(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetOR_OR2() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	BRR   volatile.Register32 // 0xC
	GTPR  volatile.Register32 // 0x10
	RTOR  volatile.Register32 // 0x14
	RQR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	RDR   volatile.Register32 // 0x24
	TDR   volatile.Register32 // 0x28
	PRESC volatile.Register32 // 0x2C
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_RXFFIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetCR1_RXFFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000000) >> 31
}
func (o *USART_Type) SetCR1_TXFEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetCR1_TXFEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetCR1_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetCR1_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetCR1_M1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR1_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR1_EOBIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetCR1_EOBIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetCR1_RTOIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetCR1_RTOIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetCR1_DEAT4(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000000)|value<<25)
}
func (o *USART_Type) GetCR1_DEAT4() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000000) >> 25
}
func (o *USART_Type) SetCR1_DEAT3(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCR1_DEAT3() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetCR1_DEAT2(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR1_DEAT2() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR1_DEAT1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR1_DEAT1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR1_DEAT0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetCR1_DEAT0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetCR1_DEDT4(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR1_DEDT4() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR1_DEDT3(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR1_DEDT3() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR1_DEDT2(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR1_DEDT2() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR1_DEDT1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR1_DEDT1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR1_DEDT0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR1_DEDT0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR1_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR1_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR1_MME(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_ADD4_7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *USART_Type) GetCR2_ADD4_7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf0000000) >> 28
}
func (o *USART_Type) SetCR2_ADD0_3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf000000)|value<<24)
}
func (o *USART_Type) GetCR2_ADD0_3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf000000) >> 24
}
func (o *USART_Type) SetCR2_RTOEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR2_RTOEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR2_ABRMOD1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR2_ABRMOD1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR2_ABRMOD0(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetCR2_ABRMOD0() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetCR2_ABREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR2_ABREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR2_TAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR2_TAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR2_DIS_NSS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR2_DIS_NSS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR2_SLVEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR2_SLVEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_TXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000000)|value<<29)
}
func (o *USART_Type) GetCR3_TXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000000) >> 29
}
func (o *USART_Type) SetCR3_RXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR3_RXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR3_RXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe000000)|value<<25)
}
func (o *USART_Type) GetCR3_RXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe000000) >> 25
}
func (o *USART_Type) SetCR3_TCBGTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCR3_TCBGTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetCR3_TXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR3_TXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *USART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *USART_Type) SetCR3_SCARCNT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000)|value<<17)
}
func (o *USART_Type) GetCR3_SCARCNT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000) >> 17
}
func (o *USART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xffff
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// USART.RTOR: Receiver timeout register
func (o *USART_Type) SetRTOR_BLEN(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetRTOR_BLEN() uint32 {
	return (volatile.LoadUint32(&o.RTOR.Reg) & 0xff000000) >> 24
}
func (o *USART_Type) SetRTOR_RTO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetRTOR_RTO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffffff
}

// USART.RQR: Request register
func (o *USART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetRQR_ABRRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetRQR_ABRRQ() uint32 {
	return volatile.LoadUint32(&o.RQR.Reg) & 0x1
}

// USART.ISR: Interrupt & status register
func (o *USART_Type) SetISR_TXFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetISR_TXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetISR_RXFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetISR_RXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetISR_TCBGT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *USART_Type) GetISR_TCBGT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *USART_Type) SetISR_RXFF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetISR_RXFF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetISR_TXFE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetISR_TXFE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetISR_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetISR_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetISR_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetISR_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetISR_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetISR_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetISR_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetISR_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetISR_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetISR_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetISR_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetISR_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetISR_ABRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetISR_ABRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetISR_ABRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetISR_ABRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetISR_UDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetISR_UDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetISR_EOBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetISR_EOBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetISR_RTOF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetISR_RTOF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetISR_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetISR_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetISR_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetISR_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetISR_LBDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetISR_LBDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetISR_TXE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetISR_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetISR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetISR_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetISR_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetISR_NF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetISR_NF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetISR_FE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetISR_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetISR_PE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetISR_PE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// USART.ICR: Interrupt flag clear register
func (o *USART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetICR_UDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetICR_UDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetICR_EOBCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetICR_EOBCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetICR_RTOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetICR_RTOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetICR_LBDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetICR_LBDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetICR_TCBGTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetICR_TCBGTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetICR_TXFECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetICR_TXFECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetICR_NCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetICR_NCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// USART.RDR: Receive data register
func (o *USART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// USART.TDR: Transmit data register
func (o *USART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// USART.PRESC: Prescaler register
func (o *USART_Type) SetPRESC_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESC.Reg, volatile.LoadUint32(&o.PRESC.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetPRESC_PRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESC.Reg) & 0xf
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	SR     volatile.Register32 // 0x8
	DR     volatile.Register32 // 0xC
	CRCPR  volatile.Register32 // 0x10
	RXCRCR volatile.Register32 // 0x14
	TXCRCR volatile.Register32 // 0x18
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_DFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_DFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_NSSP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCR2_NSSP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_DS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCR2_DS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCR2_FRXTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR2_FRXTH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR2_LDMA_RX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR2_LDMA_RX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR2_LDMA_TX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR2_LDMA_TX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_TIFRFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_TIFRFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_FRLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x600)|value<<9)
}
func (o *SPI_Type) GetSR_FRLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x600) >> 9
}
func (o *SPI_Type) SetSR_FTLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1800)|value<<11)
}
func (o *SPI_Type) GetSR_FTLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1800) >> 11
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// Voltage reference buffer
type VREF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// VREF.CSR: VREF control and status register
func (o *VREF_Type) SetCSR_ENVR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *VREF_Type) GetCSR_ENVR() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *VREF_Type) SetCSR_HIZ(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *VREF_Type) GetCSR_HIZ() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *VREF_Type) SetCSR_VRS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *VREF_Type) GetCSR_VRS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *VREF_Type) SetCSR_VRR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *VREF_Type) GetCSR_VRR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}

// VREF.CCR: calibration control register
func (o *VREF_Type) SetCCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3f)|value)
}
func (o *VREF_Type) GetCCR_TRIM() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x3f
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
}

// RTC.TR: time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.CR: control register
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_ITSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetCR_ITSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// RTC.ISR: initialization and status register
func (o *RTC_Type) SetISR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetISR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *RTC_Type) SetISR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetISR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetISR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetISR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetISR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetISR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetISR_INITS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetISR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetISR_RSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetISR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetISR_INITF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetISR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetISR_INIT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetISR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetISR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetISR_ALRAF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetISR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetISR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetISR_WUTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetISR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetISR_TSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetISR_TSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetISR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetISR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetISR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetISR_TAMP1F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetISR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetISR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetISR_TAMP3F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetISR_TAMP3F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetISR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetISR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetISR_ITSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetISR_ITSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}

// RTC.PRER: prescaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}

// RTC.WUTR: wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.ALRMAR: alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMBR: alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.WPR: write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.SSR: sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.SHIFTR: shift control register
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}

// RTC.TSTR: time stamp time register
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}

// RTC.TSDR: time stamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TSSSR: timestamp sub second register
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.CALR: calibration register
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}

// RTC.TAMPCR: tamper configuration register
func (o *RTC_Type) SetTAMPCR_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTAMPCR_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1
}
func (o *RTC_Type) SetTAMPCR_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetTAMPCR_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetTAMPCR_TAMPIE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetTAMPCR_TAMPIE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetTAMPCR_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetTAMPCR_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetTAMPCR_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetTAMPCR_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetTAMPCR_TAMP3E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetTAMPCR_TAMP3E() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetTAMPCR_TAMP3TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetTAMPCR_TAMP3TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetTAMPCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTAMPCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTAMPCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x700)|value<<8)
}
func (o *RTC_Type) GetTAMPCR_TAMPFREQ() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x700) >> 8
}
func (o *RTC_Type) SetTAMPCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1800)|value<<11)
}
func (o *RTC_Type) GetTAMPCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1800) >> 11
}
func (o *RTC_Type) SetTAMPCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x6000)|value<<13)
}
func (o *RTC_Type) GetTAMPCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x6000) >> 13
}
func (o *RTC_Type) SetTAMPCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTAMPCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTAMPCR_TAMP1IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetTAMPCR_TAMP1IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetTAMPCR_TAMP1NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetTAMPCR_TAMP1NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetTAMPCR_TAMP1MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetTAMPCR_TAMP1MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetTAMPCR_TAMP2IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetTAMPCR_TAMP2IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetTAMPCR_TAMP2NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetTAMPCR_TAMP2NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetTAMPCR_TAMP2MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_Type) GetTAMPCR_TAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x200000) >> 21
}
func (o *RTC_Type) SetTAMPCR_TAMP3IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTAMPCR_TAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTAMPCR_TAMP3NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetTAMPCR_TAMP3NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetTAMPCR_TAMP3MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetTAMPCR_TAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1000000) >> 24
}

// RTC.ALRMASSR: alarm A sub second register
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}

// RTC.ALRMBSSR: alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}

// RTC.OR: option register
func (o *RTC_Type) SetOR_RTC_ALARM_TYPE(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetOR_RTC_ALARM_TYPE() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x1
}
func (o *RTC_Type) SetOR_RTC_OUT_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetOR_RTC_OUT_RMP() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}

// RTC.BKP0R: backup register
func (o *RTC_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *RTC_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// RTC.BKP1R: backup register
func (o *RTC_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *RTC_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// RTC.BKP2R: backup register
func (o *RTC_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *RTC_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// RTC.BKP3R: backup register
func (o *RTC_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *RTC_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// RTC.BKP4R: backup register
func (o *RTC_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *RTC_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// RTC.BKP5R: backup register
func (o *RTC_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *RTC_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// RTC.BKP6R: backup register
func (o *RTC_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *RTC_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// RTC.BKP7R: backup register
func (o *RTC_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *RTC_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// RTC.BKP8R: backup register
func (o *RTC_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *RTC_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// RTC.BKP9R: backup register
func (o *RTC_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *RTC_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// RTC.BKP10R: backup register
func (o *RTC_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *RTC_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// RTC.BKP11R: backup register
func (o *RTC_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *RTC_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// RTC.BKP12R: backup register
func (o *RTC_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *RTC_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// RTC.BKP13R: backup register
func (o *RTC_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *RTC_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// RTC.BKP14R: backup register
func (o *RTC_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *RTC_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// RTC.BKP15R: backup register
func (o *RTC_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *RTC_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// RTC.BKP16R: backup register
func (o *RTC_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *RTC_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// RTC.BKP17R: backup register
func (o *RTC_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *RTC_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// RTC.BKP18R: backup register
func (o *RTC_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *RTC_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// RTC.BKP19R: backup register
func (o *RTC_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *RTC_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// Debug support
type DBGMCU_Type struct {
	IDCODE      volatile.Register32 // 0x0
	CR          volatile.Register32 // 0x4
	_           [52]byte
	APB1FZR1    volatile.Register32 // 0x3C
	C2AP_B1FZR1 volatile.Register32 // 0x40
	APB1FZR2    volatile.Register32 // 0x44
	C2APB1FZR2  volatile.Register32 // 0x48
	APB2FZR     volatile.Register32 // 0x4C
}

// DBGMCU.IDCODE: MCU Device ID Code Register
func (o *DBGMCU_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xfff)|value)
}
func (o *DBGMCU_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xfff
}
func (o *DBGMCU_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBGMCU_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBGMCU.CR: Debug MCU Configuration Register
func (o *DBGMCU_Type) SetCR_DBG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetCR_DBG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBGMCU_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetCR_TRACE_IOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetCR_TRACE_IOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetCR_TRGOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DBGMCU_Type) GetCR_TRGOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}

// DBGMCU.APB1FZR1: APB1 Low Freeze Register CPU1
func (o *DBGMCU_Type) SetAPB1FZR1_DBG_TIMER2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1FZR1.Reg, volatile.LoadUint32(&o.APB1FZR1.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetAPB1FZR1_DBG_TIMER2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB1FZR1.Reg) & 0x1
}
func (o *DBGMCU_Type) SetAPB1FZR1_DBG_RTC_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1FZR1.Reg, volatile.LoadUint32(&o.APB1FZR1.Reg)&^(0x400)|value<<10)
}
func (o *DBGMCU_Type) GetAPB1FZR1_DBG_RTC_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1FZR1.Reg) & 0x400) >> 10
}
func (o *DBGMCU_Type) SetAPB1FZR1_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1FZR1.Reg, volatile.LoadUint32(&o.APB1FZR1.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB1FZR1_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1FZR1.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB1FZR1_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1FZR1.Reg, volatile.LoadUint32(&o.APB1FZR1.Reg)&^(0x1000)|value<<12)
}
func (o *DBGMCU_Type) GetAPB1FZR1_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1FZR1.Reg) & 0x1000) >> 12
}
func (o *DBGMCU_Type) SetAPB1FZR1_DBG_I2C1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1FZR1.Reg, volatile.LoadUint32(&o.APB1FZR1.Reg)&^(0x200000)|value<<21)
}
func (o *DBGMCU_Type) GetAPB1FZR1_DBG_I2C1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1FZR1.Reg) & 0x200000) >> 21
}
func (o *DBGMCU_Type) SetAPB1FZR1_DBG_I2C3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1FZR1.Reg, volatile.LoadUint32(&o.APB1FZR1.Reg)&^(0x800000)|value<<23)
}
func (o *DBGMCU_Type) GetAPB1FZR1_DBG_I2C3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1FZR1.Reg) & 0x800000) >> 23
}
func (o *DBGMCU_Type) SetAPB1FZR1_DBG_LPTIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1FZR1.Reg, volatile.LoadUint32(&o.APB1FZR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGMCU_Type) GetAPB1FZR1_DBG_LPTIM1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1FZR1.Reg) & 0x80000000) >> 31
}

// DBGMCU.C2AP_B1FZR1: APB1 Low Freeze Register CPU2
func (o *DBGMCU_Type) SetC2AP_B1FZR1_DBG_LPTIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.C2AP_B1FZR1.Reg, volatile.LoadUint32(&o.C2AP_B1FZR1.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetC2AP_B1FZR1_DBG_LPTIM2_STOP() uint32 {
	return volatile.LoadUint32(&o.C2AP_B1FZR1.Reg) & 0x1
}
func (o *DBGMCU_Type) SetC2AP_B1FZR1_DBG_RTC_STOP(value uint32) {
	volatile.StoreUint32(&o.C2AP_B1FZR1.Reg, volatile.LoadUint32(&o.C2AP_B1FZR1.Reg)&^(0x400)|value<<10)
}
func (o *DBGMCU_Type) GetC2AP_B1FZR1_DBG_RTC_STOP() uint32 {
	return (volatile.LoadUint32(&o.C2AP_B1FZR1.Reg) & 0x400) >> 10
}
func (o *DBGMCU_Type) SetC2AP_B1FZR1_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.C2AP_B1FZR1.Reg, volatile.LoadUint32(&o.C2AP_B1FZR1.Reg)&^(0x1000)|value<<12)
}
func (o *DBGMCU_Type) GetC2AP_B1FZR1_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.C2AP_B1FZR1.Reg) & 0x1000) >> 12
}
func (o *DBGMCU_Type) SetC2AP_B1FZR1_DBG_I2C1_STOP(value uint32) {
	volatile.StoreUint32(&o.C2AP_B1FZR1.Reg, volatile.LoadUint32(&o.C2AP_B1FZR1.Reg)&^(0x200000)|value<<21)
}
func (o *DBGMCU_Type) GetC2AP_B1FZR1_DBG_I2C1_STOP() uint32 {
	return (volatile.LoadUint32(&o.C2AP_B1FZR1.Reg) & 0x200000) >> 21
}
func (o *DBGMCU_Type) SetC2AP_B1FZR1_DBG_I2C3_STOP(value uint32) {
	volatile.StoreUint32(&o.C2AP_B1FZR1.Reg, volatile.LoadUint32(&o.C2AP_B1FZR1.Reg)&^(0x800000)|value<<23)
}
func (o *DBGMCU_Type) GetC2AP_B1FZR1_DBG_I2C3_STOP() uint32 {
	return (volatile.LoadUint32(&o.C2AP_B1FZR1.Reg) & 0x800000) >> 23
}
func (o *DBGMCU_Type) SetC2AP_B1FZR1_DBG_LPTIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.C2AP_B1FZR1.Reg, volatile.LoadUint32(&o.C2AP_B1FZR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGMCU_Type) GetC2AP_B1FZR1_DBG_LPTIM1_STOP() uint32 {
	return (volatile.LoadUint32(&o.C2AP_B1FZR1.Reg) & 0x80000000) >> 31
}

// DBGMCU.APB1FZR2: APB1 High Freeze Register CPU1
func (o *DBGMCU_Type) SetAPB1FZR2_DBG_LPTIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1FZR2.Reg, volatile.LoadUint32(&o.APB1FZR2.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetAPB1FZR2_DBG_LPTIM2_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1FZR2.Reg) & 0x20) >> 5
}

// DBGMCU.C2APB1FZR2: APB1 High Freeze Register CPU2
func (o *DBGMCU_Type) SetC2APB1FZR2_DBG_LPTIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.C2APB1FZR2.Reg, volatile.LoadUint32(&o.C2APB1FZR2.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetC2APB1FZR2_DBG_LPTIM2_STOP() uint32 {
	return (volatile.LoadUint32(&o.C2APB1FZR2.Reg) & 0x20) >> 5
}

// DBGMCU.APB2FZR: APB2 Freeze Register CPU1
func (o *DBGMCU_Type) SetAPB2FZR_DBG_TIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2FZR.Reg, volatile.LoadUint32(&o.APB2FZR.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB2FZR_DBG_TIM1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2FZR.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB2FZR_DBG_TIM16_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2FZR.Reg, volatile.LoadUint32(&o.APB2FZR.Reg)&^(0x20000)|value<<17)
}
func (o *DBGMCU_Type) GetAPB2FZR_DBG_TIM16_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2FZR.Reg) & 0x20000) >> 17
}
func (o *DBGMCU_Type) SetAPB2FZR_DBG_TIM17_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2FZR.Reg, volatile.LoadUint32(&o.APB2FZR.Reg)&^(0x40000)|value<<18)
}
func (o *DBGMCU_Type) GetAPB2FZR_DBG_TIM17_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2FZR.Reg) & 0x40000) >> 18
}

// PKA
type PKA_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	CLRFR volatile.Register32 // 0x8
	_     [8168]byte
	VERR  volatile.Register32 // 0x1FF4
	IPIDR volatile.Register32 // 0x1FF8
	SIDR  volatile.Register32 // 0x1FFC
}

// PKA.CR: Control register
func (o *PKA_Type) SetCR_ADDRERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *PKA_Type) GetCR_ADDRERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *PKA_Type) SetCR_RAMERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *PKA_Type) GetCR_RAMERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *PKA_Type) SetCR_PROCENDIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *PKA_Type) GetCR_PROCENDIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *PKA_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f00)|value<<8)
}
func (o *PKA_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3f00) >> 8
}
func (o *PKA_Type) SetCR_SECLVL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *PKA_Type) GetCR_SECLVL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *PKA_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *PKA_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *PKA_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *PKA_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// PKA.SR: PKA status register
func (o *PKA_Type) SetSR_ADDRERRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *PKA_Type) GetSR_ADDRERRF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *PKA_Type) SetSR_RAMERRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *PKA_Type) GetSR_RAMERRF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *PKA_Type) SetSR_PROCENDF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *PKA_Type) GetSR_PROCENDF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *PKA_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *PKA_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// PKA.CLRFR: PKA clear flag register
func (o *PKA_Type) SetCLRFR_ADDRERRFC(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x100000)|value<<20)
}
func (o *PKA_Type) GetCLRFR_ADDRERRFC() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x100000) >> 20
}
func (o *PKA_Type) SetCLRFR_RAMERRFC(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x80000)|value<<19)
}
func (o *PKA_Type) GetCLRFR_RAMERRFC() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x80000) >> 19
}
func (o *PKA_Type) SetCLRFR_PROCENDFC(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x20000)|value<<17)
}
func (o *PKA_Type) GetCLRFR_PROCENDFC() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x20000) >> 17
}

// PKA.VERR: PKA version register
func (o *PKA_Type) SetVERR_MINREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf)|value)
}
func (o *PKA_Type) GetVERR_MINREV() uint32 {
	return volatile.LoadUint32(&o.VERR.Reg) & 0xf
}
func (o *PKA_Type) SetVERR_MAJREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf0)|value<<4)
}
func (o *PKA_Type) GetVERR_MAJREV() uint32 {
	return (volatile.LoadUint32(&o.VERR.Reg) & 0xf0) >> 4
}

// PKA.IPIDR: PKA identification register
func (o *PKA_Type) SetIPIDR(value uint32) {
	volatile.StoreUint32(&o.IPIDR.Reg, value)
}
func (o *PKA_Type) GetIPIDR() uint32 {
	return volatile.LoadUint32(&o.IPIDR.Reg)
}

// PKA.SIDR: PKA size ID register
func (o *PKA_Type) SetSIDR(value uint32) {
	volatile.StoreUint32(&o.SIDR.Reg, value)
}
func (o *PKA_Type) GetSIDR() uint32 {
	return volatile.LoadUint32(&o.SIDR.Reg)
}

// IPCC
type IPCC_Type struct {
	C1CR     volatile.Register32 // 0x0
	C1MR     volatile.Register32 // 0x4
	C1SCR    volatile.Register32 // 0x8
	C1TOC2SR volatile.Register32 // 0xC
	C2CR     volatile.Register32 // 0x10
	C2MR     volatile.Register32 // 0x14
	C2SCR    volatile.Register32 // 0x18
	C2TOC1SR volatile.Register32 // 0x1C
	_        [976]byte
	HWCFGR   volatile.Register32 // 0x3F0
	VERR     volatile.Register32 // 0x3F4
	IPIDR    volatile.Register32 // 0x3F8
	SIDR     volatile.Register32 // 0x3FC
}

// IPCC.C1CR: Control register CPU1
func (o *IPCC_Type) SetC1CR_TXFIE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC1CR_TXFIE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x10000) >> 16
}
func (o *IPCC_Type) SetC1CR_RXOIE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC1CR_RXOIE() uint32 {
	return volatile.LoadUint32(&o.C1CR.Reg) & 0x1
}

// IPCC.C1MR: Mask register CPU1
func (o *IPCC_Type) SetC1MR_CH6FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x200000)|value<<21)
}
func (o *IPCC_Type) GetC1MR_CH6FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x200000) >> 21
}
func (o *IPCC_Type) SetC1MR_CH5FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x100000)|value<<20)
}
func (o *IPCC_Type) GetC1MR_CH5FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x100000) >> 20
}
func (o *IPCC_Type) SetC1MR_CH4FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x80000)|value<<19)
}
func (o *IPCC_Type) GetC1MR_CH4FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x80000) >> 19
}
func (o *IPCC_Type) SetC1MR_CH3FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x40000)|value<<18)
}
func (o *IPCC_Type) GetC1MR_CH3FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x40000) >> 18
}
func (o *IPCC_Type) SetC1MR_CH2FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x20000)|value<<17)
}
func (o *IPCC_Type) GetC1MR_CH2FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x20000) >> 17
}
func (o *IPCC_Type) SetC1MR_CH1FM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC1MR_CH1FM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x10000) >> 16
}
func (o *IPCC_Type) SetC1MR_CH6OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC1MR_CH6OM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x20) >> 5
}
func (o *IPCC_Type) SetC1MR_CH5OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC1MR_CH5OM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC1MR_CH4OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC1MR_CH4OM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC1MR_CH3OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC1MR_CH3OM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC1MR_CH2OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC1MR_CH2OM() uint32 {
	return (volatile.LoadUint32(&o.C1MR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC1MR_CH1OM(value uint32) {
	volatile.StoreUint32(&o.C1MR.Reg, volatile.LoadUint32(&o.C1MR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC1MR_CH1OM() uint32 {
	return volatile.LoadUint32(&o.C1MR.Reg) & 0x1
}

// IPCC.C1SCR: Status Set or Clear register CPU1
func (o *IPCC_Type) SetC1SCR_CH6S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x200000)|value<<21)
}
func (o *IPCC_Type) GetC1SCR_CH6S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x200000) >> 21
}
func (o *IPCC_Type) SetC1SCR_CH5S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x100000)|value<<20)
}
func (o *IPCC_Type) GetC1SCR_CH5S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x100000) >> 20
}
func (o *IPCC_Type) SetC1SCR_CH4S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x80000)|value<<19)
}
func (o *IPCC_Type) GetC1SCR_CH4S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x80000) >> 19
}
func (o *IPCC_Type) SetC1SCR_CH3S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x40000)|value<<18)
}
func (o *IPCC_Type) GetC1SCR_CH3S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x40000) >> 18
}
func (o *IPCC_Type) SetC1SCR_CH2S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x20000)|value<<17)
}
func (o *IPCC_Type) GetC1SCR_CH2S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x20000) >> 17
}
func (o *IPCC_Type) SetC1SCR_CH1S(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC1SCR_CH1S() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x10000) >> 16
}
func (o *IPCC_Type) SetC1SCR_CH6C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC1SCR_CH6C() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x20) >> 5
}
func (o *IPCC_Type) SetC1SCR_CH5C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC1SCR_CH5C() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC1SCR_CH4C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC1SCR_CH4C() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC1SCR_CH3C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC1SCR_CH3C() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC1SCR_CH2C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC1SCR_CH2C() uint32 {
	return (volatile.LoadUint32(&o.C1SCR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC1SCR_CH1C(value uint32) {
	volatile.StoreUint32(&o.C1SCR.Reg, volatile.LoadUint32(&o.C1SCR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC1SCR_CH1C() uint32 {
	return volatile.LoadUint32(&o.C1SCR.Reg) & 0x1
}

// IPCC.C1TOC2SR: CPU1 to CPU2 status register
func (o *IPCC_Type) SetC1TOC2SR_CH6F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC1TOC2SR_CH6F() uint32 {
	return (volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x20) >> 5
}
func (o *IPCC_Type) SetC1TOC2SR_CH5F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC1TOC2SR_CH5F() uint32 {
	return (volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC1TOC2SR_CH4F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC1TOC2SR_CH4F() uint32 {
	return (volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC1TOC2SR_CH3F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC1TOC2SR_CH3F() uint32 {
	return (volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC1TOC2SR_CH2F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC1TOC2SR_CH2F() uint32 {
	return (volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC1TOC2SR_CH1F(value uint32) {
	volatile.StoreUint32(&o.C1TOC2SR.Reg, volatile.LoadUint32(&o.C1TOC2SR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC1TOC2SR_CH1F() uint32 {
	return volatile.LoadUint32(&o.C1TOC2SR.Reg) & 0x1
}

// IPCC.C2CR: Control register CPU2
func (o *IPCC_Type) SetC2CR_TXFIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC2CR_TXFIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x10000) >> 16
}
func (o *IPCC_Type) SetC2CR_RXOIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC2CR_RXOIE() uint32 {
	return volatile.LoadUint32(&o.C2CR.Reg) & 0x1
}

// IPCC.C2MR: Mask register CPU2
func (o *IPCC_Type) SetC2MR_CH6FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x200000)|value<<21)
}
func (o *IPCC_Type) GetC2MR_CH6FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x200000) >> 21
}
func (o *IPCC_Type) SetC2MR_CH5FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x100000)|value<<20)
}
func (o *IPCC_Type) GetC2MR_CH5FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x100000) >> 20
}
func (o *IPCC_Type) SetC2MR_CH4FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x80000)|value<<19)
}
func (o *IPCC_Type) GetC2MR_CH4FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x80000) >> 19
}
func (o *IPCC_Type) SetC2MR_CH3FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x40000)|value<<18)
}
func (o *IPCC_Type) GetC2MR_CH3FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x40000) >> 18
}
func (o *IPCC_Type) SetC2MR_CH2FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x20000)|value<<17)
}
func (o *IPCC_Type) GetC2MR_CH2FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x20000) >> 17
}
func (o *IPCC_Type) SetC2MR_CH1FM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC2MR_CH1FM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x10000) >> 16
}
func (o *IPCC_Type) SetC2MR_CH6OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC2MR_CH6OM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x20) >> 5
}
func (o *IPCC_Type) SetC2MR_CH5OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC2MR_CH5OM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC2MR_CH4OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC2MR_CH4OM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC2MR_CH3OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC2MR_CH3OM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC2MR_CH2OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC2MR_CH2OM() uint32 {
	return (volatile.LoadUint32(&o.C2MR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC2MR_CH1OM(value uint32) {
	volatile.StoreUint32(&o.C2MR.Reg, volatile.LoadUint32(&o.C2MR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC2MR_CH1OM() uint32 {
	return volatile.LoadUint32(&o.C2MR.Reg) & 0x1
}

// IPCC.C2SCR: Status Set or Clear register CPU2
func (o *IPCC_Type) SetC2SCR_CH6S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x200000)|value<<21)
}
func (o *IPCC_Type) GetC2SCR_CH6S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x200000) >> 21
}
func (o *IPCC_Type) SetC2SCR_CH5S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x100000)|value<<20)
}
func (o *IPCC_Type) GetC2SCR_CH5S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x100000) >> 20
}
func (o *IPCC_Type) SetC2SCR_CH4S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x80000)|value<<19)
}
func (o *IPCC_Type) GetC2SCR_CH4S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x80000) >> 19
}
func (o *IPCC_Type) SetC2SCR_CH3S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x40000)|value<<18)
}
func (o *IPCC_Type) GetC2SCR_CH3S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x40000) >> 18
}
func (o *IPCC_Type) SetC2SCR_CH2S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x20000)|value<<17)
}
func (o *IPCC_Type) GetC2SCR_CH2S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x20000) >> 17
}
func (o *IPCC_Type) SetC2SCR_CH1S(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x10000)|value<<16)
}
func (o *IPCC_Type) GetC2SCR_CH1S() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x10000) >> 16
}
func (o *IPCC_Type) SetC2SCR_CH6C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC2SCR_CH6C() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x20) >> 5
}
func (o *IPCC_Type) SetC2SCR_CH5C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC2SCR_CH5C() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC2SCR_CH4C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC2SCR_CH4C() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC2SCR_CH3C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC2SCR_CH3C() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC2SCR_CH2C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC2SCR_CH2C() uint32 {
	return (volatile.LoadUint32(&o.C2SCR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC2SCR_CH1C(value uint32) {
	volatile.StoreUint32(&o.C2SCR.Reg, volatile.LoadUint32(&o.C2SCR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC2SCR_CH1C() uint32 {
	return volatile.LoadUint32(&o.C2SCR.Reg) & 0x1
}

// IPCC.C2TOC1SR: CPU2 to CPU1 status register
func (o *IPCC_Type) SetC2TOC1SR_CH6F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x20)|value<<5)
}
func (o *IPCC_Type) GetC2TOC1SR_CH6F() uint32 {
	return (volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x20) >> 5
}
func (o *IPCC_Type) SetC2TOC1SR_CH5F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x10)|value<<4)
}
func (o *IPCC_Type) GetC2TOC1SR_CH5F() uint32 {
	return (volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x10) >> 4
}
func (o *IPCC_Type) SetC2TOC1SR_CH4F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x8)|value<<3)
}
func (o *IPCC_Type) GetC2TOC1SR_CH4F() uint32 {
	return (volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x8) >> 3
}
func (o *IPCC_Type) SetC2TOC1SR_CH3F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x4)|value<<2)
}
func (o *IPCC_Type) GetC2TOC1SR_CH3F() uint32 {
	return (volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x4) >> 2
}
func (o *IPCC_Type) SetC2TOC1SR_CH2F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x2)|value<<1)
}
func (o *IPCC_Type) GetC2TOC1SR_CH2F() uint32 {
	return (volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x2) >> 1
}
func (o *IPCC_Type) SetC2TOC1SR_CH1F(value uint32) {
	volatile.StoreUint32(&o.C2TOC1SR.Reg, volatile.LoadUint32(&o.C2TOC1SR.Reg)&^(0x1)|value)
}
func (o *IPCC_Type) GetC2TOC1SR_CH1F() uint32 {
	return volatile.LoadUint32(&o.C2TOC1SR.Reg) & 0x1
}

// IPCC.HWCFGR: IPCC Hardware configuration register
func (o *IPCC_Type) SetHWCFGR_CHANNELS(value uint32) {
	volatile.StoreUint32(&o.HWCFGR.Reg, volatile.LoadUint32(&o.HWCFGR.Reg)&^(0xff)|value)
}
func (o *IPCC_Type) GetHWCFGR_CHANNELS() uint32 {
	return volatile.LoadUint32(&o.HWCFGR.Reg) & 0xff
}

// IPCC.VERR: IPCC version register
func (o *IPCC_Type) SetVERR_MAJREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf0)|value<<4)
}
func (o *IPCC_Type) GetVERR_MAJREV() uint32 {
	return (volatile.LoadUint32(&o.VERR.Reg) & 0xf0) >> 4
}
func (o *IPCC_Type) SetVERR_MINREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf)|value)
}
func (o *IPCC_Type) GetVERR_MINREV() uint32 {
	return volatile.LoadUint32(&o.VERR.Reg) & 0xf
}

// IPCC.IPIDR: IPCC indentification register
func (o *IPCC_Type) SetIPIDR(value uint32) {
	volatile.StoreUint32(&o.IPIDR.Reg, value)
}
func (o *IPCC_Type) GetIPIDR() uint32 {
	return volatile.LoadUint32(&o.IPIDR.Reg)
}

// IPCC.SIDR: IPCC size indentification register
func (o *IPCC_Type) SetSIDR(value uint32) {
	volatile.StoreUint32(&o.SIDR.Reg, value)
}
func (o *IPCC_Type) GetSIDR() uint32 {
	return volatile.LoadUint32(&o.SIDR.Reg)
}

// External interrupt/event controller
type EXTI_Type struct {
	RTSR1   volatile.Register32 // 0x0
	FTSR1   volatile.Register32 // 0x4
	SWIER1  volatile.Register32 // 0x8
	PR1     volatile.Register32 // 0xC
	_       [16]byte
	RTSR2   volatile.Register32 // 0x20
	FTSR2   volatile.Register32 // 0x24
	SWIER2  volatile.Register32 // 0x28
	PR2     volatile.Register32 // 0x2C
	_       [80]byte
	IMR1    volatile.Register32 // 0x80
	EMR1    volatile.Register32 // 0x84
	_       [8]byte
	IMR2    volatile.Register32 // 0x90
	EMR2    volatile.Register32 // 0x94
	_       [40]byte
	C2IMR1  volatile.Register32 // 0xC0
	C2EMR1  volatile.Register32 // 0xC4
	_       [8]byte
	C2IMR2  volatile.Register32 // 0xD0
	C2EMR2  volatile.Register32 // 0xD4
	_       [768]byte
	HWCFGR7 volatile.Register32 // 0x3D8
	HWCFGR6 volatile.Register32 // 0x3DC
	HWCFGR5 volatile.Register32 // 0x3E0
	HWCFGR4 volatile.Register32 // 0x3E4
	HWCFGR3 volatile.Register32 // 0x3E8
	HWCFGR2 volatile.Register32 // 0x3EC
	HWCFGR1 volatile.Register32 // 0x3F0
	VERR    volatile.Register32 // 0x3F4
	IPIDR   volatile.Register32 // 0x3F8
	SIDR    volatile.Register32 // 0x3FC
}

// EXTI.RTSR1: rising trigger selection register
func (o *EXTI_Type) SetRTSR1_RT31(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetRTSR1_RT31() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80000000) >> 31
}
func (o *EXTI_Type) SetRTSR1_RT0(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR1_RT0() uint32 {
	return volatile.LoadUint32(&o.RTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR1_RT1(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR1_RT1() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR1_RT2(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR1_RT2() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR1_RT3(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR1_RT3() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR1_RT4(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR1_RT4() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR1_RT5(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR1_RT5() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR1_RT6(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR1_RT6() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR1_RT7(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR1_RT7() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR1_RT8(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR1_RT8() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR1_RT9(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR1_RT9() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR1_RT10(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR1_RT10() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR1_RT11(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR1_RT11() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR1_RT12(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR1_RT12() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR1_RT13(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR1_RT13() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR1_RT14(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR1_RT14() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR1_RT15(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR1_RT15() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR1_RT16(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR1_RT16() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR1_RT17(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR1_RT17() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR1_RT18(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR1_RT18() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR1_RT19(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR1_RT19() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR1_RT20(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR1_RT20() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR1_RT21(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR1_RT21() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200000) >> 21
}

// EXTI.FTSR1: falling trigger selection register
func (o *EXTI_Type) SetFTSR1_FT31(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetFTSR1_FT31() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80000000) >> 31
}
func (o *EXTI_Type) SetFTSR1_FT0(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR1_FT0() uint32 {
	return volatile.LoadUint32(&o.FTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR1_FT1(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR1_FT1() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR1_FT2(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR1_FT2() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR1_FT3(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR1_FT3() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR1_FT4(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR1_FT4() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR1_FT5(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR1_FT5() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR1_FT6(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR1_FT6() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR1_FT7(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR1_FT7() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR1_FT8(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR1_FT8() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR1_FT9(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR1_FT9() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR1_FT10(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR1_FT10() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR1_FT11(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR1_FT11() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR1_FT12(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR1_FT12() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR1_FT13(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR1_FT13() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR1_FT14(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR1_FT14() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR1_FT15(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR1_FT15() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR1_FT16(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR1_FT16() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR1_FT17(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR1_FT17() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR1_FT18(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR1_FT18() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR1_FT19(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR1_FT19() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR1_FT20(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR1_FT20() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR1_FT21(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR1_FT21() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200000) >> 21
}

// EXTI.SWIER1: software interrupt event register
func (o *EXTI_Type) SetSWIER1_SWI31(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetSWIER1_SWI31() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80000000) >> 31
}
func (o *EXTI_Type) SetSWIER1_SWI0(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER1_SWI0() uint32 {
	return volatile.LoadUint32(&o.SWIER1.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER1_SWI1(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER1_SWI1() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER1_SWI2(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER1_SWI2() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER1_SWI3(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER1_SWI3() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER1_SWI4(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER1_SWI4() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER1_SWI5(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER1_SWI5() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER1_SWI6(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER1_SWI6() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER1_SWI7(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER1_SWI7() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER1_SWI8(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER1_SWI8() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER1_SWI9(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER1_SWI9() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER1_SWI10(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER1_SWI10() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER1_SWI11(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER1_SWI11() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER1_SWI12(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER1_SWI12() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER1_SWI13(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER1_SWI13() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER1_SWI14(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER1_SWI14() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER1_SWI15(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER1_SWI15() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER1_SWI16(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER1_SWI16() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER1_SWI17(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER1_SWI17() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER1_SWI18(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER1_SWI18() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER1_SWI19(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER1_SWI19() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER1_SWI20(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER1_SWI20() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER1_SWI21(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER1_SWI21() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200000) >> 21
}

// EXTI.PR1: EXTI pending register
func (o *EXTI_Type) SetPR1_PIF31(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetPR1_PIF31() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80000000) >> 31
}
func (o *EXTI_Type) SetPR1_PIF0(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR1_PIF0() uint32 {
	return volatile.LoadUint32(&o.PR1.Reg) & 0x1
}
func (o *EXTI_Type) SetPR1_PIF1(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR1_PIF1() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR1_PIF2(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR1_PIF2() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR1_PIF3(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR1_PIF3() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR1_PIF4(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR1_PIF4() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR1_PIF5(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR1_PIF5() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR1_PIF6(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR1_PIF6() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR1_PIF7(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR1_PIF7() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR1_PIF8(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR1_PIF8() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR1_PIF9(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR1_PIF9() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR1_PIF10(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR1_PIF10() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR1_PIF11(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR1_PIF11() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR1_PIF12(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR1_PIF12() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR1_PIF13(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR1_PIF13() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR1_PIF14(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR1_PIF14() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR1_PIF15(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR1_PIF15() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR1_PIF16(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR1_PIF16() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPR1_PIF17(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetPR1_PIF17() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetPR1_PIF18(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetPR1_PIF18() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetPR1_PIF19(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPR1_PIF19() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPR1_PIF20(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPR1_PIF20() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPR1_PIF21(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR1_PIF21() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x200000) >> 21
}

// EXTI.RTSR2: rising trigger selection register
func (o *EXTI_Type) SetRTSR2_RT33(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR2_RT33() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR2_RT40_41(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetRTSR2_RT40_41() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x300) >> 8
}

// EXTI.FTSR2: falling trigger selection register
func (o *EXTI_Type) SetFTSR2_FT33(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR2_FT33() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR2_FT40_41(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetFTSR2_FT40_41() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x300) >> 8
}

// EXTI.SWIER2: software interrupt event register
func (o *EXTI_Type) SetSWIER2_SWI33(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER2_SWI33() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER2_SWI40_41(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetSWIER2_SWI40_41() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x300) >> 8
}

// EXTI.PR2: pending register
func (o *EXTI_Type) SetPR2_PIF33(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR2_PIF33() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR2_PIF40_41(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetPR2_PIF40_41() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x300) >> 8
}

// EXTI.IMR1: CPUm wakeup with interrupt mask register
func (o *EXTI_Type) SetIMR1_IM0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR1_IM0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR1_IM1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR1_IM1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR1_IM2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR1_IM2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR1_IM3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR1_IM3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR1_IM4(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR1_IM4() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR1_IM5(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR1_IM5() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR1_IM6(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR1_IM6() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR1_IM7(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR1_IM7() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR1_IM8(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR1_IM8() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR1_IM9(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR1_IM9() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR1_IM10(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR1_IM10() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR1_IM11(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR1_IM11() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR1_IM12(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR1_IM12() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR1_IM13(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR1_IM13() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR1_IM14(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR1_IM14() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR1_IM15(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR1_IM15() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR1_IM16(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR1_IM16() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR1_IM17(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR1_IM17() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR1_IM18(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR1_IM18() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR1_IM19(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR1_IM19() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR1_IM20(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR1_IM20() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR1_IM21(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR1_IM21() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR1_IM22(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR1_IM22() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetIMR1_IM23(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetIMR1_IM23() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetIMR1_IM24(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetIMR1_IM24() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetIMR1_IM25(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetIMR1_IM25() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetIMR1_IM26(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetIMR1_IM26() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetIMR1_IM27(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetIMR1_IM27() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetIMR1_IM28(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetIMR1_IM28() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetIMR1_IM29(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetIMR1_IM29() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetIMR1_IM30(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetIMR1_IM30() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetIMR1_IM31(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetIMR1_IM31() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000000) >> 31
}

// EXTI.EMR1: CPUm wakeup with event mask register
func (o *EXTI_Type) SetEMR1_EM0_15(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0xffff)|value)
}
func (o *EXTI_Type) GetEMR1_EM0_15() uint32 {
	return volatile.LoadUint32(&o.EMR1.Reg) & 0xffff
}
func (o *EXTI_Type) SetEMR1_EM17_21(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x3e0000)|value<<17)
}
func (o *EXTI_Type) GetEMR1_EM17_21() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x3e0000) >> 17
}

// EXTI.IMR2: CPUm wakeup with interrupt mask register
func (o *EXTI_Type) SetIMR2_IM0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR2_IM0() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR2_IM1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR2_IM1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR2_IM2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR2_IM2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR2_IM3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR2_IM3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR2_IM4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR2_IM4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR2_IM5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR2_IM5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR2_IM6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR2_IM6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR2_IM7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR2_IM7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR2_IM8(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR2_IM8() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR2_IM9(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR2_IM9() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR2_IM10(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR2_IM10() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR2_IM11(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR2_IM11() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR2_IM12(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR2_IM12() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR2_IM13(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR2_IM13() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR2_IM14(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR2_IM14() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR2_IM15(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR2_IM15() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR2_IM16(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR2_IM16() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10000) >> 16
}

// EXTI.EMR2: CPUm wakeup with event mask register
func (o *EXTI_Type) SetEMR2_EM(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetEMR2_EM() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x300) >> 8
}

// EXTI.C2IMR1: CPUm wakeup with interrupt mask register
func (o *EXTI_Type) SetC2IMR1_IM0(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetC2IMR1_IM0() uint32 {
	return volatile.LoadUint32(&o.C2IMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetC2IMR1_IM1(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetC2IMR1_IM1() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetC2IMR1_IM2(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetC2IMR1_IM2() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetC2IMR1_IM3(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetC2IMR1_IM3() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetC2IMR1_IM4(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetC2IMR1_IM4() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetC2IMR1_IM5(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetC2IMR1_IM5() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetC2IMR1_IM6(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetC2IMR1_IM6() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetC2IMR1_IM7(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetC2IMR1_IM7() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetC2IMR1_IM8(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetC2IMR1_IM8() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetC2IMR1_IM9(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetC2IMR1_IM9() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetC2IMR1_IM10(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetC2IMR1_IM10() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetC2IMR1_IM11(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetC2IMR1_IM11() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetC2IMR1_IM12(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetC2IMR1_IM12() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetC2IMR1_IM13(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetC2IMR1_IM13() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetC2IMR1_IM14(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetC2IMR1_IM14() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetC2IMR1_IM15(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetC2IMR1_IM15() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetC2IMR1_IM16(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetC2IMR1_IM16() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetC2IMR1_IM17(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetC2IMR1_IM17() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetC2IMR1_IM18(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetC2IMR1_IM18() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetC2IMR1_IM19(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetC2IMR1_IM19() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetC2IMR1_IM20(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetC2IMR1_IM20() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetC2IMR1_IM21(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetC2IMR1_IM21() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetC2IMR1_IM22(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetC2IMR1_IM22() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetC2IMR1_IM23(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetC2IMR1_IM23() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetC2IMR1_IM24(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetC2IMR1_IM24() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetC2IMR1_IM25(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetC2IMR1_IM25() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetC2IMR1_IM26(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetC2IMR1_IM26() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetC2IMR1_IM27(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetC2IMR1_IM27() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetC2IMR1_IM28(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetC2IMR1_IM28() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetC2IMR1_IM29(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetC2IMR1_IM29() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetC2IMR1_IM30(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetC2IMR1_IM30() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetC2IMR1_IM31(value uint32) {
	volatile.StoreUint32(&o.C2IMR1.Reg, volatile.LoadUint32(&o.C2IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetC2IMR1_IM31() uint32 {
	return (volatile.LoadUint32(&o.C2IMR1.Reg) & 0x80000000) >> 31
}

// EXTI.C2EMR1: CPUm wakeup with event mask register
func (o *EXTI_Type) SetC2EMR1_EM0_15(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0xffff)|value)
}
func (o *EXTI_Type) GetC2EMR1_EM0_15() uint32 {
	return volatile.LoadUint32(&o.C2EMR1.Reg) & 0xffff
}
func (o *EXTI_Type) SetC2EMR1_EM17_21(value uint32) {
	volatile.StoreUint32(&o.C2EMR1.Reg, volatile.LoadUint32(&o.C2EMR1.Reg)&^(0x3e0000)|value<<17)
}
func (o *EXTI_Type) GetC2EMR1_EM17_21() uint32 {
	return (volatile.LoadUint32(&o.C2EMR1.Reg) & 0x3e0000) >> 17
}

// EXTI.C2IMR2: CPUm wakeup with interrupt mask register
func (o *EXTI_Type) SetC2IMR2_IM0(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetC2IMR2_IM0() uint32 {
	return volatile.LoadUint32(&o.C2IMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetC2IMR2_IM1(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetC2IMR2_IM1() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetC2IMR2_IM2(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetC2IMR2_IM2() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetC2IMR2_IM3(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetC2IMR2_IM3() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetC2IMR2_IM4(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetC2IMR2_IM4() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetC2IMR2_IM5(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetC2IMR2_IM5() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetC2IMR2_IM6(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetC2IMR2_IM6() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetC2IMR2_IM7(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetC2IMR2_IM7() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetC2IMR2_IM8(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetC2IMR2_IM8() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetC2IMR2_IM9(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetC2IMR2_IM9() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetC2IMR2_IM10(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetC2IMR2_IM10() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetC2IMR2_IM11(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetC2IMR2_IM11() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetC2IMR2_IM12(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetC2IMR2_IM12() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetC2IMR2_IM13(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetC2IMR2_IM13() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetC2IMR2_IM14(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetC2IMR2_IM14() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetC2IMR2_IM15(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetC2IMR2_IM15() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetC2IMR2_IM16(value uint32) {
	volatile.StoreUint32(&o.C2IMR2.Reg, volatile.LoadUint32(&o.C2IMR2.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetC2IMR2_IM16() uint32 {
	return (volatile.LoadUint32(&o.C2IMR2.Reg) & 0x10000) >> 16
}

// EXTI.C2EMR2: CPUm wakeup with event mask register
func (o *EXTI_Type) SetC2EMR2_EM(value uint32) {
	volatile.StoreUint32(&o.C2EMR2.Reg, volatile.LoadUint32(&o.C2EMR2.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetC2EMR2_EM() uint32 {
	return (volatile.LoadUint32(&o.C2EMR2.Reg) & 0x300) >> 8
}

// EXTI.HWCFGR7: EXTI Hardware configuration registers
func (o *EXTI_Type) SetHWCFGR7(value uint32) {
	volatile.StoreUint32(&o.HWCFGR7.Reg, value)
}
func (o *EXTI_Type) GetHWCFGR7() uint32 {
	return volatile.LoadUint32(&o.HWCFGR7.Reg)
}

// EXTI.HWCFGR6: Hardware configuration registers
func (o *EXTI_Type) SetHWCFGR6(value uint32) {
	volatile.StoreUint32(&o.HWCFGR6.Reg, value)
}
func (o *EXTI_Type) GetHWCFGR6() uint32 {
	return volatile.LoadUint32(&o.HWCFGR6.Reg)
}

// EXTI.HWCFGR5: Hardware configuration registers
func (o *EXTI_Type) SetHWCFGR5(value uint32) {
	volatile.StoreUint32(&o.HWCFGR5.Reg, value)
}
func (o *EXTI_Type) GetHWCFGR5() uint32 {
	return volatile.LoadUint32(&o.HWCFGR5.Reg)
}

// EXTI.HWCFGR4: Hardware configuration registers
func (o *EXTI_Type) SetHWCFGR4(value uint32) {
	volatile.StoreUint32(&o.HWCFGR4.Reg, value)
}
func (o *EXTI_Type) GetHWCFGR4() uint32 {
	return volatile.LoadUint32(&o.HWCFGR4.Reg)
}

// EXTI.HWCFGR3: Hardware configuration registers
func (o *EXTI_Type) SetHWCFGR3(value uint32) {
	volatile.StoreUint32(&o.HWCFGR3.Reg, value)
}
func (o *EXTI_Type) GetHWCFGR3() uint32 {
	return volatile.LoadUint32(&o.HWCFGR3.Reg)
}

// EXTI.HWCFGR2: Hardware configuration registers
func (o *EXTI_Type) SetHWCFGR2(value uint32) {
	volatile.StoreUint32(&o.HWCFGR2.Reg, value)
}
func (o *EXTI_Type) GetHWCFGR2() uint32 {
	return volatile.LoadUint32(&o.HWCFGR2.Reg)
}

// EXTI.HWCFGR1: Hardware configuration register 1
func (o *EXTI_Type) SetHWCFGR1_NBEVENTS(value uint32) {
	volatile.StoreUint32(&o.HWCFGR1.Reg, volatile.LoadUint32(&o.HWCFGR1.Reg)&^(0xff)|value)
}
func (o *EXTI_Type) GetHWCFGR1_NBEVENTS() uint32 {
	return volatile.LoadUint32(&o.HWCFGR1.Reg) & 0xff
}
func (o *EXTI_Type) SetHWCFGR1_NBCPUS(value uint32) {
	volatile.StoreUint32(&o.HWCFGR1.Reg, volatile.LoadUint32(&o.HWCFGR1.Reg)&^(0xf00)|value<<8)
}
func (o *EXTI_Type) GetHWCFGR1_NBCPUS() uint32 {
	return (volatile.LoadUint32(&o.HWCFGR1.Reg) & 0xf00) >> 8
}
func (o *EXTI_Type) SetHWCFGR1_CPUEVTEN(value uint32) {
	volatile.StoreUint32(&o.HWCFGR1.Reg, volatile.LoadUint32(&o.HWCFGR1.Reg)&^(0xf000)|value<<12)
}
func (o *EXTI_Type) GetHWCFGR1_CPUEVTEN() uint32 {
	return (volatile.LoadUint32(&o.HWCFGR1.Reg) & 0xf000) >> 12
}

// EXTI.VERR: EXTI IP Version register
func (o *EXTI_Type) SetVERR_MINREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf)|value)
}
func (o *EXTI_Type) GetVERR_MINREV() uint32 {
	return volatile.LoadUint32(&o.VERR.Reg) & 0xf
}
func (o *EXTI_Type) SetVERR_MAJREV(value uint32) {
	volatile.StoreUint32(&o.VERR.Reg, volatile.LoadUint32(&o.VERR.Reg)&^(0xf0)|value<<4)
}
func (o *EXTI_Type) GetVERR_MAJREV() uint32 {
	return (volatile.LoadUint32(&o.VERR.Reg) & 0xf0) >> 4
}

// EXTI.IPIDR: Identification register
func (o *EXTI_Type) SetIPIDR(value uint32) {
	volatile.StoreUint32(&o.IPIDR.Reg, value)
}
func (o *EXTI_Type) GetIPIDR() uint32 {
	return volatile.LoadUint32(&o.IPIDR.Reg)
}

// EXTI.SIDR: Size ID register
func (o *EXTI_Type) SetSIDR(value uint32) {
	volatile.StoreUint32(&o.SIDR.Reg, value)
}
func (o *EXTI_Type) GetSIDR() uint32 {
	return volatile.LoadUint32(&o.SIDR.Reg)
}

// Clock recovery system
type CRS_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	ISR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
}

// CRS.CR: CRS control register
func (o *CRS_Type) SetCR_SYNCOKIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetCR_SYNCOKIE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CRS_Type) SetCR_SYNCWARNIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetCR_SYNCWARNIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetCR_ESYNCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetCR_ESYNCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetCR_CEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *CRS_Type) GetCR_CEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *CRS_Type) SetCR_AUTOTRIMEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *CRS_Type) GetCR_AUTOTRIMEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *CRS_Type) SetCR_SWSYNC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRS_Type) GetCR_SWSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRS_Type) SetCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f00)|value<<8)
}
func (o *CRS_Type) GetCR_TRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3f00) >> 8
}

// CRS.CFGR: CRS configuration register
func (o *CRS_Type) SetCFGR_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xffff)|value)
}
func (o *CRS_Type) GetCFGR_RELOAD() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0xffff
}
func (o *CRS_Type) SetCFGR_FELIM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xff0000)|value<<16)
}
func (o *CRS_Type) GetCFGR_FELIM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xff0000) >> 16
}
func (o *CRS_Type) SetCFGR_SYNCDIV(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *CRS_Type) GetCFGR_SYNCDIV() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *CRS_Type) SetCFGR_SYNCSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x30000000)|value<<28)
}
func (o *CRS_Type) GetCFGR_SYNCSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x30000000) >> 28
}
func (o *CRS_Type) SetCFGR_SYNCPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *CRS_Type) GetCFGR_SYNCPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}

// CRS.ISR: CRS interrupt and status register
func (o *CRS_Type) SetISR_SYNCOKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetISR_SYNCOKF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *CRS_Type) SetISR_SYNCWARNF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetISR_SYNCWARNF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetISR_ERRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetISR_ERRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetISR_ESYNCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetISR_ESYNCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetISR_SYNCERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *CRS_Type) GetISR_SYNCERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *CRS_Type) SetISR_SYNCMISS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *CRS_Type) GetISR_SYNCMISS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *CRS_Type) SetISR_TRIMOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *CRS_Type) GetISR_TRIMOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *CRS_Type) SetISR_FEDIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *CRS_Type) GetISR_FEDIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *CRS_Type) SetISR_FECAP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CRS_Type) GetISR_FECAP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xffff0000) >> 16
}

// CRS.ICR: CRS interrupt flag clear register
func (o *CRS_Type) SetICR_SYNCOKC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetICR_SYNCOKC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *CRS_Type) SetICR_SYNCWARNC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetICR_SYNCWARNC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetICR_ERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetICR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetICR_ESYNCC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetICR_ESYNCC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// Universal serial bus full-speed device interface
type USB_Type struct {
	EP0R      volatile.Register16 // 0x0
	_         [2]byte
	EP1R      volatile.Register16 // 0x4
	_         [2]byte
	EP2R      volatile.Register16 // 0x8
	_         [2]byte
	EP3R      volatile.Register16 // 0xC
	_         [2]byte
	EP4R      volatile.Register16 // 0x10
	_         [2]byte
	EP5R      volatile.Register16 // 0x14
	_         [2]byte
	EP6R      volatile.Register16 // 0x18
	_         [2]byte
	EP7R      volatile.Register16 // 0x1C
	_         [34]byte
	CNTR      volatile.Register16 // 0x40
	_         [2]byte
	ISTR      volatile.Register16 // 0x44
	_         [2]byte
	FNR       volatile.Register16 // 0x48
	_         [2]byte
	DADDR     volatile.Register16 // 0x4C
	_         [2]byte
	BTABLE    volatile.Register16 // 0x50
	COUNT0_TX volatile.Register16 // 0x52
	ADDR0_RX  volatile.Register16 // 0x54
	COUNT0_RX volatile.Register16 // 0x56
	BCDR      volatile.Register16 // 0x58
	COUNT1_TX volatile.Register16 // 0x5A
	ADDR1_RX  volatile.Register16 // 0x5C
	COUNT1_RX volatile.Register16 // 0x5E
	_         [2]byte
	COUNT2_TX volatile.Register16 // 0x62
	ADDR2_RX  volatile.Register16 // 0x64
	COUNT2_RX volatile.Register16 // 0x66
	_         [2]byte
	COUNT3_TX volatile.Register16 // 0x6A
	ADDR3_RX  volatile.Register16 // 0x6C
	COUNT3_RX volatile.Register16 // 0x6E
	_         [2]byte
	COUNT4_TX volatile.Register16 // 0x72
	ADDR4_RX  volatile.Register16 // 0x74
	COUNT4_RX volatile.Register16 // 0x76
	_         [2]byte
	COUNT5_TX volatile.Register16 // 0x7A
	ADDR5_RX  volatile.Register16 // 0x7C
	COUNT5_RX volatile.Register16 // 0x7E
	_         [2]byte
	COUNT6_TX volatile.Register16 // 0x82
	ADDR6_RX  volatile.Register16 // 0x84
	COUNT6_RX volatile.Register16 // 0x86
	_         [2]byte
	COUNT7_TX volatile.Register16 // 0x8A
	ADDR7_RX  volatile.Register16 // 0x8C
	COUNT7_RX volatile.Register16 // 0x8E
}

// USB.EP0R: endpoint 0 register
func (o *USB_Type) SetEP0R_EA(value uint16) {
	volatile.StoreUint16(&o.EP0R.Reg, volatile.LoadUint16(&o.EP0R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP0R_EA() uint16 {
	return volatile.LoadUint16(&o.EP0R.Reg) & 0xf
}
func (o *USB_Type) SetEP0R_STAT_TX(value uint16) {
	volatile.StoreUint16(&o.EP0R.Reg, volatile.LoadUint16(&o.EP0R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP0R_STAT_TX() uint16 {
	return (volatile.LoadUint16(&o.EP0R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP0R_DTOG_TX(value uint16) {
	volatile.StoreUint16(&o.EP0R.Reg, volatile.LoadUint16(&o.EP0R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP0R_DTOG_TX() uint16 {
	return (volatile.LoadUint16(&o.EP0R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP0R_CTR_TX(value uint16) {
	volatile.StoreUint16(&o.EP0R.Reg, volatile.LoadUint16(&o.EP0R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP0R_CTR_TX() uint16 {
	return (volatile.LoadUint16(&o.EP0R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP0R_EP_KIND(value uint16) {
	volatile.StoreUint16(&o.EP0R.Reg, volatile.LoadUint16(&o.EP0R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP0R_EP_KIND() uint16 {
	return (volatile.LoadUint16(&o.EP0R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP0R_EP_TYPE(value uint16) {
	volatile.StoreUint16(&o.EP0R.Reg, volatile.LoadUint16(&o.EP0R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP0R_EP_TYPE() uint16 {
	return (volatile.LoadUint16(&o.EP0R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP0R_SETUP(value uint16) {
	volatile.StoreUint16(&o.EP0R.Reg, volatile.LoadUint16(&o.EP0R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP0R_SETUP() uint16 {
	return (volatile.LoadUint16(&o.EP0R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP0R_STAT_RX(value uint16) {
	volatile.StoreUint16(&o.EP0R.Reg, volatile.LoadUint16(&o.EP0R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP0R_STAT_RX() uint16 {
	return (volatile.LoadUint16(&o.EP0R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP0R_DTOG_RX(value uint16) {
	volatile.StoreUint16(&o.EP0R.Reg, volatile.LoadUint16(&o.EP0R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP0R_DTOG_RX() uint16 {
	return (volatile.LoadUint16(&o.EP0R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP0R_CTR_RX(value uint16) {
	volatile.StoreUint16(&o.EP0R.Reg, volatile.LoadUint16(&o.EP0R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP0R_CTR_RX() uint16 {
	return (volatile.LoadUint16(&o.EP0R.Reg) & 0x8000) >> 15
}

// USB.EP1R: endpoint 1 register
func (o *USB_Type) SetEP1R_EA(value uint16) {
	volatile.StoreUint16(&o.EP1R.Reg, volatile.LoadUint16(&o.EP1R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP1R_EA() uint16 {
	return volatile.LoadUint16(&o.EP1R.Reg) & 0xf
}
func (o *USB_Type) SetEP1R_STAT_TX(value uint16) {
	volatile.StoreUint16(&o.EP1R.Reg, volatile.LoadUint16(&o.EP1R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP1R_STAT_TX() uint16 {
	return (volatile.LoadUint16(&o.EP1R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP1R_DTOG_TX(value uint16) {
	volatile.StoreUint16(&o.EP1R.Reg, volatile.LoadUint16(&o.EP1R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP1R_DTOG_TX() uint16 {
	return (volatile.LoadUint16(&o.EP1R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP1R_CTR_TX(value uint16) {
	volatile.StoreUint16(&o.EP1R.Reg, volatile.LoadUint16(&o.EP1R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP1R_CTR_TX() uint16 {
	return (volatile.LoadUint16(&o.EP1R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP1R_EP_KIND(value uint16) {
	volatile.StoreUint16(&o.EP1R.Reg, volatile.LoadUint16(&o.EP1R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP1R_EP_KIND() uint16 {
	return (volatile.LoadUint16(&o.EP1R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP1R_EP_TYPE(value uint16) {
	volatile.StoreUint16(&o.EP1R.Reg, volatile.LoadUint16(&o.EP1R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP1R_EP_TYPE() uint16 {
	return (volatile.LoadUint16(&o.EP1R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP1R_SETUP(value uint16) {
	volatile.StoreUint16(&o.EP1R.Reg, volatile.LoadUint16(&o.EP1R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP1R_SETUP() uint16 {
	return (volatile.LoadUint16(&o.EP1R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP1R_STAT_RX(value uint16) {
	volatile.StoreUint16(&o.EP1R.Reg, volatile.LoadUint16(&o.EP1R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP1R_STAT_RX() uint16 {
	return (volatile.LoadUint16(&o.EP1R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP1R_DTOG_RX(value uint16) {
	volatile.StoreUint16(&o.EP1R.Reg, volatile.LoadUint16(&o.EP1R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP1R_DTOG_RX() uint16 {
	return (volatile.LoadUint16(&o.EP1R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP1R_CTR_RX(value uint16) {
	volatile.StoreUint16(&o.EP1R.Reg, volatile.LoadUint16(&o.EP1R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP1R_CTR_RX() uint16 {
	return (volatile.LoadUint16(&o.EP1R.Reg) & 0x8000) >> 15
}

// USB.EP2R: endpoint 2 register
func (o *USB_Type) SetEP2R_EA(value uint16) {
	volatile.StoreUint16(&o.EP2R.Reg, volatile.LoadUint16(&o.EP2R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP2R_EA() uint16 {
	return volatile.LoadUint16(&o.EP2R.Reg) & 0xf
}
func (o *USB_Type) SetEP2R_STAT_TX(value uint16) {
	volatile.StoreUint16(&o.EP2R.Reg, volatile.LoadUint16(&o.EP2R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP2R_STAT_TX() uint16 {
	return (volatile.LoadUint16(&o.EP2R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP2R_DTOG_TX(value uint16) {
	volatile.StoreUint16(&o.EP2R.Reg, volatile.LoadUint16(&o.EP2R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP2R_DTOG_TX() uint16 {
	return (volatile.LoadUint16(&o.EP2R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP2R_CTR_TX(value uint16) {
	volatile.StoreUint16(&o.EP2R.Reg, volatile.LoadUint16(&o.EP2R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP2R_CTR_TX() uint16 {
	return (volatile.LoadUint16(&o.EP2R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP2R_EP_KIND(value uint16) {
	volatile.StoreUint16(&o.EP2R.Reg, volatile.LoadUint16(&o.EP2R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP2R_EP_KIND() uint16 {
	return (volatile.LoadUint16(&o.EP2R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP2R_EP_TYPE(value uint16) {
	volatile.StoreUint16(&o.EP2R.Reg, volatile.LoadUint16(&o.EP2R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP2R_EP_TYPE() uint16 {
	return (volatile.LoadUint16(&o.EP2R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP2R_SETUP(value uint16) {
	volatile.StoreUint16(&o.EP2R.Reg, volatile.LoadUint16(&o.EP2R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP2R_SETUP() uint16 {
	return (volatile.LoadUint16(&o.EP2R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP2R_STAT_RX(value uint16) {
	volatile.StoreUint16(&o.EP2R.Reg, volatile.LoadUint16(&o.EP2R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP2R_STAT_RX() uint16 {
	return (volatile.LoadUint16(&o.EP2R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP2R_DTOG_RX(value uint16) {
	volatile.StoreUint16(&o.EP2R.Reg, volatile.LoadUint16(&o.EP2R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP2R_DTOG_RX() uint16 {
	return (volatile.LoadUint16(&o.EP2R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP2R_CTR_RX(value uint16) {
	volatile.StoreUint16(&o.EP2R.Reg, volatile.LoadUint16(&o.EP2R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP2R_CTR_RX() uint16 {
	return (volatile.LoadUint16(&o.EP2R.Reg) & 0x8000) >> 15
}

// USB.EP3R: endpoint 3 register
func (o *USB_Type) SetEP3R_EA(value uint16) {
	volatile.StoreUint16(&o.EP3R.Reg, volatile.LoadUint16(&o.EP3R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP3R_EA() uint16 {
	return volatile.LoadUint16(&o.EP3R.Reg) & 0xf
}
func (o *USB_Type) SetEP3R_STAT_TX(value uint16) {
	volatile.StoreUint16(&o.EP3R.Reg, volatile.LoadUint16(&o.EP3R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP3R_STAT_TX() uint16 {
	return (volatile.LoadUint16(&o.EP3R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP3R_DTOG_TX(value uint16) {
	volatile.StoreUint16(&o.EP3R.Reg, volatile.LoadUint16(&o.EP3R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP3R_DTOG_TX() uint16 {
	return (volatile.LoadUint16(&o.EP3R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP3R_CTR_TX(value uint16) {
	volatile.StoreUint16(&o.EP3R.Reg, volatile.LoadUint16(&o.EP3R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP3R_CTR_TX() uint16 {
	return (volatile.LoadUint16(&o.EP3R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP3R_EP_KIND(value uint16) {
	volatile.StoreUint16(&o.EP3R.Reg, volatile.LoadUint16(&o.EP3R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP3R_EP_KIND() uint16 {
	return (volatile.LoadUint16(&o.EP3R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP3R_EP_TYPE(value uint16) {
	volatile.StoreUint16(&o.EP3R.Reg, volatile.LoadUint16(&o.EP3R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP3R_EP_TYPE() uint16 {
	return (volatile.LoadUint16(&o.EP3R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP3R_SETUP(value uint16) {
	volatile.StoreUint16(&o.EP3R.Reg, volatile.LoadUint16(&o.EP3R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP3R_SETUP() uint16 {
	return (volatile.LoadUint16(&o.EP3R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP3R_STAT_RX(value uint16) {
	volatile.StoreUint16(&o.EP3R.Reg, volatile.LoadUint16(&o.EP3R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP3R_STAT_RX() uint16 {
	return (volatile.LoadUint16(&o.EP3R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP3R_DTOG_RX(value uint16) {
	volatile.StoreUint16(&o.EP3R.Reg, volatile.LoadUint16(&o.EP3R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP3R_DTOG_RX() uint16 {
	return (volatile.LoadUint16(&o.EP3R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP3R_CTR_RX(value uint16) {
	volatile.StoreUint16(&o.EP3R.Reg, volatile.LoadUint16(&o.EP3R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP3R_CTR_RX() uint16 {
	return (volatile.LoadUint16(&o.EP3R.Reg) & 0x8000) >> 15
}

// USB.EP4R: endpoint 4 register
func (o *USB_Type) SetEP4R_EA(value uint16) {
	volatile.StoreUint16(&o.EP4R.Reg, volatile.LoadUint16(&o.EP4R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP4R_EA() uint16 {
	return volatile.LoadUint16(&o.EP4R.Reg) & 0xf
}
func (o *USB_Type) SetEP4R_STAT_TX(value uint16) {
	volatile.StoreUint16(&o.EP4R.Reg, volatile.LoadUint16(&o.EP4R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP4R_STAT_TX() uint16 {
	return (volatile.LoadUint16(&o.EP4R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP4R_DTOG_TX(value uint16) {
	volatile.StoreUint16(&o.EP4R.Reg, volatile.LoadUint16(&o.EP4R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP4R_DTOG_TX() uint16 {
	return (volatile.LoadUint16(&o.EP4R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP4R_CTR_TX(value uint16) {
	volatile.StoreUint16(&o.EP4R.Reg, volatile.LoadUint16(&o.EP4R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP4R_CTR_TX() uint16 {
	return (volatile.LoadUint16(&o.EP4R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP4R_EP_KIND(value uint16) {
	volatile.StoreUint16(&o.EP4R.Reg, volatile.LoadUint16(&o.EP4R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP4R_EP_KIND() uint16 {
	return (volatile.LoadUint16(&o.EP4R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP4R_EP_TYPE(value uint16) {
	volatile.StoreUint16(&o.EP4R.Reg, volatile.LoadUint16(&o.EP4R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP4R_EP_TYPE() uint16 {
	return (volatile.LoadUint16(&o.EP4R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP4R_SETUP(value uint16) {
	volatile.StoreUint16(&o.EP4R.Reg, volatile.LoadUint16(&o.EP4R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP4R_SETUP() uint16 {
	return (volatile.LoadUint16(&o.EP4R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP4R_STAT_RX(value uint16) {
	volatile.StoreUint16(&o.EP4R.Reg, volatile.LoadUint16(&o.EP4R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP4R_STAT_RX() uint16 {
	return (volatile.LoadUint16(&o.EP4R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP4R_DTOG_RX(value uint16) {
	volatile.StoreUint16(&o.EP4R.Reg, volatile.LoadUint16(&o.EP4R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP4R_DTOG_RX() uint16 {
	return (volatile.LoadUint16(&o.EP4R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP4R_CTR_RX(value uint16) {
	volatile.StoreUint16(&o.EP4R.Reg, volatile.LoadUint16(&o.EP4R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP4R_CTR_RX() uint16 {
	return (volatile.LoadUint16(&o.EP4R.Reg) & 0x8000) >> 15
}

// USB.EP5R: endpoint 5 register
func (o *USB_Type) SetEP5R_EA(value uint16) {
	volatile.StoreUint16(&o.EP5R.Reg, volatile.LoadUint16(&o.EP5R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP5R_EA() uint16 {
	return volatile.LoadUint16(&o.EP5R.Reg) & 0xf
}
func (o *USB_Type) SetEP5R_STAT_TX(value uint16) {
	volatile.StoreUint16(&o.EP5R.Reg, volatile.LoadUint16(&o.EP5R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP5R_STAT_TX() uint16 {
	return (volatile.LoadUint16(&o.EP5R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP5R_DTOG_TX(value uint16) {
	volatile.StoreUint16(&o.EP5R.Reg, volatile.LoadUint16(&o.EP5R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP5R_DTOG_TX() uint16 {
	return (volatile.LoadUint16(&o.EP5R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP5R_CTR_TX(value uint16) {
	volatile.StoreUint16(&o.EP5R.Reg, volatile.LoadUint16(&o.EP5R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP5R_CTR_TX() uint16 {
	return (volatile.LoadUint16(&o.EP5R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP5R_EP_KIND(value uint16) {
	volatile.StoreUint16(&o.EP5R.Reg, volatile.LoadUint16(&o.EP5R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP5R_EP_KIND() uint16 {
	return (volatile.LoadUint16(&o.EP5R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP5R_EP_TYPE(value uint16) {
	volatile.StoreUint16(&o.EP5R.Reg, volatile.LoadUint16(&o.EP5R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP5R_EP_TYPE() uint16 {
	return (volatile.LoadUint16(&o.EP5R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP5R_SETUP(value uint16) {
	volatile.StoreUint16(&o.EP5R.Reg, volatile.LoadUint16(&o.EP5R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP5R_SETUP() uint16 {
	return (volatile.LoadUint16(&o.EP5R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP5R_STAT_RX(value uint16) {
	volatile.StoreUint16(&o.EP5R.Reg, volatile.LoadUint16(&o.EP5R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP5R_STAT_RX() uint16 {
	return (volatile.LoadUint16(&o.EP5R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP5R_DTOG_RX(value uint16) {
	volatile.StoreUint16(&o.EP5R.Reg, volatile.LoadUint16(&o.EP5R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP5R_DTOG_RX() uint16 {
	return (volatile.LoadUint16(&o.EP5R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP5R_CTR_RX(value uint16) {
	volatile.StoreUint16(&o.EP5R.Reg, volatile.LoadUint16(&o.EP5R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP5R_CTR_RX() uint16 {
	return (volatile.LoadUint16(&o.EP5R.Reg) & 0x8000) >> 15
}

// USB.EP6R: endpoint 6 register
func (o *USB_Type) SetEP6R_EA(value uint16) {
	volatile.StoreUint16(&o.EP6R.Reg, volatile.LoadUint16(&o.EP6R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP6R_EA() uint16 {
	return volatile.LoadUint16(&o.EP6R.Reg) & 0xf
}
func (o *USB_Type) SetEP6R_STAT_TX(value uint16) {
	volatile.StoreUint16(&o.EP6R.Reg, volatile.LoadUint16(&o.EP6R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP6R_STAT_TX() uint16 {
	return (volatile.LoadUint16(&o.EP6R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP6R_DTOG_TX(value uint16) {
	volatile.StoreUint16(&o.EP6R.Reg, volatile.LoadUint16(&o.EP6R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP6R_DTOG_TX() uint16 {
	return (volatile.LoadUint16(&o.EP6R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP6R_CTR_TX(value uint16) {
	volatile.StoreUint16(&o.EP6R.Reg, volatile.LoadUint16(&o.EP6R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP6R_CTR_TX() uint16 {
	return (volatile.LoadUint16(&o.EP6R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP6R_EP_KIND(value uint16) {
	volatile.StoreUint16(&o.EP6R.Reg, volatile.LoadUint16(&o.EP6R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP6R_EP_KIND() uint16 {
	return (volatile.LoadUint16(&o.EP6R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP6R_EP_TYPE(value uint16) {
	volatile.StoreUint16(&o.EP6R.Reg, volatile.LoadUint16(&o.EP6R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP6R_EP_TYPE() uint16 {
	return (volatile.LoadUint16(&o.EP6R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP6R_SETUP(value uint16) {
	volatile.StoreUint16(&o.EP6R.Reg, volatile.LoadUint16(&o.EP6R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP6R_SETUP() uint16 {
	return (volatile.LoadUint16(&o.EP6R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP6R_STAT_RX(value uint16) {
	volatile.StoreUint16(&o.EP6R.Reg, volatile.LoadUint16(&o.EP6R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP6R_STAT_RX() uint16 {
	return (volatile.LoadUint16(&o.EP6R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP6R_DTOG_RX(value uint16) {
	volatile.StoreUint16(&o.EP6R.Reg, volatile.LoadUint16(&o.EP6R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP6R_DTOG_RX() uint16 {
	return (volatile.LoadUint16(&o.EP6R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP6R_CTR_RX(value uint16) {
	volatile.StoreUint16(&o.EP6R.Reg, volatile.LoadUint16(&o.EP6R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP6R_CTR_RX() uint16 {
	return (volatile.LoadUint16(&o.EP6R.Reg) & 0x8000) >> 15
}

// USB.EP7R: endpoint 7 register
func (o *USB_Type) SetEP7R_EA(value uint16) {
	volatile.StoreUint16(&o.EP7R.Reg, volatile.LoadUint16(&o.EP7R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP7R_EA() uint16 {
	return volatile.LoadUint16(&o.EP7R.Reg) & 0xf
}
func (o *USB_Type) SetEP7R_STAT_TX(value uint16) {
	volatile.StoreUint16(&o.EP7R.Reg, volatile.LoadUint16(&o.EP7R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP7R_STAT_TX() uint16 {
	return (volatile.LoadUint16(&o.EP7R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP7R_DTOG_TX(value uint16) {
	volatile.StoreUint16(&o.EP7R.Reg, volatile.LoadUint16(&o.EP7R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP7R_DTOG_TX() uint16 {
	return (volatile.LoadUint16(&o.EP7R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP7R_CTR_TX(value uint16) {
	volatile.StoreUint16(&o.EP7R.Reg, volatile.LoadUint16(&o.EP7R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP7R_CTR_TX() uint16 {
	return (volatile.LoadUint16(&o.EP7R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP7R_EP_KIND(value uint16) {
	volatile.StoreUint16(&o.EP7R.Reg, volatile.LoadUint16(&o.EP7R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP7R_EP_KIND() uint16 {
	return (volatile.LoadUint16(&o.EP7R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP7R_EP_TYPE(value uint16) {
	volatile.StoreUint16(&o.EP7R.Reg, volatile.LoadUint16(&o.EP7R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP7R_EP_TYPE() uint16 {
	return (volatile.LoadUint16(&o.EP7R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP7R_SETUP(value uint16) {
	volatile.StoreUint16(&o.EP7R.Reg, volatile.LoadUint16(&o.EP7R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP7R_SETUP() uint16 {
	return (volatile.LoadUint16(&o.EP7R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP7R_STAT_RX(value uint16) {
	volatile.StoreUint16(&o.EP7R.Reg, volatile.LoadUint16(&o.EP7R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP7R_STAT_RX() uint16 {
	return (volatile.LoadUint16(&o.EP7R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP7R_DTOG_RX(value uint16) {
	volatile.StoreUint16(&o.EP7R.Reg, volatile.LoadUint16(&o.EP7R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP7R_DTOG_RX() uint16 {
	return (volatile.LoadUint16(&o.EP7R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP7R_CTR_RX(value uint16) {
	volatile.StoreUint16(&o.EP7R.Reg, volatile.LoadUint16(&o.EP7R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP7R_CTR_RX() uint16 {
	return (volatile.LoadUint16(&o.EP7R.Reg) & 0x8000) >> 15
}

// USB.CNTR: control register
func (o *USB_Type) SetCNTR_FRES(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetCNTR_FRES() uint16 {
	return volatile.LoadUint16(&o.CNTR.Reg) & 0x1
}
func (o *USB_Type) SetCNTR_PDWN(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetCNTR_PDWN() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetCNTR_LPMODE(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetCNTR_LPMODE() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetCNTR_FSUSP(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetCNTR_FSUSP() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetCNTR_RESUME(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetCNTR_RESUME() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetCNTR_L1RESUME(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetCNTR_L1RESUME() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetCNTR_L1REQM(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetCNTR_L1REQM() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetCNTR_ESOFM(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCNTR_ESOFM() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCNTR_SOFM(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetCNTR_SOFM() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetCNTR_RESETM(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetCNTR_RESETM() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetCNTR_SUSPM(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCNTR_SUSPM() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCNTR_WKUPM(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetCNTR_WKUPM() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetCNTR_ERRM(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetCNTR_ERRM() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetCNTR_PMAOVRM(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCNTR_PMAOVRM() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCNTR_CTRM(value uint16) {
	volatile.StoreUint16(&o.CNTR.Reg, volatile.LoadUint16(&o.CNTR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCNTR_CTRM() uint16 {
	return (volatile.LoadUint16(&o.CNTR.Reg) & 0x8000) >> 15
}

// USB.ISTR: interrupt status register
func (o *USB_Type) SetISTR_EP_ID(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetISTR_EP_ID() uint16 {
	return volatile.LoadUint16(&o.ISTR.Reg) & 0xf
}
func (o *USB_Type) SetISTR_DIR(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetISTR_DIR() uint16 {
	return (volatile.LoadUint16(&o.ISTR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetISTR_L1REQ(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetISTR_L1REQ() uint16 {
	return (volatile.LoadUint16(&o.ISTR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetISTR_ESOF(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetISTR_ESOF() uint16 {
	return (volatile.LoadUint16(&o.ISTR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetISTR_SOF(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetISTR_SOF() uint16 {
	return (volatile.LoadUint16(&o.ISTR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetISTR_RESET(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetISTR_RESET() uint16 {
	return (volatile.LoadUint16(&o.ISTR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetISTR_SUSP(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetISTR_SUSP() uint16 {
	return (volatile.LoadUint16(&o.ISTR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetISTR_WKUP(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetISTR_WKUP() uint16 {
	return (volatile.LoadUint16(&o.ISTR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetISTR_ERR(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetISTR_ERR() uint16 {
	return (volatile.LoadUint16(&o.ISTR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetISTR_PMAOVR(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetISTR_PMAOVR() uint16 {
	return (volatile.LoadUint16(&o.ISTR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetISTR_CTR(value uint16) {
	volatile.StoreUint16(&o.ISTR.Reg, volatile.LoadUint16(&o.ISTR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetISTR_CTR() uint16 {
	return (volatile.LoadUint16(&o.ISTR.Reg) & 0x8000) >> 15
}

// USB.FNR: frame number register
func (o *USB_Type) SetFNR_FN(value uint16) {
	volatile.StoreUint16(&o.FNR.Reg, volatile.LoadUint16(&o.FNR.Reg)&^(0x7ff)|value)
}
func (o *USB_Type) GetFNR_FN() uint16 {
	return volatile.LoadUint16(&o.FNR.Reg) & 0x7ff
}
func (o *USB_Type) SetFNR_LSOF(value uint16) {
	volatile.StoreUint16(&o.FNR.Reg, volatile.LoadUint16(&o.FNR.Reg)&^(0x1800)|value<<11)
}
func (o *USB_Type) GetFNR_LSOF() uint16 {
	return (volatile.LoadUint16(&o.FNR.Reg) & 0x1800) >> 11
}
func (o *USB_Type) SetFNR_LCK(value uint16) {
	volatile.StoreUint16(&o.FNR.Reg, volatile.LoadUint16(&o.FNR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetFNR_LCK() uint16 {
	return (volatile.LoadUint16(&o.FNR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetFNR_RXDM(value uint16) {
	volatile.StoreUint16(&o.FNR.Reg, volatile.LoadUint16(&o.FNR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetFNR_RXDM() uint16 {
	return (volatile.LoadUint16(&o.FNR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetFNR_RXDP(value uint16) {
	volatile.StoreUint16(&o.FNR.Reg, volatile.LoadUint16(&o.FNR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetFNR_RXDP() uint16 {
	return (volatile.LoadUint16(&o.FNR.Reg) & 0x8000) >> 15
}

// USB.DADDR: device address
func (o *USB_Type) SetDADDR_ADD(value uint16) {
	volatile.StoreUint16(&o.DADDR.Reg, volatile.LoadUint16(&o.DADDR.Reg)&^(0x7f)|value)
}
func (o *USB_Type) GetDADDR_ADD() uint16 {
	return volatile.LoadUint16(&o.DADDR.Reg) & 0x7f
}
func (o *USB_Type) SetDADDR_EF(value uint16) {
	volatile.StoreUint16(&o.DADDR.Reg, volatile.LoadUint16(&o.DADDR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDADDR_EF() uint16 {
	return (volatile.LoadUint16(&o.DADDR.Reg) & 0x80) >> 7
}

// USB.BTABLE: Buffer table address
func (o *USB_Type) SetBTABLE(value uint16) {
	volatile.StoreUint16(&o.BTABLE.Reg, volatile.LoadUint16(&o.BTABLE.Reg)&^(0xfff8)|value<<3)
}
func (o *USB_Type) GetBTABLE() uint16 {
	return (volatile.LoadUint16(&o.BTABLE.Reg) & 0xfff8) >> 3
}

// USB.COUNT0_TX: Transmission byte count 0
func (o *USB_Type) SetCOUNT0_TX(value uint16) {
	volatile.StoreUint16(&o.COUNT0_TX.Reg, volatile.LoadUint16(&o.COUNT0_TX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT0_TX() uint16 {
	return volatile.LoadUint16(&o.COUNT0_TX.Reg) & 0x3ff
}

// USB.ADDR0_RX: Reception buffer address 0
func (o *USB_Type) SetADDR0_RX(value uint16) {
	volatile.StoreUint16(&o.ADDR0_RX.Reg, volatile.LoadUint16(&o.ADDR0_RX.Reg)&^(0xfffe)|value<<1)
}
func (o *USB_Type) GetADDR0_RX() uint16 {
	return (volatile.LoadUint16(&o.ADDR0_RX.Reg) & 0xfffe) >> 1
}

// USB.COUNT0_RX: Reception byte count 0
func (o *USB_Type) SetCOUNT0_RX(value uint16) {
	volatile.StoreUint16(&o.COUNT0_RX.Reg, volatile.LoadUint16(&o.COUNT0_RX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT0_RX() uint16 {
	return volatile.LoadUint16(&o.COUNT0_RX.Reg) & 0x3ff
}
func (o *USB_Type) SetCOUNT0_RX_NUM_BLOCK(value uint16) {
	volatile.StoreUint16(&o.COUNT0_RX.Reg, volatile.LoadUint16(&o.COUNT0_RX.Reg)&^(0x7c00)|value<<10)
}
func (o *USB_Type) GetCOUNT0_RX_NUM_BLOCK() uint16 {
	return (volatile.LoadUint16(&o.COUNT0_RX.Reg) & 0x7c00) >> 10
}
func (o *USB_Type) SetCOUNT0_RX_BL_SIZE(value uint16) {
	volatile.StoreUint16(&o.COUNT0_RX.Reg, volatile.LoadUint16(&o.COUNT0_RX.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCOUNT0_RX_BL_SIZE() uint16 {
	return (volatile.LoadUint16(&o.COUNT0_RX.Reg) & 0x8000) >> 15
}

// USB.BCDR: Battery charging detector(
func (o *USB_Type) SetBCDR_BCDEN(value uint16) {
	volatile.StoreUint16(&o.BCDR.Reg, volatile.LoadUint16(&o.BCDR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetBCDR_BCDEN() uint16 {
	return volatile.LoadUint16(&o.BCDR.Reg) & 0x1
}
func (o *USB_Type) SetBCDR_DCDEN(value uint16) {
	volatile.StoreUint16(&o.BCDR.Reg, volatile.LoadUint16(&o.BCDR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetBCDR_DCDEN() uint16 {
	return (volatile.LoadUint16(&o.BCDR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetBCDR_PDEN(value uint16) {
	volatile.StoreUint16(&o.BCDR.Reg, volatile.LoadUint16(&o.BCDR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetBCDR_PDEN() uint16 {
	return (volatile.LoadUint16(&o.BCDR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetBCDR_SDEN(value uint16) {
	volatile.StoreUint16(&o.BCDR.Reg, volatile.LoadUint16(&o.BCDR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetBCDR_SDEN() uint16 {
	return (volatile.LoadUint16(&o.BCDR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetBCDR_DCDET(value uint16) {
	volatile.StoreUint16(&o.BCDR.Reg, volatile.LoadUint16(&o.BCDR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetBCDR_DCDET() uint16 {
	return (volatile.LoadUint16(&o.BCDR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetBCDR_PDET(value uint16) {
	volatile.StoreUint16(&o.BCDR.Reg, volatile.LoadUint16(&o.BCDR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetBCDR_PDET() uint16 {
	return (volatile.LoadUint16(&o.BCDR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetBCDR_SDET(value uint16) {
	volatile.StoreUint16(&o.BCDR.Reg, volatile.LoadUint16(&o.BCDR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetBCDR_SDET() uint16 {
	return (volatile.LoadUint16(&o.BCDR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetBCDR_PS2DET(value uint16) {
	volatile.StoreUint16(&o.BCDR.Reg, volatile.LoadUint16(&o.BCDR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetBCDR_PS2DET() uint16 {
	return (volatile.LoadUint16(&o.BCDR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetBCDR_DPPU(value uint16) {
	volatile.StoreUint16(&o.BCDR.Reg, volatile.LoadUint16(&o.BCDR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetBCDR_DPPU() uint16 {
	return (volatile.LoadUint16(&o.BCDR.Reg) & 0x8000) >> 15
}

// USB.COUNT1_TX: Transmission byte count 0
func (o *USB_Type) SetCOUNT1_TX(value uint16) {
	volatile.StoreUint16(&o.COUNT1_TX.Reg, volatile.LoadUint16(&o.COUNT1_TX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT1_TX() uint16 {
	return volatile.LoadUint16(&o.COUNT1_TX.Reg) & 0x3ff
}

// USB.ADDR1_RX: Reception buffer address 0
func (o *USB_Type) SetADDR1_RX(value uint16) {
	volatile.StoreUint16(&o.ADDR1_RX.Reg, volatile.LoadUint16(&o.ADDR1_RX.Reg)&^(0xfffe)|value<<1)
}
func (o *USB_Type) GetADDR1_RX() uint16 {
	return (volatile.LoadUint16(&o.ADDR1_RX.Reg) & 0xfffe) >> 1
}

// USB.COUNT1_RX: Reception byte count 0
func (o *USB_Type) SetCOUNT1_RX(value uint16) {
	volatile.StoreUint16(&o.COUNT1_RX.Reg, volatile.LoadUint16(&o.COUNT1_RX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT1_RX() uint16 {
	return volatile.LoadUint16(&o.COUNT1_RX.Reg) & 0x3ff
}
func (o *USB_Type) SetCOUNT1_RX_NUM_BLOCK(value uint16) {
	volatile.StoreUint16(&o.COUNT1_RX.Reg, volatile.LoadUint16(&o.COUNT1_RX.Reg)&^(0x7c00)|value<<10)
}
func (o *USB_Type) GetCOUNT1_RX_NUM_BLOCK() uint16 {
	return (volatile.LoadUint16(&o.COUNT1_RX.Reg) & 0x7c00) >> 10
}
func (o *USB_Type) SetCOUNT1_RX_BL_SIZE(value uint16) {
	volatile.StoreUint16(&o.COUNT1_RX.Reg, volatile.LoadUint16(&o.COUNT1_RX.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCOUNT1_RX_BL_SIZE() uint16 {
	return (volatile.LoadUint16(&o.COUNT1_RX.Reg) & 0x8000) >> 15
}

// USB.COUNT2_TX: Transmission byte count 0
func (o *USB_Type) SetCOUNT2_TX(value uint16) {
	volatile.StoreUint16(&o.COUNT2_TX.Reg, volatile.LoadUint16(&o.COUNT2_TX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT2_TX() uint16 {
	return volatile.LoadUint16(&o.COUNT2_TX.Reg) & 0x3ff
}

// USB.ADDR2_RX: Reception buffer address 0
func (o *USB_Type) SetADDR2_RX(value uint16) {
	volatile.StoreUint16(&o.ADDR2_RX.Reg, volatile.LoadUint16(&o.ADDR2_RX.Reg)&^(0xfffe)|value<<1)
}
func (o *USB_Type) GetADDR2_RX() uint16 {
	return (volatile.LoadUint16(&o.ADDR2_RX.Reg) & 0xfffe) >> 1
}

// USB.COUNT2_RX: Reception byte count 0
func (o *USB_Type) SetCOUNT2_RX(value uint16) {
	volatile.StoreUint16(&o.COUNT2_RX.Reg, volatile.LoadUint16(&o.COUNT2_RX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT2_RX() uint16 {
	return volatile.LoadUint16(&o.COUNT2_RX.Reg) & 0x3ff
}
func (o *USB_Type) SetCOUNT2_RX_NUM_BLOCK(value uint16) {
	volatile.StoreUint16(&o.COUNT2_RX.Reg, volatile.LoadUint16(&o.COUNT2_RX.Reg)&^(0x7c00)|value<<10)
}
func (o *USB_Type) GetCOUNT2_RX_NUM_BLOCK() uint16 {
	return (volatile.LoadUint16(&o.COUNT2_RX.Reg) & 0x7c00) >> 10
}
func (o *USB_Type) SetCOUNT2_RX_BL_SIZE(value uint16) {
	volatile.StoreUint16(&o.COUNT2_RX.Reg, volatile.LoadUint16(&o.COUNT2_RX.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCOUNT2_RX_BL_SIZE() uint16 {
	return (volatile.LoadUint16(&o.COUNT2_RX.Reg) & 0x8000) >> 15
}

// USB.COUNT3_TX: Transmission byte count 0
func (o *USB_Type) SetCOUNT3_TX(value uint16) {
	volatile.StoreUint16(&o.COUNT3_TX.Reg, volatile.LoadUint16(&o.COUNT3_TX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT3_TX() uint16 {
	return volatile.LoadUint16(&o.COUNT3_TX.Reg) & 0x3ff
}

// USB.ADDR3_RX: Reception buffer address 0
func (o *USB_Type) SetADDR3_RX(value uint16) {
	volatile.StoreUint16(&o.ADDR3_RX.Reg, volatile.LoadUint16(&o.ADDR3_RX.Reg)&^(0xfffe)|value<<1)
}
func (o *USB_Type) GetADDR3_RX() uint16 {
	return (volatile.LoadUint16(&o.ADDR3_RX.Reg) & 0xfffe) >> 1
}

// USB.COUNT3_RX: Reception byte count 0
func (o *USB_Type) SetCOUNT3_RX(value uint16) {
	volatile.StoreUint16(&o.COUNT3_RX.Reg, volatile.LoadUint16(&o.COUNT3_RX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT3_RX() uint16 {
	return volatile.LoadUint16(&o.COUNT3_RX.Reg) & 0x3ff
}
func (o *USB_Type) SetCOUNT3_RX_NUM_BLOCK(value uint16) {
	volatile.StoreUint16(&o.COUNT3_RX.Reg, volatile.LoadUint16(&o.COUNT3_RX.Reg)&^(0x7c00)|value<<10)
}
func (o *USB_Type) GetCOUNT3_RX_NUM_BLOCK() uint16 {
	return (volatile.LoadUint16(&o.COUNT3_RX.Reg) & 0x7c00) >> 10
}
func (o *USB_Type) SetCOUNT3_RX_BL_SIZE(value uint16) {
	volatile.StoreUint16(&o.COUNT3_RX.Reg, volatile.LoadUint16(&o.COUNT3_RX.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCOUNT3_RX_BL_SIZE() uint16 {
	return (volatile.LoadUint16(&o.COUNT3_RX.Reg) & 0x8000) >> 15
}

// USB.COUNT4_TX: Transmission byte count 0
func (o *USB_Type) SetCOUNT4_TX(value uint16) {
	volatile.StoreUint16(&o.COUNT4_TX.Reg, volatile.LoadUint16(&o.COUNT4_TX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT4_TX() uint16 {
	return volatile.LoadUint16(&o.COUNT4_TX.Reg) & 0x3ff
}

// USB.ADDR4_RX: Reception buffer address 0
func (o *USB_Type) SetADDR4_RX(value uint16) {
	volatile.StoreUint16(&o.ADDR4_RX.Reg, volatile.LoadUint16(&o.ADDR4_RX.Reg)&^(0xfffe)|value<<1)
}
func (o *USB_Type) GetADDR4_RX() uint16 {
	return (volatile.LoadUint16(&o.ADDR4_RX.Reg) & 0xfffe) >> 1
}

// USB.COUNT4_RX: Reception byte count 0
func (o *USB_Type) SetCOUNT4_RX(value uint16) {
	volatile.StoreUint16(&o.COUNT4_RX.Reg, volatile.LoadUint16(&o.COUNT4_RX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT4_RX() uint16 {
	return volatile.LoadUint16(&o.COUNT4_RX.Reg) & 0x3ff
}
func (o *USB_Type) SetCOUNT4_RX_NUM_BLOCK(value uint16) {
	volatile.StoreUint16(&o.COUNT4_RX.Reg, volatile.LoadUint16(&o.COUNT4_RX.Reg)&^(0x7c00)|value<<10)
}
func (o *USB_Type) GetCOUNT4_RX_NUM_BLOCK() uint16 {
	return (volatile.LoadUint16(&o.COUNT4_RX.Reg) & 0x7c00) >> 10
}
func (o *USB_Type) SetCOUNT4_RX_BL_SIZE(value uint16) {
	volatile.StoreUint16(&o.COUNT4_RX.Reg, volatile.LoadUint16(&o.COUNT4_RX.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCOUNT4_RX_BL_SIZE() uint16 {
	return (volatile.LoadUint16(&o.COUNT4_RX.Reg) & 0x8000) >> 15
}

// USB.COUNT5_TX: Transmission byte count 0
func (o *USB_Type) SetCOUNT5_TX(value uint16) {
	volatile.StoreUint16(&o.COUNT5_TX.Reg, volatile.LoadUint16(&o.COUNT5_TX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT5_TX() uint16 {
	return volatile.LoadUint16(&o.COUNT5_TX.Reg) & 0x3ff
}

// USB.ADDR5_RX: Reception buffer address 0
func (o *USB_Type) SetADDR5_RX(value uint16) {
	volatile.StoreUint16(&o.ADDR5_RX.Reg, volatile.LoadUint16(&o.ADDR5_RX.Reg)&^(0xfffe)|value<<1)
}
func (o *USB_Type) GetADDR5_RX() uint16 {
	return (volatile.LoadUint16(&o.ADDR5_RX.Reg) & 0xfffe) >> 1
}

// USB.COUNT5_RX: Reception byte count 0
func (o *USB_Type) SetCOUNT5_RX(value uint16) {
	volatile.StoreUint16(&o.COUNT5_RX.Reg, volatile.LoadUint16(&o.COUNT5_RX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT5_RX() uint16 {
	return volatile.LoadUint16(&o.COUNT5_RX.Reg) & 0x3ff
}
func (o *USB_Type) SetCOUNT5_RX_NUM_BLOCK(value uint16) {
	volatile.StoreUint16(&o.COUNT5_RX.Reg, volatile.LoadUint16(&o.COUNT5_RX.Reg)&^(0x7c00)|value<<10)
}
func (o *USB_Type) GetCOUNT5_RX_NUM_BLOCK() uint16 {
	return (volatile.LoadUint16(&o.COUNT5_RX.Reg) & 0x7c00) >> 10
}
func (o *USB_Type) SetCOUNT5_RX_BL_SIZE(value uint16) {
	volatile.StoreUint16(&o.COUNT5_RX.Reg, volatile.LoadUint16(&o.COUNT5_RX.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCOUNT5_RX_BL_SIZE() uint16 {
	return (volatile.LoadUint16(&o.COUNT5_RX.Reg) & 0x8000) >> 15
}

// USB.COUNT6_TX: Transmission byte count 0
func (o *USB_Type) SetCOUNT6_TX(value uint16) {
	volatile.StoreUint16(&o.COUNT6_TX.Reg, volatile.LoadUint16(&o.COUNT6_TX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT6_TX() uint16 {
	return volatile.LoadUint16(&o.COUNT6_TX.Reg) & 0x3ff
}

// USB.ADDR6_RX: Reception buffer address 0
func (o *USB_Type) SetADDR6_RX(value uint16) {
	volatile.StoreUint16(&o.ADDR6_RX.Reg, volatile.LoadUint16(&o.ADDR6_RX.Reg)&^(0xfffe)|value<<1)
}
func (o *USB_Type) GetADDR6_RX() uint16 {
	return (volatile.LoadUint16(&o.ADDR6_RX.Reg) & 0xfffe) >> 1
}

// USB.COUNT6_RX: Reception byte count 0
func (o *USB_Type) SetCOUNT6_RX(value uint16) {
	volatile.StoreUint16(&o.COUNT6_RX.Reg, volatile.LoadUint16(&o.COUNT6_RX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT6_RX() uint16 {
	return volatile.LoadUint16(&o.COUNT6_RX.Reg) & 0x3ff
}
func (o *USB_Type) SetCOUNT6_RX_NUM_BLOCK(value uint16) {
	volatile.StoreUint16(&o.COUNT6_RX.Reg, volatile.LoadUint16(&o.COUNT6_RX.Reg)&^(0x7c00)|value<<10)
}
func (o *USB_Type) GetCOUNT6_RX_NUM_BLOCK() uint16 {
	return (volatile.LoadUint16(&o.COUNT6_RX.Reg) & 0x7c00) >> 10
}
func (o *USB_Type) SetCOUNT6_RX_BL_SIZE(value uint16) {
	volatile.StoreUint16(&o.COUNT6_RX.Reg, volatile.LoadUint16(&o.COUNT6_RX.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCOUNT6_RX_BL_SIZE() uint16 {
	return (volatile.LoadUint16(&o.COUNT6_RX.Reg) & 0x8000) >> 15
}

// USB.COUNT7_TX: Transmission byte count 0
func (o *USB_Type) SetCOUNT7_TX(value uint16) {
	volatile.StoreUint16(&o.COUNT7_TX.Reg, volatile.LoadUint16(&o.COUNT7_TX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT7_TX() uint16 {
	return volatile.LoadUint16(&o.COUNT7_TX.Reg) & 0x3ff
}

// USB.ADDR7_RX: Reception buffer address 0
func (o *USB_Type) SetADDR7_RX(value uint16) {
	volatile.StoreUint16(&o.ADDR7_RX.Reg, volatile.LoadUint16(&o.ADDR7_RX.Reg)&^(0xfffe)|value<<1)
}
func (o *USB_Type) GetADDR7_RX() uint16 {
	return (volatile.LoadUint16(&o.ADDR7_RX.Reg) & 0xfffe) >> 1
}

// USB.COUNT7_RX: Reception byte count 0
func (o *USB_Type) SetCOUNT7_RX(value uint16) {
	volatile.StoreUint16(&o.COUNT7_RX.Reg, volatile.LoadUint16(&o.COUNT7_RX.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetCOUNT7_RX() uint16 {
	return volatile.LoadUint16(&o.COUNT7_RX.Reg) & 0x3ff
}
func (o *USB_Type) SetCOUNT7_RX_NUM_BLOCK(value uint16) {
	volatile.StoreUint16(&o.COUNT7_RX.Reg, volatile.LoadUint16(&o.COUNT7_RX.Reg)&^(0x7c00)|value<<10)
}
func (o *USB_Type) GetCOUNT7_RX_NUM_BLOCK() uint16 {
	return (volatile.LoadUint16(&o.COUNT7_RX.Reg) & 0x7c00) >> 10
}
func (o *USB_Type) SetCOUNT7_RX_BL_SIZE(value uint16) {
	volatile.StoreUint16(&o.COUNT7_RX.Reg, volatile.LoadUint16(&o.COUNT7_RX.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCOUNT7_RX_BL_SIZE() uint16 {
	return (volatile.LoadUint16(&o.COUNT7_RX.Reg) & 0x8000) >> 15
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// SCB.CPUID: CPUID base register
func (o *SCB_Type) SetCPUID_Revision(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf)|value)
}
func (o *SCB_Type) GetCPUID_Revision() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xf
}
func (o *SCB_Type) SetCPUID_PartNo(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xfff0)|value<<4)
}
func (o *SCB_Type) GetCPUID_PartNo() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xfff0) >> 4
}
func (o *SCB_Type) SetCPUID_Constant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf0000)|value<<16)
}
func (o *SCB_Type) GetCPUID_Constant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf0000) >> 16
}
func (o *SCB_Type) SetCPUID_Variant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf00000)|value<<20)
}
func (o *SCB_Type) GetCPUID_Variant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf00000) >> 20
}
func (o *SCB_Type) SetCPUID_Implementer(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetCPUID_Implementer() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xff000000) >> 24
}

// SCB.ICSR: Interrupt control and state register
func (o *SCB_Type) SetICSR_VECTACTIVE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1ff)|value)
}
func (o *SCB_Type) GetICSR_VECTACTIVE() uint32 {
	return volatile.LoadUint32(&o.ICSR.Reg) & 0x1ff
}
func (o *SCB_Type) SetICSR_RETTOBASE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetICSR_RETTOBASE() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetICSR_VECTPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x7f000)|value<<12)
}
func (o *SCB_Type) GetICSR_VECTPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x7f000) >> 12
}
func (o *SCB_Type) SetICSR_ISRPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x400000)|value<<22)
}
func (o *SCB_Type) GetICSR_ISRPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x400000) >> 22
}
func (o *SCB_Type) SetICSR_PENDSTCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetICSR_PENDSTCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2000000) >> 25
}
func (o *SCB_Type) SetICSR_PENDSTSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4000000)|value<<26)
}
func (o *SCB_Type) GetICSR_PENDSTSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4000000) >> 26
}
func (o *SCB_Type) SetICSR_PENDSVCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8000000)|value<<27)
}
func (o *SCB_Type) GetICSR_PENDSVCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8000000) >> 27
}
func (o *SCB_Type) SetICSR_PENDSVSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000000)|value<<28)
}
func (o *SCB_Type) GetICSR_PENDSVSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000000) >> 28
}
func (o *SCB_Type) SetICSR_NMIPENDSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetICSR_NMIPENDSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80000000) >> 31
}

// SCB.VTOR: Vector table offset register
func (o *SCB_Type) SetVTOR_TBLOFF(value uint32) {
	volatile.StoreUint32(&o.VTOR.Reg, volatile.LoadUint32(&o.VTOR.Reg)&^(0x3ffffe00)|value<<9)
}
func (o *SCB_Type) GetVTOR_TBLOFF() uint32 {
	return (volatile.LoadUint32(&o.VTOR.Reg) & 0x3ffffe00) >> 9
}

// SCB.AIRCR: Application interrupt and reset control register
func (o *SCB_Type) SetAIRCR_VECTRESET(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetAIRCR_VECTRESET() uint32 {
	return volatile.LoadUint32(&o.AIRCR.Reg) & 0x1
}
func (o *SCB_Type) SetAIRCR_VECTCLRACTIVE(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetAIRCR_VECTCLRACTIVE() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetAIRCR_SYSRESETREQ(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetAIRCR_SYSRESETREQ() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetAIRCR_PRIGROUP(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x700)|value<<8)
}
func (o *SCB_Type) GetAIRCR_PRIGROUP() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x700) >> 8
}
func (o *SCB_Type) SetAIRCR_ENDIANESS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetAIRCR_ENDIANESS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetAIRCR_VECTKEYSTAT(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCB_Type) GetAIRCR_VECTKEYSTAT() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0xffff0000) >> 16
}

// SCB.SCR: System control register
func (o *SCB_Type) SetSCR_SLEEPONEXIT(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSCR_SLEEPONEXIT() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSCR_SLEEPDEEP(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetSCR_SLEEPDEEP() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetSCR_SEVEONPEND(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetSCR_SEVEONPEND() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}

// SCB.CCR: Configuration and control register
func (o *SCB_Type) SetCCR_NONBASETHRDENA(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetCCR_NONBASETHRDENA() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *SCB_Type) SetCCR_USERSETMPEND(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCCR_USERSETMPEND() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCCR_UNALIGN__TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCCR_UNALIGN__TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCCR_DIV_0_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCCR_DIV_0_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCCR_BFHFNMIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCCR_BFHFNMIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCCR_STKALIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCCR_STKALIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200) >> 9
}

// SCB.SHPR1: System handler priority registers
func (o *SCB_Type) SetSHPR1_PRI_4(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff)|value)
}
func (o *SCB_Type) GetSHPR1_PRI_4() uint32 {
	return volatile.LoadUint32(&o.SHPR1.Reg) & 0xff
}
func (o *SCB_Type) SetSHPR1_PRI_5(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff00)|value<<8)
}
func (o *SCB_Type) GetSHPR1_PRI_5() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff00) >> 8
}
func (o *SCB_Type) SetSHPR1_PRI_6(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR1_PRI_6() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff0000) >> 16
}

// SCB.SHPR2: System handler priority registers
func (o *SCB_Type) SetSHPR2_PRI_11(value uint32) {
	volatile.StoreUint32(&o.SHPR2.Reg, volatile.LoadUint32(&o.SHPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR2_PRI_11() uint32 {
	return (volatile.LoadUint32(&o.SHPR2.Reg) & 0xff000000) >> 24
}

// SCB.SHPR3: System handler priority registers
func (o *SCB_Type) SetSHPR3_PRI_14(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR3_PRI_14() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff0000) >> 16
}
func (o *SCB_Type) SetSHPR3_PRI_15(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR3_PRI_15() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff000000) >> 24
}

// SCB.SHCRS: System handler control and state register
func (o *SCB_Type) SetSHCRS_MEMFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTACT() uint32 {
	return volatile.LoadUint32(&o.SHCRS.Reg) & 0x1
}
func (o *SCB_Type) SetSHCRS_BUSFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSHCRS_USGFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetSHCRS_USGFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetSHCRS_SVCALLACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetSHCRS_SVCALLACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetSHCRS_MONITORACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetSHCRS_MONITORACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetSHCRS_PENDSVACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetSHCRS_PENDSVACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetSHCRS_SYSTICKACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetSHCRS_SYSTICKACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetSHCRS_USGFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetSHCRS_USGFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetSHCRS_MEMFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetSHCRS_BUSFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x4000)|value<<14)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x4000) >> 14
}
func (o *SCB_Type) SetSHCRS_SVCALLPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetSHCRS_SVCALLPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetSHCRS_MEMFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetSHCRS_BUSFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetSHCRS_USGFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetSHCRS_USGFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x40000) >> 18
}

// SCB.CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IACCVIOL(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IACCVIOL() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MLSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20)|value<<5)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MLSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20) >> 5
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MMARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MMARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IBUSERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IBUSERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_PRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_PRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x200) >> 9
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_STKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_STKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_LSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_LSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_BFARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_BFARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVSTATE(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVSTATE() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVPC(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVPC() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x40000) >> 18
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_NOCP(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80000)|value<<19)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_NOCP() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80000) >> 19
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNALIGNED(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNALIGNED() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000000) >> 24
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000000) >> 25
}

// SCB.HFSR: Hard fault status register
func (o *SCB_Type) SetHFSR_VECTTBL(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetHFSR_VECTTBL() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetHFSR_FORCED(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *SCB_Type) GetHFSR_FORCED() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x40000000) >> 30
}
func (o *SCB_Type) SetHFSR_DEBUG_VT(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetHFSR_DEBUG_VT() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x80000000) >> 31
}

// SCB.MMFAR: Memory management fault address register
func (o *SCB_Type) SetMMFAR(value uint32) {
	volatile.StoreUint32(&o.MMFAR.Reg, value)
}
func (o *SCB_Type) GetMMFAR() uint32 {
	return volatile.LoadUint32(&o.MMFAR.Reg)
}

// SCB.BFAR: Bus fault address register
func (o *SCB_Type) SetBFAR(value uint32) {
	volatile.StoreUint32(&o.BFAR.Reg, value)
}
func (o *SCB_Type) GetBFAR() uint32 {
	return volatile.LoadUint32(&o.BFAR.Reg)
}

// SCB.AFSR: Auxiliary fault status register
func (o *SCB_Type) SetAFSR(value uint32) {
	volatile.StoreUint32(&o.AFSR.Reg, value)
}
func (o *SCB_Type) GetAFSR() uint32 {
	return volatile.LoadUint32(&o.AFSR.Reg)
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// STK.CTRL: SysTick control and status register
func (o *STK_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *STK_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *STK_Type) SetCTRL_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *STK_Type) GetCTRL_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *STK_Type) SetCTRL_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *STK_Type) GetCTRL_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *STK_Type) SetCTRL_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *STK_Type) GetCTRL_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}

// STK.LOAD: SysTick reload value register
func (o *STK_Type) SetLOAD_RELOAD(value uint32) {
	volatile.StoreUint32(&o.LOAD.Reg, volatile.LoadUint32(&o.LOAD.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetLOAD_RELOAD() uint32 {
	return volatile.LoadUint32(&o.LOAD.Reg) & 0xffffff
}

// STK.VAL: SysTick current value register
func (o *STK_Type) SetVAL_CURRENT(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetVAL_CURRENT() uint32 {
	return volatile.LoadUint32(&o.VAL.Reg) & 0xffffff
}

// STK.CALIB: SysTick calibration value register
func (o *STK_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}
func (o *STK_Type) SetCALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *STK_Type) GetCALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x40000000) >> 30
}
func (o *STK_Type) SetCALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *STK_Type) GetCALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x80000000) >> 31
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// FPU.FPCCR: Floating-point context control register
func (o *FPU_Type) SetFPCCR_LSPACT(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPCCR_LSPACT() uint32 {
	return volatile.LoadUint32(&o.FPCCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPCCR_USER(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPCCR_USER() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPCCR_THREAD(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPCCR_THREAD() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPCCR_HFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPCCR_HFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPCCR_MMRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x20)|value<<5)
}
func (o *FPU_Type) GetFPCCR_MMRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x20) >> 5
}
func (o *FPU_Type) SetFPCCR_BFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40)|value<<6)
}
func (o *FPU_Type) GetFPCCR_BFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40) >> 6
}
func (o *FPU_Type) SetFPCCR_MONRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x100)|value<<8)
}
func (o *FPU_Type) GetFPCCR_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x100) >> 8
}
func (o *FPU_Type) SetFPCCR_LSPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPCCR_LSPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPCCR_ASPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPCCR_ASPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x80000000) >> 31
}

// FPU.FPCAR: Floating-point context address register
func (o *FPU_Type) SetFPCAR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.FPCAR.Reg, volatile.LoadUint32(&o.FPCAR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *FPU_Type) GetFPCAR_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.FPCAR.Reg) & 0xfffffff8) >> 3
}

// FPU.FPSCR: Floating-point status control register
func (o *FPU_Type) SetFPSCR_IOC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPSCR_IOC() uint32 {
	return volatile.LoadUint32(&o.FPSCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPSCR_DZC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPSCR_DZC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPSCR_OFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4)|value<<2)
}
func (o *FPU_Type) GetFPSCR_OFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4) >> 2
}
func (o *FPU_Type) SetFPSCR_UFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPSCR_UFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPSCR_IXC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPSCR_IXC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPSCR_IDC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80)|value<<7)
}
func (o *FPU_Type) GetFPSCR_IDC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80) >> 7
}
func (o *FPU_Type) SetFPSCR_RMode(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0xc00000)|value<<22)
}
func (o *FPU_Type) GetFPSCR_RMode() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0xc00000) >> 22
}
func (o *FPU_Type) SetFPSCR_FZ(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *FPU_Type) GetFPSCR_FZ() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x1000000) >> 24
}
func (o *FPU_Type) SetFPSCR_DN(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *FPU_Type) GetFPSCR_DN() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2000000) >> 25
}
func (o *FPU_Type) SetFPSCR_AHP(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *FPU_Type) GetFPSCR_AHP() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4000000) >> 26
}
func (o *FPU_Type) SetFPSCR_V(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10000000)|value<<28)
}
func (o *FPU_Type) GetFPSCR_V() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10000000) >> 28
}
func (o *FPU_Type) SetFPSCR_C(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x20000000)|value<<29)
}
func (o *FPU_Type) GetFPSCR_C() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x20000000) >> 29
}
func (o *FPU_Type) SetFPSCR_Z(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPSCR_Z() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPSCR_N(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPSCR_N() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80000000) >> 31
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	_     [120]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	_     [120]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	_     [120]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	_     [120]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	_     [248]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// NVIC.IPR14: Interrupt Priority Register
func (o *NVIC_Type) SetIPR14_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR14_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR14.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR14_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR14_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR14_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR14_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR14_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR14_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff000000) >> 24
}

// NVIC.IPR15: Interrupt Priority Register
func (o *NVIC_Type) SetIPR15_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR15_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR15.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR15_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR15_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR15_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR15_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR15_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR15_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff000000) >> 24
}

// NVIC.IPR16: Interrupt Priority Register
func (o *NVIC_Type) SetIPR16_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR16_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR16.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR16_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR16_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR16_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR16_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR16_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR16_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff000000) >> 24
}

// NVIC.IPR17: Interrupt Priority Register
func (o *NVIC_Type) SetIPR17_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR17_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR17.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR17_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR17_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR17_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR17_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR17_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR17_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff000000) >> 24
}

// Constants for DMA1: Direct memory access controller
const (
	// ISR: interrupt status register
	// Position of TEIF7 field.
	DMA_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_ISR_TEIF7 = 0x8000000
	// Position of HTIF7 field.
	DMA_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_ISR_HTIF7 = 0x4000000
	// Position of TCIF7 field.
	DMA_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_ISR_TCIF7 = 0x2000000
	// Position of GIF7 field.
	DMA_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_ISR_GIF7 = 0x1000000
	// Position of TEIF6 field.
	DMA_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_ISR_TEIF6 = 0x800000
	// Position of HTIF6 field.
	DMA_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_ISR_HTIF6 = 0x400000
	// Position of TCIF6 field.
	DMA_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_ISR_TCIF6 = 0x200000
	// Position of GIF6 field.
	DMA_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_ISR_GIF6 = 0x100000
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1

	// IFCR: interrupt flag clear register
	// Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Pos = 0x1b
	// Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000
	// Bit CTEIF7.
	DMA_IFCR_CTEIF7 = 0x8000000
	// Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_IFCR_CHTIF7 = 0x4000000
	// Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Pos = 0x19
	// Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000
	// Bit CTCIF7.
	DMA_IFCR_CTCIF7 = 0x2000000
	// Position of CGIF7 field.
	DMA_IFCR_CGIF7_Pos = 0x18
	// Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7_Msk = 0x1000000
	// Bit CGIF7.
	DMA_IFCR_CGIF7 = 0x1000000
	// Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Pos = 0x17
	// Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000
	// Bit CTEIF6.
	DMA_IFCR_CTEIF6 = 0x800000
	// Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Pos = 0x16
	// Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000
	// Bit CHTIF6.
	DMA_IFCR_CHTIF6 = 0x400000
	// Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_IFCR_CTCIF6 = 0x200000
	// Position of CGIF6 field.
	DMA_IFCR_CGIF6_Pos = 0x14
	// Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6_Msk = 0x100000
	// Bit CGIF6.
	DMA_IFCR_CGIF6 = 0x100000
	// Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA_IFCR_CTEIF5 = 0x80000
	// Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA_IFCR_CHTIF5 = 0x40000
	// Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA_IFCR_CTCIF5 = 0x20000
	// Position of CGIF5 field.
	DMA_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA_IFCR_CGIF5 = 0x10000
	// Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Pos = 0xf
	// Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000
	// Bit CTEIF4.
	DMA_IFCR_CTEIF4 = 0x8000
	// Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA_IFCR_CHTIF4 = 0x4000
	// Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA_IFCR_CTCIF4 = 0x2000
	// Position of CGIF4 field.
	DMA_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA_IFCR_CGIF4 = 0x1000
	// Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA_IFCR_CTEIF3 = 0x800
	// Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA_IFCR_CHTIF3 = 0x400
	// Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA_IFCR_CTCIF3 = 0x200
	// Position of CGIF3 field.
	DMA_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA_IFCR_CGIF3 = 0x100
	// Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA_IFCR_CTEIF2 = 0x80
	// Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA_IFCR_CHTIF2 = 0x40
	// Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA_IFCR_CTCIF2 = 0x20
	// Position of CGIF2 field.
	DMA_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA_IFCR_CGIF2 = 0x10
	// Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA_IFCR_CTEIF1 = 0x8
	// Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA_IFCR_CHTIF1 = 0x4
	// Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA_IFCR_CTCIF1 = 0x2
	// Position of CGIF1 field.
	DMA_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA_IFCR_CGIF1 = 0x1

	// CCR1: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR1_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR1_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR1_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR1_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR1_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR1_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR1_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR1_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR1_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR1_MINC = 0x80
	// Position of PINC field.
	DMA_CCR1_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR1_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR1_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR1_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR1_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR1_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR1_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR1_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR1_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR1_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR1_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR1_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR1_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR1_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR1_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR1_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR1_TCIE = 0x2
	// Position of EN field.
	DMA_CCR1_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR1_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR1_EN = 0x1

	// CNDTR1: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR1_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff

	// CPAR1: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR1_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff

	// CMAR1: channel x memory address register
	// Position of MA field.
	DMA_CMAR1_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff

	// CCR2: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR2_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR2_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR2_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR2_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR2_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR2_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR2_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR2_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR2_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR2_MINC = 0x80
	// Position of PINC field.
	DMA_CCR2_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR2_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR2_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR2_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR2_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR2_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR2_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR2_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR2_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR2_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR2_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR2_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR2_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR2_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR2_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR2_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR2_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR2_TCIE = 0x2
	// Position of EN field.
	DMA_CCR2_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR2_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR2_EN = 0x1

	// CNDTR2: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR2_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff

	// CPAR2: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR2_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff

	// CMAR2: channel x memory address register
	// Position of MA field.
	DMA_CMAR2_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff

	// CCR3: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR3_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR3_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR3_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR3_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR3_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR3_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR3_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR3_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR3_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR3_MINC = 0x80
	// Position of PINC field.
	DMA_CCR3_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR3_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR3_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR3_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR3_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR3_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR3_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR3_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR3_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR3_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR3_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR3_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR3_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR3_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR3_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR3_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR3_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR3_TCIE = 0x2
	// Position of EN field.
	DMA_CCR3_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR3_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR3_EN = 0x1

	// CNDTR3: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR3_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff

	// CPAR3: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR3_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff

	// CMAR3: channel x memory address register
	// Position of MA field.
	DMA_CMAR3_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff

	// CCR4: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR4_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR4_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR4_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR4_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR4_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR4_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR4_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR4_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR4_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR4_MINC = 0x80
	// Position of PINC field.
	DMA_CCR4_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR4_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR4_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR4_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR4_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR4_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR4_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR4_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR4_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR4_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR4_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR4_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR4_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR4_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR4_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR4_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR4_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR4_TCIE = 0x2
	// Position of EN field.
	DMA_CCR4_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR4_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR4_EN = 0x1

	// CNDTR4: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR4_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff

	// CPAR4: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR4_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff

	// CMAR4: channel x memory address register
	// Position of MA field.
	DMA_CMAR4_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff

	// CCR5: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR5_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR5_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR5_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR5_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR5_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR5_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR5_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR5_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR5_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR5_MINC = 0x80
	// Position of PINC field.
	DMA_CCR5_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR5_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR5_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR5_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR5_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR5_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR5_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR5_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR5_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR5_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR5_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR5_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR5_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR5_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR5_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR5_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR5_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR5_TCIE = 0x2
	// Position of EN field.
	DMA_CCR5_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR5_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR5_EN = 0x1

	// CNDTR5: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR5_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff

	// CPAR5: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR5_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff

	// CMAR5: channel x memory address register
	// Position of MA field.
	DMA_CMAR5_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff

	// CCR6: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR6_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR6_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR6_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR6_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR6_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR6_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR6_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR6_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR6_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR6_MINC = 0x80
	// Position of PINC field.
	DMA_CCR6_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR6_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR6_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR6_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR6_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR6_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR6_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR6_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR6_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR6_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR6_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR6_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR6_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR6_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR6_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR6_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR6_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR6_TCIE = 0x2
	// Position of EN field.
	DMA_CCR6_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR6_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR6_EN = 0x1

	// CNDTR6: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR6_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff

	// CPAR6: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR6_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff

	// CMAR6: channel x memory address register
	// Position of MA field.
	DMA_CMAR6_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff

	// CCR7: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR7_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR7_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR7_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR7_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR7_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR7_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR7_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR7_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR7_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR7_MINC = 0x80
	// Position of PINC field.
	DMA_CCR7_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR7_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR7_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR7_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR7_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR7_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR7_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR7_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR7_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR7_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR7_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR7_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR7_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR7_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR7_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR7_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR7_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR7_TCIE = 0x2
	// Position of EN field.
	DMA_CCR7_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR7_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR7_EN = 0x1

	// CNDTR7: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR7_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff

	// CPAR7: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR7_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff

	// CMAR7: channel x memory address register
	// Position of MA field.
	DMA_CMAR7_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff
)

// Constants for DMAMUX1: Direct memory access Multiplexer
const (
	// C0CR: DMA Multiplexer Channel 0 Control register
	// Position of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C0CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C0CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C0CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C0CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C0CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C0CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C0CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C0CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C0CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C0CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C0CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C0CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C0CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Msk = 0xff

	// C1CR: DMA Multiplexer Channel 1 Control register
	// Position of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C1CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C1CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C1CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C1CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C1CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C1CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C1CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C1CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C1CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C1CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C1CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C1CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C1CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Msk = 0xff

	// C2CR: DMA Multiplexer Channel 2 Control register
	// Position of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C2CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C2CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C2CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C2CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C2CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C2CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C2CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C2CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C2CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C2CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C2CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C2CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C2CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Msk = 0xff

	// C3CR: DMA Multiplexer Channel 3 Control register
	// Position of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C3CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C3CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C3CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C3CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C3CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C3CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C3CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C3CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C3CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C3CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C3CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C3CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C3CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Msk = 0xff

	// C4CR: DMA Multiplexer Channel 4 Control register
	// Position of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C4CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C4CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C4CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C4CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C4CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C4CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C4CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C4CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C4CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C4CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C4CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C4CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C4CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Msk = 0xff

	// C5CR: DMA Multiplexer Channel 5 Control register
	// Position of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C5CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C5CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C5CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C5CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C5CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C5CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C5CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C5CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C5CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C5CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C5CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C5CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C5CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Msk = 0xff

	// C6CR: DMA Multiplexer Channel 6 Control register
	// Position of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C6CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C6CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C6CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C6CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C6CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C6CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C6CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C6CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C6CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C6CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C6CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C6CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C6CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Msk = 0xff

	// C7CR: DMA Multiplexer Channel 7 Control register
	// Position of SYNC_ID field.
	DMAMUX_C7CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C7CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C7CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C7CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C7CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C7CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C7CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C7CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C7CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C7CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C7CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C7CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C7CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C7CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C7CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C7CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C7CR_DMAREQ_ID_Msk = 0xff

	// C8CR: DMA Multiplexer Channel 8 Control register
	// Position of SYNC_ID field.
	DMAMUX_C8CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C8CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C8CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C8CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C8CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C8CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C8CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C8CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C8CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C8CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C8CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C8CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C8CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C8CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C8CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C8CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C8CR_DMAREQ_ID_Msk = 0xff

	// C9CR: DMA Multiplexer Channel 9 Control register
	// Position of SYNC_ID field.
	DMAMUX_C9CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C9CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C9CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C9CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C9CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C9CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C9CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C9CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C9CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C9CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C9CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C9CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C9CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C9CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C9CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C9CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C9CR_DMAREQ_ID_Msk = 0xff

	// C10CR: DMA Multiplexer Channel 10 Control register
	// Position of SYNC_ID field.
	DMAMUX_C10CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C10CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C10CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C10CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C10CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C10CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C10CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C10CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C10CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C10CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C10CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C10CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C10CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C10CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C10CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C10CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C10CR_DMAREQ_ID_Msk = 0xff

	// C11CR: DMA Multiplexer Channel 11 Control register
	// Position of SYNC_ID field.
	DMAMUX_C11CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C11CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C11CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C11CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C11CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C11CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C11CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C11CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C11CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C11CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C11CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C11CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C11CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C11CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C11CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C11CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C11CR_DMAREQ_ID_Msk = 0xff

	// C12CR: DMA Multiplexer Channel 12 Control register
	// Position of SYNC_ID field.
	DMAMUX_C12CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C12CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C12CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C12CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C12CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C12CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C12CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C12CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C12CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C12CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C12CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C12CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C12CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C12CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C12CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C12CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C12CR_DMAREQ_ID_Msk = 0xff

	// C13CR: DMA Multiplexer Channel 13 Control register
	// Position of SYNC_ID field.
	DMAMUX_C13CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C13CR_SYNC_ID_Msk = 0x1f000000
	// Position of NBREQ field.
	DMAMUX_C13CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C13CR_NBREQ_Msk = 0xf80000
	// Position of SPOL field.
	DMAMUX_C13CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C13CR_SPOL_Msk = 0x60000
	// Position of SE field.
	DMAMUX_C13CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C13CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C13CR_SE = 0x10000
	// Position of EGE field.
	DMAMUX_C13CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C13CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C13CR_EGE = 0x200
	// Position of SOIE field.
	DMAMUX_C13CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C13CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C13CR_SOIE = 0x100
	// Position of DMAREQ_ID field.
	DMAMUX_C13CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C13CR_DMAREQ_ID_Msk = 0xff

	// CSR: DMA Multiplexer Channel Status register
	// Position of SOF0 field.
	DMAMUX_CSR_SOF0_Pos = 0x0
	// Bit mask of SOF0 field.
	DMAMUX_CSR_SOF0_Msk = 0x1
	// Bit SOF0.
	DMAMUX_CSR_SOF0 = 0x1
	// Position of SOF1 field.
	DMAMUX_CSR_SOF1_Pos = 0x1
	// Bit mask of SOF1 field.
	DMAMUX_CSR_SOF1_Msk = 0x2
	// Bit SOF1.
	DMAMUX_CSR_SOF1 = 0x2
	// Position of SOF2 field.
	DMAMUX_CSR_SOF2_Pos = 0x2
	// Bit mask of SOF2 field.
	DMAMUX_CSR_SOF2_Msk = 0x4
	// Bit SOF2.
	DMAMUX_CSR_SOF2 = 0x4
	// Position of SOF3 field.
	DMAMUX_CSR_SOF3_Pos = 0x3
	// Bit mask of SOF3 field.
	DMAMUX_CSR_SOF3_Msk = 0x8
	// Bit SOF3.
	DMAMUX_CSR_SOF3 = 0x8
	// Position of SOF4 field.
	DMAMUX_CSR_SOF4_Pos = 0x4
	// Bit mask of SOF4 field.
	DMAMUX_CSR_SOF4_Msk = 0x10
	// Bit SOF4.
	DMAMUX_CSR_SOF4 = 0x10
	// Position of SOF5 field.
	DMAMUX_CSR_SOF5_Pos = 0x5
	// Bit mask of SOF5 field.
	DMAMUX_CSR_SOF5_Msk = 0x20
	// Bit SOF5.
	DMAMUX_CSR_SOF5 = 0x20
	// Position of SOF6 field.
	DMAMUX_CSR_SOF6_Pos = 0x6
	// Bit mask of SOF6 field.
	DMAMUX_CSR_SOF6_Msk = 0x40
	// Bit SOF6.
	DMAMUX_CSR_SOF6 = 0x40
	// Position of SOF7 field.
	DMAMUX_CSR_SOF7_Pos = 0x7
	// Bit mask of SOF7 field.
	DMAMUX_CSR_SOF7_Msk = 0x80
	// Bit SOF7.
	DMAMUX_CSR_SOF7 = 0x80
	// Position of SOF8 field.
	DMAMUX_CSR_SOF8_Pos = 0x8
	// Bit mask of SOF8 field.
	DMAMUX_CSR_SOF8_Msk = 0x100
	// Bit SOF8.
	DMAMUX_CSR_SOF8 = 0x100
	// Position of SOF9 field.
	DMAMUX_CSR_SOF9_Pos = 0x9
	// Bit mask of SOF9 field.
	DMAMUX_CSR_SOF9_Msk = 0x200
	// Bit SOF9.
	DMAMUX_CSR_SOF9 = 0x200
	// Position of SOF10 field.
	DMAMUX_CSR_SOF10_Pos = 0xa
	// Bit mask of SOF10 field.
	DMAMUX_CSR_SOF10_Msk = 0x400
	// Bit SOF10.
	DMAMUX_CSR_SOF10 = 0x400
	// Position of SOF11 field.
	DMAMUX_CSR_SOF11_Pos = 0xb
	// Bit mask of SOF11 field.
	DMAMUX_CSR_SOF11_Msk = 0x800
	// Bit SOF11.
	DMAMUX_CSR_SOF11 = 0x800
	// Position of SOF12 field.
	DMAMUX_CSR_SOF12_Pos = 0xc
	// Bit mask of SOF12 field.
	DMAMUX_CSR_SOF12_Msk = 0x1000
	// Bit SOF12.
	DMAMUX_CSR_SOF12 = 0x1000
	// Position of SOF13 field.
	DMAMUX_CSR_SOF13_Pos = 0xd
	// Bit mask of SOF13 field.
	DMAMUX_CSR_SOF13_Msk = 0x2000
	// Bit SOF13.
	DMAMUX_CSR_SOF13 = 0x2000

	// CFR: DMA Channel Clear Flag Register
	// Position of CSOF0 field.
	DMAMUX_CFR_CSOF0_Pos = 0x0
	// Bit mask of CSOF0 field.
	DMAMUX_CFR_CSOF0_Msk = 0x1
	// Bit CSOF0.
	DMAMUX_CFR_CSOF0 = 0x1
	// Position of CSOF1 field.
	DMAMUX_CFR_CSOF1_Pos = 0x1
	// Bit mask of CSOF1 field.
	DMAMUX_CFR_CSOF1_Msk = 0x2
	// Bit CSOF1.
	DMAMUX_CFR_CSOF1 = 0x2
	// Position of CSOF2 field.
	DMAMUX_CFR_CSOF2_Pos = 0x2
	// Bit mask of CSOF2 field.
	DMAMUX_CFR_CSOF2_Msk = 0x4
	// Bit CSOF2.
	DMAMUX_CFR_CSOF2 = 0x4
	// Position of CSOF3 field.
	DMAMUX_CFR_CSOF3_Pos = 0x3
	// Bit mask of CSOF3 field.
	DMAMUX_CFR_CSOF3_Msk = 0x8
	// Bit CSOF3.
	DMAMUX_CFR_CSOF3 = 0x8
	// Position of CSOF4 field.
	DMAMUX_CFR_CSOF4_Pos = 0x4
	// Bit mask of CSOF4 field.
	DMAMUX_CFR_CSOF4_Msk = 0x10
	// Bit CSOF4.
	DMAMUX_CFR_CSOF4 = 0x10
	// Position of CSOF5 field.
	DMAMUX_CFR_CSOF5_Pos = 0x5
	// Bit mask of CSOF5 field.
	DMAMUX_CFR_CSOF5_Msk = 0x20
	// Bit CSOF5.
	DMAMUX_CFR_CSOF5 = 0x20
	// Position of CSOF6 field.
	DMAMUX_CFR_CSOF6_Pos = 0x6
	// Bit mask of CSOF6 field.
	DMAMUX_CFR_CSOF6_Msk = 0x40
	// Bit CSOF6.
	DMAMUX_CFR_CSOF6 = 0x40
	// Position of CSOF7 field.
	DMAMUX_CFR_CSOF7_Pos = 0x7
	// Bit mask of CSOF7 field.
	DMAMUX_CFR_CSOF7_Msk = 0x80
	// Bit CSOF7.
	DMAMUX_CFR_CSOF7 = 0x80
	// Position of CSOF8 field.
	DMAMUX_CFR_CSOF8_Pos = 0x8
	// Bit mask of CSOF8 field.
	DMAMUX_CFR_CSOF8_Msk = 0x100
	// Bit CSOF8.
	DMAMUX_CFR_CSOF8 = 0x100
	// Position of CSOF9 field.
	DMAMUX_CFR_CSOF9_Pos = 0x9
	// Bit mask of CSOF9 field.
	DMAMUX_CFR_CSOF9_Msk = 0x200
	// Bit CSOF9.
	DMAMUX_CFR_CSOF9 = 0x200
	// Position of CSOF10 field.
	DMAMUX_CFR_CSOF10_Pos = 0xa
	// Bit mask of CSOF10 field.
	DMAMUX_CFR_CSOF10_Msk = 0x400
	// Bit CSOF10.
	DMAMUX_CFR_CSOF10 = 0x400
	// Position of CSOF11 field.
	DMAMUX_CFR_CSOF11_Pos = 0xb
	// Bit mask of CSOF11 field.
	DMAMUX_CFR_CSOF11_Msk = 0x800
	// Bit CSOF11.
	DMAMUX_CFR_CSOF11 = 0x800
	// Position of CSOF12 field.
	DMAMUX_CFR_CSOF12_Pos = 0xc
	// Bit mask of CSOF12 field.
	DMAMUX_CFR_CSOF12_Msk = 0x1000
	// Bit CSOF12.
	DMAMUX_CFR_CSOF12 = 0x1000
	// Position of CSOF13 field.
	DMAMUX_CFR_CSOF13_Pos = 0xd
	// Bit mask of CSOF13 field.
	DMAMUX_CFR_CSOF13_Msk = 0x2000
	// Bit CSOF13.
	DMAMUX_CFR_CSOF13 = 0x2000

	// RG0CR: DMA Request Generator 0 Control Register
	// Position of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG0CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG0CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG0CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG0CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG0CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG0CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG0CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG0CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Msk = 0x1f

	// RG1CR: DMA Request Generator 1 Control Register
	// Position of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG1CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG1CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG1CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG1CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG1CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG1CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG1CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG1CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Msk = 0x1f

	// RG2CR: DMA Request Generator 2 Control Register
	// Position of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG2CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG2CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG2CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG2CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG2CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG2CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG2CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG2CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Msk = 0x1f

	// RG3CR: DMA Request Generator 3 Control Register
	// Position of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Msk = 0xf80000
	// Position of GPOL field.
	DMAMUX_RG3CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG3CR_GPOL_Msk = 0x60000
	// Position of GE field.
	DMAMUX_RG3CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG3CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG3CR_GE = 0x10000
	// Position of OIE field.
	DMAMUX_RG3CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG3CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG3CR_OIE = 0x100
	// Position of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Msk = 0x1f

	// RGSR: DMA Request Generator Status Register
	// Position of OF0 field.
	DMAMUX_RGSR_OF0_Pos = 0x0
	// Bit mask of OF0 field.
	DMAMUX_RGSR_OF0_Msk = 0x1
	// Bit OF0.
	DMAMUX_RGSR_OF0 = 0x1
	// Position of OF1 field.
	DMAMUX_RGSR_OF1_Pos = 0x1
	// Bit mask of OF1 field.
	DMAMUX_RGSR_OF1_Msk = 0x2
	// Bit OF1.
	DMAMUX_RGSR_OF1 = 0x2
	// Position of OF2 field.
	DMAMUX_RGSR_OF2_Pos = 0x2
	// Bit mask of OF2 field.
	DMAMUX_RGSR_OF2_Msk = 0x4
	// Bit OF2.
	DMAMUX_RGSR_OF2 = 0x4
	// Position of OF3 field.
	DMAMUX_RGSR_OF3_Pos = 0x3
	// Bit mask of OF3 field.
	DMAMUX_RGSR_OF3_Msk = 0x8
	// Bit OF3.
	DMAMUX_RGSR_OF3 = 0x8

	// RGCFR: DMA Request Generator Clear Flag Register
	// Position of CSOF0 field.
	DMAMUX_RGCFR_CSOF0_Pos = 0x0
	// Bit mask of CSOF0 field.
	DMAMUX_RGCFR_CSOF0_Msk = 0x1
	// Bit CSOF0.
	DMAMUX_RGCFR_CSOF0 = 0x1
	// Position of CSOF1 field.
	DMAMUX_RGCFR_CSOF1_Pos = 0x1
	// Bit mask of CSOF1 field.
	DMAMUX_RGCFR_CSOF1_Msk = 0x2
	// Bit CSOF1.
	DMAMUX_RGCFR_CSOF1 = 0x2
	// Position of CSOF2 field.
	DMAMUX_RGCFR_CSOF2_Pos = 0x2
	// Bit mask of CSOF2 field.
	DMAMUX_RGCFR_CSOF2_Msk = 0x4
	// Bit CSOF2.
	DMAMUX_RGCFR_CSOF2 = 0x4
	// Position of CSOF3 field.
	DMAMUX_RGCFR_CSOF3_Pos = 0x3
	// Bit mask of CSOF3 field.
	DMAMUX_RGCFR_CSOF3_Msk = 0x8
	// Bit CSOF3.
	DMAMUX_RGCFR_CSOF3 = 0x8
)

// Constants for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xffffffff

	// CR: Control register
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// Posit