/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.CSecurityTLS;
import com.tigervnc.rfb.Encodings;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.Security;
import com.tigervnc.rfb.SecurityClient;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.Dialog;
import com.tigervnc.vncviewer.MenuKey;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.Tunnel;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class OptionsDialog
extends Dialog {
    private static Map<Object, String> callbacks = new HashMap<Object, String>();
    JCheckBox autoselectCheckbox;
    ButtonGroup encodingGroup;
    JRadioButton tightButton;
    JRadioButton zrleButton;
    JRadioButton hextileButton;
    JRadioButton rawButton;
    ButtonGroup colorlevelGroup;
    JRadioButton fullcolorButton;
    JRadioButton mediumcolorButton;
    JRadioButton lowcolorButton;
    JRadioButton verylowcolorButton;
    JCheckBox compressionCheckbox;
    JCheckBox jpegCheckbox;
    JComboBox compressionInput;
    JComboBox jpegInput;
    JCheckBox encNoneCheckbox;
    JCheckBox encTLSCheckbox;
    JCheckBox encX509Checkbox;
    JCheckBox encRSAAESCheckbox;
    JTextField caInput;
    JTextField crlInput;
    JButton caChooser;
    JButton crlChooser;
    JCheckBox authNoneCheckbox;
    JCheckBox authVncCheckbox;
    JCheckBox authPlainCheckbox;
    JCheckBox authIdentCheckbox;
    JCheckBox sendLocalUsernameCheckbox;
    JCheckBox viewOnlyCheckbox;
    JCheckBox acceptClipboardCheckbox;
    JCheckBox sendClipboardCheckbox;
    JComboBox menuKeyChoice;
    JCheckBox desktopSizeCheckbox;
    JTextField desktopWidthInput;
    JTextField desktopHeightInput;
    ButtonGroup sizingGroup;
    JRadioButton remoteResizeButton;
    JRadioButton remoteScaleButton;
    JComboBox scalingFactorInput;
    JCheckBox fullScreenCheckbox;
    JCheckBox fullScreenAllMonitorsCheckbox;
    JCheckBox sharedCheckbox;
    JCheckBox dotWhenNoCursorCheckbox;
    JCheckBox acceptBellCheckbox;
    JCheckBox tunnelCheckbox;
    JCheckBox viaCheckbox;
    JTextField viaUserInput;
    JTextField viaHostInput;
    JTextField viaPortInput;
    JCheckBox extSSHCheckbox;
    JTextField sshClientInput;
    JButton sshClientChooser;
    JRadioButton sshArgsDefaultButton;
    JRadioButton sshArgsCustomButton;
    JTextField sshArgsInput;
    JTextField sshConfigInput;
    JTextField sshKeyFileInput;
    JButton sshConfigChooser;
    JButton sshKeyFileChooser;
    static LogWriter vlog = new LogWriter("OptionsDialog");

    public OptionsDialog() {
        super(true);
        int n;
        this.setTitle("VNC Viewer Options");
        this.setResizable(false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabLayoutPolicy(1);
        this.encodingGroup = new ButtonGroup();
        this.colorlevelGroup = new ButtonGroup();
        jTabbedPane.addTab("Compression", this.createCompressionPanel());
        jTabbedPane.addTab("Security", this.createSecurityPanel());
        jTabbedPane.addTab("Input", this.createInputPanel());
        jTabbedPane.addTab("Screen", this.createScreenPanel());
        jTabbedPane.addTab("Misc", this.createMiscPanel());
        jTabbedPane.addTab("SSH", this.createSshPanel());
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder());
        int n2 = 0;
        Object object = UIManager.get("TabbedPane:TabbedPaneTabArea.contentMargins");
        if (object != null) {
            n2 += ((Insets)object).left + ((Insets)object).right;
        }
        for (n = 0; n < jTabbedPane.getTabCount(); ++n) {
            n2 += jTabbedPane.getBoundsAt((int)n).width;
        }
        n = jTabbedPane.getPreferredSize().height;
        if (jTabbedPane.getPreferredSize().width < n2) {
            jTabbedPane.setPreferredSize(new Dimension(n2, n));
        }
        JButton jButton = new JButton("OK  \u21b5");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.storeOptions();
                OptionsDialog.this.endDialog();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.endDialog();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 5, 10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        jPanel.add(Box.createRigidArea(new Dimension()));
        jPanel.add(Box.createRigidArea(new Dimension()));
        jPanel.add(Box.createRigidArea(new Dimension()));
        jPanel.add(jButton2);
        jPanel.add(jButton);
        this.add(jTabbedPane);
        this.add(jPanel);
        this.addListeners(this);
        this.pack();
    }

    public static void showDialog(Container container) {
        OptionsDialog optionsDialog = new OptionsDialog();
        optionsDialog.show(container);
    }

    public void show(Container container) {
        this.loadOptions();
        super.showDialog(container);
    }

    public static void addCallback(String string, Object object) {
        callbacks.put(object, string);
    }

    public static void removeCallback(Object object) {
        callbacks.remove(object);
    }

    @Override
    public void endDialog() {
        super.endDialog();
        this.dispose();
    }

    private void loadOptions() {
        File file;
        this.autoselectCheckbox.setSelected(Parameters.autoSelect.getValue());
        int n = Encodings.encodingNum(Parameters.preferredEncoding.getValueStr());
        switch (n) {
            case 7: {
                this.tightButton.setSelected(true);
                break;
            }
            case 16: {
                this.zrleButton.setSelected(true);
                break;
            }
            case 5: {
                this.hextileButton.setSelected(true);
                break;
            }
            case 0: {
                this.rawButton.setSelected(true);
            }
        }
        if (Parameters.fullColor.getValue()) {
            this.fullcolorButton.setSelected(true);
        } else {
            switch (Parameters.lowColorLevel.getValue()) {
                case 0: {
                    this.verylowcolorButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.lowcolorButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.mediumcolorButton.setSelected(true);
                }
            }
        }
        int n2 = 0;
        this.compressionCheckbox.setSelected(Parameters.customCompressLevel.getValue());
        this.jpegCheckbox.setSelected(!Parameters.noJpeg.getValue());
        n2 = 0 + Parameters.compressLevel.getValue();
        this.compressionInput.setSelectedItem(n2);
        n2 = 0 + Parameters.qualityLevel.getValue();
        this.jpegInput.setSelectedItem(n2);
        this.handleAutoselect();
        this.handleCompression();
        this.handleJpeg();
        Security security = new Security(SecurityClient.secTypes);
        this.encNoneCheckbox.setSelected(false);
        this.encTLSCheckbox.setSelected(false);
        this.encX509Checkbox.setSelected(false);
        this.encRSAAESCheckbox.setSelected(false);
        this.authNoneCheckbox.setSelected(false);
        this.authVncCheckbox.setSelected(false);
        this.authPlainCheckbox.setSelected(false);
        this.authIdentCheckbox.setSelected(false);
        this.sendLocalUsernameCheckbox.setSelected(Parameters.sendLocalUsername.getValue());
        List<Integer> list = security.GetEnabledSecTypes();
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            switch (iterator.next()) {
                case 1: {
                    this.encNoneCheckbox.setSelected(true);
                    this.authNoneCheckbox.setSelected(true);
                    break;
                }
                case 2: {
                    this.encNoneCheckbox.setSelected(true);
                    this.authVncCheckbox.setSelected(true);
                }
            }
        }
        List<Integer> list2 = security.GetEnabledExtSecTypes();
        Iterator<Integer> iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            switch (iterator2.next()) {
                case 256: {
                    this.encNoneCheckbox.setSelected(true);
                    this.authPlainCheckbox.setSelected(true);
                    break;
                }
                case 265: {
                    this.encNoneCheckbox.setSelected(true);
                    this.authIdentCheckbox.setSelected(true);
                    break;
                }
                case 257: {
                    this.encTLSCheckbox.setSelected(true);
                    this.authNoneCheckbox.setSelected(true);
                    break;
                }
                case 258: {
                    this.encTLSCheckbox.setSelected(true);
                    this.authVncCheckbox.setSelected(true);
                    break;
                }
                case 259: {
                    this.encTLSCheckbox.setSelected(true);
                    this.authPlainCheckbox.setSelected(true);
                    break;
                }
                case 266: {
                    this.encTLSCheckbox.setSelected(true);
                    this.authIdentCheckbox.setSelected(true);
                    break;
                }
                case 260: {
                    this.encX509Checkbox.setSelected(true);
                    this.authNoneCheckbox.setSelected(true);
                    break;
                }
                case 261: {
                    this.encX509Checkbox.setSelected(true);
                    this.authVncCheckbox.setSelected(true);
                    break;
                }
                case 262: {
                    this.encX509Checkbox.setSelected(true);
                    this.authPlainCheckbox.setSelected(true);
                    break;
                }
                case 267: {
                    this.encX509Checkbox.setSelected(true);
                    this.authIdentCheckbox.setSelected(true);
                    break;
                }
                case 5: 
                case 129: {
                    this.encRSAAESCheckbox.setSelected(true);
                }
                case 6: 
                case 130: {
                    this.authVncCheckbox.setSelected(true);
                    this.authPlainCheckbox.setSelected(true);
                }
            }
        }
        File file2 = new File(CSecurityTLS.X509CA.getValueStr());
        if (file2.exists() && file2.canRead()) {
            this.caInput.setText(file2.getAbsolutePath());
        }
        if ((file = new File(CSecurityTLS.X509CRL.getValueStr())).exists() && file.canRead()) {
            this.crlInput.setText(file.getAbsolutePath());
        }
        this.handleX509();
        this.handleSendLocalUsername();
        this.viewOnlyCheckbox.setSelected(Parameters.viewOnly.getValue());
        this.acceptClipboardCheckbox.setSelected(Parameters.acceptClipboard.getValue());
        this.sendClipboardCheckbox.setSelected(Parameters.sendClipboard.getValue());
        this.menuKeyChoice.setSelectedIndex(0);
        String string = Parameters.menuKey.getValueStr();
        for (int i = 0; i < this.menuKeyChoice.getItemCount(); ++i) {
            if (!string.equals(this.menuKeyChoice.getItemAt(i))) continue;
            this.menuKeyChoice.setSelectedIndex(i);
        }
        if (Parameters.desktopSize.getValueStr().isEmpty() || Parameters.desktopSize.getValueStr().split("x").length != 2) {
            this.desktopSizeCheckbox.setSelected(false);
            this.desktopWidthInput.setText("1024");
            this.desktopHeightInput.setText("768");
        } else {
            this.desktopSizeCheckbox.setSelected(true);
            String string2 = Parameters.desktopSize.getValueStr().split("x")[0];
            this.desktopWidthInput.setText(string2);
            String string3 = Parameters.desktopSize.getValueStr().split("x")[1];
            this.desktopHeightInput.setText(string3);
        }
        if (Parameters.remoteResize.getValue()) {
            this.remoteResizeButton.setSelected(true);
        } else {
            this.remoteScaleButton.setSelected(true);
        }
        this.fullScreenCheckbox.setSelected(Parameters.fullScreen.getValue());
        this.fullScreenAllMonitorsCheckbox.setSelected(Parameters.fullScreenAllMonitors.getValue());
        this.scalingFactorInput.setSelectedItem("100%");
        String string4 = Parameters.scalingFactor.getValueStr();
        if (string4.matches("^[0-9]+$")) {
            string4 = string4.concat("%");
        }
        if (string4.matches("^FixedRatio$")) {
            string4 = new String("Fixed Aspect Ratio");
        }
        for (int i = 0; i < this.scalingFactorInput.getItemCount(); ++i) {
            if (!string4.equals(this.scalingFactorInput.getItemAt(i))) continue;
            this.scalingFactorInput.setSelectedIndex(i);
        }
        this.handleDesktopSize();
        this.sharedCheckbox.setSelected(Parameters.shared.getValue());
        this.dotWhenNoCursorCheckbox.setSelected(Parameters.dotWhenNoCursor.getValue());
        this.acceptBellCheckbox.setSelected(Parameters.acceptBell.getValue());
        this.tunnelCheckbox.setSelected(Parameters.tunnel.getValue() || !Parameters.via.getValueStr().isEmpty());
        this.viaCheckbox.setSelected(!Parameters.via.getValueStr().isEmpty());
        if (this.viaCheckbox.isSelected()) {
            this.viaUserInput.setText(Tunnel.getSshUser());
            this.viaHostInput.setText(Tunnel.getSshHost());
            this.viaPortInput.setText(Integer.toString(Tunnel.getSshPort()));
        }
        this.extSSHCheckbox.setSelected(Parameters.extSSH.getValue());
        File file3 = new File(Parameters.extSSHClient.getValueStr());
        if (file3.exists() && file3.isFile() && file3.canExecute()) {
            this.sshClientInput.setText(file3.getAbsolutePath());
        }
        if (Parameters.extSSHArgs.getValueStr().isEmpty()) {
            this.sshArgsDefaultButton.setSelected(true);
        } else {
            this.sshArgsCustomButton.setSelected(true);
            this.sshArgsInput.setText(Parameters.extSSHArgs.getValueStr());
        }
        file3 = new File(Parameters.sshKeyFile.getValueStr());
        if (file3.exists() && file3.isFile() && file3.canRead()) {
            this.sshKeyFileInput.setText(file3.getAbsolutePath());
        }
        if ((file3 = new File(Parameters.sshConfig.getValueStr())).exists() && file3.isFile() && file3.canRead()) {
            this.sshConfigInput.setText(file3.getAbsolutePath());
        }
        this.handleTunnel();
        this.handleVia();
        this.handleExtSSH();
        this.handleRfbState();
    }

    private void storeOptions() {
        Object object;
        String string;
        Object object2;
        String string2;
        File file;
        Parameters.autoSelect.setParam(this.autoselectCheckbox.isSelected());
        if (this.tightButton.isSelected()) {
            Parameters.preferredEncoding.setParam(Encodings.encodingName(7));
        } else if (this.zrleButton.isSelected()) {
            Parameters.preferredEncoding.setParam(Encodings.encodingName(16));
        } else if (this.hextileButton.isSelected()) {
            Parameters.preferredEncoding.setParam(Encodings.encodingName(5));
        } else if (this.rawButton.isSelected()) {
            Parameters.preferredEncoding.setParam(Encodings.encodingName(0));
        }
        Parameters.fullColor.setParam(this.fullcolorButton.isSelected());
        if (this.verylowcolorButton.isSelected()) {
            Parameters.lowColorLevel.setParam(0);
        } else if (this.lowcolorButton.isSelected()) {
            Parameters.lowColorLevel.setParam(1);
        } else if (this.mediumcolorButton.isSelected()) {
            Parameters.lowColorLevel.setParam(2);
        }
        Parameters.customCompressLevel.setParam(this.compressionCheckbox.isSelected());
        Parameters.noJpeg.setParam(!this.jpegCheckbox.isSelected());
        Parameters.compressLevel.setParam((Integer)this.compressionInput.getSelectedItem());
        Parameters.qualityLevel.setParam((Integer)this.jpegInput.getSelectedItem());
        Security security = new Security();
        if (this.encNoneCheckbox.isSelected()) {
            if (this.authNoneCheckbox.isSelected()) {
                security.EnableSecType(1);
            }
            if (this.authVncCheckbox.isSelected()) {
                security.EnableSecType(2);
                security.EnableSecType(6);
                security.EnableSecType(130);
            }
            if (this.authPlainCheckbox.isSelected()) {
                security.EnableSecType(256);
                security.EnableSecType(6);
                security.EnableSecType(130);
            }
            if (this.authIdentCheckbox.isSelected()) {
                security.EnableSecType(265);
            }
        }
        if (this.encTLSCheckbox.isSelected()) {
            if (this.authNoneCheckbox.isSelected()) {
                security.EnableSecType(257);
            }
            if (this.authVncCheckbox.isSelected()) {
                security.EnableSecType(258);
            }
            if (this.authPlainCheckbox.isSelected()) {
                security.EnableSecType(259);
            }
            if (this.authIdentCheckbox.isSelected()) {
                security.EnableSecType(266);
            }
        }
        if (this.encX509Checkbox.isSelected()) {
            if (this.authNoneCheckbox.isSelected()) {
                security.EnableSecType(260);
            }
            if (this.authVncCheckbox.isSelected()) {
                security.EnableSecType(261);
            }
            if (this.authPlainCheckbox.isSelected()) {
                security.EnableSecType(262);
            }
            if (this.authIdentCheckbox.isSelected()) {
                security.EnableSecType(267);
            }
        }
        if (this.encRSAAESCheckbox.isSelected()) {
            security.EnableSecType(5);
            security.EnableSecType(129);
        }
        if (this.authIdentCheckbox.isSelected() || this.authPlainCheckbox.isSelected()) {
            Parameters.sendLocalUsername.setParam(this.sendLocalUsernameCheckbox.isSelected());
        }
        SecurityClient.secTypes.setParam(security.ToString());
        File file2 = new File(this.caInput.getText());
        if (file2.exists() && file2.canRead()) {
            CSecurityTLS.X509CA.setParam(file2.getAbsolutePath());
        }
        if ((file = new File(this.crlInput.getText())).exists() && file.canRead()) {
            CSecurityTLS.X509CRL.setParam(file.getAbsolutePath());
        }
        Parameters.viewOnly.setParam(this.viewOnlyCheckbox.isSelected());
        Parameters.acceptClipboard.setParam(this.acceptClipboardCheckbox.isSelected());
        Parameters.sendClipboard.setParam(this.sendClipboardCheckbox.isSelected());
        String string3 = MenuKey.getMenuKeySymbols()[this.menuKeyChoice.getSelectedIndex()].name;
        Parameters.menuKey.setParam(string3);
        if (this.desktopSizeCheckbox.isSelected() && !this.desktopWidthInput.getText().isEmpty() && !this.desktopHeightInput.getText().isEmpty()) {
            string2 = this.desktopWidthInput.getText();
            object2 = this.desktopHeightInput.getText();
            Parameters.desktopSize.setParam(string2.concat("x").concat((String)object2));
        } else {
            Parameters.desktopSize.setParam("");
        }
        Parameters.remoteResize.setParam(this.remoteResizeButton.isSelected());
        Parameters.fullScreen.setParam(this.fullScreenCheckbox.isSelected());
        Parameters.fullScreenAllMonitors.setParam(this.fullScreenAllMonitorsCheckbox.isSelected());
        string2 = ((String)this.scalingFactorInput.getSelectedItem()).replace("%", "");
        string2.replace("Fixed Aspect Ratio", "FixedRatio");
        Parameters.scalingFactor.setParam(string2);
        Parameters.shared.setParam(this.sharedCheckbox.isSelected());
        Parameters.dotWhenNoCursor.setParam(this.dotWhenNoCursorCheckbox.isSelected());
        Parameters.acceptBell.setParam(this.acceptBellCheckbox.isSelected());
        Parameters.tunnel.setParam(this.tunnelCheckbox.isSelected());
        if (this.viaCheckbox.isSelected() && !this.viaUserInput.getText().isEmpty() && !this.viaHostInput.getText().isEmpty() && !this.viaPortInput.getText().isEmpty()) {
            object2 = this.viaUserInput.getText();
            String object3 = this.viaHostInput.getText();
            string = this.viaPortInput.getText();
            object = ((String)object2).concat("@").concat(object3).concat(":").concat(string);
            Parameters.via.setParam((String)object);
        } else {
            Parameters.via.setParam("");
        }
        Parameters.extSSH.setParam(this.extSSHCheckbox.isSelected());
        if (!this.sshClientInput.getText().isEmpty()) {
            Parameters.extSSHClient.setParam(this.sshClientInput.getText());
        }
        if (this.sshArgsCustomButton.isSelected() && !this.sshArgsInput.getText().isEmpty()) {
            Parameters.extSSHArgs.setParam(this.sshArgsInput.getText());
        } else {
            Parameters.extSSHArgs.setParam(new String());
        }
        if (!this.sshConfigInput.getText().isEmpty()) {
            Parameters.sshConfig.setParam(this.sshConfigInput.getText());
        }
        if (!this.sshKeyFileInput.getText().isEmpty()) {
            Parameters.sshKeyFile.setParam(this.sshKeyFileInput.getText());
        }
        try {
            for (Map.Entry entry : callbacks.entrySet()) {
                string = entry.getKey();
                object = string.getClass().getMethod((String)entry.getValue(), new Class[0]);
                if (object == null) {
                    vlog.info(string.getClass().getName(), new Object[0]);
                }
                ((Method)object).invoke((Object)string, new Object[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vlog.error("NoSuchMethodException: " + noSuchMethodException.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            vlog.error("IllegalAccessException: " + illegalAccessException.getMessage(), new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            vlog.error("InvocationTargetException: " + invocationTargetException.getMessage(), new Object[0]);
        }
    }

    private JPanel createCompressionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.autoselectCheckbox = new JCheckBox("Auto Select");
        this.autoselectCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleAutoselect();
            }
        });
        jPanel2.add(this.autoselectCheckbox);
        jPanel2.add(Box.createHorizontalGlue());
        JPanel jPanel3 = new JPanel(new GridLayout(4, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Preferred encoding"));
        this.tightButton = new Dialog.GroupedJRadioButton("Tight", this.encodingGroup, jPanel3);
        this.zrleButton = new Dialog.GroupedJRadioButton("ZRLE", this.encodingGroup, jPanel3);
        this.hextileButton = new Dialog.GroupedJRadioButton("Hextile", this.encodingGroup, jPanel3);
        this.rawButton = new Dialog.GroupedJRadioButton("Raw", this.encodingGroup, jPanel3);
        JPanel jPanel4 = new JPanel(new GridLayout(4, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Color level"));
        this.fullcolorButton = new Dialog.GroupedJRadioButton("Full", this.colorlevelGroup, jPanel4);
        this.mediumcolorButton = new Dialog.GroupedJRadioButton("Medium", this.colorlevelGroup, jPanel4);
        this.lowcolorButton = new Dialog.GroupedJRadioButton("Low", this.colorlevelGroup, jPanel4);
        this.verylowcolorButton = new Dialog.GroupedJRadioButton("Very low", this.colorlevelGroup, jPanel4);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2, 5, 0));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        this.compressionCheckbox = new JCheckBox("Custom Compression Level");
        this.compressionCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleCompression();
            }
        });
        Object[] objectArray = new Object[]{1, 2, 3, 4, 5, 6};
        this.compressionInput = new Dialog.MyJComboBox(objectArray);
        ((Dialog.MyJComboBox)this.compressionInput).setDocument(new IntegerDocument(1));
        this.compressionInput.setPrototypeDisplayValue("0.");
        this.compressionInput.setEditable(true);
        JLabel jLabel = new JLabel("Level (0=fast, 9=best)");
        this.jpegCheckbox = new JCheckBox("Allow JPEG Compression");
        this.jpegCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleJpeg();
            }
        });
        Object[] objectArray2 = new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.jpegInput = new Dialog.MyJComboBox(objectArray2);
        this.jpegInput.setPrototypeDisplayValue("0.");
        JLabel jLabel2 = new JLabel("Quality (0=poor, 9=best)");
        jPanel6.add((Component)this.compressionCheckbox, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        int n = this.getButtonLabelInset(this.compressionCheckbox);
        jPanel6.add((Component)this.compressionInput, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, n, 0, 0), 0, 0));
        jPanel6.add((Component)jLabel, new GridBagConstraints(1, 1, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel6.add((Component)this.jpegCheckbox, new GridBagConstraints(0, 2, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
        n = this.getButtonLabelInset(this.jpegCheckbox);
        jPanel6.add((Component)this.jpegInput, new GridBagConstraints(0, 3, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, n, 0, 0), 0, 0));
        jPanel6.add((Component)jLabel2, new GridBagConstraints(1, 3, 1, 1, HEAVY, 0.0, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel6.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, 4, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(jPanel2);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        return jPanel;
    }

    private JPanel createSecurityPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Encryption"));
        this.encNoneCheckbox = new JCheckBox("None");
        this.encTLSCheckbox = new JCheckBox("Anonymous TLS");
        this.encX509Checkbox = new JCheckBox("TLS with X.509 certificates");
        this.encX509Checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleX509();
            }
        });
        JLabel jLabel = new JLabel("X.509 CA Certificate");
        this.caInput = new JTextField();
        this.caChooser = new JButton("Browse");
        this.caChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileNameExtensionFilter fileNameExtensionFilter;
                JRootPane jRootPane = ((JButton)actionEvent.getSource()).getRootPane();
                File file = new File(CSecurityTLS.X509CA.getValueStr());
                File file2 = Dialog.showChooser("Path to X509 CA certificate", file, jRootPane, fileNameExtensionFilter = new FileNameExtensionFilter("X.509 certificate", "crt", "cer", "pem"));
                if (file2 != null && file2.exists() && file2.canRead()) {
                    OptionsDialog.this.caInput.setText(file2.getAbsolutePath());
                }
            }
        });
        JLabel jLabel2 = new JLabel("X.509 CRL file");
        this.crlInput = new JTextField();
        this.crlChooser = new JButton("Browse");
        this.crlChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileNameExtensionFilter fileNameExtensionFilter;
                JRootPane jRootPane = ((JButton)actionEvent.getSource()).getRootPane();
                File file = new File(CSecurityTLS.X509CRL.getValueStr());
                File file2 = Dialog.showChooser("Path to X509 CRL file", file, jRootPane, fileNameExtensionFilter = new FileNameExtensionFilter("X.509 CRL", "crl"));
                if (file2 != null && file2.exists() && file2.canRead()) {
                    OptionsDialog.this.crlInput.setText(file2.getAbsolutePath());
                }
            }
        });
        this.encRSAAESCheckbox = new JCheckBox("RSA-AES");
        this.encRSAAESCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleRSAAES();
            }
        });
        jPanel3.add((Component)this.encNoneCheckbox, new GridBagConstraints(0, 0, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel3.add((Component)this.encTLSCheckbox, new GridBagConstraints(0, 1, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel3.add((Component)this.encX509Checkbox, new GridBagConstraints(0, 2, 3, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        int n = this.getButtonLabelInset(this.encX509Checkbox);
        jPanel3.add((Component)jLabel, new GridBagConstraints(0, 3, 1, 1, LIGHT, LIGHT, 22, 0, new Insets(0, n, 5, 0), 0, 0));
        jPanel3.add((Component)this.caInput, new GridBagConstraints(1, 3, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel3.add((Component)this.caChooser, new GridBagConstraints(2, 3, 1, 1, LIGHT, LIGHT, 21, 3, new Insets(0, 5, 5, 0), 0, 0));
        jPanel3.add((Component)jLabel2, new GridBagConstraints(0, 4, 1, 1, LIGHT, LIGHT, 22, 0, new Insets(0, n, 0, 0), 0, 0));
        jPanel3.add((Component)this.crlInput, new GridBagConstraints(1, 4, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel3.add((Component)this.crlChooser, new GridBagConstraints(2, 4, 1, 1, LIGHT, LIGHT, 21, 3, new Insets(0, 5, 0, 0), 0, 0));
        jPanel3.add((Component)this.encRSAAESCheckbox, new GridBagConstraints(0, 5, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder("Authentication"));
        this.authNoneCheckbox = new JCheckBox("None");
        this.authVncCheckbox = new JCheckBox("Standard VNC");
        this.authPlainCheckbox = new JCheckBox("Plaintext");
        this.authPlainCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleSendLocalUsername();
            }
        });
        this.authIdentCheckbox = new JCheckBox("Ident");
        this.authIdentCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleSendLocalUsername();
            }
        });
        this.sendLocalUsernameCheckbox = new JCheckBox("Send Local Username");
        jPanel4.add((Component)this.authNoneCheckbox, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel4.add((Component)this.authVncCheckbox, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel4.add((Component)this.authPlainCheckbox, new GridBagConstraints(0, 2, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 2, 0), 0, 0));
        jPanel4.add((Component)this.authIdentCheckbox, new GridBagConstraints(0, 3, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(2, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.sendLocalUsernameCheckbox, new GridBagConstraints(1, 2, 1, 2, HEAVY, LIGHT, 21, 0, new Insets(2, 20, 2, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add((Component)jPanel4, new GridBagConstraints(0, 2, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add(Box.createRigidArea(new Dimension(0, 0)), new GridBagConstraints(0, -1, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createInputPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.viewOnlyCheckbox = new JCheckBox("View only (ignore mouse and keyboard)");
        this.acceptClipboardCheckbox = new JCheckBox("Accept clipboard from server");
        this.sendClipboardCheckbox = new JCheckBox("Send clipboard to server");
        JLabel jLabel = new JLabel("Menu key");
        String[] stringArray = new String[MenuKey.getMenuKeySymbolCount()];
        for (int i = 0; i < MenuKey.getMenuKeySymbolCount(); ++i) {
            stringArray[i] = MenuKey.getKeyText(MenuKey.getMenuKeySymbols()[i]);
        }
        this.menuKeyChoice = new JComboBox<String>(stringArray);
        jPanel.add((Component)this.viewOnlyCheckbox, new GridBagConstraints(0, 0, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add((Component)this.acceptClipboardCheckbox, new GridBagConstraints(0, 1, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add((Component)this.sendClipboardCheckbox, new GridBagConstraints(0, 2, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 3, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.menuKeyChoice, new GridBagConstraints(1, 3, 1, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, 4, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createScreenPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Desktop Sizing"));
        this.desktopSizeCheckbox = new JCheckBox("Resize remote session on connect");
        this.desktopSizeCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleDesktopSize();
            }
        });
        this.desktopWidthInput = new IntegerTextField(5);
        this.desktopHeightInput = new IntegerTextField(5);
        JPanel jPanel3 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel3.add(this.desktopWidthInput);
        jPanel3.add(new JLabel(" x "));
        jPanel3.add(this.desktopHeightInput);
        this.sizingGroup = new ButtonGroup();
        this.remoteResizeButton = new JRadioButton("Resize remote session to the local window");
        this.sizingGroup.add(this.remoteResizeButton);
        this.remoteScaleButton = new JRadioButton("Scale remote session to the local window");
        this.sizingGroup.add(this.remoteScaleButton);
        this.remoteResizeButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleRemoteResize();
            }
        });
        JLabel jLabel = new JLabel("Scaling Factor");
        Object[] objectArray = new Object[]{"Auto", "Fixed Aspect Ratio", "50%", "75%", "95%", "100%", "105%", "125%", "150%", "175%", "200%", "250%", "300%", "350%", "400%"};
        this.scalingFactorInput = new Dialog.MyJComboBox(objectArray);
        this.scalingFactorInput.setEditable(true);
        this.fullScreenCheckbox = new JCheckBox("Full-screen mode");
        this.fullScreenAllMonitorsCheckbox = new JCheckBox("Enable full-screen mode over all monitors");
        jPanel2.add((Component)this.desktopSizeCheckbox, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        int n = this.getButtonLabelInset(this.desktopSizeCheckbox);
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, n, 0, 0), 0, 0));
        jPanel2.add((Component)this.remoteResizeButton, new GridBagConstraints(0, 2, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel2.add((Component)this.remoteScaleButton, new GridBagConstraints(0, 3, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        n = this.getButtonLabelInset(this.remoteScaleButton);
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 4, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, n, 4, 0), 0, 0));
        jPanel2.add((Component)this.scalingFactorInput, new GridBagConstraints(1, 4, 1, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 5, 4, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add((Component)this.fullScreenCheckbox, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        n = this.getButtonLabelInset(this.fullScreenCheckbox);
        jPanel.add((Component)this.fullScreenAllMonitorsCheckbox, new GridBagConstraints(0, 2, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, n, 4, 0), 0, 0));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, 3, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createMiscPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.sharedCheckbox = new JCheckBox("Shared (don't disconnect other viewers)");
        this.dotWhenNoCursorCheckbox = new JCheckBox("Show dot when no cursor");
        this.acceptBellCheckbox = new JCheckBox("Beep when requested by the server");
        jPanel.add((Component)this.sharedCheckbox, new GridBagConstraints(0, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add((Component)this.dotWhenNoCursorCheckbox, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add((Component)this.acceptBellCheckbox, new GridBagConstraints(0, 2, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, 3, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createSshPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.tunnelCheckbox = new JCheckBox("Tunnel VNC over SSH");
        this.tunnelCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleTunnel();
            }
        });
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.viaCheckbox = new JCheckBox("Use SSH gateway");
        this.viaCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleVia();
            }
        });
        JLabel jLabel = new JLabel("Username");
        this.viaUserInput = new JTextField();
        JLabel jLabel2 = new JLabel("@");
        JLabel jLabel3 = new JLabel("Hostname (or IP address)");
        this.viaHostInput = new JTextField("");
        JLabel jLabel4 = new JLabel("Port");
        this.viaPortInput = new IntegerTextField(5);
        this.extSSHCheckbox = new JCheckBox("Use external SSH client");
        this.extSSHCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OptionsDialog.this.handleExtSSH();
            }
        });
        this.sshClientInput = new JTextField();
        this.sshClientChooser = new JButton("Browse");
        this.sshClientChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRootPane jRootPane = ((JButton)actionEvent.getSource()).getRootPane();
                File file = new File(Parameters.extSSHClient.getValueStr());
                File file2 = Dialog.showChooser("Path to external SSH client", file, jRootPane);
                if (file2 != null && file2.exists() && file2.isFile() && file2.canExecute()) {
                    OptionsDialog.this.sshClientInput.setText(file2.getAbsolutePath());
                }
            }
        });
        JLabel jLabel5 = new JLabel("SSH config file");
        this.sshConfigInput = new JTextField();
        this.sshConfigChooser = new JButton("Browse");
        this.sshConfigChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRootPane jRootPane = ((JButton)actionEvent.getSource()).getRootPane();
                File file = new File(Parameters.sshConfig.getValueStr());
                File file2 = Dialog.showChooser("Path to OpenSSH client config file", file, jRootPane);
                if (file2 != null && file2.exists() && file2.isFile() && file2.canRead()) {
                    OptionsDialog.this.sshConfigInput.setText(file2.getAbsolutePath());
                }
            }
        });
        JLabel jLabel6 = new JLabel("SSH identity file");
        this.sshKeyFileInput = new JTextField();
        this.sshKeyFileChooser = new JButton("Browse");
        this.sshKeyFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRootPane jRootPane = ((JButton)actionEvent.getSource()).getRootPane();
                File file = Dialog.showChooser("Path to SSH key file", null, jRootPane);
                if (file != null && file.exists() && file.isFile() && file.canRead()) {
                    OptionsDialog.this.sshKeyFileInput.setText(file.getAbsolutePath());
                }
            }
        });
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JLabel jLabel7 = new JLabel("Arguments:");
        this.sshArgsDefaultButton = new Dialog.GroupedJRadioButton("Default", buttonGroup, jPanel3);
        this.sshArgsDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.sshArgsInput.setEnabled(OptionsDialog.this.sshArgsCustomButton.isSelected());
            }
        });
        this.sshArgsCustomButton = new Dialog.GroupedJRadioButton("Custom", buttonGroup, jPanel3);
        this.sshArgsCustomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.sshArgsInput.setEnabled(OptionsDialog.this.sshArgsCustomButton.isSelected());
            }
        });
        this.sshArgsInput = new JTextField();
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)this.viaCheckbox, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        int n = this.getButtonLabelInset(this.viaCheckbox);
        jPanel4.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 2, new Insets(0, n, 4, 0), 0, 0));
        jPanel4.add((Component)jLabel3, new GridBagConstraints(2, 1, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        jPanel4.add((Component)jLabel4, new GridBagConstraints(3, 1, 1, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 5, 4, 0), 0, 0));
        jPanel4.add((Component)this.viaUserInput, new GridBagConstraints(0, 2, 1, 1, LIGHT, LIGHT, 21, 2, new Insets(0, n, 0, 0), 0, 0));
        jPanel4.add((Component)jLabel2, new GridBagConstraints(1, 2, 1, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 2, 0, 2), 0, 0));
        jPanel4.add((Component)this.viaHostInput, new GridBagConstraints(2, 2, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.viaPortInput, new GridBagConstraints(3, 2, 1, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)this.extSSHCheckbox, new GridBagConstraints(0, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)this.sshClientInput, new GridBagConstraints(1, 0, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel5.add((Component)this.sshClientChooser, new GridBagConstraints(2, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel3.add((Component)jLabel7, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.sshArgsDefaultButton, new GridBagConstraints(1, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel3.add((Component)this.sshArgsCustomButton, new GridBagConstraints(2, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel3.add((Component)this.sshArgsInput, new GridBagConstraints(3, 1, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        n = this.getButtonLabelInset(this.extSSHCheckbox);
        jPanel5.add((Component)jPanel3, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(4, n, 0, 0), 0, 0));
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Embedded SSH client configuration");
        jPanel6.setBorder(titledBorder);
        jPanel6.add((Component)jLabel5, new GridBagConstraints(0, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel6.add((Component)this.sshConfigInput, new GridBagConstraints(1, 0, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel6.add((Component)this.sshConfigChooser, new GridBagConstraints(2, 0, 1, 1, LIGHT, LIGHT, 21, 3, new Insets(0, 5, 5, 0), 0, 0));
        jPanel6.add((Component)jLabel6, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel6.add((Component)this.sshKeyFileInput, new GridBagConstraints(1, 1, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel6.add((Component)this.sshKeyFileChooser, new GridBagConstraints(2, 1, 1, 1, LIGHT, LIGHT, 21, 3, new Insets(0, 5, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel4, new GridBagConstraints(0, 0, 0, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        jPanel2.add((Component)jPanel5, new GridBagConstraints(0, 1, 0, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        jPanel2.add((Component)jPanel6, new GridBagConstraints(0, 2, 0, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.tunnelCheckbox, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        n = this.getButtonLabelInset(this.tunnelCheckbox);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 2, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(0, n, 4, 0), 0, 0));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, -1, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void handleAutoselect() {
        ButtonGroup[] buttonGroupArray;
        for (ButtonGroup buttonGroup : buttonGroupArray = new ButtonGroup[]{this.encodingGroup, this.colorlevelGroup}) {
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().setEnabled(!this.autoselectCheckbox.isSelected());
            }
        }
        this.jpegCheckbox.setEnabled(!this.autoselectCheckbox.isSelected());
        this.handleJpeg();
    }

    private void handleCompression() {
        this.compressionInput.setEnabled(this.compressionCheckbox.isSelected());
    }

    private void handleJpeg() {
        if (this.jpegCheckbox.isSelected() && !this.autoselectCheckbox.isSelected()) {
            this.jpegInput.setEnabled(true);
        } else {
            this.jpegInput.setEnabled(false);
        }
    }

    private void handleX509() {
        this.caInput.setEnabled(this.encX509Checkbox.isSelected());
        this.caChooser.setEnabled(this.encX509Checkbox.isSelected());
        this.crlInput.setEnabled(this.encX509Checkbox.isSelected());
        this.crlChooser.setEnabled(this.encX509Checkbox.isSelected());
    }

    private void handleRSAAES() {
        this.authVncCheckbox.setSelected(true);
        this.authPlainCheckbox.setSelected(true);
    }

    private void handleSendLocalUsername() {
        boolean bl = this.authIdentCheckbox.isSelected() || this.authPlainCheckbox.isSelected();
        this.sendLocalUsernameCheckbox.setEnabled(bl);
    }

    private void handleDesktopSize() {
        this.desktopWidthInput.setEnabled(this.desktopSizeCheckbox.isSelected());
        this.desktopHeightInput.setEnabled(this.desktopSizeCheckbox.isSelected());
    }

    private void handleRemoteResize() {
        this.scalingFactorInput.setEnabled(!this.remoteResizeButton.isSelected());
    }

    private void handleTunnel() {
        this.viaCheckbox.setEnabled(this.tunnelCheckbox.isSelected());
        this.extSSHCheckbox.setEnabled(this.tunnelCheckbox.isSelected());
        if (this.tunnelCheckbox.isSelected()) {
            JComponent[] jComponentArray;
            for (JComponent jComponent : jComponentArray = new JComponent[]{this.viaUserInput, this.viaHostInput, this.viaPortInput}) {
                jComponent.setEnabled(this.viaCheckbox.isSelected());
            }
            this.sshClientInput.setEnabled(this.extSSHCheckbox.isSelected());
            this.sshClientChooser.setEnabled(this.extSSHCheckbox.isSelected());
            this.sshArgsDefaultButton.setEnabled(this.extSSHCheckbox.isSelected());
            this.sshArgsCustomButton.setEnabled(this.extSSHCheckbox.isSelected());
            this.sshArgsInput.setEnabled(this.extSSHCheckbox.isSelected());
            this.sshConfigInput.setEnabled(!this.extSSHCheckbox.isSelected());
            this.sshConfigChooser.setEnabled(!this.extSSHCheckbox.isSelected());
            this.sshKeyFileInput.setEnabled(!this.extSSHCheckbox.isSelected());
            this.sshKeyFileChooser.setEnabled(!this.extSSHCheckbox.isSelected());
        } else {
            JComponent[] jComponentArray;
            for (JComponent jComponent : jComponentArray = new JComponent[]{this.viaUserInput, this.viaHostInput, this.viaPortInput, this.sshClientInput, this.sshClientChooser, this.sshArgsDefaultButton, this.sshArgsCustomButton, this.sshArgsInput, this.sshConfigInput, this.sshConfigChooser, this.sshKeyFileInput, this.sshKeyFileChooser}) {
                jComponent.setEnabled(false);
            }
        }
    }

    private void handleVia() {
        if (this.tunnelCheckbox.isSelected()) {
            this.viaUserInput.setEnabled(this.viaCheckbox.isSelected());
            this.viaHostInput.setEnabled(this.viaCheckbox.isSelected());
            this.viaPortInput.setEnabled(this.viaCheckbox.isSelected());
        }
    }

    private void handleExtSSH() {
        if (this.tunnelCheckbox.isSelected()) {
            this.sshClientInput.setEnabled(this.extSSHCheckbox.isSelected());
            this.sshClientChooser.setEnabled(this.extSSHCheckbox.isSelected());
            this.sshArgsDefaultButton.setEnabled(this.extSSHCheckbox.isSelected());
            this.sshArgsCustomButton.setEnabled(this.extSSHCheckbox.isSelected());
            this.sshConfigInput.setEnabled(!this.extSSHCheckbox.isSelected());
            this.sshConfigChooser.setEnabled(!this.extSSHCheckbox.isSelected());
            this.sshKeyFileInput.setEnabled(!this.extSSHCheckbox.isSelected());
            this.sshKeyFileChooser.setEnabled(!this.extSSHCheckbox.isSelected());
            if (this.sshArgsCustomButton.isSelected()) {
                this.sshArgsInput.setEnabled(this.extSSHCheckbox.isSelected());
            } else {
                this.sshArgsInput.setEnabled(false);
            }
        }
    }

    private void handleRfbState() {
        CConn cConn = VncViewer.cc;
        if (cConn != null && cConn.state() == CConnection.stateEnum.RFBSTATE_NORMAL) {
            JComponent[] jComponentArray;
            for (JComponent jComponent : jComponentArray = new JComponent[]{this.encNoneCheckbox, this.encTLSCheckbox, this.encX509Checkbox, this.authNoneCheckbox, this.authVncCheckbox, this.authVncCheckbox, this.authIdentCheckbox, this.authPlainCheckbox, this.sendLocalUsernameCheckbox, this.caInput, this.caChooser, this.crlInput, this.crlChooser, this.sharedCheckbox, this.tunnelCheckbox, this.viaCheckbox, this.viaUserInput, this.viaHostInput, this.viaPortInput, this.extSSHCheckbox, this.sshClientInput, this.sshClientChooser, this.sshArgsDefaultButton, this.sshArgsCustomButton, this.sshArgsInput, this.sshConfigInput, this.sshKeyFileInput, this.sshConfigChooser, this.sshKeyFileChooser}) {
                jComponent.setEnabled(false);
            }
        }
    }

    private class IntegerTextField
    extends JFormattedTextField {
        public IntegerTextField(int n) {
            this.setDocument(new IntegerDocument(n));
            Font font = this.getFont();
            String string = String.format("%0" + n + "d", 0);
            int n2 = this.getFontMetrics(font).stringWidth(string) + this.getMargin().left + this.getMargin().right + this.getInsets().left + this.getInsets().right;
            int n3 = this.getPreferredSize().height;
            this.setPreferredSize(new Dimension(n2, n3));
        }

        @Override
        protected void processFocusEvent(FocusEvent focusEvent) {
            if (focusEvent.isTemporary()) {
                return;
            }
            if (focusEvent.getID() == 1005 && (this.getText() == null || this.getText().isEmpty())) {
                this.setValue(null);
            }
            super.processFocusEvent(focusEvent);
        }
    }

    private class IntegerDocument
    extends PlainDocument {
        private int limit;

        public IntegerDocument(int n) {
            this.limit = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || !string.matches("^[0-9]+$")) {
                return;
            }
            if (this.getLength() + string.length() > this.limit) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

