/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.DAELoader;
import com.eteks.sweethome3d.j3d.Max3DSLoader;
import com.eteks.sweethome3d.j3d.OBJLoader;
import com.eteks.sweethome3d.j3d.ShapeTools;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.SimpleURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.lw3d.Lw3dLoader;
import java.awt.EventQueue;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.Light;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class ModelManager {
    public static final String SPECIAL_SHAPE_PREFIX = "sweethome3d_";
    public static final String WINDOW_PANE_SHAPE_PREFIX = "sweethome3d_window_pane";
    public static final String MIRROR_SHAPE_PREFIX = "sweethome3d_window_mirror";
    public static final String LIGHT_SHAPE_PREFIX = "sweethome3d_light";
    public static final String MANNEQUIN_ABDOMEN_PREFIX = "sweethome3d_mannequin_abdomen";
    public static final String MANNEQUIN_CHEST_PREFIX = "sweethome3d_mannequin_chest";
    public static final String MANNEQUIN_PELVIS_PREFIX = "sweethome3d_mannequin_pelvis";
    public static final String MANNEQUIN_NECK_PREFIX = "sweethome3d_mannequin_neck";
    public static final String MANNEQUIN_HEAD_PREFIX = "sweethome3d_mannequin_head";
    public static final String MANNEQUIN_LEFT_SHOULDER_PREFIX = "sweethome3d_mannequin_left_shoulder";
    public static final String MANNEQUIN_LEFT_ARM_PREFIX = "sweethome3d_mannequin_left_arm";
    public static final String MANNEQUIN_LEFT_ELBOW_PREFIX = "sweethome3d_mannequin_left_elbow";
    public static final String MANNEQUIN_LEFT_FOREARM_PREFIX = "sweethome3d_mannequin_left_forearm";
    public static final String MANNEQUIN_LEFT_WRIST_PREFIX = "sweethome3d_mannequin_left_wrist";
    public static final String MANNEQUIN_LEFT_HAND_PREFIX = "sweethome3d_mannequin_left_hand";
    public static final String MANNEQUIN_LEFT_HIP_PREFIX = "sweethome3d_mannequin_left_hip";
    public static final String MANNEQUIN_LEFT_THIGH_PREFIX = "sweethome3d_mannequin_left_thigh";
    public static final String MANNEQUIN_LEFT_KNEE_PREFIX = "sweethome3d_mannequin_left_knee";
    public static final String MANNEQUIN_LEFT_LEG_PREFIX = "sweethome3d_mannequin_left_leg";
    public static final String MANNEQUIN_LEFT_ANKLE_PREFIX = "sweethome3d_mannequin_left_ankle";
    public static final String MANNEQUIN_LEFT_FOOT_PREFIX = "sweethome3d_mannequin_left_foot";
    public static final String MANNEQUIN_RIGHT_SHOULDER_PREFIX = "sweethome3d_mannequin_right_shoulder";
    public static final String MANNEQUIN_RIGHT_ARM_PREFIX = "sweethome3d_mannequin_right_arm";
    public static final String MANNEQUIN_RIGHT_ELBOW_PREFIX = "sweethome3d_mannequin_right_elbow";
    public static final String MANNEQUIN_RIGHT_FOREARM_PREFIX = "sweethome3d_mannequin_right_forearm";
    public static final String MANNEQUIN_RIGHT_WRIST_PREFIX = "sweethome3d_mannequin_right_wrist";
    public static final String MANNEQUIN_RIGHT_HAND_PREFIX = "sweethome3d_mannequin_right_hand";
    public static final String MANNEQUIN_RIGHT_HIP_PREFIX = "sweethome3d_mannequin_right_hip";
    public static final String MANNEQUIN_RIGHT_THIGH_PREFIX = "sweethome3d_mannequin_right_thigh";
    public static final String MANNEQUIN_RIGHT_KNEE_PREFIX = "sweethome3d_mannequin_right_knee";
    public static final String MANNEQUIN_RIGHT_LEG_PREFIX = "sweethome3d_mannequin_right_leg";
    public static final String MANNEQUIN_RIGHT_ANKLE_PREFIX = "sweethome3d_mannequin_right_ankle";
    public static final String MANNEQUIN_RIGHT_FOOT_PREFIX = "sweethome3d_mannequin_right_foot";
    public static final String MANNEQUIN_ABDOMEN_CHEST_PREFIX = "sweethome3d_mannequin_abdomen_chest";
    public static final String MANNEQUIN_ABDOMEN_PELVIS_PREFIX = "sweethome3d_mannequin_abdomen_pelvis";
    public static final String BALL_PREFIX = "sweethome3d_ball_";
    public static final String ARM_ON_BALL_PREFIX = "sweethome3d_arm_on_ball_";
    public static final String HINGE_PREFIX = "sweethome3d_hinge_";
    public static final String OPENING_ON_HINGE_PREFIX = "sweethome3d_opening_on_hinge_";
    public static final String WINDOW_PANE_ON_HINGE_PREFIX = "sweethome3d_window_pane_on_hinge_";
    public static final String MIRROR_ON_HINGE_PREFIX = "sweethome3d_window_mirror_on_hinge_";
    public static final String UNIQUE_RAIL_PREFIX = "sweethome3d_unique_rail";
    public static final String RAIL_PREFIX = "sweethome3d_rail_";
    public static final String OPENING_ON_RAIL_PREFIX = "sweethome3d_opening_on_rail_";
    public static final String WINDOW_PANE_ON_RAIL_PREFIX = "sweethome3d_window_pane_on_rail_";
    public static final String MIRROR_ON_RAIL_PREFIX = "sweethome3d_window_mirror_on_rail_";
    public static final String SUB_TRANSFORMATION_SEPARATOR = "_and_";
    public static final String DEFORMABLE_TRANSFORM_GROUP_SUFFIX = "_transformation";
    public static final String EDGE_COLOR_MATERIAL_PREFIX = "edge_color";
    private static final TransparencyAttributes WINDOW_PANE_TRANSPARENCY_ATTRIBUTES = new TransparencyAttributes(1, 0.5f);
    private static final Material DEFAULT_MATERIAL = new Material();
    private static final float MINIMUM_SIZE = 0.001f;
    private static final String ADDITIONAL_LOADER_CLASSES = "com.eteks.sweethome3d.j3d.additionalLoaderClasses";
    private static ModelManager instance;
    private Map<Content, BranchGroup> loadedModelNodes = new WeakHashMap<Content, BranchGroup>();
    private Map<Content, List<ModelObserver>> loadingModelObservers = new HashMap<Content, List<ModelObserver>>();
    private Map<Content, Map<Transform3D, BoundingBox>> transformedModelNodeBounds = new WeakHashMap<Content, Map<Transform3D, BoundingBox>>();
    private ExecutorService modelsLoader;
    private Class<Loader>[] additionalLoaderClasses;

    private ModelManager() {
        ArrayList<Class<Loader>> arrayList = new ArrayList<Class<Loader>>();
        String string = System.getProperty(ADDITIONAL_LOADER_CLASSES);
        if (string != null) {
            for (String string2 : string.split("\\s|:")) {
                try {
                    arrayList.add(this.getLoaderClass(string2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Invalid loader class " + string2 + ":\n" + illegalArgumentException.getMessage());
                }
            }
        }
        this.additionalLoaderClasses = arrayList.toArray(new Class[arrayList.size()]);
    }

    private Class<Loader> getLoaderClass(String string) {
        try {
            Class<Loader> clazz = this.getClass().getClassLoader().loadClass(string);
            if (!Loader.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(string + " not a subclass of " + Loader.class.getName());
            }
            if (Modifier.isAbstract(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) {
                throw new IllegalArgumentException(string + " not a public static class");
            }
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            constructor.newInstance(new Object[0]);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(invocationTargetException.getMessage(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(string + " constructor not accessible");
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(string + " not a public static class");
        }
    }

    public static ModelManager getInstance() {
        if (instance == null) {
            instance = new ModelManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.modelsLoader != null) {
            this.modelsLoader.shutdownNow();
            this.modelsLoader = null;
        }
        Map<Content, BranchGroup> map = this.loadedModelNodes;
        synchronized (map) {
            this.loadedModelNodes.clear();
        }
        this.loadingModelObservers.clear();
    }

    float getMinimumSize() {
        return 0.001f;
    }

    public Vector3f getSize(Node node) {
        return this.getSize(node, new Transform3D());
    }

    public Vector3f getSize(Node node, Transform3D transform3D) {
        BoundingBox boundingBox = this.getBounds(node, transform3D);
        Point3d point3d = new Point3d();
        boundingBox.getLower(point3d);
        Point3d point3d2 = new Point3d();
        boundingBox.getUpper(point3d2);
        return new Vector3f(Math.max(this.getMinimumSize(), (float)(point3d2.x - point3d.x)), Math.max(this.getMinimumSize(), (float)(point3d2.y - point3d.y)), Math.max(this.getMinimumSize(), (float)(point3d2.z - point3d.z)));
    }

    public Point3f getCenter(Node node) {
        BoundingBox boundingBox = this.getBounds(node);
        Point3d point3d = new Point3d();
        boundingBox.getLower(point3d);
        Point3d point3d2 = new Point3d();
        boundingBox.getUpper(point3d2);
        return new Point3f((float)(point3d.x + point3d2.x) / 2.0f, (float)(point3d.y + point3d2.y) / 2.0f, (float)(point3d.z + point3d2.z) / 2.0f);
    }

    public BoundingBox getBounds(Node node) {
        return this.getBounds(node, new Transform3D());
    }

    public BoundingBox getBounds(Node node, Transform3D transform3D) {
        BoundingBox boundingBox = new BoundingBox(new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY));
        this.computeBounds(node, boundingBox, transform3D, !this.isOrthogonalRotation(transform3D), this.isDeformed(node));
        Point3d point3d = new Point3d();
        boundingBox.getLower(point3d);
        if (point3d.x == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Node has no bounds");
        }
        return boundingBox;
    }

    private boolean isOrthogonalRotation(Transform3D transform3D) {
        Matrix3f matrix3f = new Matrix3f();
        transform3D.get(matrix3f);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!((double)Math.abs(matrix3f.getElement(i, j)) > 1.0E-6) || !((double)Math.abs(matrix3f.getElement(i, j) - 1.0f) > 1.0E-6) || !((double)Math.abs(matrix3f.getElement(i, j) + 1.0f) > 1.0E-6)) continue;
                return false;
            }
        }
        return true;
    }

    private void computeBounds(Node node, BoundingBox boundingBox, Transform3D transform3D, boolean bl, boolean bl2) {
        if (node instanceof Group) {
            BoundingBox boundingBox2;
            Map<Transform3D, BoundingBox> map = null;
            BoundingBox boundingBox3 = null;
            if (node instanceof TransformGroup) {
                transform3D = new Transform3D(transform3D);
                boundingBox2 = new Transform3D();
                ((TransformGroup)node).getTransform((Transform3D)boundingBox2);
                transform3D.mul((Transform3D)boundingBox2);
            } else if (bl && !bl2 && node instanceof BranchGroup && node.getUserData() instanceof Content && (map = this.transformedModelNodeBounds.get(node.getUserData())) != null) {
                boundingBox3 = map.get(transform3D);
            }
            if (boundingBox3 == null) {
                boundingBox2 = map != null ? new BoundingBox(new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY)) : boundingBox;
                Enumeration enumeration = ((Group)node).getAllChildren();
                while (enumeration.hasMoreElements()) {
                    this.computeBounds((Node)enumeration.nextElement(), boundingBox2, transform3D, bl, bl2);
                }
                if (map != null) {
                    boundingBox3 = boundingBox2;
                    map.put(transform3D, boundingBox3);
                }
            }
            if (boundingBox3 != null) {
                boundingBox.combine(boundingBox3);
            }
        } else if (node instanceof Link) {
            this.computeBounds((Node)((Link)node).getSharedGroup(), boundingBox, transform3D, bl, bl2);
        } else if (node instanceof Shape3D) {
            Bounds bounds;
            Shape3D shape3D = (Shape3D)node;
            if (bl || bl2 && !this.isOrthogonalRotation(transform3D)) {
                bounds = this.computeTransformedGeometryBounds(shape3D, transform3D);
            } else {
                bounds = shape3D.getBounds();
                bounds.transform(transform3D);
            }
            boundingBox.combine(bounds);
        }
    }

    private Bounds computeTransformedGeometryBounds(Shape3D shape3D, Transform3D transform3D) {
        Point3d point3d = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Point3d point3d2 = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        int n = shape3D.numGeometries();
        for (int i = 0; i < n; ++i) {
            GeometryArray geometryArray;
            Geometry geometry = shape3D.getGeometry(i);
            if (geometry instanceof GeometryArray) {
                geometryArray = (GeometryArray)geometry;
                int n2 = geometryArray.getVertexCount();
                Point3f point3f = new Point3f();
                if ((geometryArray.getVertexFormat() & 0x80) != 0) {
                    int n3;
                    int n4;
                    if ((geometryArray.getVertexFormat() & 0x100) != 0) {
                        float[] fArray = geometryArray.getInterleavedVertices();
                        n4 = fArray.length / n2;
                        int n5 = n4 - 3;
                        for (n3 = 0; n3 < n2; ++n3) {
                            point3f.x = fArray[n5];
                            point3f.y = fArray[n5 + 1];
                            point3f.z = fArray[n5 + 2];
                            this.updateBounds(point3f, transform3D, point3d, point3d2);
                            n5 += n4;
                        }
                        continue;
                    }
                    float[] fArray = geometryArray.getCoordRefFloat();
                    n3 = 0;
                    for (n4 = 0; n4 < n2; ++n4) {
                        point3f.x = fArray[n3];
                        point3f.y = fArray[n3 + 1];
                        point3f.z = fArray[n3 + 2];
                        this.updateBounds(point3f, transform3D, point3d, point3d2);
                        n3 += 3;
                    }
                    continue;
                }
                for (int j = 0; j < n2; ++j) {
                    geometryArray.getCoordinate(j, point3f);
                    this.updateBounds(point3f, transform3D, point3d, point3d2);
                }
                continue;
            }
            geometryArray = shape3D.getBounds();
            geometryArray.transform(transform3D);
            return geometryArray;
        }
        BoundingBox boundingBox = new BoundingBox(point3d, point3d2);
        return boundingBox;
    }

    private void updateBounds(Point3f point3f, Transform3D transform3D, Point3d point3d, Point3d point3d2) {
        transform3D.transform(point3f);
        if (point3d.x > (double)point3f.x) {
            point3d.x = point3f.x;
        }
        if (point3d.y > (double)point3f.y) {
            point3d.y = point3f.y;
        }
        if (point3d.z > (double)point3f.z) {
            point3d.z = point3f.z;
        }
        if (point3d2.x < (double)point3f.x) {
            point3d2.x = point3f.x;
        }
        if (point3d2.y < (double)point3f.y) {
            point3d2.y = point3f.y;
        }
        if (point3d2.z < (double)point3f.z) {
            point3d2.z = point3f.z;
        }
    }

    public TransformGroup getNormalizedTransformGroup(Node node, float[][] fArray, float f) {
        return new TransformGroup(this.getNormalizedTransform(node, fArray, f, true));
    }

    public TransformGroup getNormalizedTransformGroup(Node node, float[][] fArray, float f, boolean bl) {
        return new TransformGroup(this.getNormalizedTransform(node, fArray, f, bl));
    }

    public Transform3D getNormalizedTransform(Node node, float[][] fArray, float f) {
        return this.getNormalizedTransform(node, fArray, f, true);
    }

    public Transform3D getNormalizedTransform(Node node, float[][] fArray, float f, boolean bl) {
        Transform3D transform3D;
        Transform3D transform3D2;
        BoundingBox boundingBox = this.getBounds(node);
        Point3d point3d = new Point3d();
        boundingBox.getLower(point3d);
        Point3d point3d2 = new Point3d();
        boundingBox.getUpper(point3d2);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.setTranslation(new Vector3d(-point3d.x - (point3d2.x - point3d.x) / 2.0, -point3d.y - (point3d2.y - point3d.y) / 2.0, -point3d.z - (point3d2.z - point3d.z) / 2.0));
        if (fArray != null) {
            transform3D2 = this.getRotationTransformation(fArray);
            transform3D2.mul(transform3D3);
            BoundingBox boundingBox2 = this.getBounds(node, transform3D2);
            boundingBox2.getLower(point3d);
            boundingBox2.getUpper(point3d2);
            transform3D = new Transform3D();
            if (bl) {
                transform3D.setTranslation(new Vector3d(-point3d.x - (point3d2.x - point3d.x) / 2.0, -point3d.y - (point3d2.y - point3d.y) / 2.0, -point3d.z - (point3d2.z - point3d.z) / 2.0));
            }
            transform3D.mul(transform3D2);
        } else {
            transform3D = transform3D3;
        }
        transform3D2 = new Transform3D();
        transform3D2.setScale(new Vector3d((double)f / Math.max((double)this.getMinimumSize(), point3d2.x - point3d.x), (double)f / Math.max((double)this.getMinimumSize(), point3d2.y - point3d.y), (double)f / Math.max((double)this.getMinimumSize(), point3d2.z - point3d.z)));
        transform3D2.mul(transform3D);
        return transform3D2;
    }

    Transform3D getRotationTransformation(float[][] fArray) {
        Matrix3f matrix3f = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
        Transform3D transform3D = new Transform3D();
        transform3D.setRotation(matrix3f);
        return transform3D;
    }

    Transform3D getPieceOfFurnitureNormalizedModelTransformation(HomePieceOfFurniture homePieceOfFurniture, Node node) {
        float f;
        Transform3D transform3D;
        Transform3D transform3D2;
        Transform3D transform3D3;
        Transform3D transform3D4 = new Transform3D();
        float f2 = homePieceOfFurniture.getWidth();
        if (homePieceOfFurniture.isModelMirrored()) {
            f2 *= -1.0f;
        }
        transform3D4.setScale(new Vector3d((double)f2, (double)homePieceOfFurniture.getHeight(), (double)homePieceOfFurniture.getDepth()));
        if (homePieceOfFurniture.isHorizontallyRotated() && node != null) {
            transform3D3 = new Transform3D();
            if (homePieceOfFurniture.getPitch() != 0.0f) {
                transform3D3.rotX((double)(-homePieceOfFurniture.getPitch()));
            }
            if (homePieceOfFurniture.getRoll() != 0.0f) {
                transform3D2 = new Transform3D();
                transform3D2.rotZ((double)(-homePieceOfFurniture.getRoll()));
                transform3D3.mul(transform3D2, transform3D3);
            }
            transform3D3.mul(transform3D4);
            transform3D2 = this.getBounds(node, transform3D3);
            Point3d point3d = new Point3d();
            transform3D2.getLower(point3d);
            Point3d point3d2 = new Point3d();
            transform3D2.getUpper(point3d2);
            transform3D = new Transform3D();
            transform3D.setTranslation(new Vector3d(-point3d.x - (point3d2.x - point3d.x) / 2.0, -point3d.y - (point3d2.y - point3d.y) / 2.0, -point3d.z - (point3d2.z - point3d.z) / 2.0));
            transform3D.mul(transform3D3);
            f = (float)Math.max((double)this.getMinimumSize(), point3d2.y - point3d.y);
        } else {
            transform3D = transform3D4;
            f = homePieceOfFurniture.getHeight();
        }
        transform3D3 = new Transform3D();
        transform3D3.rotY((double)(-homePieceOfFurniture.getAngle()));
        transform3D3.mul(transform3D);
        transform3D2 = new Transform3D();
        float f3 = homePieceOfFurniture.getLevel() != null ? homePieceOfFurniture.getLevel().getElevation() : 0.0f;
        transform3D2.setTranslation(new Vector3f(homePieceOfFurniture.getX(), homePieceOfFurniture.getElevation() + f / 2.0f + f3, homePieceOfFurniture.getY()));
        transform3D2.mul(transform3D3);
        return transform3D2;
    }

    public void loadModel(Content content, ModelObserver modelObserver) {
        this.loadModel(content, false, modelObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadModel(final Content content, boolean bl, ModelObserver modelObserver) {
        BranchGroup branchGroup;
        ArrayList<ModelObserver> arrayList = this.loadedModelNodes;
        synchronized (arrayList) {
            branchGroup = this.loadedModelNodes.get(content);
        }
        if (branchGroup != null) {
            modelObserver.modelUpdated((BranchGroup)this.cloneNode((Node)branchGroup));
        } else if (bl) {
            try {
                branchGroup = this.loadModel(content);
                arrayList = this.loadedModelNodes;
                synchronized (arrayList) {
                    this.loadedModelNodes.put(content, branchGroup);
                    this.transformedModelNodeBounds.put(content, new WeakHashMap());
                }
                modelObserver.modelUpdated((BranchGroup)this.cloneNode((Node)branchGroup));
            }
            catch (IOException iOException) {
                modelObserver.modelError(iOException);
            }
        } else {
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalStateException("Asynchronous call out of Event Dispatch Thread");
            }
            if (this.modelsLoader == null) {
                this.modelsLoader = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            }
            if ((arrayList = this.loadingModelObservers.get(content)) != null) {
                arrayList.add(modelObserver);
            } else {
                arrayList = new ArrayList<ModelObserver>();
                arrayList.add(modelObserver);
                this.loadingModelObservers.put(content, arrayList);
                this.modelsLoader.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            final BranchGroup branchGroup = ModelManager.this.loadModel(content);
                            Map map = ModelManager.this.loadedModelNodes;
                            synchronized (map) {
                                ModelManager.this.loadedModelNodes.put(content, branchGroup);
                                ModelManager.this.transformedModelNodeBounds.put(content, new WeakHashMap());
                            }
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    List list = (List)ModelManager.this.loadingModelObservers.remove(content);
                                    if (list != null) {
                                        for (ModelObserver modelObserver : list) {
                                            modelObserver.modelUpdated((BranchGroup)ModelManager.this.cloneNode((Node)branchGroup));
                                        }
                                    }
                                }
                            });
                        }
                        catch (IOException iOException) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    List list = (List)ModelManager.this.loadingModelObservers.remove(content);
                                    if (list != null) {
                                        for (ModelObserver modelObserver : list) {
                                            modelObserver.modelError(iOException);
                                        }
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node cloneNode(Node node) {
        Map<Content, BranchGroup> map = this.loadedModelNodes;
        synchronized (map) {
            return this.cloneNode(node, new HashMap<SharedGroup, SharedGroup>());
        }
    }

    private Node cloneNode(Node node, Map<SharedGroup, SharedGroup> map) {
        if (node instanceof Shape3D) {
            Shape3D shape3D = (Shape3D)node;
            Shape3D shape3D2 = (Shape3D)shape3D.cloneNode(false);
            Appearance appearance = shape3D.getAppearance();
            if (appearance != null) {
                TexCoordGeneration texCoordGeneration;
                TextureAttributes textureAttributes;
                PointAttributes pointAttributes;
                LineAttributes lineAttributes;
                PolygonAttributes polygonAttributes;
                RenderingAttributes renderingAttributes;
                TransparencyAttributes transparencyAttributes;
                ColoringAttributes coloringAttributes;
                Appearance appearance2 = (Appearance)appearance.cloneNodeComponent(false);
                Material material = appearance.getMaterial();
                if (material != null) {
                    appearance2.setMaterial((Material)material.cloneNodeComponent(true));
                }
                if ((coloringAttributes = appearance.getColoringAttributes()) != null) {
                    appearance2.setColoringAttributes((ColoringAttributes)coloringAttributes.cloneNodeComponent(true));
                }
                if ((transparencyAttributes = appearance.getTransparencyAttributes()) != null) {
                    appearance2.setTransparencyAttributes((TransparencyAttributes)transparencyAttributes.cloneNodeComponent(true));
                }
                if ((renderingAttributes = appearance.getRenderingAttributes()) != null) {
                    appearance2.setRenderingAttributes((RenderingAttributes)renderingAttributes.cloneNodeComponent(true));
                }
                if ((polygonAttributes = appearance.getPolygonAttributes()) != null) {
                    appearance2.setPolygonAttributes((PolygonAttributes)polygonAttributes.cloneNodeComponent(true));
                }
                if ((lineAttributes = appearance.getLineAttributes()) != null) {
                    appearance2.setLineAttributes((LineAttributes)lineAttributes.cloneNodeComponent(true));
                }
                if ((pointAttributes = appearance.getPointAttributes()) != null) {
                    appearance2.setPointAttributes((PointAttributes)pointAttributes.cloneNodeComponent(true));
                }
                if ((textureAttributes = appearance.getTextureAttributes()) != null) {
                    appearance2.setTextureAttributes((TextureAttributes)textureAttributes.cloneNodeComponent(true));
                }
                if ((texCoordGeneration = appearance.getTexCoordGeneration()) != null) {
                    appearance2.setTexCoordGeneration((TexCoordGeneration)texCoordGeneration.cloneNodeComponent(true));
                }
                shape3D2.setAppearance(appearance2);
            }
            return shape3D2;
        }
        if (node instanceof Link) {
            Link link = (Link)node.cloneNode(true);
            SharedGroup sharedGroup = link.getSharedGroup();
            if (sharedGroup != null) {
                SharedGroup sharedGroup2 = map.get(sharedGroup);
                if (sharedGroup2 == null) {
                    sharedGroup2 = (SharedGroup)this.cloneNode((Node)sharedGroup, map);
                    map.put(sharedGroup, sharedGroup2);
                }
                link.setSharedGroup(sharedGroup2);
            }
            return link;
        }
        Node node2 = node.cloneNode(true);
        if (node instanceof Group) {
            Group group = (Group)node;
            Group group2 = (Group)node2;
            int n = group.numChildren();
            for (int i = 0; i < n; ++i) {
                Node node3 = this.cloneNode(group.getChild(i), map);
                group2.addChild(node3);
            }
        }
        return node2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BranchGroup loadModel(Content content) throws IOException {
        Object object;
        URLContent uRLContent = content instanceof URLContent ? (URLContent)content : TemporaryURLContent.copyToTemporaryURLContent(content);
        Loader[] loaderArray = new Loader[]{new OBJLoader(), new DAELoader(), new Max3DSLoader(), new Lw3dLoader()};
        Loader[] loaderArray2 = new Loader[loaderArray.length + this.additionalLoaderClasses.length];
        System.arraycopy(loaderArray, 0, loaderArray2, 0, loaderArray.length);
        for (int i = 0; i < this.additionalLoaderClasses.length; ++i) {
            try {
                loaderArray2[loaderArray.length + i] = this.additionalLoaderClasses[i].newInstance();
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new InternalError(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException.getMessage());
            }
        }
        Throwable throwable = null;
        Boolean bl = this.shouldUseCaches(uRLContent);
        for (Loader loader : loaderArray2) {
            Object object2;
            boolean bl2 = false;
            try {
                loader.getClass().getMethod("setUseCaches", Boolean.class).invoke((Object)loader, bl);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object2 = uRLContent.getURL().openConnection();
                bl2 = ((URLConnection)object2).getDefaultUseCaches() != bl.booleanValue();
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException instanceof Exception) {
                    throwable = (Exception)invocationTargetException.getTargetException();
                    continue;
                }
                invocationTargetException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                Scene scene;
                loader.setFlags(loader.getFlags() & 0xFFFFFFE8);
                if (bl2) {
                    object2 = this;
                    synchronized (object2) {
                        URLConnection uRLConnection = uRLContent.getURL().openConnection();
                        try {
                            uRLConnection.setDefaultUseCaches(bl);
                            scene = loader.load(uRLContent.getURL());
                            if (uRLConnection.getDefaultUseCaches() == bl.booleanValue()) {
                                uRLConnection.setDefaultUseCaches(bl == false);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (uRLConnection.getDefaultUseCaches() == bl.booleanValue()) {
                                uRLConnection.setDefaultUseCaches(bl == false);
                            }
                            throw throwable2;
                        }
                    }
                }
                scene = loader.load(uRLContent.getURL());
                if ((object2 = scene.getSceneGroup()).numChildren() == 0) {
                    throw new IllegalArgumentException("Empty model");
                }
                this.updateShapeNamesAndWindowPanesTransparency(scene);
                this.turnOffLightsShareAndModulateTextures((Node)object2, new IdentityHashMap<Texture, Texture>());
                this.updateDeformableModelHierarchy((Group)object2);
                this.checkAppearancesName((Node)object2);
                this.replaceMultipleSharedShapes((BranchGroup)object2);
                object2.setUserData((Object)content);
                return object2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throwable = illegalArgumentException;
            }
            catch (IncorrectFormatException incorrectFormatException) {
                throwable = incorrectFormatException;
            }
            catch (ParsingErrorException parsingErrorException) {
                throwable = parsingErrorException;
            }
            catch (IOException iOException) {
                throwable = iOException;
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getClass().getName().equals("com.sun.j3d.utils.image.ImageException")) {
                    throwable = runtimeException;
                    continue;
                }
                throw runtimeException;
            }
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof IncorrectFormatException) {
            object = new IOException("Incorrect format");
            ((Throwable)object).initCause(throwable);
            throw object;
        }
        if (throwable instanceof ParsingErrorException) {
            object = new IOException("Parsing error");
            ((Throwable)object).initCause(throwable);
            throw object;
        }
        object = new IOException();
        ((Throwable)object).initCause(throwable);
        throw object;
    }

    private boolean shouldUseCaches(URLContent uRLContent) throws IOException {
        JarURLConnection jarURLConnection;
        URL uRL;
        URLConnection uRLConnection = uRLContent.getURL().openConnection();
        if (OperatingSystem.isWindows() && uRLConnection instanceof JarURLConnection && (uRL = (jarURLConnection = (JarURLConnection)uRLConnection).getJarFileURL()).getProtocol().equalsIgnoreCase("file")) {
            try {
                File file;
                try {
                    file = new File(uRL.toURI());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    file = new File(uRL.getPath());
                }
                if (file.canWrite()) {
                    return false;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException();
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
        }
        return uRLConnection.getDefaultUseCaches();
    }

    private void updateShapeNamesAndWindowPanesTransparency(Scene scene) {
        Hashtable hashtable = scene.getNamedObjects();
        for (Map.Entry entry : hashtable.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Node) {
                ((Node)v).setUserData((Object)string);
            }
            if (!(v instanceof Shape3D) || !string.startsWith(WINDOW_PANE_SHAPE_PREFIX)) continue;
            Shape3D shape3D = (Shape3D)v;
            Appearance appearance = shape3D.getAppearance();
            if (appearance == null) {
                appearance = new Appearance();
                shape3D.setAppearance(appearance);
            }
            if (appearance.getTransparencyAttributes() != null) continue;
            appearance.setTransparencyAttributes(WINDOW_PANE_TRANSPARENCY_ATTRIBUTES);
        }
    }

    private void updateDeformableModelHierarchy(Group group) {
        if (this.containsNode((Node)group, MANNEQUIN_ABDOMEN_PREFIX) && this.containsNode((Node)group, MANNEQUIN_CHEST_PREFIX) && this.containsNode((Node)group, MANNEQUIN_PELVIS_PREFIX) && this.containsNode((Node)group, MANNEQUIN_NECK_PREFIX) && this.containsNode((Node)group, MANNEQUIN_HEAD_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_SHOULDER_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_ARM_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_ELBOW_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_FOREARM_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_WRIST_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_HAND_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_HIP_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_THIGH_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_KNEE_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_LEG_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_ANKLE_PREFIX) && this.containsNode((Node)group, MANNEQUIN_LEFT_FOOT_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_SHOULDER_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_ARM_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_ELBOW_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_FOREARM_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_WRIST_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_HAND_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_HIP_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_THIGH_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_KNEE_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_LEG_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_ANKLE_PREFIX) && this.containsNode((Node)group, MANNEQUIN_RIGHT_FOOT_PREFIX)) {
            Group group2 = this.extractNodes((Node)group, MANNEQUIN_HEAD_PREFIX, null);
            TransformGroup transformGroup = this.createPickableTransformGroup(MANNEQUIN_NECK_PREFIX, new Node[]{group2});
            Group group3 = this.extractNodes((Node)group, MANNEQUIN_LEFT_HAND_PREFIX, null);
            TransformGroup transformGroup2 = this.createPickableTransformGroup(MANNEQUIN_LEFT_WRIST_PREFIX, new Node[]{group3});
            Group group4 = this.extractNodes((Node)group, MANNEQUIN_LEFT_FOREARM_PREFIX, null);
            Group group5 = this.extractNodes((Node)group, MANNEQUIN_LEFT_WRIST_PREFIX, null);
            TransformGroup transformGroup3 = this.createPickableTransformGroup(MANNEQUIN_LEFT_ELBOW_PREFIX, new Node[]{group4, group5, transformGroup2});
            Group group6 = this.extractNodes((Node)group, MANNEQUIN_LEFT_ARM_PREFIX, null);
            Group group7 = this.extractNodes((Node)group, MANNEQUIN_LEFT_ELBOW_PREFIX, null);
            TransformGroup transformGroup4 = this.createPickableTransformGroup(MANNEQUIN_LEFT_SHOULDER_PREFIX, new Node[]{group6, group7, transformGroup3});
            Group group8 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_HAND_PREFIX, null);
            TransformGroup transformGroup5 = this.createPickableTransformGroup(MANNEQUIN_RIGHT_WRIST_PREFIX, new Node[]{group8});
            Group group9 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_FOREARM_PREFIX, null);
            Group group10 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_WRIST_PREFIX, null);
            TransformGroup transformGroup6 = this.createPickableTransformGroup(MANNEQUIN_RIGHT_ELBOW_PREFIX, new Node[]{group9, group10, transformGroup5});
            Group group11 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_ARM_PREFIX, null);
            Group group12 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_ELBOW_PREFIX, null);
            TransformGroup transformGroup7 = this.createPickableTransformGroup(MANNEQUIN_RIGHT_SHOULDER_PREFIX, new Node[]{group11, group12, transformGroup6});
            Group group13 = this.extractNodes((Node)group, MANNEQUIN_CHEST_PREFIX, null);
            Group group14 = this.extractNodes((Node)group, MANNEQUIN_LEFT_SHOULDER_PREFIX, null);
            Group group15 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_SHOULDER_PREFIX, null);
            Group group16 = this.extractNodes((Node)group, MANNEQUIN_NECK_PREFIX, null);
            TransformGroup transformGroup8 = this.createPickableTransformGroup(MANNEQUIN_ABDOMEN_CHEST_PREFIX, new Node[]{group13, group14, transformGroup4, group15, transformGroup7, group16, transformGroup});
            Group group17 = this.extractNodes((Node)group, MANNEQUIN_LEFT_FOOT_PREFIX, null);
            TransformGroup transformGroup9 = this.createPickableTransformGroup(MANNEQUIN_LEFT_ANKLE_PREFIX, new Node[]{group17});
            Group group18 = this.extractNodes((Node)group, MANNEQUIN_LEFT_LEG_PREFIX, null);
            Group group19 = this.extractNodes((Node)group, MANNEQUIN_LEFT_ANKLE_PREFIX, null);
            TransformGroup transformGroup10 = this.createPickableTransformGroup(MANNEQUIN_LEFT_KNEE_PREFIX, new Node[]{group18, group19, transformGroup9});
            Group group20 = this.extractNodes((Node)group, MANNEQUIN_LEFT_THIGH_PREFIX, null);
            Group group21 = this.extractNodes((Node)group, MANNEQUIN_LEFT_KNEE_PREFIX, null);
            TransformGroup transformGroup11 = this.createPickableTransformGroup(MANNEQUIN_LEFT_HIP_PREFIX, new Node[]{group20, group21, transformGroup10});
            Group group22 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_FOOT_PREFIX, null);
            TransformGroup transformGroup12 = this.createPickableTransformGroup(MANNEQUIN_RIGHT_ANKLE_PREFIX, new Node[]{group22});
            Group group23 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_LEG_PREFIX, null);
            Group group24 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_ANKLE_PREFIX, null);
            TransformGroup transformGroup13 = this.createPickableTransformGroup(MANNEQUIN_RIGHT_KNEE_PREFIX, new Node[]{group23, group24, transformGroup12});
            Group group25 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_THIGH_PREFIX, null);
            Group group26 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_KNEE_PREFIX, null);
            TransformGroup transformGroup14 = this.createPickableTransformGroup(MANNEQUIN_RIGHT_HIP_PREFIX, new Node[]{group25, group26, transformGroup13});
            Group group27 = this.extractNodes((Node)group, MANNEQUIN_PELVIS_PREFIX, null);
            Group group28 = this.extractNodes((Node)group, MANNEQUIN_LEFT_HIP_PREFIX, null);
            Group group29 = this.extractNodes((Node)group, MANNEQUIN_RIGHT_HIP_PREFIX, null);
            TransformGroup transformGroup15 = this.createPickableTransformGroup(MANNEQUIN_ABDOMEN_PELVIS_PREFIX, new Node[]{group27, group28, transformGroup11, group29, transformGroup14});
            Group group30 = this.extractNodes((Node)group, MANNEQUIN_ABDOMEN_PREFIX, null);
            group.addChild((Node)group30);
            group.addChild((Node)transformGroup8);
            group.addChild((Node)transformGroup15);
        } else {
            this.updateSimpleDeformableModelHierarchy(group, null, HINGE_PREFIX, OPENING_ON_HINGE_PREFIX, WINDOW_PANE_ON_HINGE_PREFIX, MIRROR_ON_HINGE_PREFIX);
            this.updateSimpleDeformableModelHierarchy(group, null, BALL_PREFIX, ARM_ON_BALL_PREFIX, null, null);
            this.updateSimpleDeformableModelHierarchy(group, UNIQUE_RAIL_PREFIX, RAIL_PREFIX, OPENING_ON_RAIL_PREFIX, WINDOW_PANE_ON_RAIL_PREFIX, MIRROR_ON_RAIL_PREFIX);
            HashSet<Node> hashSet = new HashSet<Node>();
            while (this.updateDeformableModelSubTransformedHierarchy(group, (Node)group, new String[]{HINGE_PREFIX, BALL_PREFIX, RAIL_PREFIX}, new String[]{OPENING_ON_HINGE_PREFIX, ARM_ON_BALL_PREFIX, OPENING_ON_RAIL_PREFIX}, hashSet)) {
            }
        }
    }

    private void updateSimpleDeformableModelHierarchy(Group group, String string, String string2, String string3, String string4, String string5) {
        if (this.containsNode((Node)group, string3 + 1) || string4 != null && this.containsNode((Node)group, string4 + 1) || string5 != null && this.containsNode((Node)group, string5 + 1)) {
            if (this.containsNode((Node)group, string2 + 1)) {
                int n = 1;
                do {
                    Group group2 = this.extractNodes((Node)group, string2 + n, null);
                    Group group3 = this.extractNodes((Node)group, string3 + n, null);
                    Group group4 = string4 != null ? this.extractNodes((Node)group, string4 + n, null) : null;
                    Group group5 = string5 != null ? this.extractNodes((Node)group, string5 + n, null) : null;
                    TransformGroup transformGroup = this.createPickableTransformGroup(string2 + n, new Node[]{group3, group4, group5});
                    group.addChild((Node)group2);
                    group.addChild((Node)transformGroup);
                } while (this.containsNode((Node)group, string2 + ++n) && (this.containsNode((Node)group, string3 + n) || string4 != null && this.containsNode((Node)group, string4 + n) || string5 != null && this.containsNode((Node)group, string5 + n)));
            } else if (string != null && this.containsNode((Node)group, string)) {
                Group group6 = this.extractNodes((Node)group, string, null);
                group.addChild((Node)group6);
                int n = 1;
                do {
                    Group group7 = this.extractNodes((Node)group, string3 + n, null);
                    Group group8 = this.extractNodes((Node)group, string4 + n, null);
                    Group group9 = this.extractNodes((Node)group, string5 + n, null);
                    group.addChild((Node)this.createPickableTransformGroup(string2 + n, new Node[]{group7, group8, group9}));
                } while (this.containsNode((Node)group, string3 + ++n) || this.containsNode((Node)group, string4 + n) || this.containsNode((Node)group, string5 + n));
            }
        }
    }

    public boolean containsNode(Node node, String string) {
        Object object = node.getUserData();
        if (object instanceof String && ((String)object).startsWith(string)) {
            return true;
        }
        if (node instanceof Group) {
            Group group = (Group)node;
            for (int i = group.numChildren() - 1; i >= 0; --i) {
                if (!this.containsNode(group.getChild(i), string)) continue;
                return true;
            }
        }
        return false;
    }

    private Group extractNodes(Node node, String string, Group group) {
        if (node.getUserData() != null && ((String)node.getUserData()).startsWith(string)) {
            ((Group)node.getParent()).removeChild(node);
            if (group == null) {
                group = new Group();
            }
            group.addChild(node);
        }
        if (node instanceof Group) {
            Group group2 = (Group)node;
            for (int i = group2.numChildren() - 1; i >= 0; --i) {
                group = this.extractNodes(group2.getChild(i), string, group);
            }
        }
        return group;
    }

    private TransformGroup createPickableTransformGroup(String string, Node ... nodeArray) {
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        transformGroup.setCapability(1);
        transformGroup.setCapability(46);
        transformGroup.setUserData((Object)(string + DEFORMABLE_TRANSFORM_GROUP_SUFFIX));
        for (Node node : nodeArray) {
            if (node == null) continue;
            transformGroup.addChild(node);
        }
        return transformGroup;
    }

    private boolean updateDeformableModelSubTransformedHierarchy(Group group, Node node, String[] stringArray, String[] stringArray2, Set<Node> set) {
        Object object;
        if (group != node && !set.contains(node) && (object = node.getUserData()) instanceof String) {
            String string = (String)object;
            for (String string2 : stringArray) {
                int n;
                if (!string.startsWith(string2) || (n = string.indexOf(SUB_TRANSFORMATION_SEPARATOR)) <= 0) continue;
                for (int i = 0; i < stringArray2.length; ++i) {
                    int n2;
                    int n3 = string.indexOf(stringArray2[i], n + SUB_TRANSFORMATION_SEPARATOR.length());
                    if (n3 < 0) continue;
                    set.add(node);
                    Node node2 = node.getParent();
                    Group group2 = (Group)node2.getParent();
                    if (group2 == null) continue;
                    int n4 = group2.indexOfChild(node2);
                    Node node3 = group2.getChild(++n4);
                    while (!(node3 instanceof TransformGroup)) {
                        node3 = group2.getChild(++n4);
                    }
                    for (n2 = n3 + stringArray2[i].length(); n2 < string.length() && string.charAt(n2) >= '0' && string.charAt(n2) <= '9'; ++n2) {
                    }
                    if (!this.attachNodesToPickableTransformGroup((Node)group, stringArray[i] + string.substring(n3 + stringArray2[i].length(), n2), node2, node3)) continue;
                    return true;
                }
            }
        }
        if (node instanceof Group) {
            object = (Group)node;
            for (int i = object.numChildren() - 1; i >= 0; --i) {
                if (!this.updateDeformableModelSubTransformedHierarchy(group, object.getChild(i), stringArray, stringArray2, set)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean attachNodesToPickableTransformGroup(Node node, String string, Node ... nodeArray) {
        if (node instanceof TransformGroup && (string + DEFORMABLE_TRANSFORM_GROUP_SUFFIX).equals(node.getUserData())) {
            Group group = (Group)node;
            for (Node node2 : nodeArray) {
                ((Group)node2.getParent()).removeChild(node2);
                group.addChild(node2);
            }
            return true;
        }
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                if (!this.attachNodesToPickableTransformGroup((Node)enumeration.nextElement(), string, nodeArray)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsDeformableNode(Node node) {
        if (node instanceof TransformGroup && node.getUserData() instanceof String && ((String)node.getUserData()).endsWith(DEFORMABLE_TRANSFORM_GROUP_SUFFIX)) {
            return true;
        }
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                if (!this.containsDeformableNode((Node)enumeration.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDeformed(Node node) {
        if (node instanceof TransformGroup && node.getUserData() instanceof String && ((String)node.getUserData()).endsWith(DEFORMABLE_TRANSFORM_GROUP_SUFFIX)) {
            Transform3D transform3D = new Transform3D();
            ((TransformGroup)node).getTransform(transform3D);
            return (transform3D.getBestType() & 2) != 2;
        }
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                if (!this.isDeformed((Node)enumeration.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    private void turnOffLightsShareAndModulateTextures(Node node, Map<Texture, Texture> map) {
        if (node instanceof Group) {
            node.setCapability(6);
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.turnOffLightsShareAndModulateTextures((Node)enumeration.nextElement(), map);
            }
        } else if (node instanceof Link) {
            this.turnOffLightsShareAndModulateTextures((Node)((Link)node).getSharedGroup(), map);
        } else if (node instanceof Light) {
            ((Light)node).setEnable(false);
        } else if (node instanceof Shape3D) {
            Texture texture;
            Shape3D shape3D = (Shape3D)node;
            Enumeration enumeration = shape3D.getAllGeometries();
            while (enumeration.hasMoreElements()) {
                ((Geometry)enumeration.nextElement()).setCapability(18);
            }
            enumeration = shape3D.getAppearance();
            if (enumeration != null && (texture = enumeration.getTexture()) != null) {
                TextureAttributes textureAttributes;
                Texture texture2 = map.get(texture);
                if (texture2 == null) {
                    texture2 = TextureManager.getInstance().shareTexture(texture);
                    map.put(texture, texture2);
                }
                if (texture2 != texture) {
                    enumeration.setTexture(texture2);
                }
                if ((textureAttributes = enumeration.getTextureAttributes()) == null) {
                    textureAttributes = new TextureAttributes();
                    textureAttributes.setTextureMode(2);
                    enumeration.setTextureAttributes(textureAttributes);
                    Material material = enumeration.getMaterial();
                    if (material == null) {
                        enumeration.setMaterial((Material)DEFAULT_MATERIAL.cloneNodeComponent(true));
                    } else {
                        Color3f color3f = new Color3f();
                        DEFAULT_MATERIAL.getDiffuseColor(color3f);
                        material.setDiffuseColor(color3f);
                        DEFAULT_MATERIAL.getAmbientColor(color3f);
                        material.setAmbientColor(color3f);
                    }
                }
                if (TextureManager.getInstance().isTextureTransparent(texture2) && enumeration.getTransparencyAttributes() == null) {
                    enumeration.setTransparencyAttributes(new TransparencyAttributes(1, 0.0f));
                }
            }
        }
    }

    public void checkAppearancesName(Node node) {
        LinkedHashSet<Appearance> linkedHashSet = new LinkedHashSet<Appearance>();
        this.searchAppearances(node, false, linkedHashSet);
        int n = 0;
        for (Appearance appearance : linkedHashSet) {
            try {
                if (appearance.getName() != null) continue;
                appearance.setName("Texture_" + ++n);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                break;
            }
        }
    }

    public HomeMaterial[] getMaterials(Node node) {
        return this.getMaterials(node, null);
    }

    public HomeMaterial[] getMaterials(Node node, String string) {
        return this.getMaterials(node, false, null);
    }

    public HomeMaterial[] getMaterials(Node node, boolean bl, String string) {
        HashSet<Appearance> hashSet = new HashSet<Appearance>();
        this.searchAppearances(node, bl, hashSet);
        TreeSet<HomeMaterial> treeSet = new TreeSet<HomeMaterial>(new Comparator<HomeMaterial>(){

            @Override
            public int compare(HomeMaterial homeMaterial, HomeMaterial homeMaterial2) {
                String string = homeMaterial.getName();
                String string2 = homeMaterial2.getName();
                if (string != null) {
                    if (string2 != null) {
                        return string.compareTo(string2);
                    }
                    return 1;
                }
                if (string2 != null) {
                    return -1;
                }
                return 0;
            }
        });
        for (Appearance appearance : hashSet) {
            URL uRL;
            Texture texture;
            Integer n = null;
            Float f = null;
            Material material = appearance.getMaterial();
            if (material != null) {
                texture = new Color3f();
                material.getDiffuseColor((Color3f)texture);
                n = 0xFF000000 | (int)(texture.x * 255.0f) << 16 | (int)(texture.y * 255.0f) << 8 | (int)(texture.z * 255.0f);
                f = Float.valueOf(material.getShininess() / 128.0f);
            }
            texture = appearance.getTexture();
            HomeTexture homeTexture = null;
            if (texture != null && (uRL = (URL)texture.getUserData()) != null) {
                SimpleURLContent simpleURLContent = new SimpleURLContent(uRL);
                String string2 = uRL.getFile();
                int n2 = (string2 = string2.substring(string2.lastIndexOf(47) + 1)).lastIndexOf(46);
                if (n2 != -1) {
                    string2 = string2.substring(0, n2);
                }
                homeTexture = new HomeTexture(new CatalogTexture(null, string2, simpleURLContent, -1.0f, -1.0f, string));
            }
            try {
                treeSet.add(new HomeMaterial(appearance.getName(), n, homeTexture, f));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                return new HomeMaterial[0];
            }
        }
        return treeSet.toArray(new HomeMaterial[treeSet.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void searchAppearances(Node node, boolean bl, Set<Appearance> set) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.searchAppearances((Node)enumeration.nextElement(), bl, set);
            }
            return;
        } else if (node instanceof Link) {
            this.searchAppearances((Node)((Link)node).getSharedGroup(), bl, set);
            return;
        } else {
            Appearance appearance;
            if (!(node instanceof Shape3D) || (appearance = ((Shape3D)node).getAppearance()) == null) return;
            try {
                if (bl && appearance.getName().startsWith(EDGE_COLOR_MATERIAL_PREFIX)) return;
                set.add(appearance);
                return;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                set.add(appearance);
            }
        }
    }

    private void replaceMultipleSharedShapes(BranchGroup branchGroup) {
        HashMap<Shape3D, Integer> hashMap = new HashMap<Shape3D, Integer>();
        this.searchSharedShapes((Node)branchGroup, hashMap, false);
        for (Map.Entry entry : hashMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            ArrayList<Transform3D> arrayList = new ArrayList<Transform3D>((Integer)entry.getValue());
            Shape3D shape3D = (Shape3D)entry.getKey();
            this.searchShapeTransformations((Node)branchGroup, shape3D, arrayList, new Transform3D());
            Shape3D shape3D2 = (Shape3D)shape3D.cloneNode(true);
            for (int i = 0; i < shape3D2.numGeometries(); ++i) {
                Geometry geometry = this.getTransformedGeometry(shape3D2.getGeometry(i), arrayList);
                if (geometry == null) {
                    return;
                }
                shape3D2.setGeometry(geometry, i);
            }
            this.removeSharedShape((Node)branchGroup, shape3D);
            branchGroup.addChild((Node)shape3D2);
        }
    }

    private void searchSharedShapes(Node node, Map<Shape3D, Integer> map, boolean bl) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.searchSharedShapes((Node)enumeration.nextElement(), map, bl);
            }
        } else if (node instanceof Link) {
            this.searchSharedShapes((Node)((Link)node).getSharedGroup(), map, true);
        } else if (node instanceof Shape3D && bl) {
            Integer n = map.get(node);
            if (n == null) {
                map.put((Shape3D)node, 1);
            } else {
                n = n + 1;
                map.put((Shape3D)node, n);
            }
        }
    }

    private void searchShapeTransformations(Node node, Shape3D shape3D, List<Transform3D> list, Transform3D transform3D) {
        if (node instanceof Group) {
            if (!(node instanceof TransformGroup) || !this.isDeformed(node)) {
                Enumeration enumeration;
                if (node instanceof TransformGroup) {
                    transform3D = new Transform3D(transform3D);
                    enumeration = new Transform3D();
                    ((TransformGroup)node).getTransform((Transform3D)enumeration);
                    transform3D.mul((Transform3D)enumeration);
                }
                enumeration = ((Group)node).getAllChildren();
                while (enumeration.hasMoreElements()) {
                    this.searchShapeTransformations((Node)enumeration.nextElement(), shape3D, list, transform3D);
                }
            }
        } else if (node instanceof Link) {
            this.searchShapeTransformations((Node)((Link)node).getSharedGroup(), shape3D, list, transform3D);
        } else if (node == shape3D) {
            list.add(transform3D);
        }
    }

    private Geometry getTransformedGeometry(Geometry geometry, List<Transform3D> list) {
        block55: {
            Object object;
            block56: {
                int n;
                Object object2;
                Object object3;
                boolean bl;
                boolean bl2;
                GeometryArray geometryArray;
                block57: {
                    int n2;
                    Object object4;
                    int n3;
                    int n4;
                    int n5;
                    IndexedGeometryArray indexedGeometryArray;
                    block58: {
                        int n6;
                        int n7;
                        if (!(geometry instanceof GeometryArray)) break block55;
                        geometryArray = (GeometryArray)geometry;
                        object = null;
                        bl2 = (geometryArray.getVertexFormat() & 2) != 0;
                        boolean bl3 = bl = (geometryArray.getVertexFormat() & 0x20) != 0;
                        if (geometryArray instanceof IndexedGeometryArray) {
                            indexedGeometryArray = (IndexedGeometryArray)geometryArray;
                            object3 = null;
                            if (geometryArray instanceof IndexedLineArray) {
                                object3 = new IndexedLineArray(indexedGeometryArray.getVertexCount() * list.size(), indexedGeometryArray.getVertexFormat(), indexedGeometryArray.getIndexCount() * list.size());
                            } else if (geometryArray instanceof IndexedTriangleArray) {
                                object3 = new IndexedTriangleArray(indexedGeometryArray.getVertexCount() * list.size(), indexedGeometryArray.getVertexFormat(), indexedGeometryArray.getIndexCount() * list.size());
                            } else if (geometryArray instanceof IndexedQuadArray) {
                                object3 = new IndexedQuadArray(indexedGeometryArray.getVertexCount() * list.size(), indexedGeometryArray.getVertexFormat(), indexedGeometryArray.getIndexCount() * list.size());
                            } else if (geometryArray instanceof IndexedGeometryStripArray) {
                                IndexedGeometryStripArray indexedGeometryStripArray = (IndexedGeometryStripArray)geometryArray;
                                int[] nArray = new int[indexedGeometryStripArray.getNumStrips()];
                                indexedGeometryStripArray.getStripIndexCounts(nArray);
                                object2 = new int[nArray.length * list.size()];
                                n7 = 0;
                                for (n6 = 0; n6 < list.size(); ++n6) {
                                    n5 = nArray.length;
                                    for (n4 = 0; n4 < n5; ++n4) {
                                        object2[n7 + n4] = nArray[n4];
                                    }
                                    n7 += nArray.length;
                                }
                                if (indexedGeometryStripArray instanceof IndexedLineStripArray) {
                                    object3 = new IndexedLineStripArray(indexedGeometryArray.getVertexCount() * list.size(), indexedGeometryArray.getVertexFormat(), indexedGeometryArray.getIndexCount() * list.size(), object2);
                                } else if (indexedGeometryStripArray instanceof IndexedTriangleStripArray) {
                                    object3 = new IndexedTriangleStripArray(indexedGeometryArray.getVertexCount() * list.size(), indexedGeometryArray.getVertexFormat(), indexedGeometryArray.getIndexCount() * list.size(), object2);
                                } else if (indexedGeometryStripArray instanceof IndexedTriangleFanArray) {
                                    object3 = new IndexedTriangleFanArray(indexedGeometryArray.getVertexCount() * list.size(), indexedGeometryArray.getVertexFormat(), indexedGeometryArray.getIndexCount(), object2);
                                }
                            }
                            int n8 = 0;
                            n = 0;
                            if (object3 != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    n6 = indexedGeometryArray.getIndexCount();
                                    for (n7 = 0; n7 < n6; ++n7) {
                                        object3.setCoordinateIndex(n8 + n7, n + indexedGeometryArray.getCoordinateIndex(n7));
                                        if (bl2) {
                                            object3.setNormalIndex(n8 + n7, n + indexedGeometryArray.getNormalIndex(n7));
                                        }
                                        if (!bl) continue;
                                        object3.setTextureCoordinateIndex(0, n8 + n7, n + indexedGeometryArray.getTextureCoordinateIndex(0, n7));
                                    }
                                    n8 += indexedGeometryArray.getIndexCount();
                                    n += indexedGeometryArray.getVertexCount();
                                }
                                object = object3;
                            }
                        } else if (geometryArray instanceof LineArray) {
                            object = new LineArray(geometryArray.getVertexCount() * list.size(), geometryArray.getVertexFormat());
                        } else if (geometryArray instanceof TriangleArray) {
                            object = new TriangleArray(geometryArray.getVertexCount() * list.size(), geometryArray.getVertexFormat());
                        } else if (geometryArray instanceof QuadArray) {
                            object = new QuadArray(geometryArray.getVertexCount() * list.size(), geometryArray.getVertexFormat());
                        } else if (geometryArray instanceof GeometryStripArray) {
                            indexedGeometryArray = (GeometryStripArray)geometryArray;
                            object3 = new int[indexedGeometryArray.getNumStrips()];
                            indexedGeometryArray.getStripVertexCounts((int[])object3);
                            int[] nArray = new int[((int[])object3).length * list.size()];
                            n = 0;
                            for (int i = 0; i < list.size(); ++i) {
                                n6 = ((Object)object3).length;
                                for (n7 = 0; n7 < n6; ++n7) {
                                    nArray[n + n7] = (int)object3[n7];
                                }
                                n += ((Object)object3).length;
                            }
                            if (indexedGeometryArray instanceof LineStripArray) {
                                object = new LineStripArray(geometryArray.getVertexCount() * list.size(), geometryArray.getVertexFormat(), nArray);
                            } else if (indexedGeometryArray instanceof TriangleStripArray) {
                                object = new TriangleStripArray(geometryArray.getVertexCount() * list.size(), geometryArray.getVertexFormat(), nArray);
                            } else if (indexedGeometryArray instanceof TriangleFanArray) {
                                object = new TriangleFanArray(geometryArray.getVertexCount() * list.size(), geometryArray.getVertexFormat(), nArray);
                            }
                        }
                        if (object == null) break block56;
                        if ((geometryArray.getVertexFormat() & 0x80) == 0) break block57;
                        indexedGeometryArray = new Point3f();
                        object3 = new Vector3f();
                        if ((geometryArray.getVertexFormat() & 0x100) == 0) break block58;
                        float[] fArray = geometryArray.getInterleavedVertices();
                        n = fArray.length / geometryArray.getVertexCount();
                        object2 = new float[fArray.length * list.size()];
                        n7 = 0;
                        for (Transform3D transform3D : list) {
                            n5 = 0;
                            int n9 = n - 3;
                            int n10 = geometryArray.getVertexCount();
                            while (n5 < n10) {
                                indexedGeometryArray.x = fArray[n9];
                                indexedGeometryArray.y = fArray[n9 + 1];
                                indexedGeometryArray.z = fArray[n9 + 2];
                                transform3D.transform((Point3f)indexedGeometryArray);
                                object2[n7 + n9] = (int)indexedGeometryArray.x;
                                object2[n7 + n9 + 1] = (int)indexedGeometryArray.y;
                                object2[n7 + n9 + 2] = (int)indexedGeometryArray.z;
                                ++n5;
                                n9 += n;
                            }
                            if (bl) {
                                n5 = 0;
                                n9 = 0;
                                n10 = geometryArray.getVertexCount();
                                while (n5 < n10) {
                                    object2[n7 + n9] = (int)fArray[n9];
                                    object2[n7 + n9 + 1] = (int)fArray[n9 + 1];
                                    ++n5;
                                    n9 += n;
                                }
                            }
                            if (bl2) {
                                n5 = 0;
                                n9 = n - 6;
                                n10 = geometryArray.getVertexCount();
                                while (n5 < n10) {
                                    ((Vector3f)object3).x = fArray[n9];
                                    ((Vector3f)object3).y = fArray[n9 + 1];
                                    ((Vector3f)object3).z = fArray[n9 + 2];
                                    transform3D.transform((Vector3f)object3);
                                    object3.normalize();
                                    object2[n7 + n9] = (int)((Vector3f)object3).x;
                                    object2[n7 + n9 + 1] = (int)((Vector3f)object3).y;
                                    object2[n7 + n9 + 2] = (int)((Vector3f)object3).z;
                                    ++n5;
                                    n9 += n;
                                }
                            }
                            n7 += fArray.length;
                        }
                        object.setInterleavedVertices((float[])object2);
                        break block56;
                    }
                    float[] fArray = geometryArray.getCoordRefFloat();
                    float[] fArray2 = new float[fArray.length * list.size()];
                    int n11 = 0;
                    for (Transform3D transform3D : list) {
                        n4 = 0;
                        n5 = 0;
                        n3 = geometryArray.getVertexCount();
                        while (n4 < n3) {
                            indexedGeometryArray.x = fArray[n5];
                            indexedGeometryArray.y = fArray[n5 + 1];
                            indexedGeometryArray.z = fArray[n5 + 2];
                            transform3D.transform((Point3f)indexedGeometryArray);
                            fArray2[n11 + n5] = indexedGeometryArray.x;
                            fArray2[n11 + n5 + 1] = indexedGeometryArray.y;
                            fArray2[n11 + n5 + 2] = indexedGeometryArray.z;
                            ++n4;
                            n5 += 3;
                        }
                        n11 += fArray.length;
                    }
                    object.setCoordRefFloat(fArray2);
                    if (bl) {
                        object4 = geometryArray.getTexCoordRefFloat(0);
                        float[] fArray3 = new float[((Object)object4).length * list.size()];
                        n11 = 0;
                        for (n4 = 0; n4 < list.size(); ++n4) {
                            n5 = 0;
                            n3 = 0;
                            n2 = geometryArray.getVertexCount();
                            while (n5 < n2) {
                                fArray3[n11 + n3] = (float)object4[n3];
                                fArray3[n11 + n3 + 1] = (float)object4[n3 + 1];
                                ++n5;
                                n3 += 2;
                            }
                            n11 += fArray.length;
                        }
                        object.setTexCoordRefFloat(0, fArray3);
                    }
                    if (!bl2) break block56;
                    object4 = geometryArray.getNormalRefFloat();
                    float[] fArray4 = new float[((Object)object4).length * list.size()];
                    n11 = 0;
                    for (Transform3D transform3D : list) {
                        n3 = 0;
                        n2 = 0;
                        int n12 = geometryArray.getVertexCount();
                        while (n3 < n12) {
                            ((Vector3f)object3).x = (float)object4[n2];
                            ((Vector3f)object3).y = (float)object4[n2 + 1];
                            ((Vector3f)object3).z = (float)object4[n2 + 2];
                            transform3D.transform((Vector3f)object3);
                            object3.normalize();
                            fArray4[n11 + n2] = ((Vector3f)object3).x;
                            fArray4[n11 + n2 + 1] = ((Vector3f)object3).y;
                            fArray4[n11 + n2 + 2] = ((Vector3f)object3).z;
                            ++n3;
                            n2 += 3;
                        }
                        n11 += fArray.length;
                    }
                    object.setNormalRefFloat(fArray4);
                    break block56;
                }
                int n13 = 0;
                object3 = list.iterator();
                while (object3.hasNext()) {
                    Transform3D transform3D = (Transform3D)object3.next();
                    int n14 = geometryArray.getVertexCount();
                    for (n = 0; n < n14; ++n) {
                        Point3f point3f = new Point3f();
                        geometryArray.getCoordinate(n, point3f);
                        transform3D.transform(point3f);
                        object.setCoordinate(n13 + n, point3f);
                    }
                    n13 += geometryArray.getVertexCount();
                }
                if (bl) {
                    n13 = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        n = geometryArray.getVertexCount();
                        for (int j = 0; j < n; ++j) {
                            object2 = new TexCoord2f();
                            geometryArray.getTextureCoordinate(0, j, (TexCoord2f)object2);
                            object.setTextureCoordinate(0, n13 + j, (TexCoord2f)object2);
                        }
                        n13 += geometryArray.getVertexCount();
                    }
                }
                if (bl2) {
                    n13 = 0;
                    for (Transform3D transform3D : list) {
                        int n15 = geometryArray.getVertexCount();
                        for (n = 0; n < n15; ++n) {
                            Vector3f vector3f = new Vector3f();
                            geometryArray.getNormal(n, vector3f);
                            transform3D.transform(vector3f);
                            vector3f.normalize();
                            object.setNormal(n13 + n, vector3f);
                        }
                        n13 += geometryArray.getVertexCount();
                    }
                }
            }
            return object;
        }
        return null;
    }

    private void removeSharedShape(Node node, Shape3D shape3D) {
        if (node instanceof Group) {
            if (!(node instanceof TransformGroup) || !this.isDeformed(node)) {
                Group group = (Group)node;
                for (int i = group.numChildren() - 1; i >= 0; --i) {
                    this.removeSharedShape(group.getChild(i), shape3D);
                }
                if (group.numChildren() == 0 && group.getParent() instanceof Group) {
                    ((Group)group.getParent()).removeChild((Node)group);
                }
            }
        } else if (node instanceof Link) {
            SharedGroup sharedGroup = ((Link)node).getSharedGroup();
            this.removeSharedShape((Node)sharedGroup, shape3D);
            if (sharedGroup.numChildren() == 0) {
                ((Group)node.getParent()).removeChild(node);
            }
        } else if (node == shape3D) {
            ((Group)node.getParent()).removeChild(node);
        }
    }

    Area getFrontArea(String string, Node node) {
        Area area;
        if (string != null) {
            area = new Area(this.getShape(string));
            area.transform(AffineTransform.getScaleInstance(1.0, -1.0));
            area.transform(AffineTransform.getTranslateInstance(-0.5, 0.5));
        } else {
            int n = this.getVertexCount(node);
            if (n < 1000000) {
                Area area2 = new Area();
                this.computeBottomOrFrontArea(node, area2, new Transform3D(), false, false);
                area = new Area();
                ArrayList<float[]> arrayList = new ArrayList<float[]>();
                float[] fArray = null;
                Object object = area2.getPathIterator(null, 1.0);
                while (!object.isDone()) {
                    float[] fArray2 = new float[2];
                    switch (object.currentSegment(fArray2)) {
                        case 0: 
                        case 1: {
                            if (fArray == null || fArray2[0] != fArray[0] || fArray2[1] != fArray[1]) {
                                arrayList.add(fArray2);
                            }
                            fArray = fArray2;
                            break;
                        }
                        case 4: {
                            float[][] fArray3;
                            Room room;
                            if (((float[])arrayList.get(0))[0] == fArray[0] && ((float[])arrayList.get(0))[1] == fArray[1]) {
                                arrayList.remove(arrayList.size() - 1);
                            }
                            if (arrayList.size() > 2 && (room = new Room(fArray3 = (float[][])arrayList.toArray((T[])new float[arrayList.size()][]))).getArea() > 0.0f && !room.isClockwise()) {
                                GeneralPath generalPath = new GeneralPath();
                                generalPath.moveTo(fArray3[0][0], fArray3[0][1]);
                                for (int i = 1; i < fArray3.length; ++i) {
                                    generalPath.lineTo(fArray3[i][0], fArray3[i][1]);
                                }
                                generalPath.closePath();
                                area.add(new Area(generalPath));
                            }
                            arrayList.clear();
                            fArray = null;
                        }
                    }
                    object.next();
                }
                object = area2.getBounds2D();
                area.transform(AffineTransform.getTranslateInstance(-((RectangularShape)object).getCenterX(), -((RectangularShape)object).getCenterY()));
                area.transform(AffineTransform.getScaleInstance(1.0 / ((RectangularShape)object).getWidth(), 1.0 / ((RectangularShape)object).getHeight()));
            } else {
                area = new Area(new Rectangle2D.Float(-0.5f, -0.5f, 1.0f, 1.0f));
            }
        }
        return area;
    }

    public Area getAreaOnFloor(Node node) {
        Area area;
        int n = this.getVertexCount(node);
        if (n < 10000) {
            area = new Area();
            this.computeBottomOrFrontArea(node, area, new Transform3D(), true, true);
        } else {
            ArrayList<float[]> arrayList = new ArrayList<float[]>(n);
            this.computeVerticesOnFloor(node, arrayList, new Transform3D());
            if (arrayList.size() > 0) {
                float[][] fArray = this.getSurroundingPolygon((float[][])arrayList.toArray((T[])new float[arrayList.size()][]));
                GeneralPath generalPath = new GeneralPath(1, fArray.length);
                generalPath.moveTo(fArray[0][0], fArray[0][1]);
                for (int i = 0; i < fArray.length; ++i) {
                    generalPath.lineTo(fArray[i][0], fArray[i][1]);
                }
                generalPath.closePath();
                area = new Area(generalPath);
            } else {
                area = new Area();
            }
        }
        return area;
    }

    private int getVertexCount(Node node) {
        int n;
        block4: {
            RenderingAttributes renderingAttributes;
            block5: {
                block3: {
                    n = 0;
                    if (!(node instanceof Group)) break block3;
                    Enumeration enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        n += this.getVertexCount((Node)enumeration.nextElement());
                    }
                    break block4;
                }
                if (!(node instanceof Link)) break block5;
                n = this.getVertexCount((Node)((Link)node).getSharedGroup());
                break block4;
            }
            if (!(node instanceof Shape3D)) break block4;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            RenderingAttributes renderingAttributes2 = renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            if (renderingAttributes == null || renderingAttributes.getVisible()) {
                int n2 = shape3D.numGeometries();
                for (int i = 0; i < n2; ++i) {
                    Geometry geometry = shape3D.getGeometry(i);
                    if (!(geometry instanceof GeometryArray)) continue;
                    n += ((GeometryArray)geometry).getVertexCount();
                }
            }
        }
        return n;
    }

    private void computeBottomOrFrontArea(Node node, Area area, Transform3D transform3D, boolean bl, boolean bl2) {
        block5: {
            TransparencyAttributes transparencyAttributes;
            block6: {
                block4: {
                    Enumeration enumeration;
                    if (!(node instanceof Group)) break block4;
                    if (node instanceof TransformGroup) {
                        transform3D = new Transform3D(transform3D);
                        enumeration = new Transform3D();
                        ((TransformGroup)node).getTransform((Transform3D)enumeration);
                        transform3D.mul((Transform3D)enumeration);
                    }
                    enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.computeBottomOrFrontArea((Node)enumeration.nextElement(), area, transform3D, bl, bl2);
                    }
                    break block5;
                }
                if (!(node instanceof Link)) break block6;
                this.computeBottomOrFrontArea((Node)((Link)node).getSharedGroup(), area, transform3D, bl, bl2);
                break block5;
            }
            if (!(node instanceof Shape3D)) break block5;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            RenderingAttributes renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            TransparencyAttributes transparencyAttributes2 = transparencyAttributes = appearance != null ? appearance.getTransparencyAttributes() : null;
            if (!(renderingAttributes != null && !renderingAttributes.getVisible() || bl && transparencyAttributes != null && !(transparencyAttributes.getTransparency() < 1.0f))) {
                int n = shape3D.numGeometries();
                for (int i = 0; i < n; ++i) {
                    this.computeBottomOrFrontGeometryArea(shape3D.getGeometry(i), area, transform3D, bl2);
                }
            }
        }
    }

    private void computeBottomOrFrontGeometryArea(Geometry geometry, Area area, Transform3D transform3D, boolean bl) {
        if (geometry instanceof GeometryArray) {
            int n;
            int n2;
            int n3;
            GeometryArray geometryArray = (GeometryArray)geometry;
            int n4 = geometryArray.getVertexCount();
            float[] fArray = new float[n4 * 2];
            Point3f point3f = new Point3f();
            if ((geometryArray.getVertexFormat() & 0x80) != 0) {
                if ((geometryArray.getVertexFormat() & 0x100) != 0) {
                    float[] fArray2 = geometryArray.getInterleavedVertices();
                    n3 = fArray2.length / n4;
                    n2 = 0;
                    n = n3 - 3;
                    while (n2 < fArray.length) {
                        point3f.x = fArray2[n];
                        point3f.y = fArray2[n + 1];
                        point3f.z = fArray2[n + 2];
                        transform3D.transform(point3f);
                        fArray[n2++] = point3f.x;
                        fArray[n2++] = bl ? point3f.z : point3f.y;
                        n += n3;
                    }
                } else {
                    float[] fArray3 = geometryArray.getCoordRefFloat();
                    n3 = 0;
                    n2 = 0;
                    while (n3 < fArray.length) {
                        point3f.x = fArray3[n2];
                        point3f.y = fArray3[n2 + 1];
                        point3f.z = fArray3[n2 + 2];
                        transform3D.transform(point3f);
                        fArray[n3++] = point3f.x;
                        fArray[n3++] = bl ? point3f.z : point3f.y;
                        n2 += 3;
                    }
                }
            } else {
                int n5 = 0;
                n3 = 0;
                while (n5 < fArray.length) {
                    geometryArray.getCoordinate(n3, point3f);
                    transform3D.transform(point3f);
                    fArray[n5++] = point3f.x;
                    fArray[n5++] = bl ? point3f.z : point3f.y;
                    ++n3;
                }
            }
            GeneralPath generalPath = null;
            if (geometryArray instanceof IndexedGeometryArray) {
                if (geometryArray instanceof IndexedTriangleArray) {
                    IndexedTriangleArray indexedTriangleArray = (IndexedTriangleArray)geometryArray;
                    generalPath = new GeneralPath(1, 1000);
                    n = 0;
                    int n6 = indexedTriangleArray.getIndexCount();
                    for (n2 = 0; n2 < n6; n2 += 3) {
                        this.addIndexedTriangleToPath((IndexedGeometryArray)indexedTriangleArray, n2, n2 + 1, n2 + 2, fArray, generalPath, n++, area);
                    }
                } else if (geometryArray instanceof IndexedQuadArray) {
                    IndexedQuadArray indexedQuadArray = (IndexedQuadArray)geometryArray;
                    generalPath = new GeneralPath(1, 1000);
                    n = 0;
                    int n7 = indexedQuadArray.getIndexCount();
                    for (n2 = 0; n2 < n7; n2 += 4) {
                        this.addIndexedQuadrilateralToPath((IndexedGeometryArray)indexedQuadArray, n2, n2 + 1, n2 + 2, n2 + 3, fArray, generalPath, n++, area);
                    }
                } else if (geometryArray instanceof IndexedGeometryStripArray) {
                    IndexedGeometryStripArray indexedGeometryStripArray = (IndexedGeometryStripArray)geometryArray;
                    int[] nArray = new int[indexedGeometryStripArray.getNumStrips()];
                    indexedGeometryStripArray.getStripIndexCounts(nArray);
                    generalPath = new GeneralPath(1, 1000);
                    n = 0;
                    if (indexedGeometryStripArray instanceof IndexedTriangleStripArray) {
                        int n8 = 0;
                        for (int i = 0; i < nArray.length; ++i) {
                            int n9 = n;
                            int n10 = n + nArray[i] - 2;
                            int n11 = 0;
                            while (n9 < n10) {
                                if (n11 % 2 == 0) {
                                    this.addIndexedTriangleToPath((IndexedGeometryArray)indexedGeometryStripArray, n9, n9 + 1, n9 + 2, fArray, generalPath, n8++, area);
                                } else {
                                    this.addIndexedTriangleToPath((IndexedGeometryArray)indexedGeometryStripArray, n9, n9 + 2, n9 + 1, fArray, generalPath, n8++, area);
                                }
                                ++n9;
                                ++n11;
                            }
                            n += nArray[i];
                        }
                    } else if (indexedGeometryStripArray instanceof IndexedTriangleFanArray) {
                        int n12 = 0;
                        for (int i = 0; i < nArray.length; ++i) {
                            int n13 = n + nArray[i] - 2;
                            for (int j = n; j < n13; ++j) {
                                this.addIndexedTriangleToPath((IndexedGeometryArray)indexedGeometryStripArray, n, j + 1, j + 2, fArray, generalPath, n12++, area);
                            }
                            n += nArray[i];
                        }
                    }
                }
            } else if (geometryArray instanceof TriangleArray) {
                TriangleArray triangleArray = (TriangleArray)geometryArray;
                generalPath = new GeneralPath(1, 1000);
                n = 0;
                for (n2 = 0; n2 < n4; n2 += 3) {
                    this.addTriangleToPath((GeometryArray)triangleArray, n2, n2 + 1, n2 + 2, fArray, generalPath, n++, area);
                }
            } else if (geometryArray instanceof QuadArray) {
                QuadArray quadArray = (QuadArray)geometryArray;
                generalPath = new GeneralPath(1, 1000);
                n = 0;
                for (n2 = 0; n2 < n4; n2 += 4) {
                    this.addQuadrilateralToPath((GeometryArray)quadArray, n2, n2 + 1, n2 + 2, n2 + 3, fArray, generalPath, n++, area);
                }
            } else if (geometryArray instanceof GeometryStripArray) {
                GeometryStripArray geometryStripArray = (GeometryStripArray)geometryArray;
                int[] nArray = new int[geometryStripArray.getNumStrips()];
                geometryStripArray.getStripVertexCounts(nArray);
                generalPath = new GeneralPath(1, 1000);
                n = 0;
                if (geometryStripArray instanceof TriangleStripArray) {
                    int n14 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        int n15 = n;
                        int n16 = n + nArray[i] - 2;
                        int n17 = 0;
                        while (n15 < n16) {
                            if (n17 % 2 == 0) {
                                this.addTriangleToPath((GeometryArray)geometryStripArray, n15, n15 + 1, n15 + 2, fArray, generalPath, n14++, area);
                            } else {
                                this.addTriangleToPath((GeometryArray)geometryStripArray, n15, n15 + 2, n15 + 1, fArray, generalPath, n14++, area);
                            }
                            ++n15;
                            ++n17;
                        }
                        n += nArray[i];
                    }
                } else if (geometryStripArray instanceof TriangleFanArray) {
                    int n18 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        int n19 = n + nArray[i] - 2;
                        for (int j = n; j < n19; ++j) {
                            this.addTriangleToPath((GeometryArray)geometryStripArray, n, j + 1, j + 2, fArray, generalPath, n18++, area);
                        }
                        n += nArray[i];
                    }
                }
            }
            if (generalPath != null) {
                area.add(new Area(generalPath));
            }
        }
    }

    private void addIndexedTriangleToPath(IndexedGeometryArray indexedGeometryArray, int n, int n2, int n3, float[] fArray, GeneralPath generalPath, int n4, Area area) {
        this.addTriangleToPath((GeometryArray)indexedGeometryArray, indexedGeometryArray.getCoordinateIndex(n), indexedGeometryArray.getCoordinateIndex(n2), indexedGeometryArray.getCoordinateIndex(n3), fArray, generalPath, n4, area);
    }

    private void addIndexedQuadrilateralToPath(IndexedGeometryArray indexedGeometryArray, int n, int n2, int n3, int n4, float[] fArray, GeneralPath generalPath, int n5, Area area) {
        this.addQuadrilateralToPath((GeometryArray)indexedGeometryArray, indexedGeometryArray.getCoordinateIndex(n), indexedGeometryArray.getCoordinateIndex(n2), indexedGeometryArray.getCoordinateIndex(n3), indexedGeometryArray.getCoordinateIndex(n4), fArray, generalPath, n5, area);
    }

    private void addTriangleToPath(GeometryArray geometryArray, int n, int n2, int n3, float[] fArray, GeneralPath generalPath, int n4, Area area) {
        float f = fArray[2 * n2];
        float f2 = fArray[2 * n];
        float f3 = fArray[2 * n3 + 1];
        float f4 = fArray[2 * n2 + 1];
        float f5 = fArray[2 * n + 1];
        float f6 = fArray[2 * n3];
        if ((f - f2) * (f3 - f4) - (f4 - f5) * (f6 - f) > 0.0f) {
            if (n4 > 0 && n4 % 1000 == 0) {
                area.add(new Area(generalPath));
                generalPath.reset();
            }
            generalPath.moveTo(f2, f5);
            generalPath.lineTo(f, f4);
            generalPath.lineTo(f6, f3);
            generalPath.closePath();
        }
    }

    private void addQuadrilateralToPath(GeometryArray geometryArray, int n, int n2, int n3, int n4, float[] fArray, GeneralPath generalPath, int n5, Area area) {
        float f = fArray[2 * n2];
        float f2 = fArray[2 * n];
        float f3 = fArray[2 * n3 + 1];
        float f4 = fArray[2 * n2 + 1];
        float f5 = fArray[2 * n + 1];
        float f6 = fArray[2 * n3];
        if ((f - f2) * (f3 - f4) - (f4 - f5) * (f6 - f) > 0.0f) {
            if (n5 > 0 && n5 % 1000 == 0) {
                area.add(new Area(generalPath));
                generalPath.reset();
            }
            generalPath.moveTo(f2, f5);
            generalPath.lineTo(f, f4);
            generalPath.lineTo(f6, f3);
            generalPath.lineTo(fArray[2 * n4], fArray[2 * n4 + 1]);
            generalPath.closePath();
        }
    }

    private void computeVerticesOnFloor(Node node, List<float[]> list, Transform3D transform3D) {
        block10: {
            TransparencyAttributes transparencyAttributes;
            block11: {
                block9: {
                    Enumeration enumeration;
                    if (!(node instanceof Group)) break block9;
                    if (node instanceof TransformGroup) {
                        transform3D = new Transform3D(transform3D);
                        enumeration = new Transform3D();
                        ((TransformGroup)node).getTransform((Transform3D)enumeration);
                        transform3D.mul((Transform3D)enumeration);
                    }
                    enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.computeVerticesOnFloor((Node)enumeration.nextElement(), list, transform3D);
                    }
                    break block10;
                }
                if (!(node instanceof Link)) break block11;
                this.computeVerticesOnFloor((Node)((Link)node).getSharedGroup(), list, transform3D);
                break block10;
            }
            if (!(node instanceof Shape3D)) break block10;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            RenderingAttributes renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            TransparencyAttributes transparencyAttributes2 = transparencyAttributes = appearance != null ? appearance.getTransparencyAttributes() : null;
            if ((renderingAttributes == null || renderingAttributes.getVisible()) && (transparencyAttributes == null || transparencyAttributes.getTransparency() < 1.0f)) {
                int n = shape3D.numGeometries();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    Geometry geometry = shape3D.getGeometry(i);
                    if (!(geometry instanceof GeometryArray)) continue;
                    GeometryArray geometryArray = (GeometryArray)geometry;
                    int n3 = geometryArray.getVertexCount();
                    Point3f point3f = new Point3f();
                    if ((geometryArray.getVertexFormat() & 0x80) != 0) {
                        int n4;
                        if ((geometryArray.getVertexFormat() & 0x100) != 0) {
                            float[] fArray = geometryArray.getInterleavedVertices();
                            n2 = fArray.length / n3;
                            int n5 = n2 - 3;
                            for (n4 = 0; n4 < n3; ++n4) {
                                point3f.x = fArray[n5];
                                point3f.y = fArray[n5 + 1];
                                point3f.z = fArray[n5 + 2];
                                transform3D.transform(point3f);
                                list.add(new float[]{point3f.x, point3f.z});
                                n5 += n2;
                            }
                            continue;
                        }
                        float[] fArray = geometryArray.getCoordRefFloat();
                        n4 = 0;
                        for (n2 = 0; n2 < n3; ++n2) {
                            point3f.x = fArray[n4];
                            point3f.y = fArray[n4 + 1];
                            point3f.z = fArray[n4 + 2];
                            transform3D.transform(point3f);
                            list.add(new float[]{point3f.x, point3f.z});
                            n4 += 3;
                        }
                        continue;
                    }
                    n2 = 0;
                    for (int j = 0; j < n3; ++j) {
                        geometryArray.getCoordinate(n2, point3f);
                        transform3D.transform(point3f);
                        list.add(new float[]{point3f.x, point3f.z});
                        ++n2;
                    }
                }
            }
        }
    }

    private float[][] getSurroundingPolygon(float[][] fArray) {
        int n;
        Arrays.sort(fArray, new Comparator<float[]>(){

            @Override
            public int compare(float[] fArray, float[] fArray2) {
                if (fArray[0] == fArray2[0]) {
                    return (int)Math.signum(fArray2[1] - fArray[1]);
                }
                return (int)Math.signum(fArray2[0] - fArray[0]);
            }
        });
        float[][] fArrayArray = new float[fArray.length][];
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        float f = fArray[0][0];
        for (n = 1; n < fArray.length && fArray[n][0] == f; ++n) {
        }
        int n5 = n - 1;
        if (n5 == fArray.length - 1) {
            fArrayArray[++n3] = fArray[n4];
            if (fArray[n5][1] != fArray[n4][1]) {
                fArrayArray[++n3] = fArray[n5];
            }
            fArrayArray[++n3] = fArray[n4];
            float[][] fArrayArray2 = new float[n3 + 1][];
            System.arraycopy(fArrayArray, 0, fArrayArray2, 0, fArrayArray2.length);
            return fArrayArray2;
        }
        int n6 = fArray.length - 1;
        float f2 = fArray[fArray.length - 1][0];
        for (n = fArray.length - 2; n >= 0 && fArray[n][0] == f2; --n) {
        }
        int n7 = n + 1;
        fArrayArray[++n3] = fArray[n4];
        n = n5;
        while (++n <= n7) {
            if (this.isLeft(fArray[n4], fArray[n7], fArray[n]) >= 0.0f && n < n7) continue;
            while (n3 > 0 && !(this.isLeft(fArrayArray[n3 - 1], fArrayArray[n3], fArray[n]) > 0.0f)) {
                --n3;
            }
            fArrayArray[++n3] = fArray[n];
        }
        if (n6 != n7) {
            fArrayArray[++n3] = fArray[n6];
        }
        n2 = n3;
        n = n7;
        while (--n >= n5) {
            if (this.isLeft(fArray[n6], fArray[n5], fArray[n]) >= 0.0f && n > n5) continue;
            while (n3 > n2 && !(this.isLeft(fArrayArray[n3 - 1], fArrayArray[n3], fArray[n]) > 0.0f)) {
                --n3;
            }
            fArrayArray[++n3] = fArray[n];
        }
        if (n5 != n4) {
            fArrayArray[++n3] = fArray[n4];
        }
        float[][] fArrayArray3 = new float[n3 + 1][];
        System.arraycopy(fArrayArray, 0, fArrayArray3, 0, fArrayArray3.length);
        return fArrayArray3;
    }

    private float isLeft(float[] fArray, float[] fArray2, float[] fArray3) {
        return (fArray2[0] - fArray[0]) * (fArray3[1] - fArray[1]) - (fArray3[0] - fArray[0]) * (fArray2[1] - fArray[1]);
    }

    public Area getAreaOnFloor(HomePieceOfFurniture homePieceOfFurniture) {
        if (homePieceOfFurniture.getStaircaseCutOutShape() == null) {
            throw new IllegalArgumentException("No cut out shape associated to piece");
        }
        Shape shape = this.getShape(homePieceOfFurniture.getStaircaseCutOutShape());
        Area area = new Area(shape);
        if (homePieceOfFurniture.isModelMirrored()) {
            area = this.getMirroredArea(area);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(homePieceOfFurniture.getX() - homePieceOfFurniture.getWidth() / 2.0f, homePieceOfFurniture.getY() - homePieceOfFurniture.getDepth() / 2.0f);
        affineTransform.concatenate(AffineTransform.getRotateInstance(homePieceOfFurniture.getAngle(), homePieceOfFurniture.getWidth() / 2.0f, homePieceOfFurniture.getDepth() / 2.0f));
        affineTransform.concatenate(AffineTransform.getScaleInstance(homePieceOfFurniture.getWidth(), homePieceOfFurniture.getDepth()));
        area.transform(affineTransform);
        return area;
    }

    private Area getMirroredArea(Area area) {
        GeneralPath generalPath = new GeneralPath();
        float[] fArray = new float[6];
        PathIterator pathIterator = area.getPathIterator(null);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    generalPath.moveTo(1.0f - fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    generalPath.lineTo(1.0f - fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    generalPath.quadTo(1.0f - fArray[0], fArray[1], 1.0f - fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    generalPath.curveTo(1.0f - fArray[0], fArray[1], 1.0f - fArray[2], fArray[3], 1.0f - fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    generalPath.closePath();
                }
            }
            pathIterator.next();
        }
        return new Area(generalPath);
    }

    public Shape getShape(String string) {
        return ShapeTools.getShape(string);
    }

    public static interface ModelObserver {
        public void modelUpdated(BranchGroup var1);

        public void modelError(Exception var1);
    }
}

