/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.lw3d.LwoSurface;
import com.sun.j3d.loaders.lw3d.ParserObject;
import java.util.Vector;
import javax.vecmath.Vector3f;

class ShapeHolder
extends ParserObject {
    Vector facetSizesList;
    Vector facetIndicesList;
    int[] facetIndicesArray;
    int currentNumIndices = 0;
    int numSurf;
    int numVerts;
    int[] facetIndices;
    int[] facetSizes;
    int[] normalIndices;
    float[] normalCoords;
    float[] coordsArray;

    ShapeHolder() {
    }

    ShapeHolder(int n) {
        super(n);
    }

    void printGeometryData(LwoSurface lwoSurface) {
        int n = 0;
        System.out.println("\nPolygon Data:");
        System.out.println("  Surface color = " + lwoSurface.color);
        System.out.println("  Surface diffuse = " + lwoSurface.diffuseColor);
        for (int i = 0; i < this.facetSizes.length; ++i) {
            int n2 = this.facetSizes[i];
            System.out.println("Facet of size " + n2);
            for (int j = 0; j < n2; ++j) {
                int n3 = 3 * this.facetIndices[n++];
                System.out.println("x, y, z = " + this.coordsArray[n3] + ", " + this.coordsArray[n3 + 1] + ", " + this.coordsArray[n3 + 2]);
            }
        }
    }

    void createArrays(boolean bl) {
        int n;
        int n2;
        int n3;
        this.debugOutputLn(1, "createArrays()");
        this.facetIndices = new int[this.currentNumIndices];
        if (bl) {
            n3 = 0;
            for (n2 = 0; n2 < this.facetSizesList.size(); ++n2) {
                n = (Integer)this.facetSizesList.elementAt(n2);
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.facetIndices[n3 + i] = this.facetIndicesArray[n3 + n - i - 1];
                }
                n3 += n;
            }
        } else {
            for (n3 = 0; n3 < this.facetIndices.length; ++n3) {
                this.facetIndices[n3] = this.facetIndicesArray[n3];
            }
        }
        this.debugOutputLn(8, "facetIndices.len and coordsArray.len = " + this.facetIndices.length + ", " + this.coordsArray.length);
        if ((Integer)this.facetSizesList.elementAt(0) < 3) {
            this.debugOutputLn(8, "Using direct geometry because facetIndices is of size " + this.facetIndices.length + " and coordsArray is of length " + this.coordsArray.length);
            float[] fArray = new float[this.facetIndices.length * 3];
            n2 = 0;
            for (n = 0; n < this.facetIndices.length; ++n) {
                fArray[n2++] = this.coordsArray[this.facetIndices[n] * 3];
                fArray[n2++] = this.coordsArray[this.facetIndices[n] * 3 + 1];
                fArray[n2++] = this.coordsArray[this.facetIndices[n] * 3 + 2];
            }
            this.coordsArray = fArray;
            this.facetIndices = null;
        }
        this.facetSizes = new int[this.facetSizesList.size()];
        for (int i = 0; i < this.facetSizes.length; ++i) {
            this.facetSizes[i] = (Integer)this.facetSizesList.elementAt(i);
        }
        this.facetSizesList = null;
        this.facetIndicesList = null;
        this.facetIndicesArray = null;
    }

    void nullify() {
        this.facetSizesList = null;
        this.facetIndicesList = null;
        this.facetIndicesArray = null;
        this.facetSizes = null;
        this.facetIndices = null;
        this.normalCoords = null;
        this.normalIndices = null;
    }

    void calcNormals() {
        this.debugOutputLn(1, "calcNormals()");
        this.debugOutputLn(8, "coordsLength, facetsizes.len = " + this.coordsArray.length + ", " + this.facetSizes.length);
        if (this.facetSizes[0] > 2) {
            if (this.facetIndices != null) {
                this.normalIndices = new int[this.facetIndices.length];
                this.normalCoords = new float[this.facetIndices.length * 3];
            } else {
                this.normalCoords = new float[this.coordsArray.length];
            }
            this.debugOutputLn(8, "normalCoords, incides len = " + this.normalCoords.length + ", " + (this.facetIndices == null ? 0 : this.normalIndices.length));
            int n = 0;
            int n2 = -1;
            for (int i = 0; i < this.facetSizes.length; ++i) {
                Vector3f vector3f;
                int n3 = this.facetSizes[i];
                if (n3 < 3) {
                    vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
                } else {
                    int n4;
                    int n5;
                    int n6;
                    if (this.facetIndices != null) {
                        n6 = this.facetIndices[n];
                        n5 = this.facetIndices[n + 1];
                        n4 = this.facetIndices[n + 2];
                    } else {
                        n6 = n;
                        n5 = n + 1;
                        n4 = n + 2;
                    }
                    Vector3f vector3f2 = new Vector3f(this.coordsArray[n5 * 3] - this.coordsArray[n6 * 3], this.coordsArray[n5 * 3 + 1] - this.coordsArray[n6 * 3 + 1], this.coordsArray[n5 * 3 + 2] - this.coordsArray[n6 * 3 + 2]);
                    Vector3f vector3f3 = new Vector3f(this.coordsArray[n4 * 3] - this.coordsArray[n6 * 3], this.coordsArray[n4 * 3 + 1] - this.coordsArray[n6 * 3 + 1], this.coordsArray[n4 * 3 + 2] - this.coordsArray[n6 * 3 + 2]);
                    vector3f = new Vector3f();
                    vector3f.cross(vector3f2, vector3f3);
                    vector3f.normalize(vector3f);
                }
                for (int j = 0; j < n3; ++j) {
                    int n7 = n + j;
                    this.normalCoords[n7 * 3] = vector3f.x;
                    this.normalCoords[n7 * 3 + 1] = vector3f.y;
                    this.normalCoords[n7 * 3 + 2] = vector3f.z;
                    if (this.facetIndices == null) continue;
                    this.normalIndices[n7] = n7;
                }
                n += n3;
            }
        }
        this.debugOutputLn(1, "done with calcNormals()");
    }
}

