/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.BBox;
import com.sun.j3d.utils.geometry.Heap;
import com.sun.j3d.utils.geometry.NoHash;
import com.sun.j3d.utils.geometry.Numerics;
import com.sun.j3d.utils.geometry.Triangulator;

class EarClip {
    EarClip() {
    }

    static void classifyAngles(Triangulator triangulator, int n) {
        int n2;
        int n3 = n;
        int n4 = triangulator.fetchData(n3);
        int n5 = triangulator.fetchPrevData(n3);
        int n6 = triangulator.fetchData(n5);
        do {
            n2 = triangulator.fetchNextData(n3);
            int n7 = triangulator.fetchData(n2);
            int n8 = Numerics.isConvexAngle(triangulator, n6, n4, n7, n3);
            triangulator.setAngle(n3, n8);
            n6 = n4;
            n4 = n7;
        } while ((n3 = n2) != n);
    }

    static void classifyEars(Triangulator triangulator, int n) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        double[] dArray = new double[1];
        Heap.initHeap(triangulator);
        int n2 = n;
        int n3 = triangulator.fetchData(n2);
        do {
            if (triangulator.getAngle(n2) > 0 && EarClip.isEar(triangulator, n2, nArray, nArray2, dArray)) {
                Heap.dumpOnHeap(triangulator, dArray[0], n2, nArray[0], nArray2[0]);
            }
            n2 = triangulator.fetchNextData(n2);
            n3 = triangulator.fetchData(n2);
        } while (n2 != n);
    }

    static boolean isEar(Triangulator triangulator, int n, int[] nArray, int[] nArray2, double[] dArray) {
        BBox bBox;
        int n2 = triangulator.fetchData(n);
        nArray2[0] = triangulator.fetchNextData(n);
        int n3 = triangulator.fetchData(nArray2[0]);
        int n4 = triangulator.fetchNextData(nArray2[0]);
        int n5 = triangulator.fetchData(n4);
        nArray[0] = triangulator.fetchPrevData(n);
        int n6 = triangulator.fetchData(nArray[0]);
        int n7 = triangulator.fetchPrevData(nArray[0]);
        int n8 = triangulator.fetchData(n7);
        if (n6 == n3 || n6 == n2 || n2 == n3 || triangulator.getAngle(n) == 2) {
            dArray[0] = 0.0;
            return true;
        }
        if (n8 == n3) {
            if (triangulator.getAngle(n7) < 0 || triangulator.getAngle(nArray2[0]) < 0) {
                dArray[0] = 0.0;
                return true;
            }
            return false;
        }
        if (n6 == n5) {
            if (triangulator.getAngle(nArray[0]) < 0 || triangulator.getAngle(n4) < 0) {
                dArray[0] = 0.0;
                return true;
            }
            return false;
        }
        boolean bl = triangulator.getAngle(nArray[0]) > 0;
        boolean bl2 = Numerics.isInCone(triangulator, n8, n6, n2, n3, bl);
        if (!bl2) {
            return false;
        }
        bl = triangulator.getAngle(nArray2[0]) > 0;
        bl2 = Numerics.isInCone(triangulator, n2, n3, n5, n6, bl);
        if (bl2 && !NoHash.noHashIntersectionExists(triangulator, n2, n, n3, n6, bBox = new BBox(triangulator, n6, n3))) {
            dArray[0] = triangulator.earsSorted ? Numerics.getRatio(triangulator, n6, n3, n2) : 1.0;
            return true;
        }
        return false;
    }

    static boolean clipEar(Triangulator triangulator, boolean[] blArray) {
        int n;
        int n2;
        int n3;
        int n4;
        double[] dArray = new double[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        boolean bl = false;
        do {
            if (!Heap.deleteFromHeap(triangulator, nArray6, nArray2, nArray4)) {
                return false;
            }
            n4 = triangulator.fetchPrevData(nArray6[0]);
            n2 = triangulator.fetchData(n4);
            n3 = triangulator.fetchNextData(nArray6[0]);
            n = triangulator.fetchData(n3);
        } while (nArray2[0] != n4 || nArray4[0] != n3);
        int n5 = triangulator.fetchData(nArray6[0]);
        triangulator.deleteLinks(nArray6[0]);
        triangulator.storeTriangle(n4, nArray6[0], n3);
        int n6 = triangulator.fetchPrevData(n4);
        int n7 = triangulator.fetchData(n6);
        if (n6 == n3) {
            blArray[0] = true;
            return true;
        }
        int n8 = Numerics.isConvexAngle(triangulator, n7, n2, n, n4);
        int n9 = triangulator.fetchNextData(n3);
        int n10 = triangulator.fetchData(n9);
        int n11 = Numerics.isConvexAngle(triangulator, n2, n, n10, n3);
        if (n2 != n) {
            if (n8 >= 0 && triangulator.getAngle(n4) < 0) {
                NoHash.deleteReflexVertex(triangulator, n4);
            }
            if (n11 >= 0 && triangulator.getAngle(n3) < 0) {
                NoHash.deleteReflexVertex(triangulator, n3);
            }
        } else if (n8 >= 0 && triangulator.getAngle(n4) < 0) {
            NoHash.deleteReflexVertex(triangulator, n4);
        } else if (n11 >= 0 && triangulator.getAngle(n3) < 0) {
            NoHash.deleteReflexVertex(triangulator, n3);
        }
        triangulator.setAngle(n4, n8);
        triangulator.setAngle(n3, n11);
        if (n8 > 0 && EarClip.isEar(triangulator, n4, nArray, nArray3, dArray)) {
            Heap.insertIntoHeap(triangulator, dArray[0], n4, nArray[0], nArray3[0]);
        }
        if (n11 > 0 && EarClip.isEar(triangulator, n3, nArray3, nArray5, dArray)) {
            Heap.insertIntoHeap(triangulator, dArray[0], n3, nArray3[0], nArray5[0]);
        }
        n6 = triangulator.fetchPrevData(n4);
        n7 = triangulator.fetchData(n6);
        n9 = triangulator.fetchNextData(n3);
        n10 = triangulator.fetchData(n9);
        if (n6 == n9) {
            triangulator.storeTriangle(n4, n3, n9);
            blArray[0] = true;
        } else {
            blArray[0] = false;
        }
        return true;
    }
}

