/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.wls.shaded.org.apache.bcel.verifier.statics;

import com.oracle.wls.shaded.org.apache.bcel.generic.Type;
import com.oracle.wls.shaded.org.apache.bcel.verifier.exc.AssertionViolatedException;
import com.oracle.wls.shaded.org.apache.bcel.verifier.exc.LocalVariableInfoInconsistentException;
import com.oracle.wls.shaded.org.apache.bcel.verifier.statics.DOUBLE_Upper;
import com.oracle.wls.shaded.org.apache.bcel.verifier.statics.IntList;
import com.oracle.wls.shaded.org.apache.bcel.verifier.statics.LONG_Upper;
import com.oracle.wls.shaded.org.apache.bcel.verifier.statics.LocalVariableInfo;

public class LocalVariablesInfo {
    private LocalVariableInfo[] localVariableInfos;
    private IntList instruction_offsets = new IntList();

    LocalVariablesInfo(int max_locals) {
        this.localVariableInfos = new LocalVariableInfo[max_locals];
        int i = 0;
        while (i < max_locals) {
            this.localVariableInfos[i] = new LocalVariableInfo();
            ++i;
        }
    }

    public LocalVariableInfo getLocalVariableInfo(int slot) {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        return this.localVariableInfos[slot];
    }

    public void add(int slot, String name, int startpc, int length, Type t) throws LocalVariableInfoInconsistentException {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        this.localVariableInfos[slot].add(name, startpc, length, t);
        if (t == Type.LONG) {
            this.localVariableInfos[slot + 1].add(name, startpc, length, LONG_Upper.theInstance());
        }
        if (t == Type.DOUBLE) {
            this.localVariableInfos[slot + 1].add(name, startpc, length, DOUBLE_Upper.theInstance());
        }
    }
}

