/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileSwitchWithDiamonds;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class FtileSwitchWithOneLink
extends FtileSwitchWithDiamonds {
    private final Rainbow arrowColor;

    public FtileSwitchWithOneLink(List<Ftile> tiles, List<Branch> branches, Swimlane in, Ftile diamond1, Ftile diamond2, StringBounder stringBounder, Rainbow arrowColor) {
        super(tiles, branches, in, diamond1, diamond2, stringBounder);
        this.arrowColor = arrowColor;
    }

    public Ftile addLinks(StringBounder stringBounder) {
        ArrayList<Connection> conns = new ArrayList<Connection>();
        Ftile single = (Ftile)this.tiles.get(0);
        conns.add(new ConnectionVerticalTop(single, (Branch)this.branches.get(0)));
        if (single.calculateDimension(stringBounder).hasPointOut()) {
            conns.add(new ConnectionVerticalBottom(single));
        }
        return FtileUtils.addConnection((Ftile)this, conns);
    }

    class ConnectionVerticalBottom
    extends AbstractConnection {
        public ConnectionVerticalBottom(Ftile tile) {
            super(tile, FtileSwitchWithOneLink.this.diamond2);
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = Snake.create(FtileSwitchWithOneLink.this.skinParam(), FtileSwitchWithOneLink.this.arrowColor, FtileSwitchWithOneLink.this.skinParam().arrows().asToDown());
            snake.addPoint(x2, y1);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            return FtileSwitchWithOneLink.this.getTranslateOf(this.getFtile1(), stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            FtileGeometry dimDiamond2 = FtileSwitchWithOneLink.this.diamond2.calculateDimension(stringBounder);
            return FtileSwitchWithOneLink.this.getTranslateDiamond2(stringBounder).getTranslated(dimDiamond2.getPointA());
        }
    }

    class ConnectionVerticalTop
    extends AbstractConnection {
        private final Branch branch;

        public ConnectionVerticalTop(Ftile tile, Branch branch) {
            super(FtileSwitchWithOneLink.this.diamond1, tile);
            this.branch = branch;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            Snake snake = Snake.create(FtileSwitchWithOneLink.this.skinParam(), FtileSwitchWithOneLink.this.arrowColor, FtileSwitchWithOneLink.this.skinParam().arrows().asToDown()).withLabel(this.branch.getTextBlockPositive(), this.arrowHorizontalAlignment());
            snake.addPoint(x2, y1);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = FtileSwitchWithOneLink.this.diamond1.calculateDimension(stringBounder);
            return FtileSwitchWithOneLink.this.getTranslateDiamond1(stringBounder).getTranslated(dimDiamond1.getPointC());
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            return FtileSwitchWithOneLink.this.getTranslateOf(this.getFtile2(), stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }
    }
}

