# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.sql_database import SQLDatabase


class MySQLDatabase(SQLDatabase):
    """
    MySQLDatabase - maintain a connection to a my_sql database
    
    Superclass: SQLDatabase
    
    This class provides a VTK interface to my_sql (http://www.mysql.com). 
    Unlike file-based databases like SQLite, you talk to my_sql through a
    client/server connection.  You must specify the hostname, (optional)
    port to connect to, username, password and database name in order to
    connect.
    
    @sa
    MySQLQuery
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMySQLDatabase, obj, update, **traits)
    
    reconnect = tvtk_base.true_bool_trait(desc=\
        """
        Should automatic reconnection be enabled? This defaults to true.
        If you change its value, you must do so before any call to
        Open().
        """
    )

    def _reconnect_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReconnect,
                        self.reconnect_)

    database_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        The name of the database to connect to.
        """
    )

    def _database_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDatabaseName,
                        self.database_name)

    host_name = traits.String('localhost', enter_set=True, auto_set=False, desc=\
        """
        The database server host name.
        """
    )

    def _host_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHostName,
                        self.host_name)

    server_port = traits.Trait(3306, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        The port used for connecting to the database.
        """
    )

    def _server_port_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetServerPort,
                        self.server_port)

    user = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        The user name for connecting to the database server.
        """
    )

    def _user_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUser,
                        self.user)

    def create_database(self, *args):
        """
        V.create_database(string, bool) -> bool
        C++: bool CreateDatabase(const char *dbName, bool dropExisting)
        Create a new database, optionally dropping any existing database
        of the same name. Returns true when the database is properly
        created and false on failure.
        """
        ret = self._wrap_call(self._vtk_obj.CreateDatabase, *args)
        return ret

    def drop_database(self, *args):
        """
        V.drop_database(string) -> bool
        C++: bool DropDatabase(const char *dbName)
        Drop a database if it exists. Returns true on success and false
        on failure.
        """
        ret = self._wrap_call(self._vtk_obj.DropDatabase, *args)
        return ret

    def parse_url(self, *args):
        """
        V.parse_url(string) -> bool
        
        Overridden to determine connection parameters given the URL. This
        is called by create_from_url() to initialize the instance. Look at
        create_from_url() for details about the URL format.
        """
        ret = self._wrap_call(self._vtk_obj.ParseURL, *args)
        return ret

    def set_password(self, *args):
        """
        V.set_password(string)
        C++: virtual void SetPassword(const char *_arg)
        The user's password for connecting to the database server.
        """
        ret = self._wrap_call(self._vtk_obj.SetPassword, *args)
        return ret

    _updateable_traits_ = \
    (('reconnect', 'GetReconnect'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('database_name', 'GetDatabaseName'), ('host_name', 'GetHostName'),
    ('server_port', 'GetServerPort'), ('user', 'GetUser'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'reconnect', 'database_name',
    'host_name', 'server_port', 'user'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MySQLDatabase, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MySQLDatabase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['reconnect'], [], ['database_name', 'host_name', 'server_port',
            'user']),
            title='Edit MySQLDatabase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MySQLDatabase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

