test("basic functionality", () => {
    const vals = [
        1,
        2,
        1.23,
        2.34567,
        1n,
        2n,
        [],
        [1],
        [2],
        [1, 2],
        "foo",
        "fooo",
        "🔥",
        "❤️",
        "bar",
        {},
        { a: 1 },
        { a: 2 },
        { b: 1 },
        true,
        false,
        undefined,
        null,
        NaN,
        +Infinity,
        -Infinity,
    ];

    // Each row contains: xIndex, yIndex, (x < y), (x > y), (x <= y), (x >= y)
    // where x = vals[xIndex], y = vals[yIndex]
    // Table can be generated using a mature engine and the following code:
    // for (var xIndex = 0; xIndex < vals.length; ++xIndex) {
    //     for (var yIndex = 0; yIndex < vals.length; ++yIndex) {
    //         var x = vals[xIndex];
    //         var y = vals[yIndex];
    //         console.log(`[${xIndex}, ${yIndex}, ${x < y}, ${x > y}, ${x <= y}, ${x >= y}]`);
    //     }
    // }
    const table = [
        [0, 0, false, false, true, true],
        [0, 1, true, false, true, false],
        [0, 2, true, false, true, false],
        [0, 3, true, false, true, false],
        [0, 4, false, false, true, true],
        [0, 5, true, false, true, false],
        [0, 6, false, true, false, true],
        [0, 7, false, false, true, true],
        [0, 8, true, false, true, false],
        [0, 9, false, false, false, false],
        [0, 10, false, false, false, false],
        [0, 11, false, false, false, false],
        [0, 12, false, false, false, false],
        [0, 13, false, false, false, false],
        [0, 14, false, false, false, false],
        [0, 15, false, false, false, false],
        [0, 16, false, false, false, false],
        [0, 17, false, false, false, false],
        [0, 18, false, false, false, false],
        [0, 19, false, false, true, true],
        [0, 20, false, true, false, true],
        [0, 21, false, false, false, false],
        [0, 22, false, true, false, true],
        [0, 23, false, false, false, false],
        [0, 24, true, false, true, false],
        [0, 25, false, true, false, true],
        [1, 0, false, true, false, true],
        [1, 1, false, false, true, true],
        [1, 2, false, true, false, true],
        [1, 3, true, false, true, false],
        [1, 4, false, true, false, true],
        [1, 5, false, false, true, true],
        [1, 6, false, true, false, true],
        [1, 7, false, true, false, true],
        [1, 8, false, false, true, true],
        [1, 9, false, false, false, false],
        [1, 10, false, false, false, false],
        [1, 11, false, false, false, false],
        [1, 12, false, false, false, false],
        [1, 13, false, false, false, false],
        [1, 14, false, false, false, false],
        [1, 15, false, false, false, false],
        [1, 16, false, false, false, false],
        [1, 17, false, false, false, false],
        [1, 18, false, false, false, false],
        [1, 19, false, true, false, true],
        [1, 20, false, true, false, true],
        [1, 21, false, false, false, false],
        [1, 22, false, true, false, true],
        [1, 23, false, false, false, false],
        [1, 24, true, false, true, false],
        [1, 25, false, true, false, true],
        [2, 0, false, true, false, true],
        [2, 1, true, false, true, false],
        [2, 2, false, false, true, true],
        [2, 3, true, false, true, false],
        [2, 4, false, true, false, true],
        [2, 5, true, false, true, false],
        [2, 6, false, true, false, true],
        [2, 7, false, true, false, true],
        [2, 8, true, false, true, false],
        [2, 9, false, false, false, false],
        [2, 10, false, false, false, false],
        [2, 11, false, false, false, false],
        [2, 12, false, false, false, false],
        [2, 13, false, false, false, false],
        [2, 14, false, false, false, false],
        [2, 15, false, false, false, false],
        [2, 16, false, false, false, false],
        [2, 17, false, false, false, false],
        [2, 18, false, false, false, false],
        [2, 19, false, true, false, true],
        [2, 20, false, true, false, true],
        [2, 21, false, false, false, false],
        [2, 22, false, true, false, true],
        [2, 23, false, false, false, false],
        [2, 24, true, false, true, false],
        [2, 25, false, true, false, true],
        [3, 0, false, true, false, true],
        [3, 1, false, true, false, true],
        [3, 2, false, true, false, true],
        [3, 3, false, false, true, true],
        [3, 4, false, true, false, true],
        [3, 5, false, true, false, true],
        [3, 6, false, true, false, true],
        [3, 7, false, true, false, true],
        [3, 8, false, true, false, true],
        [3, 9, false, false, false, false],
        [3, 10, false, false, false, false],
        [3, 11, false, false, false, false],
        [3, 12, false, false, false, false],
        [3, 13, false, false, false, false],
        [3, 14, false, false, false, false],
        [3, 15, false, false, false, false],
        [3, 16, false, false, false, false],
        [3, 17, false, false, false, false],
        [3, 18, false, false, false, false],
        [3, 19, false, true, false, true],
        [3, 20, false, true, false, true],
        [3, 21, false, false, false, false],
        [3, 22, false, true, false, true],
        [3, 23, false, false, false, false],
        [3, 24, true, false, true, false],
        [3, 25, false, true, false, true],
        [4, 0, false, false, true, true],
        [4, 1, true, false, true, false],
        [4, 2, true, false, true, false],
        [4, 3, true, false, true, false],
        [4, 4, false, false, true, true],
        [4, 5, true, false, true, false],
        [4, 6, false, true, false, true],
        [4, 7, false, false, true, true],
        [4, 8, true, false, true, false],
        [4, 9, false, false, false, false],
        [4, 10, false, false, false, false],
        [4, 11, false, false, false, false],
        [4, 12, false, false, false, false],
        [4, 13, false, false, false, false],
        [4, 14, false, false, false, false],
        [4, 15, false, false, false, false],
        [4, 16, false, false, false, false],
        [4, 17, false, false, false, false],
        [4, 18, false, false, false, false],
        [4, 19, false, false, true, true],
        [4, 20, false, true, false, true],
        [4, 21, false, false, false, false],
        [4, 22, false, true, false, true],
        [4, 23, false, false, false, false],
        [4, 24, true, false, true, false],
        [4, 25, false, true, false, true],
        [5, 0, false, true, false, true],
        [5, 1, false, false, true, true],
        [5, 2, false, true, false, true],
        [5, 3, true, false, true, false],
        [5, 4, false, true, false, true],
        [5, 5, false, false, true, true],
        [5, 6, false, true, false, true],
        [5, 7, false, true, false, true],
        [5, 8, false, false, true, true],
        [5, 9, false, false, false, false],
        [5, 10, false, false, false, false],
        [5, 11, false, false, false, false],
        [5, 12, false, false, false, false],
        [5, 13, false, false, false, false],
        [5, 14, false, false, false, false],
        [5, 15, false, false, false, false],
        [5, 16, false, false, false, false],
        [5, 17, false, false, false, false],
        [5, 18, false, false, false, false],
        [5, 19, false, true, false, true],
        [5, 20, false, true, false, true],
        [5, 21, false, false, false, false],
        [5, 22, false, true, false, true],
        [5, 23, false, false, false, false],
        [5, 24, true, false, true, false],
        [5, 25, false, true, false, true],
        [6, 0, true, false, true, false],
        [6, 1, true, false, true, false],
        [6, 2, true, false, true, false],
        [6, 3, true, false, true, false],
        [6, 4, true, false, true, false],
        [6, 5, true, false, true, false],
        [6, 6, false, false, true, true],
        [6, 7, true, false, true, false],
        [6, 8, true, false, true, false],
        [6, 9, true, false, true, false],
        [6, 10, true, false, true, false],
        [6, 11, true, false, true, false],
        [6, 12, true, false, true, false],
        [6, 13, true, false, true, false],
        [6, 14, true, false, true, false],
        [6, 15, true, false, true, false],
        [6, 16, true, false, true, false],
        [6, 17, true, false, true, false],
        [6, 18, true, false, true, false],
        [6, 19, true, false, true, false],
        [6, 20, false, false, true, true],
        [6, 21, false, false, false, false],
        [6, 22, false, false, true, true],
        [6, 23, false, false, false, false],
        [6, 24, true, false, true, false],
        [6, 25, false, true, false, true],
        [7, 0, false, false, true, true],
        [7, 1, true, false, true, false],
        [7, 2, true, false, true, false],
        [7, 3, true, false, true, false],
        [7, 4, false, false, true, true],
        [7, 5, true, false, true, false],
        [7, 6, false, true, false, true],
        [7, 7, false, false, true, true],
        [7, 8, true, false, true, false],
        [7, 9, true, false, true, false],
        [7, 10, true, false, true, false],
        [7, 11, true, false, true, false],
        [7, 12, true, false, true, false],
        [7, 13, true, false, true, false],
        [7, 14, true, false, true, false],
        [7, 15, true, false, true, false],
        [7, 16, true, false, true, false],
        [7, 17, true, false, true, false],
        [7, 18, true, false, true, false],
        [7, 19, false, false, true, true],
        [7, 20, false, true, false, true],
        [7, 21, false, false, false, false],
        [7, 22, false, true, false, true],
        [7, 23, false, false, false, false],
        [7, 24, true, false, true, false],
        [7, 25, false, true, false, true],
        [8, 0, false, true, false, true],
        [8, 1, false, false, true, true],
        [8, 2, false, true, false, true],
        [8, 3, true, false, true, false],
        [8, 4, false, true, false, true],
        [8, 5, false, false, true, true],
        [8, 6, false, true, false, true],
        [8, 7, false, true, false, true],
        [8, 8, false, false, true, true],
        [8, 9, false, true, false, true],
        [8, 10, true, false, true, false],
        [8, 11, true, false, true, false],
        [8, 12, true, false, true, false],
        [8, 13, true, false, true, false],
        [8, 14, true, false, true, false],
        [8, 15, true, false, true, false],
        [8, 16, true, false, true, false],
        [8, 17, true, false, true, false],
        [8, 18, true, false, true, false],
        [8, 19, false, true, false, true],
        [8, 20, false, true, false, true],
        [8, 21, false, false, false, false],
        [8, 22, false, true, false, true],
        [8, 23, false, false, false, false],
        [8, 24, true, false, true, false],
        [8, 25, false, true, false, true],
        [9, 0, false, false, false, false],
        [9, 1, false, false, false, false],
        [9, 2, false, false, false, false],
        [9, 3, false, false, false, false],
        [9, 4, false, false, false, false],
        [9, 5, false, false, false, false],
        [9, 6, false, true, false, true],
        [9, 7, false, true, false, true],
        [9, 8, true, false, true, false],
        [9, 9, false, false, true, true],
        [9, 10, true, false, true, false],
        [9, 11, true, false, true, false],
        [9, 12, true, false, true, false],
        [9, 13, true, false, true, false],
        [9, 14, true, false, true, false],
        [9, 15, true, false, true, false],
        [9, 16, true, false, true, false],
        [9, 17, true, false, true, false],
        [9, 18, true, false, true, false],
        [9, 19, false, false, false, false],
        [9, 20, false, false, false, false],
        [9, 21, false, false, false, false],
        [9, 22, false, false, false, false],
        [9, 23, false, false, false, false],
        [9, 24, false, false, false, false],
        [9, 25, false, false, false, false],
        [10, 0, false, false, false, false],
        [10, 1, false, false, false, false],
        [10, 2, false, false, false, false],
        [10, 3, false, false, false, false],
        [10, 4, false, false, false, false],
        [10, 5, false, false, false, false],
        [10, 6, false, true, false, true],
        [10, 7, false, true, false, true],
        [10, 8, false, true, false, true],
        [10, 9, false, true, false, true],
        [10, 10, false, false, true, true],
        [10, 11, true, false, true, false],
        [10, 12, true, false, true, false],
        [10, 13, true, false, true, false],
        [10, 14, false, true, false, true],
        [10, 15, false, true, false, true],
        [10, 16, false, true, false, true],
        [10, 17, false, true, false, true],
        [10, 18, false, true, false, true],
        [10, 19, false, false, false, false],
        [10, 20, false, false, false, false],
        [10, 21, false, false, false, false],
        [10, 22, false, false, false, false],
        [10, 23, false, false, false, false],
        [10, 24, false, false, false, false],
        [10, 25, false, false, false, false],
        [11, 0, false, false, false, false],
        [11, 1, false, false, false, false],
        [11, 2, false, false, false, false],
        [11, 3, false, false, false, false],
        [11, 4, false, false, false, false],
        [11, 5, false, false, false, false],
        [11, 6, false, true, false, true],
        [11, 7, false, true, false, true],
        [11, 8, false, true, false, true],
        [11, 9, false, true, false, true],
        [11, 10, false, true, false, true],
        [11, 11, false, false, true, true],
        [11, 12, true, false, true, false],
        [11, 13, true, false, true, false],
        [11, 14, false, true, false, true],
        [11, 15, false, true, false, true],
        [11, 16, false, true, false, true],
        [11, 17, false, true, false, true],
        [11, 18, false, true, false, true],
        [11, 19, false, false, false, false],
        [11, 20, false, false, false, false],
        [11, 21, false, false, false, false],
        [11, 22, false, false, false, false],
        [11, 23, false, false, false, false],
        [11, 24, false, false, false, false],
        [11, 25, false, false, false, false],
        [12, 0, false, false, false, false],
        [12, 1, false, false, false, false],
        [12, 2, false, false, false, false],
        [12, 3, false, false, false, false],
        [12, 4, false, false, false, false],
        [12, 5, false, false, false, false],
        [12, 6, false, true, false, true],
        [12, 7, false, true, false, true],
        [12, 8, false, true, false, true],
        [12, 9, false, true, false, true],
        [12, 10, false, true, false, true],
        [12, 11, false, true, false, true],
        [12, 12, false, false, true, true],
        [12, 13, false, true, false, true],
        [12, 14, false, true, false, true],
        [12, 15, false, true, false, true],
        [12, 16, false, true, false, true],
        [12, 17, false, true, false, true],
        [12, 18, false, true, false, true],
        [12, 19, false, false, false, false],
        [12, 20, false, false, false, false],
        [12, 21, false, false, false, false],
        [12, 22, false, false, false, false],
        [12, 23, false, false, false, false],
        [12, 24, false, false, false, false],
        [12, 25, false, false, false, false],
        [13, 0, false, false, false, false],
        [13, 1, false, false, false, false],
        [13, 2, false, false, false, false],
        [13, 3, false, false, false, false],
        [13, 4, false, false, false, false],
        [13, 5, false, false, false, false],
        [13, 6, false, true, false, true],
        [13, 7, false, true, false, true],
        [13, 8, false, true, false, true],
        [13, 9, false, true, false, true],
        [13, 10, false, true, false, true],
        [13, 11, false, true, false, true],
        [13, 12, true, false, true, false],
        [13, 13, false, false, true, true],
        [13, 14, false, true, false, true],
        [13, 15, false, true, false, true],
        [13, 16, false, true, false, true],
        [13, 17, false, true, false, true],
        [13, 18, false, true, false, true],
        [13, 19, false, false, false, false],
        [13, 20, false, false, false, false],
        [13, 21, false, false, false, false],
        [13, 22, false, false, false, false],
        [13, 23, false, false, false, false],
        [13, 24, false, false, false, false],
        [13, 25, false, false, false, false],
        [14, 0, false, false, false, false],
        [14, 1, false, false, false, false],
        [14, 2, false, false, false, false],
        [14, 3, false, false, false, false],
        [14, 4, false, false, false, false],
        [14, 5, false, false, false, false],
        [14, 6, false, true, false, true],
        [14, 7, false, true, false, true],
        [14, 8, false, true, false, true],
        [14, 9, false, true, false, true],
        [14, 10, true, false, true, false],
        [14, 11, true, false, true, false],
        [14, 12, true, false, true, false],
        [14, 13, true, false, true, false],
        [14, 14, false, false, true, true],
        [14, 15, false, true, false, true],
        [14, 16, false, true, false, true],
        [14, 17, false, true, false, true],
        [14, 18, false, true, false, true],
        [14, 19, false, false, false, false],
        [14, 20, false, false, false, false],
        [14, 21, false, false, false, false],
        [14, 22, false, false, false, false],
        [14, 23, false, false, false, false],
        [14, 24, false, false, false, false],
        [14, 25, false, false, false, false],
        [15, 0, false, false, false, false],
        [15, 1, false, false, false, false],
        [15, 2, false, false, false, false],
        [15, 3, false, false, false, false],
        [15, 4, false, false, false, false],
        [15, 5, false, false, false, false],
        [15, 6, false, true, false, true],
        [15, 7, false, true, false, true],
        [15, 8, false, true, false, true],
        [15, 9, false, true, false, true],
        [15, 10, true, false, true, false],
        [15, 11, true, false, true, false],
        [15, 12, true, false, true, false],
        [15, 13, true, false, true, false],
        [15, 14, true, false, true, false],
        [15, 15, false, false, true, true],
        [15, 16, false, false, true, true],
        [15, 17, false, false, true, true],
        [15, 18, false, false, true, true],
        [15, 19, false, false, false, false],
        [15, 20, false, false, false, false],
        [15, 21, false, false, false, false],
        [15, 22, false, false, false, false],
        [15, 23, false, false, false, false],
        [15, 24, false, false, false, false],
        [15, 25, false, false, false, false],
        [16, 0, false, false, false, false],
        [16, 1, false, false, false, false],
        [16, 2, false, false, false, false],
        [16, 3, false, false, false, false],
        [16, 4, false, false, false, false],
        [16, 5, false, false, false, false],
        [16, 6, false, true, false, true],
        [16, 7, false, true, false, true],
        [16, 8, false, true, false, true],
        [16, 9, false, true, false, true],
        [16, 10, true, false, true, false],
        [16, 11, true, false, true, false],
        [16, 12, true, false, true, false],
        [16, 13, true, false, true, false],
        [16, 14, true, false, true, false],
        [16, 15, false, false, true, true],
        [16, 16, false, false, true, true],
        [16, 17, false, false, true, true],
        [16, 18, false, false, true, true],
        [16, 19, false, false, false, false],
        [16, 20, false, false, false, false],
        [16, 21, false, false, false, false],
        [16, 22, false, false, false, false],
        [16, 23, false, false, false, false],
        [16, 24, false, false, false, false],
        [16, 25, false, false, false, false],
        [17, 0, false, false, false, false],
        [17, 1, false, false, false, false],
        [17, 2, false, false, false, false],
        [17, 3, false, false, false, false],
        [17, 4, false, false, false, false],
        [17, 5, false, false, false, false],
        [17, 6, false, true, false, true],
        [17, 7, false, true, false, true],
        [17, 8, false, true, false, true],
        [17, 9, false, true, false, true],
        [17, 10, true, false, true, false],
        [17, 11, true, false, true, false],
        [17, 12, true, false, true, false],
        [17, 13, true, false, true, false],
        [17, 14, true, false, true, false],
        [17, 15, false, false, true, true],
        [17, 16, false, false, true, true],
        [17, 17, false, false, true, true],
        [17, 18, false, false, true, true],
        [17, 19, false, false, false, false],
        [17, 20, false, false, false, false],
        [17, 21, false, false, false, false],
        [17, 22, false, false, false, false],
        [17, 23, false, false, false, false],
        [17, 24, false, false, false, false],
        [17, 25, false, false, false, false],
        [18, 0, false, false, false, false],
        [18, 1, false, false, false, false],
        [18, 2, false, false, false, false],
        [18, 3, false, false, false, false],
        [18, 4, false, false, false, false],
        [18, 5, false, false, false, false],
        [18, 6, false, true, false, true],
        [18, 7, false, true, false, true],
        [18, 8, false, true, false, true],
        [18, 9, false, true, false, true],
        [18, 10, true, false, true, false],
        [18, 11, true, false, true, false],
        [18, 12, true, false, true, false],
        [18, 13, true, false, true, false],
        [18, 14, true, false, true, false],
        [18, 15, false, false, true, true],
        [18, 16, false, false, true, true],
        [18, 17, false, false, true, true],
        [18, 18, false, false, true, true],
        [18, 19, false, false, false, false],
        [18, 20, false, false, false, false],
        [18, 21, false, false, false, false],
        [18, 22, false, false, false, false],
        [18, 23, false, false, false, false],
        [18, 24, false, false, false, false],
        [18, 25, false, false, false, false],
        [19, 0, false, false, true, true],
        [19, 1, true, false, true, false],
        [19, 2, true, false, true, false],
        [19, 3, true, false, true, false],
        [19, 4, false, false, true, true],
        [19, 5, true, false, true, false],
        [19, 6, false, true, false, true],
        [19, 7, false, false, true, true],
        [19, 8, true, false, true, false],
        [19, 9, false, false, false, false],
        [19, 10, false, false, false, false],
        [19, 11, false, false, false, false],
        [19, 12, false, false, false, false],
        [19, 13, false, false, false, false],
        [19, 14, false, false, false, false],
        [19, 15, false, false, false, false],
        [19, 16, false, false, false, false],
        [19, 17, false, false, false, false],
        [19, 18, false, false, false, false],
        [19, 19, false, false, true, true],
        [19, 20, false, true, false, true],
        [19, 21, false, false, false, false],
        [19, 22, false, true, false, true],
        [19, 23, false, false, false, false],
        [19, 24, true, false, true, false],
        [19, 25, false, true, false, true],
        [20, 0, true, false, true, false],
        [20, 1, true, false, true, false],
        [20, 2, true, false, true, false],
        [20, 3, true, false, true, false],
        [20, 4, true, false, true, false],
        [20, 5, true, false, true, false],
        [20, 6, false, false, true, true],
        [20, 7, true, false, true, false],
        [20, 8, true, false, true, false],
        [20, 9, false, false, false, false],
        [20, 10, false, false, false, false],
        [20, 11, false, false, false, false],
        [20, 12, false, false, false, false],
        [20, 13, false, false, false, false],
        [20, 14, false, false, false, false],
        [20, 15, false, false, false, false],
        [20, 16, false, false, false, false],
        [20, 17, false, false, false, false],
        [20, 18, false, false, false, false],
        [20, 19, true, false, true, false],
        [20, 20, false, false, true, true],
        [20, 21, false, false, false, false],
        [20, 22, false, false, true, true],
        [20, 23, false, false, false, false],
        [20, 24, true, false, true, false],
        [20, 25, false, true, false, true],
        [21, 0, false, false, false, false],
        [21, 1, false, false, false, false],
        [21, 2, false, false, false, false],
        [21, 3, false, false, false, false],
        [21, 4, false, false, false, false],
        [21, 5, false, false, false, false],
        [21, 6, false, false, false, false],
        [21, 7, false, false, false, false],
        [21, 8, false, false, false, false],
        [21, 9, false, false, false, false],
        [21, 10, false, false, false, false],
        [21, 11, false, false, false, false],
        [21, 12, false, false, false, false],
        [21, 13, false, false, false, false],
        [21, 14, false, false, false, false],
        [21, 15, false, false, false, false],
        [21, 16, false, false, false, false],
        [21, 17, false, false, false, false],
        [21, 18, false, false, false, false],
        [21, 19, false, false, false, false],
        [21, 20, false, false, false, false],
        [21, 21, false, false, false, false],
        [21, 22, false, false, false, false],
        [21, 23, false, false, false, false],
        [21, 24, false, false, false, false],
        [21, 25, false, false, false, false],
        [22, 0, true, false, true, false],
        [22, 1, true, false, true, false],
        [22, 2, true, false, true, false],
        [22, 3, true, false, true, false],
        [22, 4, true, false, true, false],
        [22, 5, true, false, true, false],
        [22, 6, false, false, true, true],
        [22, 7, true, false, true, false],
        [22, 8, true, false, true, false],
        [22, 9, false, false, false, false],
        [22, 10, false, false, false, false],
        [22, 11, false, false, false, false],
        [22, 12, false, false, false, false],
        [22, 13, false, false, false, false],
        [22, 14, false, false, false, false],
        [22, 15, false, false, false, false],
        [22, 16, false, false, false, false],
        [22, 17, false, false, false, false],
        [22, 18, false, false, false, false],
        [22, 19, true, false, true, false],
        [22, 20, false, false, true, true],
        [22, 21, false, false, false, false],
        [22, 22, false, false, true, true],
        [22, 23, false, false, false, false],
        [22, 24, true, false, true, false],
        [22, 25, false, true, false, true],
        [23, 0, false, false, false, false],
        [23, 1, false, false, false, false],
        [23, 2, false, false, false, false],
        [23, 3, false, false, false, false],
        [23, 4, false, false, false, false],
        [23, 5, false, false, false, false],
        [23, 6, false, false, false, false],
        [23, 7, false, false, false, false],
        [23, 8, false, false, false, false],
        [23, 9, false, false, false, false],
        [23, 10, false, false, false, false],
        [23, 11, false, false, false, false],
        [23, 12, false, false, false, false],
        [23, 13, false, false, false, false],
        [23, 14, false, false, false, false],
        [23, 15, false, false, false, false],
        [23, 16, false, false, false, false],
        [23, 17, false, false, false, false],
        [23, 18, false, false, false, false],
        [23, 19, false, false, false, false],
        [23, 20, false, false, false, false],
        [23, 21, false, false, false, false],
        [23, 22, false, false, false, false],
        [23, 23, false, false, false, false],
        [23, 24, false, false, false, false],
        [23, 25, false, false, false, false],
        [24, 0, false, true, false, true],
        [24, 1, false, true, false, true],
        [24, 2, false, true, false, true],
        [24, 3, false, true, false, true],
        [24, 4, false, true, false, true],
        [24, 5, false, true, false, true],
        [24, 6, false, true, false, true],
        [24, 7, false, true, false, true],
        [24, 8, false, true, false, true],
        [24, 9, false, false, false, false],
        [24, 10, false, false, false, false],
        [24, 11, false, false, false, false],
        [24, 12, false, false, false, false],
        [24, 13, false, false, false, false],
        [24, 14, false, false, false, false],
        [24, 15, false, false, false, false],
        [24, 16, false, false, false, false],
        [24, 17, false, false, false, false],
        [24, 18, false, false, false, false],
        [24, 19, false, true, false, true],
        [24, 20, false, true, false, true],
        [24, 21, false, false, false, false],
        [24, 22, false, true, false, true],
        [24, 23, false, false, false, false],
        [24, 24, false, false, true, true],
        [24, 25, false, true, false, true],
        [25, 0, true, false, true, false],
        [25, 1, true, false, true, false],
        [25, 2, true, false, true, false],
        [25, 3, true, false, true, false],
        [25, 4, true, false, true, false],
        [25, 5, true, false, true, false],
        [25, 6, true, false, true, false],
        [25, 7, true, false, true, false],
        [25, 8, true, false, true, false],
        [25, 9, false, false, false, false],
        [25, 10, false, false, false, false],
        [25, 11, false, false, false, false],
        [25, 12, false, false, false, false],
        [25, 13, false, false, false, false],
        [25, 14, false, false, false, false],
        [25, 15, false, false, false, false],
        [25, 16, false, false, false, false],
        [25, 17, false, false, false, false],
        [25, 18, false, false, false, false],
        [25, 19, true, false, true, false],
        [25, 20, true, false, true, false],
        [25, 21, false, false, false, false],
        [25, 22, true, false, true, false],
        [25, 23, false, false, false, false],
        [25, 24, true, false, true, false],
        [25, 25, false, false, true, true],
    ];

    for (let test of table) {
        let x = vals[test[0]];
        let y = vals[test[1]];

        expect(x < y).toBe(test[2]);
        expect(x > y).toBe(test[3]);
        expect(x <= y).toBe(test[4]);
        expect(x >= y).toBe(test[5]);
    }
});
