#!/bin/sh

set -e

OUTPUT_FILE=$1

if command -v git >/dev/null; then
    if git status >/dev/null 2>&1; then
        GIT_HASH=$( (git log --pretty=format:'%h' -n 1 | cut -c1-7) || true )
        # There is at least one modified file as reported by git.
        if git status --porcelain=v2 | head | grep -Ei '^1' >/dev/null; then
            GIT_HASH="${GIT_HASH}-modified"
        fi
    else
        GIT_HASH=unknown
    fi
else
    GIT_HASH=unknown
fi


cat << EOF > "$OUTPUT_FILE"
/*
 * Automatically generated by Kernel/generate-version-file.sh
 */

#pragma once
#include <AK/StringView.h>

namespace Kernel {

constexpr unsigned SERENITY_MAJOR_REVISION = 1;
constexpr unsigned SERENITY_MINOR_REVISION = 0;
constexpr StringView SERENITY_VERSION = "${GIT_HASH}"sv;

}
EOF
