/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CMSPermGenGen;
import sun.jvm.hotspot.memory.CompactingPermGenGen;
import sun.jvm.hotspot.memory.ConcurrentMarkSweepGeneration;
import sun.jvm.hotspot.memory.DefNewGeneration;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.memory.ParNewGeneration;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.memory.TenuredGeneration;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VirtualConstructor;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class GenerationFactory {
    private static VirtualConstructor ctor;

    private static synchronized void initialize(TypeDataBase db) {
        ctor = new VirtualConstructor(db);
        ctor.addMapping("CompactingPermGenGen", CompactingPermGenGen.class);
        ctor.addMapping("CMSPermGenGen", CMSPermGenGen.class);
        ctor.addMapping("DefNewGeneration", DefNewGeneration.class);
        ctor.addMapping("ParNewGeneration", ParNewGeneration.class);
        ctor.addMapping("TenuredGeneration", TenuredGeneration.class);
        ctor.addMapping("ConcurrentMarkSweepGeneration", ConcurrentMarkSweepGeneration.class);
    }

    public static Generation newObject(Address addr) {
        try {
            return (Generation)ctor.instantiateWrapperFor(addr);
        }
        catch (WrongTypeException e) {
            return new Generation(addr){

                @Override
                public String name() {
                    return "unknown generation type";
                }

                @Override
                public void spaceIterate(SpaceClosure blk, boolean usedOnly) {
                }

                @Override
                public void printOn(PrintStream tty) {
                    tty.println("unknown subtype of Generation @ " + this.getAddress() + " (" + this.virtualSpace().low() + "," + this.virtualSpace().high() + ")");
                }

                @Override
                public long used() {
                    return 0L;
                }

                @Override
                public long free() {
                    return 0L;
                }

                @Override
                public long capacity() {
                    return 0L;
                }

                @Override
                public long contiguousAvailable() {
                    return 0L;
                }
            };
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                GenerationFactory.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

