/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.bugspot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import sun.jvm.hotspot.bugspot.StackTraceEntry;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.ui.GraphicsUtilities;

public class StackTracePanel
extends JPanel {
    private List trace;
    private Model model = new Model();
    private JComboBox list;
    private List listeners;

    public StackTracePanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(GraphicsUtilities.newBorder(5));
        this.list = new JComboBox(this.model);
        this.list.setPrototypeDisplayValue("ZZZZZZZZZZZZZZZZZZZZZZZZZZZZ");
        this.add((Component)this.list, "Center");
        this.list.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    StackTracePanel.this.fireFrameChanged();
                }
            }
        });
    }

    public void setTrace(List trace) {
        this.trace = trace;
        this.model.dataChanged();
        this.list.setSelectedIndex(0);
        this.fireFrameChanged();
    }

    public void addListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    protected void fireFrameChanged() {
        if (this.listeners != null) {
            StackTraceEntry entry = (StackTraceEntry)this.trace.get(this.list.getSelectedIndex());
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ((Listener)iter.next()).frameChanged(entry.getCFrame(), entry.getJavaFrame());
            }
        }
    }

    class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private Object selectedItem;

        Model() {
        }

        @Override
        public Object getElementAt(int index) {
            if (StackTracePanel.this.trace == null) {
                return null;
            }
            return StackTracePanel.this.trace.get(index);
        }

        @Override
        public int getSize() {
            if (StackTracePanel.this.trace == null) {
                return 0;
            }
            return StackTracePanel.this.trace.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object item) {
            this.selectedItem = item;
        }

        public void dataChanged() {
            this.fireContentsChanged(this, 0, StackTracePanel.this.trace.size());
        }
    }

    public static interface Listener {
        public void frameChanged(CFrame var1, JavaVFrame var2);
    }
}

