#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 indexed-traversable
version:              0.1.1
visibility:           public
id:                   indexed-traversable-0.1.1-1Z2GfU1EWlL3ZzMnGNHsA4
key:                  indexed-traversable-0.1.1-1Z2GfU1EWlL3ZzMnGNHsA4
license:              BSD-2-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Edward Kmett
synopsis:             FunctorWithIndex, FoldableWithIndex, TraversableWithIndex
description:
    This package provides three useful generalizations:

    @
    class Functor f => FunctorWithIndex i f | f -> i where
    \  imap :: (i -> a -> b) -> f a -> f b
    @

    @
    class Foldable f => FoldableWithIndex i f | f -> i where
    \  ifoldMap :: Monoid m => (i -> a -> m) -> f a -> m
    @

    @
    class (FunctorWithIndex i t, FoldableWithIndex i t, Traversable t) => TraversableWithIndex i t | t -> i where
    \  itraverse :: Applicative f => (i -> a -> f b) -> t a -> f (t b)
    @

    This package contains instances for types in GHC boot libraries.
    For some additional instances see [indexed-traversable-instances](https://hackage.haskell.org/package/indexed-traversable-instances).

    The [keys](https://hackage.haskell.org/package/keys) package provides similar functionality,
    but uses (associated) @TypeFamilies@ instead of @FunctionalDependencies@.

category:             Data
abi:                  31a089c49496caffd23a4bbe01febfc9
exposed:              True
exposed-modules:
    Data.Foldable.WithIndex Data.Functor.WithIndex
    Data.Traversable.WithIndex

hidden-modules:       GhcExts WithIndex
import-dirs:          /usr/lib/ghc-8.10.5/site-local/indexed-traversable-0.1.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/indexed-traversable-0.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/indexed-traversable-0.1.1
hs-libraries:         HSindexed-traversable-0.1.1-1Z2GfU1EWlL3ZzMnGNHsA4
depends:
    array-0.5.4.0 base-4.14.2.0 containers-0.6.4.1 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-indexed-traversable/html/indexed-traversable.haddock

haddock-html:         /usr/share/doc/haskell-indexed-traversable/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

