#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 filepattern
version:              0.1.2
visibility:           public
id:                   filepattern-0.1.2-DSg3wkERMhNJ2fV3brX1w7
key:                  filepattern-0.1.2-DSg3wkERMhNJ2fV3brX1w7
license:              BSD-3-Clause
copyright:            Neil Mitchell 2011-2020
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:
    Neil Mitchell <ndmitchell@gmail.com>, Evan Rutledge Borden <evan@evan-borden.com>

homepage:             https://github.com/ndmitchell/filepattern#readme
synopsis:             File path glob-like matching
description:
    A library for matching files using patterns such as @\"src\/**\/*.png\"@ for all @.png@ files
    recursively under the @src@ directory. Features:

    * All matching is /O(n)/. Most functions precompute some information given only one argument.

    * See "System.FilePattern" and @?==@ simple matching and semantics.

    * Use @match@ and @substitute@ to extract suitable
    strings from the @*@ and @**@ matches, and substitute them back into other patterns.

    * Use @step@ and @matchMany@ to perform bulk matching
    of many patterns against many paths simultaneously.

    * Use "System.FilePattern.Directory" to perform optimised directory traverals using patterns.

    Originally taken from the <https://hackage.haskell.org/package/shake Shake library>.

category:             Development, FilePath
abi:                  52ec819f9d4c8c015ccd1e165ab7e41d
exposed:              True
exposed-modules:      System.FilePattern System.FilePattern.Directory
hidden-modules:
    System.FilePattern.Core System.FilePattern.ListBy
    System.FilePattern.Monads System.FilePattern.Step
    System.FilePattern.Tree System.FilePattern.Wildcard

import-dirs:          /usr/lib/ghc-8.10.5/site-local/filepattern-0.1.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/filepattern-0.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/filepattern-0.1.2
hs-libraries:         HSfilepattern-0.1.2-DSg3wkERMhNJ2fV3brX1w7
depends:
    base-4.14.2.0 directory-1.3.6.0 extra-1.7.9-HHsi7iW1l3L1a3O3w2D3UA
    filepath-1.4.2.1

haddock-interfaces:   /usr/share/doc/haskell-filepattern/html/filepattern.haddock
haddock-html:         /usr/share/doc/haskell-filepattern/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

