'use strict';

var env = require('env-variable');

/**
 * Checks if a given namespace is allowed by the environment variables.
 *
 * @param {String} name namespace that should be included.
 * @param {Array} variables
 * @returns {Boolean}
 * @api public
 */
module.exports = function enabled(name, variables) {
  var envy = env()
    , variable
    , i = 0;

  variables = variables || ['diagnostics', 'debug'];

  for (; i < variables.length; i++) {
    if ((variable = envy[variables[i]])) break;
  }

  if (!variable) return false;

  variables = variable.split(/[\s,]+/);
  i = 0;

  for (; i < variables.length; i++) {
    variable = variables[i].replace('*', '.*?');

    if ('-' === variable.charAt(0)) {
      if ((new RegExp('^'+ variable.substr(1) +'$')).test(name)) {
        return false;
      }

      continue;
    }

    if ((new RegExp('^'+ variable +'$')).test(name)) {
      return true;
    }
  }

  return false;
};
