/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CoordinatedLayerTreeHostMessages_h
#define CoordinatedLayerTreeHostMessages_h

#if USE(COORDINATED_GRAPHICS)

#include "Arguments.h"
#include "MessageEncoder.h"
#include "StringReference.h"
#include "WebCoreArgumentCoders.h"
#include <WebCore/FloatPoint.h>
#include <WebCore/FloatRect.h>
#include <WebCore/IntSize.h>


namespace Messages {
namespace CoordinatedLayerTreeHost {

static inline IPC::StringReference messageReceiverName()
{
    return IPC::StringReference("CoordinatedLayerTreeHost");
}

class SetVisibleContentsRect {
public:
    typedef std::tuple<WebCore::FloatRect, WebCore::FloatPoint> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("SetVisibleContentsRect"); }
    static const bool isSync = false;

    SetVisibleContentsRect(const WebCore::FloatRect& visibleContentsRect, const WebCore::FloatPoint& trajectoryVectory)
        : m_arguments(visibleContentsRect, trajectoryVectory)
    {
    }

    const std::tuple<const WebCore::FloatRect&, const WebCore::FloatPoint&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::FloatRect&, const WebCore::FloatPoint&> m_arguments;
};

class RenderNextFrame {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RenderNextFrame"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class PurgeBackingStores {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("PurgeBackingStores"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class CommitScrollOffset {
public:
    typedef std::tuple<uint32_t, WebCore::IntSize> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("CommitScrollOffset"); }
    static const bool isSync = false;

    CommitScrollOffset(uint32_t layerID, const WebCore::IntSize& offset)
        : m_arguments(layerID, offset)
    {
    }

    const std::tuple<uint32_t, const WebCore::IntSize&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<uint32_t, const WebCore::IntSize&> m_arguments;
};

} // namespace CoordinatedLayerTreeHost
} // namespace Messages

#endif // USE(COORDINATED_GRAPHICS)

#endif // CoordinatedLayerTreeHostMessages_h
