/*
 * Copyright (c) 2015 Canon Inc. All rights reserved.
 * Copyright (c) 2015 Igalia.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#ifndef ReadableStreamInternalsBuiltins_h
#define ReadableStreamInternalsBuiltins_h

#if ENABLE(STREAMS_API)

#include <builtins/BuiltinUtils.h>
#include <bytecode/UnlinkedFunctionExecutable.h>
#include <runtime/Identifier.h>
#include <runtime/JSFunction.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* ReadableStreamInternals */
extern const char* s_readableStreamInternalsPrivateInitializeReadableStreamReaderCode;
extern const int s_readableStreamInternalsPrivateInitializeReadableStreamReaderCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPrivateInitializeReadableStreamReaderCodeConstructAbility;
extern const char* s_readableStreamInternalsPrivateInitializeReadableStreamControllerCode;
extern const int s_readableStreamInternalsPrivateInitializeReadableStreamControllerCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsPrivateInitializeReadableStreamControllerCodeConstructAbility;
extern const char* s_readableStreamInternalsTeeReadableStreamCode;
extern const int s_readableStreamInternalsTeeReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsTeeReadableStreamCodeConstructAbility;
extern const char* s_readableStreamInternalsTeeReadableStreamPullFunctionCode;
extern const int s_readableStreamInternalsTeeReadableStreamPullFunctionCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsTeeReadableStreamPullFunctionCodeConstructAbility;
extern const char* s_readableStreamInternalsTeeReadableStreamBranch1CancelFunctionCode;
extern const int s_readableStreamInternalsTeeReadableStreamBranch1CancelFunctionCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsTeeReadableStreamBranch1CancelFunctionCodeConstructAbility;
extern const char* s_readableStreamInternalsTeeReadableStreamBranch2CancelFunctionCode;
extern const int s_readableStreamInternalsTeeReadableStreamBranch2CancelFunctionCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsTeeReadableStreamBranch2CancelFunctionCodeConstructAbility;
extern const char* s_readableStreamInternalsIsReadableStreamCode;
extern const int s_readableStreamInternalsIsReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamCodeConstructAbility;
extern const char* s_readableStreamInternalsIsReadableStreamReaderCode;
extern const int s_readableStreamInternalsIsReadableStreamReaderCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamReaderCodeConstructAbility;
extern const char* s_readableStreamInternalsIsReadableStreamControllerCode;
extern const int s_readableStreamInternalsIsReadableStreamControllerCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamControllerCodeConstructAbility;
extern const char* s_readableStreamInternalsErrorReadableStreamCode;
extern const int s_readableStreamInternalsErrorReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsErrorReadableStreamCodeConstructAbility;
extern const char* s_readableStreamInternalsRequestReadableStreamPullCode;
extern const int s_readableStreamInternalsRequestReadableStreamPullCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsRequestReadableStreamPullCodeConstructAbility;
extern const char* s_readableStreamInternalsIsReadableStreamLockedCode;
extern const int s_readableStreamInternalsIsReadableStreamLockedCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamLockedCodeConstructAbility;
extern const char* s_readableStreamInternalsGetReadableStreamDesiredSizeCode;
extern const int s_readableStreamInternalsGetReadableStreamDesiredSizeCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsGetReadableStreamDesiredSizeCodeConstructAbility;
extern const char* s_readableStreamInternalsCancelReadableStreamCode;
extern const int s_readableStreamInternalsCancelReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsCancelReadableStreamCodeConstructAbility;
extern const char* s_readableStreamInternalsFinishClosingReadableStreamCode;
extern const int s_readableStreamInternalsFinishClosingReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsFinishClosingReadableStreamCodeConstructAbility;
extern const char* s_readableStreamInternalsCloseReadableStreamCode;
extern const int s_readableStreamInternalsCloseReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsCloseReadableStreamCodeConstructAbility;
extern const char* s_readableStreamInternalsEnqueueInReadableStreamCode;
extern const int s_readableStreamInternalsEnqueueInReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsEnqueueInReadableStreamCodeConstructAbility;
extern const char* s_readableStreamInternalsReadFromReadableStreamReaderCode;
extern const int s_readableStreamInternalsReadFromReadableStreamReaderCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsReadFromReadableStreamReaderCodeConstructAbility;
extern const char* s_readableStreamInternalsIsReadableStreamDisturbedCode;
extern const int s_readableStreamInternalsIsReadableStreamDisturbedCodeLength;
extern const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDisturbedCodeConstructAbility;

#define WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_DATA(macro) \
    macro(privateInitializeReadableStreamReader, readableStreamInternalsPrivateInitializeReadableStreamReader, 1) \
    macro(privateInitializeReadableStreamController, readableStreamInternalsPrivateInitializeReadableStreamController, 1) \
    macro(teeReadableStream, readableStreamInternalsTeeReadableStream, 2) \
    macro(teeReadableStreamPullFunction, readableStreamInternalsTeeReadableStreamPullFunction, 3) \
    macro(teeReadableStreamBranch1CancelFunction, readableStreamInternalsTeeReadableStreamBranch1CancelFunction, 2) \
    macro(teeReadableStreamBranch2CancelFunction, readableStreamInternalsTeeReadableStreamBranch2CancelFunction, 2) \
    macro(isReadableStream, readableStreamInternalsIsReadableStream, 1) \
    macro(isReadableStreamReader, readableStreamInternalsIsReadableStreamReader, 1) \
    macro(isReadableStreamController, readableStreamInternalsIsReadableStreamController, 1) \
    macro(errorReadableStream, readableStreamInternalsErrorReadableStream, 2) \
    macro(requestReadableStreamPull, readableStreamInternalsRequestReadableStreamPull, 1) \
    macro(isReadableStreamLocked, readableStreamInternalsIsReadableStreamLocked, 1) \
    macro(getReadableStreamDesiredSize, readableStreamInternalsGetReadableStreamDesiredSize, 1) \
    macro(cancelReadableStream, readableStreamInternalsCancelReadableStream, 2) \
    macro(finishClosingReadableStream, readableStreamInternalsFinishClosingReadableStream, 1) \
    macro(closeReadableStream, readableStreamInternalsCloseReadableStream, 1) \
    macro(enqueueInReadableStream, readableStreamInternalsEnqueueInReadableStream, 2) \
    macro(readFromReadableStreamReader, readableStreamInternalsReadFromReadableStreamReader, 1) \
    macro(isReadableStreamDisturbed, readableStreamInternalsIsReadableStreamDisturbed, 1) \

#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PRIVATEINITIALIZEREADABLESTREAMREADER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_PRIVATEINITIALIZEREADABLESTREAMCONTROLLER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_TEEREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_TEEREADABLESTREAMPULLFUNCTION 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_TEEREADABLESTREAMBRANCH1CANCELFUNCTION 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_TEEREADABLESTREAMBRANCH2CANCELFUNCTION 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMREADER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMCONTROLLER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ERRORREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_REQUESTREADABLESTREAMPULL 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMLOCKED 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_GETREADABLESTREAMDESIREDSIZE 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_CANCELREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_FINISHCLOSINGREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_CLOSEREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ENQUEUEINREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_READFROMREADABLESTREAMREADER 1
#define WEBCORE_BUILTIN_READABLESTREAMINTERNALS_ISREADABLESTREAMDISTURBED 1

#define WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(macro) \
    macro(readableStreamInternalsPrivateInitializeReadableStreamReaderCode, privateInitializeReadableStreamReader, s_readableStreamInternalsPrivateInitializeReadableStreamReaderCodeLength) \
    macro(readableStreamInternalsPrivateInitializeReadableStreamControllerCode, privateInitializeReadableStreamController, s_readableStreamInternalsPrivateInitializeReadableStreamControllerCodeLength) \
    macro(readableStreamInternalsTeeReadableStreamCode, teeReadableStream, s_readableStreamInternalsTeeReadableStreamCodeLength) \
    macro(readableStreamInternalsTeeReadableStreamPullFunctionCode, teeReadableStreamPullFunction, s_readableStreamInternalsTeeReadableStreamPullFunctionCodeLength) \
    macro(readableStreamInternalsTeeReadableStreamBranch1CancelFunctionCode, teeReadableStreamBranch1CancelFunction, s_readableStreamInternalsTeeReadableStreamBranch1CancelFunctionCodeLength) \
    macro(readableStreamInternalsTeeReadableStreamBranch2CancelFunctionCode, teeReadableStreamBranch2CancelFunction, s_readableStreamInternalsTeeReadableStreamBranch2CancelFunctionCodeLength) \
    macro(readableStreamInternalsIsReadableStreamCode, isReadableStream, s_readableStreamInternalsIsReadableStreamCodeLength) \
    macro(readableStreamInternalsIsReadableStreamReaderCode, isReadableStreamReader, s_readableStreamInternalsIsReadableStreamReaderCodeLength) \
    macro(readableStreamInternalsIsReadableStreamControllerCode, isReadableStreamController, s_readableStreamInternalsIsReadableStreamControllerCodeLength) \
    macro(readableStreamInternalsErrorReadableStreamCode, errorReadableStream, s_readableStreamInternalsErrorReadableStreamCodeLength) \
    macro(readableStreamInternalsRequestReadableStreamPullCode, requestReadableStreamPull, s_readableStreamInternalsRequestReadableStreamPullCodeLength) \
    macro(readableStreamInternalsIsReadableStreamLockedCode, isReadableStreamLocked, s_readableStreamInternalsIsReadableStreamLockedCodeLength) \
    macro(readableStreamInternalsGetReadableStreamDesiredSizeCode, getReadableStreamDesiredSize, s_readableStreamInternalsGetReadableStreamDesiredSizeCodeLength) \
    macro(readableStreamInternalsCancelReadableStreamCode, cancelReadableStream, s_readableStreamInternalsCancelReadableStreamCodeLength) \
    macro(readableStreamInternalsFinishClosingReadableStreamCode, finishClosingReadableStream, s_readableStreamInternalsFinishClosingReadableStreamCodeLength) \
    macro(readableStreamInternalsCloseReadableStreamCode, closeReadableStream, s_readableStreamInternalsCloseReadableStreamCodeLength) \
    macro(readableStreamInternalsEnqueueInReadableStreamCode, enqueueInReadableStream, s_readableStreamInternalsEnqueueInReadableStreamCodeLength) \
    macro(readableStreamInternalsReadFromReadableStreamReaderCode, readFromReadableStreamReader, s_readableStreamInternalsReadFromReadableStreamReaderCodeLength) \
    macro(readableStreamInternalsIsReadableStreamDisturbedCode, isReadableStreamDisturbed, s_readableStreamInternalsIsReadableStreamDisturbedCodeLength) \

#define WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(macro) \
    macro(cancelReadableStream) \
    macro(closeReadableStream) \
    macro(enqueueInReadableStream) \
    macro(errorReadableStream) \
    macro(finishClosingReadableStream) \
    macro(getReadableStreamDesiredSize) \
    macro(isReadableStream) \
    macro(isReadableStreamController) \
    macro(isReadableStreamDisturbed) \
    macro(isReadableStreamLocked) \
    macro(isReadableStreamReader) \
    macro(privateInitializeReadableStreamController) \
    macro(privateInitializeReadableStreamReader) \
    macro(readFromReadableStreamReader) \
    macro(requestReadableStreamPull) \
    macro(teeReadableStream) \
    macro(teeReadableStreamBranch1CancelFunction) \
    macro(teeReadableStreamBranch2CancelFunction) \
    macro(teeReadableStreamPullFunction) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class ReadableStreamInternalsBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit ReadableStreamInternalsBuiltinsWrapper(JSC::VM* vm)
        : m_vm(*vm)
        WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, length) , m_##name##Source(JSC::makeSource(StringImpl::createFromLiteral(s_##name, length)))
        WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, length) \
inline JSC::UnlinkedFunctionExecutable* ReadableStreamInternalsBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable)\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, functionName##PublicName(), s_##name##ConstructAbility), this, &m_##name##Executable);\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void ReadableStreamInternalsBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

class ReadableStreamInternalsBuiltinFunctions {
public:
    explicit ReadableStreamInternalsBuiltinFunctions(JSC::VM& vm) : m_vm(vm) { }

    void init(JSC::JSGlobalObject&);
    void visit(JSC::SlotVisitor&);

public:
    JSC::VM& m_vm;

#define DECLARE_BUILTIN_SOURCE_MEMBERS(functionName) \
    JSC::WriteBarrier<JSC::JSFunction> m_##functionName##Function;
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS
};

inline void ReadableStreamInternalsBuiltinFunctions::init(JSC::JSGlobalObject& globalObject)
{
#define EXPORT_FUNCTION(codeName, functionName, length)\
    m_##functionName##Function.set(m_vm, &globalObject, JSC::JSFunction::createBuiltinFunction(m_vm, codeName##Generator(m_vm), &globalObject));
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(EXPORT_FUNCTION)
#undef EXPORT_FUNCTION
}

inline void ReadableStreamInternalsBuiltinFunctions::visit(JSC::SlotVisitor& visitor)
{
#define VISIT_FUNCTION(name) visitor.append(&m_##name##Function);
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(VISIT_FUNCTION)
#undef VISIT_FUNCTION
}


} // namespace WebCore

#endif // ENABLE(STREAMS_API)

#endif // ReadableStreamInternalsBuiltins_h
