/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathEvaluator.h"

#include "ExceptionCode.h"
#include "JSCustomXPathNSResolver.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNode.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXPathEvaluatorPrototypeFunctionCreateExpression(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXPathEvaluatorPrototypeFunctionCreateNSResolver(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXPathEvaluatorPrototypeFunctionEvaluate(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsXPathEvaluatorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXPathEvaluatorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXPathEvaluatorPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSXPathEvaluatorPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathEvaluatorPrototype* ptr = new (NotNull, JSC::allocateCell<JSXPathEvaluatorPrototype>(vm.heap)) JSXPathEvaluatorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXPathEvaluatorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSXPathEvaluator> JSXPathEvaluatorConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSXPathEvaluatorConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSXPathEvaluatorConstructor*>(state->callee());
    RefPtr<XPathEvaluator> object = XPathEvaluator::create();
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSXPathEvaluatorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXPathEvaluatorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXPathEvaluator::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("XPathEvaluator"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSXPathEvaluatorConstructor::s_info = { "XPathEvaluator", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXPathEvaluatorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXPathEvaluatorPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathEvaluatorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXPathEvaluatorConstructor) } },
    { "createExpression", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXPathEvaluatorPrototypeFunctionCreateExpression), (intptr_t) (0) } },
    { "createNSResolver", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXPathEvaluatorPrototypeFunctionCreateNSResolver), (intptr_t) (0) } },
    { "evaluate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXPathEvaluatorPrototypeFunctionEvaluate), (intptr_t) (0) } },
};

const ClassInfo JSXPathEvaluatorPrototype::s_info = { "XPathEvaluatorPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXPathEvaluatorPrototype) };

void JSXPathEvaluatorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXPathEvaluatorPrototypeTableValues, *this);
}

const ClassInfo JSXPathEvaluator::s_info = { "XPathEvaluator", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXPathEvaluator) };

JSXPathEvaluator::JSXPathEvaluator(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XPathEvaluator>&& impl)
    : JSDOMWrapper<XPathEvaluator>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSXPathEvaluator::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSXPathEvaluatorPrototype::create(vm, globalObject, JSXPathEvaluatorPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSXPathEvaluator::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXPathEvaluator>(vm, globalObject);
}

void JSXPathEvaluator::destroy(JSC::JSCell* cell)
{
    JSXPathEvaluator* thisObject = static_cast<JSXPathEvaluator*>(cell);
    thisObject->JSXPathEvaluator::~JSXPathEvaluator();
}

EncodedJSValue jsXPathEvaluatorConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSXPathEvaluatorPrototype* domObject = jsDynamicCast<JSXPathEvaluatorPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSXPathEvaluator::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSXPathEvaluatorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSXPathEvaluatorPrototype* domObject = jsDynamicCast<JSXPathEvaluatorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSXPathEvaluator::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathEvaluatorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXPathEvaluatorPrototypeFunctionCreateExpression(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXPathEvaluator*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XPathEvaluator", "createExpression");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXPathEvaluator::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String expression = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = JSXPathNSResolver::toWrapped(state->argument(1));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(state, state->argument(1));
        if (UNLIKELY(state->hadException()))
            return JSValue::encode(jsUndefined());
        resolver = customResolver.get();
    }
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createExpression(expression, resolver, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXPathEvaluatorPrototypeFunctionCreateNSResolver(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXPathEvaluator*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XPathEvaluator", "createNSResolver");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXPathEvaluator::info());
    auto& impl = castedThis->wrapped();
    Node* nodeResolver = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createNSResolver(nodeResolver)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXPathEvaluatorPrototypeFunctionEvaluate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXPathEvaluator*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XPathEvaluator", "evaluate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXPathEvaluator::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String expression = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Node* contextNode = JSNode::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = JSXPathNSResolver::toWrapped(state->argument(2));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(state, state->argument(2));
        if (UNLIKELY(state->hadException()))
            return JSValue::encode(jsUndefined());
        resolver = customResolver.get();
    }
    uint16_t type = toUInt16(state, state->argument(3), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    XPathResult* inResult = JSXPathResult::toWrapped(state->argument(4));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.evaluate(expression, contextNode, resolver, type, inResult, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSXPathEvaluatorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSXPathEvaluatorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXPathEvaluator = jsCast<JSXPathEvaluator*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXPathEvaluator->wrapped(), jsXPathEvaluator);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, XPathEvaluator* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSXPathEvaluator>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, XPathEvaluator* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXPathEvaluator>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XPathEvaluator.
    COMPILE_ASSERT(!__is_polymorphic(XPathEvaluator), XPathEvaluator_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSXPathEvaluator>(globalObject, impl);
}

XPathEvaluator* JSXPathEvaluator::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXPathEvaluator*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
