/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequest.h"

#include "Document.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDocument.h"
#include "JSEventListener.h"
#include "JSXMLHttpRequestUpload.h"
#include "URL.h"
#include "XMLHttpRequestUpload.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionOpen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionSetRequestHeader(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionSend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionAbort(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionGetResponseHeader(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionOverrideMimeType(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsXMLHttpRequestOnreadystatechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestOnreadystatechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestTimeout(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestTimeout(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestReadyState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestWithCredentials(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestWithCredentials(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestUpload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestResponseText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestResponseXML(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestResponseType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestResponseType(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestResponse(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestStatus(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestStatusText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestResponseURL(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXMLHttpRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXMLHttpRequestPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSXMLHttpRequestPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestPrototype>(vm.heap)) JSXMLHttpRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSXMLHttpRequest> JSXMLHttpRequestConstructor;

/* Hash table for constructor */

static const HashTableValue JSXMLHttpRequestConstructorTableValues[] =
{
    { "UNSENT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "OPENED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "HEADERS_RECEIVED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "LOADING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "DONE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
};


COMPILE_ASSERT(0 == XMLHttpRequest::UNSENT, XMLHttpRequestEnumUNSENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == XMLHttpRequest::OPENED, XMLHttpRequestEnumOPENEDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == XMLHttpRequest::HEADERS_RECEIVED, XMLHttpRequestEnumHEADERS_RECEIVEDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == XMLHttpRequest::LOADING, XMLHttpRequestEnumLOADINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == XMLHttpRequest::DONE, XMLHttpRequestEnumDONEIsWrongUseDoNotCheckConstants);

template<> EncodedJSValue JSC_HOST_CALL JSXMLHttpRequestConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSXMLHttpRequestConstructor*>(state->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "XMLHttpRequest");
    RefPtr<XMLHttpRequest> object = XMLHttpRequest::create(*context);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSXMLHttpRequestConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSXMLHttpRequestEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequest::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("XMLHttpRequest"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSXMLHttpRequestConstructorTableValues, *this);
}

template<> const ClassInfo JSXMLHttpRequestConstructor::s_info = { "XMLHttpRequest", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestConstructor) } },
    { "onreadystatechange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestOnreadystatechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestOnreadystatechange) } },
    { "timeout", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestTimeout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestTimeout) } },
    { "readyState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "withCredentials", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestWithCredentials), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestWithCredentials) } },
    { "upload", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUpload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseText", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponseText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseXML", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponseXML), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseType", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponseType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestResponseType) } },
    { "response", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponse), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "status", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestStatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "statusText", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestStatusText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "responseURL", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponseURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "open", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionOpen), (intptr_t) (2) } },
    { "setRequestHeader", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionSetRequestHeader), (intptr_t) (2) } },
    { "send", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionSend), (intptr_t) (0) } },
    { "abort", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionAbort), (intptr_t) (0) } },
    { "getAllResponseHeaders", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders), (intptr_t) (0) } },
    { "getResponseHeader", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionGetResponseHeader), (intptr_t) (1) } },
    { "overrideMimeType", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionOverrideMimeType), (intptr_t) (1) } },
    { "UNSENT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "OPENED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "HEADERS_RECEIVED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "LOADING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "DONE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
};

const ClassInfo JSXMLHttpRequestPrototype::s_info = { "XMLHttpRequestPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestPrototype) };

void JSXMLHttpRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequestPrototypeTableValues, *this);
}

const ClassInfo JSXMLHttpRequest::s_info = { "XMLHttpRequest", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequest) };

JSXMLHttpRequest::JSXMLHttpRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequest>&& impl)
    : JSXMLHttpRequestEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSXMLHttpRequest::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSXMLHttpRequestPrototype::create(vm, globalObject, JSXMLHttpRequestPrototype::createStructure(vm, globalObject, JSXMLHttpRequestEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSXMLHttpRequest::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXMLHttpRequest>(vm, globalObject);
}

EncodedJSValue jsXMLHttpRequestOnreadystatechange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "onreadystatechange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().readystatechangeEvent));
}


EncodedJSValue jsXMLHttpRequestTimeout(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "timeout");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.timeout());
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestReadyState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "readyState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.readyState());
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestWithCredentials(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "withCredentials");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.withCredentials());
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestUpload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "upload");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.upload()));
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestResponseText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "responseText");
    }
    return JSValue::encode(castedThis->responseText(*state));
}


EncodedJSValue jsXMLHttpRequestResponseXML(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "responseXML");
    }
    ExceptionCode ec = 0;
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.responseXML(ec)));
    setDOMException(state, ec);
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestResponseType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "responseType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.responseType());
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestResponse(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "response");
    }
    return JSValue::encode(castedThis->response(*state));
}


EncodedJSValue jsXMLHttpRequestStatus(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "status");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.status());
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestStatusText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "statusText");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.statusText());
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestResponseURL(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequest*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequest", "responseURL");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.responseURL());
    return JSValue::encode(result);
}


EncodedJSValue jsXMLHttpRequestConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSXMLHttpRequestPrototype* domObject = jsDynamicCast<JSXMLHttpRequestPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSXMLHttpRequest::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSXMLHttpRequestConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSXMLHttpRequestPrototype* domObject = jsDynamicCast<JSXMLHttpRequestPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSXMLHttpRequestOnreadystatechange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequest* castedThis = jsDynamicCast<JSXMLHttpRequest*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequest", "onreadystatechange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().readystatechangeEvent, value);
}


void setJSXMLHttpRequestTimeout(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequest* castedThis = jsDynamicCast<JSXMLHttpRequest*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequest", "timeout");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    unsigned nativeValue = toUInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setTimeout(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSXMLHttpRequestWithCredentials(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequest* castedThis = jsDynamicCast<JSXMLHttpRequest*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequest", "withCredentials");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setWithCredentials(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSXMLHttpRequestResponseType(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequest* castedThis = jsDynamicCast<JSXMLHttpRequest*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequest", "responseType");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (nativeValue != "" && nativeValue != "arraybuffer" && nativeValue != "blob" && nativeValue != "document" && nativeValue != "json" && nativeValue != "text")
        return;
    impl.setResponseType(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSXMLHttpRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionOpen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXMLHttpRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XMLHttpRequest", "open");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXMLHttpRequest::info());
    return JSValue::encode(castedThis->open(*state));
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionSetRequestHeader(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXMLHttpRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XMLHttpRequest", "setRequestHeader");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXMLHttpRequest::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String header = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String value = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setRequestHeader(header, value, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionSend(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXMLHttpRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XMLHttpRequest", "send");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXMLHttpRequest::info());
    return JSValue::encode(castedThis->send(*state));
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionAbort(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXMLHttpRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XMLHttpRequest", "abort");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXMLHttpRequest::info());
    auto& impl = castedThis->wrapped();
    impl.abort();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXMLHttpRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XMLHttpRequest", "getAllResponseHeaders");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXMLHttpRequest::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrUndefined(state, impl.getAllResponseHeaders());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionGetResponseHeader(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXMLHttpRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XMLHttpRequest", "getResponseHeader");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXMLHttpRequest::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String header = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.getResponseHeader(header));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionOverrideMimeType(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXMLHttpRequest*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XMLHttpRequest", "overrideMimeType");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXMLHttpRequest::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String override = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.overrideMimeType(override, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

void JSXMLHttpRequest::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSXMLHttpRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
    thisObject->visitAdditionalChildren(visitor);
    visitor.append(&thisObject->m_response);
}

bool JSXMLHttpRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsXMLHttpRequest = jsCast<JSXMLHttpRequest*>(handle.slot()->asCell());
    if (jsXMLHttpRequest->wrapped().hasPendingActivity())
        return true;
    if (jsXMLHttpRequest->wrapped().isFiringEventListeners())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSXMLHttpRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXMLHttpRequest = jsCast<JSXMLHttpRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXMLHttpRequest->wrapped(), jsXMLHttpRequest);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7XMLHttpRequest@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14XMLHttpRequestE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, XMLHttpRequest* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSXMLHttpRequest>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, XMLHttpRequest* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXMLHttpRequest>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7XMLHttpRequest@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14XMLHttpRequestE[2];
#if COMPILER(CLANG)
    // If this fails XMLHttpRequest does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(XMLHttpRequest), XMLHttpRequest_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // XMLHttpRequest has subclasses. If XMLHttpRequest has subclasses that get passed
    // to toJS() we currently require XMLHttpRequest you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSXMLHttpRequest>(globalObject, impl);
}

XMLHttpRequest* JSXMLHttpRequest::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXMLHttpRequest*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
