/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWheelEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMWindow.h"
#include "JSDictionary.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWheelEventPrototypeFunctionInitWebKitWheelEvent(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsWheelEventDeltaX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventDeltaY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventDeltaZ(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventDeltaMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventWheelDeltaX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventWheelDeltaY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventWheelDelta(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventWebkitDirectionInvertedFromDevice(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWheelEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWheelEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWheelEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWheelEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWheelEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSWheelEventPrototype>(vm.heap)) JSWheelEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWheelEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSWheelEvent> JSWheelEventConstructor;

/* Hash table for constructor */

static const HashTableValue JSWheelEventConstructorTableValues[] =
{
    { "DOM_DELTA_PIXEL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00) } },
    { "DOM_DELTA_LINE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x01) } },
    { "DOM_DELTA_PAGE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x02) } },
};


COMPILE_ASSERT(0x00 == WheelEvent::DOM_DELTA_PIXEL, WheelEventEnumDOM_DELTA_PIXELIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x01 == WheelEvent::DOM_DELTA_LINE, WheelEventEnumDOM_DELTA_LINEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x02 == WheelEvent::DOM_DELTA_PAGE, WheelEventEnumDOM_DELTA_PAGEIsWrongUseDoNotCheckConstants);

template<> EncodedJSValue JSC_HOST_CALL JSWheelEventConstructor::construct(ExecState* state)
{
    auto* jsConstructor = jsCast<JSWheelEventConstructor*>(state->callee());

    if (!jsConstructor->scriptExecutionContext())
        return throwVMError(state, createReferenceError(state, "Constructor associated execution context is unavailable"));

    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));

    AtomicString eventType = state->argument(0).toString(state)->toAtomicString(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    WheelEventInit eventInit;

    JSValue initializerValue = state->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(state);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(state, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillWheelEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<WheelEvent> event = WheelEvent::createForBindings(eventType, eventInit);
    return JSValue::encode(toJS(state, jsConstructor->globalObject(), event.get()));
}

bool fillWheelEventInit(WheelEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillMouseEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("deltaX", eventInit.deltaX))
        return false;
    if (!dictionary.tryGetProperty("deltaY", eventInit.deltaY))
        return false;
    if (!dictionary.tryGetProperty("deltaZ", eventInit.deltaZ))
        return false;
    if (!dictionary.tryGetProperty("deltaMode", eventInit.deltaMode))
        return false;
    if (!dictionary.tryGetProperty("wheelDeltaX", eventInit.wheelDeltaX))
        return false;
    if (!dictionary.tryGetProperty("wheelDeltaY", eventInit.wheelDeltaY))
        return false;
    return true;
}

template<> JSValue JSWheelEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMouseEvent::getConstructor(vm, &globalObject);
}

template<> void JSWheelEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWheelEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WheelEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSWheelEventConstructorTableValues, *this);
}

template<> ConstructType JSWheelEventConstructor::getConstructData(JSCell* cell, ConstructData& constructData)
{
#if ENABLE(DOM4_EVENTS_CONSTRUCTOR)
    UNUSED_PARAM(cell);
    constructData.native.function = construct;
    return ConstructTypeHost;
#else
    return Base::getConstructData(cell, constructData);
#endif
}

template<> const ClassInfo JSWheelEventConstructor::s_info = { "WheelEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWheelEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWheelEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWheelEventConstructor) } },
    { "deltaX", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDeltaX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "deltaY", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDeltaY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "deltaZ", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDeltaZ), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "deltaMode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventDeltaMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "wheelDeltaX", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDeltaX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "wheelDeltaY", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDeltaY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "wheelDelta", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWheelDelta), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitDirectionInvertedFromDevice", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWheelEventWebkitDirectionInvertedFromDevice), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initWebKitWheelEvent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWheelEventPrototypeFunctionInitWebKitWheelEvent), (intptr_t) (0) } },
    { "DOM_DELTA_PIXEL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00) } },
    { "DOM_DELTA_LINE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x01) } },
    { "DOM_DELTA_PAGE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x02) } },
};

const ClassInfo JSWheelEventPrototype::s_info = { "WheelEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWheelEventPrototype) };

void JSWheelEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWheelEventPrototypeTableValues, *this);
}

const ClassInfo JSWheelEvent::s_info = { "WheelEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWheelEvent) };

JSWheelEvent::JSWheelEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WheelEvent>&& impl)
    : JSMouseEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWheelEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWheelEventPrototype::create(vm, globalObject, JSWheelEventPrototype::createStructure(vm, globalObject, JSMouseEvent::getPrototype(vm, globalObject)));
}

JSObject* JSWheelEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWheelEvent>(vm, globalObject);
}

EncodedJSValue jsWheelEventDeltaX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWheelEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WheelEvent", "deltaX");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.deltaX());
    return JSValue::encode(result);
}


EncodedJSValue jsWheelEventDeltaY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWheelEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WheelEvent", "deltaY");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.deltaY());
    return JSValue::encode(result);
}


EncodedJSValue jsWheelEventDeltaZ(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWheelEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WheelEvent", "deltaZ");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.deltaZ());
    return JSValue::encode(result);
}


EncodedJSValue jsWheelEventDeltaMode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWheelEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WheelEvent", "deltaMode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.deltaMode());
    return JSValue::encode(result);
}


EncodedJSValue jsWheelEventWheelDeltaX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWheelEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WheelEvent", "wheelDeltaX");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.wheelDeltaX());
    return JSValue::encode(result);
}


EncodedJSValue jsWheelEventWheelDeltaY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWheelEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WheelEvent", "wheelDeltaY");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.wheelDeltaY());
    return JSValue::encode(result);
}


EncodedJSValue jsWheelEventWheelDelta(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWheelEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WheelEvent", "wheelDelta");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.wheelDelta());
    return JSValue::encode(result);
}


EncodedJSValue jsWheelEventWebkitDirectionInvertedFromDevice(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWheelEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WheelEvent", "webkitDirectionInvertedFromDevice");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitDirectionInvertedFromDevice());
    return JSValue::encode(result);
}


EncodedJSValue jsWheelEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWheelEventPrototype* domObject = jsDynamicCast<JSWheelEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWheelEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWheelEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWheelEventPrototype* domObject = jsDynamicCast<JSWheelEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWheelEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWheelEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWheelEventPrototypeFunctionInitWebKitWheelEvent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWheelEvent*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WheelEvent", "initWebKitWheelEvent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWheelEvent::info());
    auto& impl = castedThis->wrapped();
    int wheelDeltaX = toInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int wheelDeltaY = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    DOMWindow* view = JSDOMWindow::toWrapped(state->argument(2));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int screenX = toInt32(state, state->argument(3), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int screenY = toInt32(state, state->argument(4), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int clientX = toInt32(state, state->argument(5), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int clientY = toInt32(state, state->argument(6), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool ctrlKey = state->argument(7).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool altKey = state->argument(8).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool shiftKey = state->argument(9).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool metaKey = state->argument(10).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.initWebKitWheelEvent(wheelDeltaX, wheelDeltaY, view, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey);
    return JSValue::encode(jsUndefined());
}


}
