/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitCSSMatrix.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSWebKitCSSMatrix.h"
#include "URL.h"
#include "WebKitCSSMatrix.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSetMatrixValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionMultiply(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionInverse(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionTranslate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionScale(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionRotate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionRotateAxisAngle(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSkewX(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSkewY(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionToString(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsWebKitCSSMatrixA(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixA(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixB(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixB(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixC(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixC(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixD(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixD(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixE(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixE(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixF(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixF(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM11(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM11(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM12(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM12(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM13(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM13(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM14(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM14(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM21(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM21(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM22(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM22(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM23(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM23(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM24(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM24(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM31(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM31(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM32(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM32(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM33(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM33(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM34(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM34(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM41(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM41(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM42(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM42(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM43(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM43(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixM44(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixM44(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitCSSMatrixConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitCSSMatrixConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebKitCSSMatrixPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebKitCSSMatrixPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitCSSMatrixPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitCSSMatrixPrototype>(vm.heap)) JSWebKitCSSMatrixPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitCSSMatrixPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSWebKitCSSMatrix> JSWebKitCSSMatrixConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSWebKitCSSMatrixConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSWebKitCSSMatrixConstructor*>(state->callee());
    ExceptionCode ec = 0;
    String cssValue = state->argument(0).isUndefined() ? String() : state->uncheckedArgument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<WebKitCSSMatrix> object = WebKitCSSMatrix::create(cssValue, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSWebKitCSSMatrixConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebKitCSSMatrixConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebKitCSSMatrix::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebKitCSSMatrix"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebKitCSSMatrixConstructor::s_info = { "WebKitCSSMatrix", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitCSSMatrixConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebKitCSSMatrixPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixConstructor) } },
    { "a", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixA), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixA) } },
    { "b", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixB), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixB) } },
    { "c", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixC), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixC) } },
    { "d", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixD), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixD) } },
    { "e", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixE), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixE) } },
    { "f", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixF), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixF) } },
    { "m11", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM11), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM11) } },
    { "m12", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM12), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM12) } },
    { "m13", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM13), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM13) } },
    { "m14", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM14), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM14) } },
    { "m21", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM21), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM21) } },
    { "m22", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM22), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM22) } },
    { "m23", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM23), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM23) } },
    { "m24", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM24), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM24) } },
    { "m31", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM31), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM31) } },
    { "m32", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM32), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM32) } },
    { "m33", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM33), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM33) } },
    { "m34", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM34), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM34) } },
    { "m41", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM41), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM41) } },
    { "m42", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM42), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM42) } },
    { "m43", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM43), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM43) } },
    { "m44", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSMatrixM44), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitCSSMatrixM44) } },
    { "setMatrixValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionSetMatrixValue), (intptr_t) (0) } },
    { "multiply", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionMultiply), (intptr_t) (0) } },
    { "inverse", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionInverse), (intptr_t) (0) } },
    { "translate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionTranslate), (intptr_t) (0) } },
    { "scale", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionScale), (intptr_t) (0) } },
    { "rotate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionRotate), (intptr_t) (0) } },
    { "rotateAxisAngle", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionRotateAxisAngle), (intptr_t) (0) } },
    { "skewX", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionSkewX), (intptr_t) (0) } },
    { "skewY", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionSkewY), (intptr_t) (0) } },
    { "toString", DontEnum | JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWebKitCSSMatrixPrototypeFunctionToString), (intptr_t) (0) } },
};

const ClassInfo JSWebKitCSSMatrixPrototype::s_info = { "WebKitCSSMatrixPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitCSSMatrixPrototype) };

void JSWebKitCSSMatrixPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitCSSMatrixPrototypeTableValues, *this);
}

const ClassInfo JSWebKitCSSMatrix::s_info = { "WebKitCSSMatrix", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitCSSMatrix) };

JSWebKitCSSMatrix::JSWebKitCSSMatrix(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitCSSMatrix>&& impl)
    : JSDOMWrapper<WebKitCSSMatrix>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebKitCSSMatrix::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebKitCSSMatrixPrototype::create(vm, globalObject, JSWebKitCSSMatrixPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebKitCSSMatrix::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitCSSMatrix>(vm, globalObject);
}

void JSWebKitCSSMatrix::destroy(JSC::JSCell* cell)
{
    JSWebKitCSSMatrix* thisObject = static_cast<JSWebKitCSSMatrix*>(cell);
    thisObject->JSWebKitCSSMatrix::~JSWebKitCSSMatrix();
}

EncodedJSValue jsWebKitCSSMatrixA(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "a");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.a());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixB(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "b");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.b());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixC(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "c");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.c());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixD(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "d");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.d());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixE(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "e");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.e());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixF(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "f");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.f());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM11(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m11");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m11());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM12(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m12");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m12());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM13(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m13");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m13());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM14(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m14");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m14());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM21(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m21");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m21());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM22(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m22");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m22());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM23(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m23");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m23());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM24(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m24");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m24());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM31(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m31");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m31());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM32(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m32");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m32());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM33(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m33");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m33());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM34(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m34");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m34());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM41(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m41");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m41());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM42(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m42");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m42());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM43(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m43");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m43());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixM44(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitCSSMatrix", "m44");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.m44());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitCSSMatrixConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebKitCSSMatrixPrototype* domObject = jsDynamicCast<JSWebKitCSSMatrixPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebKitCSSMatrix::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebKitCSSMatrixConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebKitCSSMatrixPrototype* domObject = jsDynamicCast<JSWebKitCSSMatrixPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSWebKitCSSMatrixA(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "a");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setA(nativeValue);
}


void setJSWebKitCSSMatrixB(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "b");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setB(nativeValue);
}


void setJSWebKitCSSMatrixC(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "c");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setC(nativeValue);
}


void setJSWebKitCSSMatrixD(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "d");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setD(nativeValue);
}


void setJSWebKitCSSMatrixE(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "e");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setE(nativeValue);
}


void setJSWebKitCSSMatrixF(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "f");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setF(nativeValue);
}


void setJSWebKitCSSMatrixM11(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m11");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM11(nativeValue);
}


void setJSWebKitCSSMatrixM12(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m12");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM12(nativeValue);
}


void setJSWebKitCSSMatrixM13(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m13");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM13(nativeValue);
}


void setJSWebKitCSSMatrixM14(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m14");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM14(nativeValue);
}


void setJSWebKitCSSMatrixM21(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m21");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM21(nativeValue);
}


void setJSWebKitCSSMatrixM22(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m22");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM22(nativeValue);
}


void setJSWebKitCSSMatrixM23(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m23");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM23(nativeValue);
}


void setJSWebKitCSSMatrixM24(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m24");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM24(nativeValue);
}


void setJSWebKitCSSMatrixM31(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m31");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM31(nativeValue);
}


void setJSWebKitCSSMatrixM32(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m32");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM32(nativeValue);
}


void setJSWebKitCSSMatrixM33(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m33");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM33(nativeValue);
}


void setJSWebKitCSSMatrixM34(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m34");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM34(nativeValue);
}


void setJSWebKitCSSMatrixM41(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m41");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM41(nativeValue);
}


void setJSWebKitCSSMatrixM42(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m42");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM42(nativeValue);
}


void setJSWebKitCSSMatrixM43(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m43");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM43(nativeValue);
}


void setJSWebKitCSSMatrixM44(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitCSSMatrix* castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitCSSMatrix", "m44");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setM44(nativeValue);
}


JSValue JSWebKitCSSMatrix::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitCSSMatrixConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSetMatrixValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitCSSMatrix", "setMatrixValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitCSSMatrix::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String string = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setMatrixValue(string, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionMultiply(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitCSSMatrix", "multiply");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitCSSMatrix::info());
    auto& impl = castedThis->wrapped();
    WebKitCSSMatrix* secondMatrix = JSWebKitCSSMatrix::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.multiply(secondMatrix)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionInverse(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitCSSMatrix", "inverse");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitCSSMatrix::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.inverse(ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionTranslate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitCSSMatrix", "translate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitCSSMatrix::info());
    auto& impl = castedThis->wrapped();
    double x = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double y = state->argument(1).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double z = state->argument(2).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.translate(x, y, z)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionScale(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitCSSMatrix", "scale");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitCSSMatrix::info());
    auto& impl = castedThis->wrapped();
    double scaleX = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double scaleY = state->argument(1).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double scaleZ = state->argument(2).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.scale(scaleX, scaleY, scaleZ)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionRotate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitCSSMatrix", "rotate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitCSSMatrix::info());
    auto& impl = castedThis->wrapped();
    double rotX = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double rotY = state->argument(1).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double rotZ = state->argument(2).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.rotate(rotX, rotY, rotZ)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionRotateAxisAngle(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitCSSMatrix", "rotateAxisAngle");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitCSSMatrix::info());
    auto& impl = castedThis->wrapped();
    double x = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double y = state->argument(1).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double z = state->argument(2).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    double angle = state->argument(3).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.rotateAxisAngle(x, y, z, angle)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSkewX(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitCSSMatrix", "skewX");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitCSSMatrix::info());
    auto& impl = castedThis->wrapped();
    double angle = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.skewX(angle)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionSkewY(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitCSSMatrix", "skewY");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitCSSMatrix::info());
    auto& impl = castedThis->wrapped();
    double angle = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.skewY(angle)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSMatrixPrototypeFunctionToString(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSWebKitCSSMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "WebKitCSSMatrix", "toString");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWebKitCSSMatrix::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.toString());
    return JSValue::encode(result);
}

bool JSWebKitCSSMatrixOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebKitCSSMatrixOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebKitCSSMatrix = jsCast<JSWebKitCSSMatrix*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebKitCSSMatrix->wrapped(), jsWebKitCSSMatrix);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebKitCSSMatrix* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebKitCSSMatrix>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebKitCSSMatrix* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebKitCSSMatrix>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WebKitCSSMatrix.
    COMPILE_ASSERT(!__is_polymorphic(WebKitCSSMatrix), WebKitCSSMatrix_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSWebKitCSSMatrix>(globalObject, impl);
}

WebKitCSSMatrix* JSWebKitCSSMatrix::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebKitCSSMatrix*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
