/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStorage.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionKey(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionGetItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionSetItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionRemoveItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionClear(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsStorageLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStorageConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSStorageConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSStoragePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSStoragePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStoragePrototype* ptr = new (NotNull, JSC::allocateCell<JSStoragePrototype>(vm.heap)) JSStoragePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStoragePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSStorage> JSStorageConstructor;

template<> JSValue JSStorageConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSStorageConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSStorage::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Storage"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSStorageConstructor::s_info = { "Storage", &Base::s_info, 0, CREATE_METHOD_TABLE(JSStorageConstructor) };

/* Hash table for prototype */

static const HashTableValue JSStoragePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSStorageConstructor) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "key", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionKey), (intptr_t) (1) } },
    { "getItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionGetItem), (intptr_t) (1) } },
    { "setItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionSetItem), (intptr_t) (2) } },
    { "removeItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionRemoveItem), (intptr_t) (1) } },
    { "clear", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionClear), (intptr_t) (0) } },
};

const ClassInfo JSStoragePrototype::s_info = { "StoragePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSStoragePrototype) };

void JSStoragePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStoragePrototypeTableValues, *this);
}

const ClassInfo JSStorage::s_info = { "Storage", &Base::s_info, 0, CREATE_METHOD_TABLE(JSStorage) };

JSStorage::JSStorage(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Storage>&& impl)
    : JSDOMWrapper<Storage>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSStorage::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSStoragePrototype::create(vm, globalObject, JSStoragePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSStorage::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStorage>(vm, globalObject);
}

void JSStorage::destroy(JSC::JSCell* cell)
{
    JSStorage* thisObject = static_cast<JSStorage*>(cell);
    thisObject->JSStorage::~JSStorage();
}

bool JSStorage::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSStorage*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    JSValue proto = thisObject->prototype();
    if (proto.isObject() && jsCast<JSObject*>(proto)->hasProperty(state, propertyName))
        return false;

    if (thisObject->classInfo() == info()) {
        JSValue value;
        if (thisObject->nameGetter(state, propertyName, value)) {
            slot.setValue(thisObject, ReadOnly | DontDelete | DontEnum, value);
            return true;
        }
    }
    return false;
}

bool JSStorage::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSStorage*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    if (thisObject->classInfo() == info()) {
        JSValue value;
        if (thisObject->nameGetter(state, propertyName, value)) {
            slot.setValue(thisObject, ReadOnly | DontDelete | DontEnum, value);
            return true;
        }
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsStorageLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStorage*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Storage", "length");
    }
    ExceptionCode ec = 0;
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length(ec));
    setDOMException(state, ec);
    return JSValue::encode(result);
}


EncodedJSValue jsStorageConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSStoragePrototype* domObject = jsDynamicCast<JSStoragePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSStorage::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSStorageConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSStoragePrototype* domObject = jsDynamicCast<JSStoragePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSStorage::put(JSCell* cell, ExecState* state, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    auto* thisObject = jsCast<JSStorage*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::put(thisObject, state, propertyName, value, slot);
}

void JSStorage::putByIndex(JSCell* cell, ExecState* state, unsigned index, JSValue value, bool shouldThrow)
{
    auto* thisObject = jsCast<JSStorage*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    PutPropertySlot slot(thisObject, shouldThrow);
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::putByIndex(cell, state, index, value, shouldThrow);
}

JSValue JSStorage::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStorageConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionKey(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSStorage*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Storage", "key");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSStorage::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.key(index, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionGetItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSStorage*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Storage", "getItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSStorage::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String key = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.getItem(key, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionSetItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSStorage*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Storage", "setItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSStorage::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String key = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String data = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setItem(key, data, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionRemoveItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSStorage*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Storage", "removeItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSStorage::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String key = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.removeItem(key, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionClear(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSStorage*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Storage", "clear");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSStorage::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    impl.clear(ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

bool JSStorageOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsStorage = jsCast<JSStorage*>(handle.slot()->asCell());
    Frame* root = WTF::getPtr(jsStorage->wrapped().frame());
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSStorageOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsStorage = jsCast<JSStorage*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsStorage->wrapped(), jsStorage);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Storage* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSStorage>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Storage* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSStorage>(globalObject, impl))
        return result;
    return createNewWrapper<JSStorage>(globalObject, impl);
}

Storage* JSStorage::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSStorage*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
