/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSScriptProcessorNode.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsScriptProcessorNodeOnaudioprocess(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSScriptProcessorNodeOnaudioprocess(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsScriptProcessorNodeBufferSize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsScriptProcessorNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSScriptProcessorNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSScriptProcessorNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSScriptProcessorNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSScriptProcessorNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSScriptProcessorNodePrototype>(vm.heap)) JSScriptProcessorNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSScriptProcessorNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSScriptProcessorNode> JSScriptProcessorNodeConstructor;

template<> JSValue JSScriptProcessorNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSScriptProcessorNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSScriptProcessorNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ScriptProcessorNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSScriptProcessorNodeConstructor::s_info = { "ScriptProcessorNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSScriptProcessorNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSScriptProcessorNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProcessorNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSScriptProcessorNodeConstructor) } },
    { "onaudioprocess", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProcessorNodeOnaudioprocess), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSScriptProcessorNodeOnaudioprocess) } },
    { "bufferSize", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProcessorNodeBufferSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSScriptProcessorNodePrototype::s_info = { "ScriptProcessorNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSScriptProcessorNodePrototype) };

void JSScriptProcessorNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSScriptProcessorNodePrototypeTableValues, *this);
}

const ClassInfo JSScriptProcessorNode::s_info = { "ScriptProcessorNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSScriptProcessorNode) };

JSScriptProcessorNode::JSScriptProcessorNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ScriptProcessorNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSScriptProcessorNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSScriptProcessorNodePrototype::create(vm, globalObject, JSScriptProcessorNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSScriptProcessorNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSScriptProcessorNode>(vm, globalObject);
}

EncodedJSValue jsScriptProcessorNodeOnaudioprocess(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSScriptProcessorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ScriptProcessorNode", "onaudioprocess");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().audioprocessEvent));
}


EncodedJSValue jsScriptProcessorNodeBufferSize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSScriptProcessorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ScriptProcessorNode", "bufferSize");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.bufferSize());
    return JSValue::encode(result);
}


EncodedJSValue jsScriptProcessorNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSScriptProcessorNodePrototype* domObject = jsDynamicCast<JSScriptProcessorNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSScriptProcessorNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSScriptProcessorNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSScriptProcessorNodePrototype* domObject = jsDynamicCast<JSScriptProcessorNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSScriptProcessorNodeOnaudioprocess(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSScriptProcessorNode* castedThis = jsDynamicCast<JSScriptProcessorNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "ScriptProcessorNode", "onaudioprocess");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().audioprocessEvent, value);
}


JSValue JSScriptProcessorNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSScriptProcessorNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSScriptProcessorNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSScriptProcessorNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ScriptProcessorNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19ScriptProcessorNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, ScriptProcessorNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSScriptProcessorNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, ScriptProcessorNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSScriptProcessorNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7ScriptProcessorNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore19ScriptProcessorNodeE[2];
#if COMPILER(CLANG)
    // If this fails ScriptProcessorNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(ScriptProcessorNode), ScriptProcessorNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // ScriptProcessorNode has subclasses. If ScriptProcessorNode has subclasses that get passed
    // to toJS() we currently require ScriptProcessorNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSScriptProcessorNode>(globalObject, impl);
}

ScriptProcessorNode* JSScriptProcessorNode::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSScriptProcessorNode*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
