/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSegArcRel.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGPathSegArcRelX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegArcRelX(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegArcRelY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegArcRelY(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegArcRelR1(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegArcRelR1(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegArcRelR2(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegArcRelR2(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegArcRelAngle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegArcRelAngle(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegArcRelLargeArcFlag(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegArcRelLargeArcFlag(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegArcRelSweepFlag(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegArcRelSweepFlag(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGPathSegArcRelConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegArcRelConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGPathSegArcRelPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGPathSegArcRelPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegArcRelPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegArcRelPrototype>(vm.heap)) JSSVGPathSegArcRelPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegArcRelPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGPathSegArcRel> JSSVGPathSegArcRelConstructor;

template<> JSValue JSSVGPathSegArcRelConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSeg::getConstructor(vm, &globalObject);
}

template<> void JSSVGPathSegArcRelConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSegArcRel::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGPathSegArcRel"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGPathSegArcRelConstructor::s_info = { "SVGPathSegArcRel", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPathSegArcRelConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegArcRelPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegArcRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegArcRelConstructor) } },
    { "x", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegArcRelX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegArcRelX) } },
    { "y", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegArcRelY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegArcRelY) } },
    { "r1", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegArcRelR1), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegArcRelR1) } },
    { "r2", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegArcRelR2), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegArcRelR2) } },
    { "angle", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegArcRelAngle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegArcRelAngle) } },
    { "largeArcFlag", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegArcRelLargeArcFlag), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegArcRelLargeArcFlag) } },
    { "sweepFlag", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegArcRelSweepFlag), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegArcRelSweepFlag) } },
};

const ClassInfo JSSVGPathSegArcRelPrototype::s_info = { "SVGPathSegArcRelPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPathSegArcRelPrototype) };

void JSSVGPathSegArcRelPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSegArcRelPrototypeTableValues, *this);
}

const ClassInfo JSSVGPathSegArcRel::s_info = { "SVGPathSegArcRel", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPathSegArcRel) };

JSSVGPathSegArcRel::JSSVGPathSegArcRel(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSegArcRel>&& impl)
    : JSSVGPathSeg(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGPathSegArcRel::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGPathSegArcRelPrototype::create(vm, globalObject, JSSVGPathSegArcRelPrototype::createStructure(vm, globalObject, JSSVGPathSeg::getPrototype(vm, globalObject)));
}

JSObject* JSSVGPathSegArcRel::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathSegArcRel>(vm, globalObject);
}

EncodedJSValue jsSVGPathSegArcRelX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSegArcRel", "x");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.x());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegArcRelY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSegArcRel", "y");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.y());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegArcRelR1(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSegArcRel", "r1");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.r1());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegArcRelR2(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSegArcRel", "r2");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.r2());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegArcRelAngle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSegArcRel", "angle");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.angle());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegArcRelLargeArcFlag(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSegArcRel", "largeArcFlag");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.largeArcFlag());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegArcRelSweepFlag(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSegArcRel", "sweepFlag");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.sweepFlag());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegArcRelConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGPathSegArcRelPrototype* domObject = jsDynamicCast<JSSVGPathSegArcRelPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGPathSegArcRel::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGPathSegArcRelConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGPathSegArcRelPrototype* domObject = jsDynamicCast<JSSVGPathSegArcRelPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSVGPathSegArcRelX(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGPathSegArcRel* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGPathSegArcRel", "x");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setX(nativeValue);
}


void setJSSVGPathSegArcRelY(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGPathSegArcRel* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGPathSegArcRel", "y");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setY(nativeValue);
}


void setJSSVGPathSegArcRelR1(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGPathSegArcRel* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGPathSegArcRel", "r1");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setR1(nativeValue);
}


void setJSSVGPathSegArcRelR2(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGPathSegArcRel* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGPathSegArcRel", "r2");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setR2(nativeValue);
}


void setJSSVGPathSegArcRelAngle(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGPathSegArcRel* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGPathSegArcRel", "angle");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAngle(nativeValue);
}


void setJSSVGPathSegArcRelLargeArcFlag(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGPathSegArcRel* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGPathSegArcRel", "largeArcFlag");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLargeArcFlag(nativeValue);
}


void setJSSVGPathSegArcRelSweepFlag(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGPathSegArcRel* castedThis = jsDynamicCast<JSSVGPathSegArcRel*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGPathSegArcRel", "sweepFlag");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSweepFlag(nativeValue);
}


JSValue JSSVGPathSegArcRel::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegArcRelConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}
