/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPaint.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSVGPaintPrototypeFunctionSetUri(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGPaintPrototypeFunctionSetPaint(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsSVGPaintPaintType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGPaintUri(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGPaintConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPaintConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGPaintPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGPaintPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPaintPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPaintPrototype>(vm.heap)) JSSVGPaintPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPaintPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGPaint> JSSVGPaintConstructor;

/* Hash table for constructor */

static const HashTableValue JSSVGPaintConstructorTableValues[] =
{
    { "SVG_PAINTTYPE_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_PAINTTYPE_RGBCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_PAINTTYPE_NONE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(101) } },
    { "SVG_PAINTTYPE_CURRENTCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(102) } },
    { "SVG_PAINTTYPE_URI_NONE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(103) } },
    { "SVG_PAINTTYPE_URI_CURRENTCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(104) } },
    { "SVG_PAINTTYPE_URI_RGBCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(105) } },
    { "SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(106) } },
    { "SVG_PAINTTYPE_URI", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(107) } },
};


COMPILE_ASSERT(0 == SVGPaint::SVG_PAINTTYPE_UNKNOWN, SVGPaintEnumSVG_PAINTTYPE_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGPaint::SVG_PAINTTYPE_RGBCOLOR, SVGPaintEnumSVG_PAINTTYPE_RGBCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGPaint::SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR, SVGPaintEnumSVG_PAINTTYPE_RGBCOLOR_ICCCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(101 == SVGPaint::SVG_PAINTTYPE_NONE, SVGPaintEnumSVG_PAINTTYPE_NONEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(102 == SVGPaint::SVG_PAINTTYPE_CURRENTCOLOR, SVGPaintEnumSVG_PAINTTYPE_CURRENTCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(103 == SVGPaint::SVG_PAINTTYPE_URI_NONE, SVGPaintEnumSVG_PAINTTYPE_URI_NONEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(104 == SVGPaint::SVG_PAINTTYPE_URI_CURRENTCOLOR, SVGPaintEnumSVG_PAINTTYPE_URI_CURRENTCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(105 == SVGPaint::SVG_PAINTTYPE_URI_RGBCOLOR, SVGPaintEnumSVG_PAINTTYPE_URI_RGBCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(106 == SVGPaint::SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR, SVGPaintEnumSVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(107 == SVGPaint::SVG_PAINTTYPE_URI, SVGPaintEnumSVG_PAINTTYPE_URIIsWrongUseDoNotCheckConstants);

template<> JSValue JSSVGPaintConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGColor::getConstructor(vm, &globalObject);
}

template<> void JSSVGPaintConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGPaint::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGPaint"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSSVGPaintConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGPaintConstructor::s_info = { "SVGPaint", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPaintConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGPaintPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPaintConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPaintConstructor) } },
    { "paintType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPaintPaintType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "uri", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPaintUri), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "setUri", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGPaintPrototypeFunctionSetUri), (intptr_t) (1) } },
    { "setPaint", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGPaintPrototypeFunctionSetPaint), (intptr_t) (4) } },
    { "SVG_PAINTTYPE_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_PAINTTYPE_RGBCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_PAINTTYPE_NONE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(101) } },
    { "SVG_PAINTTYPE_CURRENTCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(102) } },
    { "SVG_PAINTTYPE_URI_NONE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(103) } },
    { "SVG_PAINTTYPE_URI_CURRENTCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(104) } },
    { "SVG_PAINTTYPE_URI_RGBCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(105) } },
    { "SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(106) } },
    { "SVG_PAINTTYPE_URI", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(107) } },
};

const ClassInfo JSSVGPaintPrototype::s_info = { "SVGPaintPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPaintPrototype) };

void JSSVGPaintPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPaintPrototypeTableValues, *this);
}

const ClassInfo JSSVGPaint::s_info = { "SVGPaint", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPaint) };

JSSVGPaint::JSSVGPaint(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPaint>&& impl)
    : JSSVGColor(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGPaint::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGPaintPrototype::create(vm, globalObject, JSSVGPaintPrototype::createStructure(vm, globalObject, JSSVGColor::getPrototype(vm, globalObject)));
}

JSObject* JSSVGPaint::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPaint>(vm, globalObject);
}

EncodedJSValue jsSVGPaintPaintType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPaint*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPaint", "paintType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.paintType());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPaintUri(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPaint*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPaint", "uri");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.uri());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPaintConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGPaintPrototype* domObject = jsDynamicCast<JSSVGPaintPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGPaint::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGPaintConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGPaintPrototype* domObject = jsDynamicCast<JSSVGPaintPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGPaint::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPaintConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGPaintPrototypeFunctionSetUri(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGPaint*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGPaint", "setUri");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGPaint::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String uri = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setUri(uri);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGPaintPrototypeFunctionSetPaint(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGPaint*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGPaint", "setPaint");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGPaint::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 4))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    uint16_t paintType = toUInt16(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String uri = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String rgbColor = state->argument(2).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String iccColor = state->argument(3).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setPaint(paintType, uri, rgbColor, iccColor, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}


}
