/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGColor.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSRGBColor.h"
#include "RGBColor.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetRGBColor(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetRGBColorICCColor(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetColor(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsSVGColorColorType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGColorRgbColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGColorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGColorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGColorPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGColorPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGColorPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGColorPrototype>(vm.heap)) JSSVGColorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGColorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGColor> JSSVGColorConstructor;

/* Hash table for constructor */

static const HashTableValue JSSVGColorConstructorTableValues[] =
{
    { "SVG_COLORTYPE_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_COLORTYPE_RGBCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_COLORTYPE_RGBCOLOR_ICCCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_COLORTYPE_CURRENTCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};


COMPILE_ASSERT(0 == SVGColor::SVG_COLORTYPE_UNKNOWN, SVGColorEnumSVG_COLORTYPE_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGColor::SVG_COLORTYPE_RGBCOLOR, SVGColorEnumSVG_COLORTYPE_RGBCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGColor::SVG_COLORTYPE_RGBCOLOR_ICCCOLOR, SVGColorEnumSVG_COLORTYPE_RGBCOLOR_ICCCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == SVGColor::SVG_COLORTYPE_CURRENTCOLOR, SVGColorEnumSVG_COLORTYPE_CURRENTCOLORIsWrongUseDoNotCheckConstants);

template<> JSValue JSSVGColorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSValue::getConstructor(vm, &globalObject);
}

template<> void JSSVGColorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGColor::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGColor"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSSVGColorConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGColorConstructor::s_info = { "SVGColor", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGColorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGColorPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGColorConstructor) } },
    { "colorType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorColorType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rgbColor", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorRgbColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "setRGBColor", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGColorPrototypeFunctionSetRGBColor), (intptr_t) (1) } },
    { "setRGBColorICCColor", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGColorPrototypeFunctionSetRGBColorICCColor), (intptr_t) (2) } },
    { "setColor", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGColorPrototypeFunctionSetColor), (intptr_t) (3) } },
    { "SVG_COLORTYPE_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_COLORTYPE_RGBCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_COLORTYPE_RGBCOLOR_ICCCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_COLORTYPE_CURRENTCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSSVGColorPrototype::s_info = { "SVGColorPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGColorPrototype) };

void JSSVGColorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGColorPrototypeTableValues, *this);
}

const ClassInfo JSSVGColor::s_info = { "SVGColor", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGColor) };

JSSVGColor::JSSVGColor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGColor>&& impl)
    : JSCSSValue(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGColor::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGColorPrototype::create(vm, globalObject, JSSVGColorPrototype::createStructure(vm, globalObject, JSCSSValue::getPrototype(vm, globalObject)));
}

JSObject* JSSVGColor::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGColor>(vm, globalObject);
}

EncodedJSValue jsSVGColorColorType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGColor*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGColor", "colorType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.colorType());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGColorRgbColor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGColor*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGColor", "rgbColor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.rgbColor()));
    return JSValue::encode(result);
}


EncodedJSValue jsSVGColorConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGColorPrototype* domObject = jsDynamicCast<JSSVGColorPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGColor::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGColorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGColorPrototype* domObject = jsDynamicCast<JSSVGColorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGColor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGColorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetRGBColor(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGColor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGColor", "setRGBColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGColor::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String rgbColor = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setRGBColor(rgbColor, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetRGBColorICCColor(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGColor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGColor", "setRGBColorICCColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGColor::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String rgbColor = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String iccColor = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setRGBColorICCColor(rgbColor, iccColor, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetColor(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGColor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGColor", "setColor");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGColor::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    uint16_t colorType = toUInt16(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String rgbColor = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String iccColor = state->argument(2).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setColor(colorType, rgbColor, iccColor, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}


}
