/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGAnimatedRect.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSSVGRect.h"
#include "SVGRect.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGAnimatedRectBaseVal(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGAnimatedRectAnimVal(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGAnimatedRectConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGAnimatedRectConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGAnimatedRectPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGAnimatedRectPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAnimatedRectPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAnimatedRectPrototype>(vm.heap)) JSSVGAnimatedRectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAnimatedRectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGAnimatedRect> JSSVGAnimatedRectConstructor;

template<> JSValue JSSVGAnimatedRectConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGAnimatedRectConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGAnimatedRect::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGAnimatedRect"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGAnimatedRectConstructor::s_info = { "SVGAnimatedRect", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAnimatedRectConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedRectPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedRectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAnimatedRectConstructor) } },
    { "baseVal", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedRectBaseVal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "animVal", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedRectAnimVal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSVGAnimatedRectPrototype::s_info = { "SVGAnimatedRectPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAnimatedRectPrototype) };

void JSSVGAnimatedRectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAnimatedRectPrototypeTableValues, *this);
}

const ClassInfo JSSVGAnimatedRect::s_info = { "SVGAnimatedRect", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAnimatedRect) };

JSSVGAnimatedRect::JSSVGAnimatedRect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGAnimatedRect>&& impl)
    : JSDOMWrapper<SVGAnimatedRect>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGAnimatedRect::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedRectPrototype::create(vm, globalObject, JSSVGAnimatedRectPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGAnimatedRect::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedRect>(vm, globalObject);
}

void JSSVGAnimatedRect::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedRect* thisObject = static_cast<JSSVGAnimatedRect*>(cell);
    thisObject->JSSVGAnimatedRect::~JSSVGAnimatedRect();
}

EncodedJSValue jsSVGAnimatedRectBaseVal(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGAnimatedRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGAnimatedRect", "baseVal");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPropertyTearOff<FloatRect>*>(impl.baseVal().get())));
    return JSValue::encode(result);
}


EncodedJSValue jsSVGAnimatedRectAnimVal(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGAnimatedRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGAnimatedRect", "animVal");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPropertyTearOff<FloatRect>*>(impl.animVal().get())));
    return JSValue::encode(result);
}


EncodedJSValue jsSVGAnimatedRectConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGAnimatedRectPrototype* domObject = jsDynamicCast<JSSVGAnimatedRectPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGAnimatedRect::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGAnimatedRectConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGAnimatedRectPrototype* domObject = jsDynamicCast<JSSVGAnimatedRectPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGAnimatedRect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedRectConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSSVGAnimatedRectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedRectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGAnimatedRect = jsCast<JSSVGAnimatedRect*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGAnimatedRect->wrapped(), jsSVGAnimatedRect);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGAnimatedRect* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGAnimatedRect>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGAnimatedRect* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGAnimatedRect>(globalObject, impl))
        return result;
    return createNewWrapper<JSSVGAnimatedRect>(globalObject, impl);
}

SVGAnimatedRect* JSSVGAnimatedRect::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGAnimatedRect*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
