/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGAngle.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSVGAnglePrototypeFunctionNewValueSpecifiedUnits(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGAnglePrototypeFunctionConvertToSpecifiedUnits(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsSVGAngleUnitType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGAngleValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGAngleValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGAngleValueInSpecifiedUnits(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGAngleValueInSpecifiedUnits(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGAngleValueAsString(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGAngleValueAsString(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGAngleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGAngleConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGAnglePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGAnglePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAnglePrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAnglePrototype>(vm.heap)) JSSVGAnglePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAnglePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGAngle> JSSVGAngleConstructor;

/* Hash table for constructor */

static const HashTableValue JSSVGAngleConstructorTableValues[] =
{
    { "SVG_ANGLETYPE_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_ANGLETYPE_UNSPECIFIED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_ANGLETYPE_DEG", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_ANGLETYPE_RAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_ANGLETYPE_GRAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
};


COMPILE_ASSERT(0 == SVGAngle::SVG_ANGLETYPE_UNKNOWN, SVGAngleEnumSVG_ANGLETYPE_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGAngle::SVG_ANGLETYPE_UNSPECIFIED, SVGAngleEnumSVG_ANGLETYPE_UNSPECIFIEDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGAngle::SVG_ANGLETYPE_DEG, SVGAngleEnumSVG_ANGLETYPE_DEGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == SVGAngle::SVG_ANGLETYPE_RAD, SVGAngleEnumSVG_ANGLETYPE_RADIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == SVGAngle::SVG_ANGLETYPE_GRAD, SVGAngleEnumSVG_ANGLETYPE_GRADIsWrongUseDoNotCheckConstants);

template<> JSValue JSSVGAngleConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGAngleConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGAngle::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGAngle"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSSVGAngleConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGAngleConstructor::s_info = { "SVGAngle", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAngleConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGAnglePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAngleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAngleConstructor) } },
    { "unitType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAngleUnitType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "value", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAngleValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAngleValue) } },
    { "valueInSpecifiedUnits", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAngleValueInSpecifiedUnits), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAngleValueInSpecifiedUnits) } },
    { "valueAsString", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAngleValueAsString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAngleValueAsString) } },
    { "newValueSpecifiedUnits", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGAnglePrototypeFunctionNewValueSpecifiedUnits), (intptr_t) (2) } },
    { "convertToSpecifiedUnits", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGAnglePrototypeFunctionConvertToSpecifiedUnits), (intptr_t) (1) } },
    { "SVG_ANGLETYPE_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_ANGLETYPE_UNSPECIFIED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_ANGLETYPE_DEG", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_ANGLETYPE_RAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_ANGLETYPE_GRAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
};

const ClassInfo JSSVGAnglePrototype::s_info = { "SVGAnglePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAnglePrototype) };

void JSSVGAnglePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAnglePrototypeTableValues, *this);
}

const ClassInfo JSSVGAngle::s_info = { "SVGAngle", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAngle) };

JSSVGAngle::JSSVGAngle(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPropertyTearOff<SVGAngle>>&& impl)
    : JSDOMWrapper<SVGPropertyTearOff<SVGAngle>>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGAngle::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGAnglePrototype::create(vm, globalObject, JSSVGAnglePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGAngle::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAngle>(vm, globalObject);
}

void JSSVGAngle::destroy(JSC::JSCell* cell)
{
    JSSVGAngle* thisObject = static_cast<JSSVGAngle*>(cell);
    thisObject->JSSVGAngle::~JSSVGAngle();
}

EncodedJSValue jsSVGAngleUnitType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGAngle*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGAngle", "unitType");
    }
    SVGAngle& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.unitType());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGAngleValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGAngle*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGAngle", "value");
    }
    SVGAngle& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.value());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGAngleValueInSpecifiedUnits(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGAngle*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGAngle", "valueInSpecifiedUnits");
    }
    SVGAngle& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.valueInSpecifiedUnits());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGAngleValueAsString(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGAngle*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGAngle", "valueAsString");
    }
    SVGAngle& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsStringWithCache(state, impl.valueAsString());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGAngleConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGAnglePrototype* domObject = jsDynamicCast<JSSVGAnglePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGAngle::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGAngleConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGAnglePrototype* domObject = jsDynamicCast<JSSVGAnglePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSVGAngleValue(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGAngle* castedThis = jsDynamicCast<JSSVGAngle*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGAngle", "value");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGAngle& podImpl = impl.propertyReference();
    podImpl.setValue(nativeValue);
    impl.commitChange();
}


void setJSSVGAngleValueInSpecifiedUnits(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGAngle* castedThis = jsDynamicCast<JSSVGAngle*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGAngle", "valueInSpecifiedUnits");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGAngle& podImpl = impl.propertyReference();
    podImpl.setValueInSpecifiedUnits(nativeValue);
    impl.commitChange();
}


void setJSSVGAngleValueAsString(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGAngle* castedThis = jsDynamicCast<JSSVGAngle*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGAngle", "valueAsString");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGAngle& podImpl = impl.propertyReference();
    podImpl.setValueAsString(nativeValue, ec);
    setDOMException(state, ec);
    if (!ec)
        impl.commitChange();
}


JSValue JSSVGAngle::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAngleConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGAnglePrototypeFunctionNewValueSpecifiedUnits(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGAngle*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGAngle", "newValueSpecifiedUnits");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGAngle::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGAngle& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    uint16_t unitType = toUInt16(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float valueInSpecifiedUnits = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    podImpl.newValueSpecifiedUnits(unitType, valueInSpecifiedUnits, ec);
    setDOMException(state, ec);
    if (!ec)
        impl.commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGAnglePrototypeFunctionConvertToSpecifiedUnits(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGAngle*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGAngle", "convertToSpecifiedUnits");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGAngle::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGAngle& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    uint16_t unitType = toUInt16(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    podImpl.convertToSpecifiedUnits(unitType, ec);
    setDOMException(state, ec);
    if (!ec)
        impl.commitChange();
    return JSValue::encode(jsUndefined());
}

bool JSSVGAngleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAngleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGAngle = jsCast<JSSVGAngle*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGAngle->wrapped(), jsSVGAngle);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGAngle>* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGAngle, SVGPropertyTearOff<SVGAngle>>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGAngle>* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGAngle, SVGPropertyTearOff<SVGAngle>>(globalObject, impl))
        return result;
    return createNewWrapper<JSSVGAngle, SVGPropertyTearOff<SVGAngle>>(globalObject, impl);
}

SVGPropertyTearOff<SVGAngle>* JSSVGAngle::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGAngle*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
