/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSProcessingInstruction.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSStyleSheet.h"
#include "StyleSheet.h"
#include "URL.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsProcessingInstructionTarget(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsProcessingInstructionSheet(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsProcessingInstructionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSProcessingInstructionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSProcessingInstructionPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSProcessingInstructionPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSProcessingInstructionPrototype* ptr = new (NotNull, JSC::allocateCell<JSProcessingInstructionPrototype>(vm.heap)) JSProcessingInstructionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSProcessingInstructionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSProcessingInstruction> JSProcessingInstructionConstructor;

template<> JSValue JSProcessingInstructionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCharacterData::getConstructor(vm, &globalObject);
}

template<> void JSProcessingInstructionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSProcessingInstruction::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ProcessingInstruction"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSProcessingInstructionConstructor::s_info = { "ProcessingInstruction", &Base::s_info, 0, CREATE_METHOD_TABLE(JSProcessingInstructionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSProcessingInstructionPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsProcessingInstructionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSProcessingInstructionConstructor) } },
    { "target", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsProcessingInstructionTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sheet", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsProcessingInstructionSheet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSProcessingInstructionPrototype::s_info = { "ProcessingInstructionPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSProcessingInstructionPrototype) };

void JSProcessingInstructionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSProcessingInstructionPrototypeTableValues, *this);
}

const ClassInfo JSProcessingInstruction::s_info = { "ProcessingInstruction", &Base::s_info, 0, CREATE_METHOD_TABLE(JSProcessingInstruction) };

JSProcessingInstruction::JSProcessingInstruction(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ProcessingInstruction>&& impl)
    : JSCharacterData(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSProcessingInstruction::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSProcessingInstructionPrototype::create(vm, globalObject, JSProcessingInstructionPrototype::createStructure(vm, globalObject, JSCharacterData::getPrototype(vm, globalObject)));
}

JSObject* JSProcessingInstruction::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSProcessingInstruction>(vm, globalObject);
}

EncodedJSValue jsProcessingInstructionTarget(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSProcessingInstruction*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ProcessingInstruction", "target");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.target());
    return JSValue::encode(result);
}


EncodedJSValue jsProcessingInstructionSheet(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSProcessingInstruction*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ProcessingInstruction", "sheet");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.sheet()));
    return JSValue::encode(result);
}


EncodedJSValue jsProcessingInstructionConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSProcessingInstructionPrototype* domObject = jsDynamicCast<JSProcessingInstructionPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSProcessingInstruction::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSProcessingInstructionConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSProcessingInstructionPrototype* domObject = jsDynamicCast<JSProcessingInstructionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSProcessingInstruction::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSProcessingInstructionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSProcessingInstruction::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSProcessingInstruction*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ProcessingInstruction@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21ProcessingInstructionE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, ProcessingInstruction* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSProcessingInstruction>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, ProcessingInstruction* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSProcessingInstruction>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7ProcessingInstruction@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore21ProcessingInstructionE[2];
#if COMPILER(CLANG)
    // If this fails ProcessingInstruction does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(ProcessingInstruction), ProcessingInstruction_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // ProcessingInstruction has subclasses. If ProcessingInstruction has subclasses that get passed
    // to toJS() we currently require ProcessingInstruction you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSProcessingInstruction>(globalObject, impl);
}


}
