/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSPerformanceNavigation.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsPerformanceNavigationType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceNavigationRedirectCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceNavigationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPerformanceNavigationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPerformanceNavigationPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSPerformanceNavigationPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPerformanceNavigationPrototype* ptr = new (NotNull, JSC::allocateCell<JSPerformanceNavigationPrototype>(vm.heap)) JSPerformanceNavigationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPerformanceNavigationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSPerformanceNavigation> JSPerformanceNavigationConstructor;

/* Hash table for constructor */

static const HashTableValue JSPerformanceNavigationConstructorTableValues[] =
{
    { "TYPE_NAVIGATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "TYPE_RELOAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "TYPE_BACK_FORWARD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TYPE_RESERVED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(255) } },
};


COMPILE_ASSERT(0 == PerformanceNavigation::TYPE_NAVIGATE, PerformanceNavigationEnumTYPE_NAVIGATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == PerformanceNavigation::TYPE_RELOAD, PerformanceNavigationEnumTYPE_RELOADIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == PerformanceNavigation::TYPE_BACK_FORWARD, PerformanceNavigationEnumTYPE_BACK_FORWARDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(255 == PerformanceNavigation::TYPE_RESERVED, PerformanceNavigationEnumTYPE_RESERVEDIsWrongUseDoNotCheckConstants);

template<> JSValue JSPerformanceNavigationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPerformanceNavigationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPerformanceNavigation::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("PerformanceNavigation"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSPerformanceNavigationConstructorTableValues, *this);
}

template<> const ClassInfo JSPerformanceNavigationConstructor::s_info = { "PerformanceNavigation", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPerformanceNavigationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPerformanceNavigationPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPerformanceNavigationConstructor) } },
    { "type", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "redirectCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationRedirectCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "TYPE_NAVIGATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "TYPE_RELOAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "TYPE_BACK_FORWARD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TYPE_RESERVED", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(255) } },
};

const ClassInfo JSPerformanceNavigationPrototype::s_info = { "PerformanceNavigationPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPerformanceNavigationPrototype) };

void JSPerformanceNavigationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPerformanceNavigationPrototypeTableValues, *this);
}

const ClassInfo JSPerformanceNavigation::s_info = { "PerformanceNavigation", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPerformanceNavigation) };

JSPerformanceNavigation::JSPerformanceNavigation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PerformanceNavigation>&& impl)
    : JSDOMWrapper<PerformanceNavigation>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSPerformanceNavigation::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSPerformanceNavigationPrototype::create(vm, globalObject, JSPerformanceNavigationPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSPerformanceNavigation::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPerformanceNavigation>(vm, globalObject);
}

void JSPerformanceNavigation::destroy(JSC::JSCell* cell)
{
    JSPerformanceNavigation* thisObject = static_cast<JSPerformanceNavigation*>(cell);
    thisObject->JSPerformanceNavigation::~JSPerformanceNavigation();
}

EncodedJSValue jsPerformanceNavigationType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceNavigation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceNavigation", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceNavigationRedirectCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformanceNavigation*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "PerformanceNavigation", "redirectCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.redirectCount());
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceNavigationConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSPerformanceNavigationPrototype* domObject = jsDynamicCast<JSPerformanceNavigationPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSPerformanceNavigation::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSPerformanceNavigationConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSPerformanceNavigationPrototype* domObject = jsDynamicCast<JSPerformanceNavigationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSPerformanceNavigation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceNavigationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSPerformanceNavigationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSPerformanceNavigationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPerformanceNavigation = jsCast<JSPerformanceNavigation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPerformanceNavigation->wrapped(), jsPerformanceNavigation);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PerformanceNavigation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21PerformanceNavigationE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, PerformanceNavigation* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSPerformanceNavigation>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, PerformanceNavigation* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPerformanceNavigation>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7PerformanceNavigation@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore21PerformanceNavigationE[2];
#if COMPILER(CLANG)
    // If this fails PerformanceNavigation does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(PerformanceNavigation), PerformanceNavigation_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // PerformanceNavigation has subclasses. If PerformanceNavigation has subclasses that get passed
    // to toJS() we currently require PerformanceNavigation you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSPerformanceNavigation>(globalObject, impl);
}

PerformanceNavigation* JSPerformanceNavigation::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPerformanceNavigation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_TIMING)
