/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSOfflineAudioCompletionEvent.h"

#include "AudioBuffer.h"
#include "JSAudioBuffer.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsOfflineAudioCompletionEventRenderedBuffer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOfflineAudioCompletionEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSOfflineAudioCompletionEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSOfflineAudioCompletionEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSOfflineAudioCompletionEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOfflineAudioCompletionEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSOfflineAudioCompletionEventPrototype>(vm.heap)) JSOfflineAudioCompletionEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOfflineAudioCompletionEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSOfflineAudioCompletionEvent> JSOfflineAudioCompletionEventConstructor;

template<> JSValue JSOfflineAudioCompletionEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSOfflineAudioCompletionEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSOfflineAudioCompletionEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("OfflineAudioCompletionEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSOfflineAudioCompletionEventConstructor::s_info = { "OfflineAudioCompletionEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOfflineAudioCompletionEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSOfflineAudioCompletionEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOfflineAudioCompletionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOfflineAudioCompletionEventConstructor) } },
    { "renderedBuffer", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOfflineAudioCompletionEventRenderedBuffer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSOfflineAudioCompletionEventPrototype::s_info = { "OfflineAudioCompletionEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOfflineAudioCompletionEventPrototype) };

void JSOfflineAudioCompletionEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOfflineAudioCompletionEventPrototypeTableValues, *this);
}

const ClassInfo JSOfflineAudioCompletionEvent::s_info = { "OfflineAudioCompletionEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOfflineAudioCompletionEvent) };

JSOfflineAudioCompletionEvent::JSOfflineAudioCompletionEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OfflineAudioCompletionEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSOfflineAudioCompletionEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSOfflineAudioCompletionEventPrototype::create(vm, globalObject, JSOfflineAudioCompletionEventPrototype::createStructure(vm, globalObject, JSEvent::getPrototype(vm, globalObject)));
}

JSObject* JSOfflineAudioCompletionEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOfflineAudioCompletionEvent>(vm, globalObject);
}

EncodedJSValue jsOfflineAudioCompletionEventRenderedBuffer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSOfflineAudioCompletionEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "OfflineAudioCompletionEvent", "renderedBuffer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.renderedBuffer()));
    return JSValue::encode(result);
}


EncodedJSValue jsOfflineAudioCompletionEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSOfflineAudioCompletionEventPrototype* domObject = jsDynamicCast<JSOfflineAudioCompletionEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSOfflineAudioCompletionEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSOfflineAudioCompletionEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSOfflineAudioCompletionEventPrototype* domObject = jsDynamicCast<JSOfflineAudioCompletionEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSOfflineAudioCompletionEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOfflineAudioCompletionEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OfflineAudioCompletionEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27OfflineAudioCompletionEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, OfflineAudioCompletionEvent* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSOfflineAudioCompletionEvent>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, OfflineAudioCompletionEvent* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSOfflineAudioCompletionEvent>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7OfflineAudioCompletionEvent@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore27OfflineAudioCompletionEventE[2];
#if COMPILER(CLANG)
    // If this fails OfflineAudioCompletionEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(OfflineAudioCompletionEvent), OfflineAudioCompletionEvent_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // OfflineAudioCompletionEvent has subclasses. If OfflineAudioCompletionEvent has subclasses that get passed
    // to toJS() we currently require OfflineAudioCompletionEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSOfflineAudioCompletionEvent>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
