/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESStandardDerivatives.h"

#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

class JSOESStandardDerivativesPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSOESStandardDerivativesPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESStandardDerivativesPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESStandardDerivativesPrototype>(vm.heap)) JSOESStandardDerivativesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESStandardDerivativesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSOESStandardDerivativesPrototypeTableValues[] =
{
    { "FRAGMENT_SHADER_DERIVATIVE_HINT_OES", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8B8B) } },
};

const ClassInfo JSOESStandardDerivativesPrototype::s_info = { "OESStandardDerivativesPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOESStandardDerivativesPrototype) };

void JSOESStandardDerivativesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOESStandardDerivativesPrototypeTableValues, *this);
}

const ClassInfo JSOESStandardDerivatives::s_info = { "OESStandardDerivatives", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOESStandardDerivatives) };

JSOESStandardDerivatives::JSOESStandardDerivatives(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESStandardDerivatives>&& impl)
    : JSDOMWrapper<OESStandardDerivatives>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSOESStandardDerivatives::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSOESStandardDerivativesPrototype::create(vm, globalObject, JSOESStandardDerivativesPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSOESStandardDerivatives::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOESStandardDerivatives>(vm, globalObject);
}

void JSOESStandardDerivatives::destroy(JSC::JSCell* cell)
{
    JSOESStandardDerivatives* thisObject = static_cast<JSOESStandardDerivatives*>(cell);
    thisObject->JSOESStandardDerivatives::~JSOESStandardDerivatives();
}

bool JSOESStandardDerivativesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsOESStandardDerivatives = jsCast<JSOESStandardDerivatives*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsOESStandardDerivatives->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSOESStandardDerivativesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESStandardDerivatives = jsCast<JSOESStandardDerivatives*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESStandardDerivatives->wrapped(), jsOESStandardDerivatives);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESStandardDerivatives@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22OESStandardDerivativesE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, OESStandardDerivatives* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSOESStandardDerivatives>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, OESStandardDerivatives* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSOESStandardDerivatives>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7OESStandardDerivatives@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22OESStandardDerivativesE[2];
#if COMPILER(CLANG)
    // If this fails OESStandardDerivatives does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(OESStandardDerivatives), OESStandardDerivatives_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // OESStandardDerivatives has subclasses. If OESStandardDerivatives has subclasses that get passed
    // to toJS() we currently require OESStandardDerivatives you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSOESStandardDerivatives>(globalObject, impl);
}

OESStandardDerivatives* JSOESStandardDerivatives::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESStandardDerivatives*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
