/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNodeIterator.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "Node.h"
#include "NodeFilter.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionNextNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionPreviousNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionDetach(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsNodeIteratorRoot(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeIteratorWhatToShow(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeIteratorFilter(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeIteratorReferenceNode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeIteratorPointerBeforeReferenceNode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeIteratorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNodeIteratorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSNodeIteratorPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSNodeIteratorPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNodeIteratorPrototype* ptr = new (NotNull, JSC::allocateCell<JSNodeIteratorPrototype>(vm.heap)) JSNodeIteratorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNodeIteratorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSNodeIterator> JSNodeIteratorConstructor;

template<> JSValue JSNodeIteratorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNodeIteratorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSNodeIterator::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("NodeIterator"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSNodeIteratorConstructor::s_info = { "NodeIterator", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNodeIteratorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSNodeIteratorPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNodeIteratorConstructor) } },
    { "root", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorRoot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "whatToShow", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorWhatToShow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "filter", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorFilter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "referenceNode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorReferenceNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pointerBeforeReferenceNode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorPointerBeforeReferenceNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "nextNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodeIteratorPrototypeFunctionNextNode), (intptr_t) (0) } },
    { "previousNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodeIteratorPrototypeFunctionPreviousNode), (intptr_t) (0) } },
    { "detach", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNodeIteratorPrototypeFunctionDetach), (intptr_t) (0) } },
};

const ClassInfo JSNodeIteratorPrototype::s_info = { "NodeIteratorPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNodeIteratorPrototype) };

void JSNodeIteratorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNodeIteratorPrototypeTableValues, *this);
}

const ClassInfo JSNodeIterator::s_info = { "NodeIterator", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNodeIterator) };

JSNodeIterator::JSNodeIterator(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NodeIterator>&& impl)
    : JSDOMWrapper<NodeIterator>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSNodeIterator::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSNodeIteratorPrototype::create(vm, globalObject, JSNodeIteratorPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSNodeIterator::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNodeIterator>(vm, globalObject);
}

void JSNodeIterator::destroy(JSC::JSCell* cell)
{
    JSNodeIterator* thisObject = static_cast<JSNodeIterator*>(cell);
    thisObject->JSNodeIterator::~JSNodeIterator();
}

EncodedJSValue jsNodeIteratorRoot(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNodeIterator*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "NodeIterator", "root");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.root()));
    return JSValue::encode(result);
}


EncodedJSValue jsNodeIteratorWhatToShow(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNodeIterator*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "NodeIterator", "whatToShow");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.whatToShow());
    return JSValue::encode(result);
}


EncodedJSValue jsNodeIteratorFilter(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNodeIterator*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "NodeIterator", "filter");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.filter()));
    return JSValue::encode(result);
}


EncodedJSValue jsNodeIteratorReferenceNode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNodeIterator*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "NodeIterator", "referenceNode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.referenceNode()));
    return JSValue::encode(result);
}


EncodedJSValue jsNodeIteratorPointerBeforeReferenceNode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNodeIterator*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "NodeIterator", "pointerBeforeReferenceNode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.pointerBeforeReferenceNode());
    return JSValue::encode(result);
}


EncodedJSValue jsNodeIteratorConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSNodeIteratorPrototype* domObject = jsDynamicCast<JSNodeIteratorPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSNodeIterator::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSNodeIteratorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSNodeIteratorPrototype* domObject = jsDynamicCast<JSNodeIteratorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSNodeIterator::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNodeIteratorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionNextNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNodeIterator*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "NodeIterator", "nextNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNodeIterator::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.nextNode()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionPreviousNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNodeIterator*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "NodeIterator", "previousNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNodeIterator::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.previousNode()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionDetach(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNodeIterator*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "NodeIterator", "detach");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNodeIterator::info());
    auto& impl = castedThis->wrapped();
    impl.detach();
    return JSValue::encode(jsUndefined());
}

void JSNodeIterator::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSNodeIterator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSNodeIteratorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSNodeIteratorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNodeIterator = jsCast<JSNodeIterator*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsNodeIterator->wrapped(), jsNodeIterator);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, NodeIterator* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSNodeIterator>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, NodeIterator* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSNodeIterator>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to NodeIterator.
    COMPILE_ASSERT(!__is_polymorphic(NodeIterator), NodeIterator_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSNodeIterator>(globalObject, impl);
}

NodeIterator* JSNodeIterator::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNodeIterator*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
