/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSMediaSource.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSSourceBuffer.h"
#include "JSSourceBufferList.h"
#include "SourceBuffer.h"
#include "SourceBufferList.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionAddSourceBuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionRemoveSourceBuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionEndOfStream(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaSourceConstructorFunctionIsTypeSupported(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsMediaSourceSourceBuffers(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaSourceActiveSourceBuffers(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaSourceDuration(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaSourceDuration(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaSourceReadyState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaSourceConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaSourceConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaSourcePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMediaSourcePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaSourcePrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaSourcePrototype>(vm.heap)) JSMediaSourcePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaSourcePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSMediaSource> JSMediaSourceConstructor;

/* Hash table for constructor */

static const HashTableValue JSMediaSourceConstructorTableValues[] =
{
    { "isTypeSupported", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaSourceConstructorFunctionIsTypeSupported), (intptr_t) (1) } },
};

template<> EncodedJSValue JSC_HOST_CALL JSMediaSourceConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSMediaSourceConstructor*>(state->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "MediaSource");
    RefPtr<MediaSource> object = MediaSource::create(*context);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSMediaSourceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaSourceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaSource::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MediaSource"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSMediaSourceConstructorTableValues, *this);
}

template<> const ClassInfo JSMediaSourceConstructor::s_info = { "MediaSource", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaSourceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaSourcePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaSourceConstructor) } },
    { "sourceBuffers", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceSourceBuffers), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "activeSourceBuffers", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceActiveSourceBuffers), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "duration", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceDuration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaSourceDuration) } },
    { "readyState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "addSourceBuffer", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaSourcePrototypeFunctionAddSourceBuffer), (intptr_t) (1) } },
    { "removeSourceBuffer", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaSourcePrototypeFunctionRemoveSourceBuffer), (intptr_t) (1) } },
    { "endOfStream", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaSourcePrototypeFunctionEndOfStream), (intptr_t) (0) } },
};

const ClassInfo JSMediaSourcePrototype::s_info = { "MediaSourcePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaSourcePrototype) };

void JSMediaSourcePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaSourcePrototypeTableValues, *this);
}

const ClassInfo JSMediaSource::s_info = { "MediaSource", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaSource) };

JSMediaSource::JSMediaSource(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaSource>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMediaSource::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMediaSourcePrototype::create(vm, globalObject, JSMediaSourcePrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSMediaSource::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaSource>(vm, globalObject);
}

EncodedJSValue jsMediaSourceSourceBuffers(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaSource", "sourceBuffers");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.sourceBuffers()));
    return JSValue::encode(result);
}


EncodedJSValue jsMediaSourceActiveSourceBuffers(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaSource", "activeSourceBuffers");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.activeSourceBuffers()));
    return JSValue::encode(result);
}


EncodedJSValue jsMediaSourceDuration(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaSource", "duration");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.duration());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaSourceReadyState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaSource*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaSource", "readyState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.readyState());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaSourceConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSMediaSourcePrototype* domObject = jsDynamicCast<JSMediaSourcePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSMediaSource::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSMediaSourceConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMediaSourcePrototype* domObject = jsDynamicCast<JSMediaSourcePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSMediaSourceDuration(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSMediaSource* castedThis = jsDynamicCast<JSMediaSource*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "MediaSource", "duration");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDuration(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSMediaSource::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaSourceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionAddSourceBuffer(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaSource*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaSource", "addSourceBuffer");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaSource::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String type = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.addSourceBuffer(type, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionRemoveSourceBuffer(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaSource*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaSource", "removeSourceBuffer");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaSource::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    SourceBuffer* buffer = JSSourceBuffer::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.removeSourceBuffer(buffer, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionEndOfStream(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaSource*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaSource", "endOfStream");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaSource::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.endOfStream(ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    // Keep pointer to the JSString in a local so we don't need to ref the String.
    auto* errorString = state->argument(0).toString(state);
    auto& error = errorString->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (error != "network" && error != "decode")
        return throwArgumentMustBeEnumError(*state, 0, "error", "MediaSource", "endOfStream", "\"network\", \"decode\"");
    impl.endOfStream(error, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSourceConstructorFunctionIsTypeSupported(ExecState* state)
{
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String type = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(MediaSource::isTypeSupported(type));
    return JSValue::encode(result);
}

void JSMediaSource::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSMediaSource*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSMediaSourceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsMediaSource = jsCast<JSMediaSource*>(handle.slot()->asCell());
    if (jsMediaSource->wrapped().hasPendingActivity())
        return true;
    if (jsMediaSource->wrapped().isFiringEventListeners())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSMediaSourceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaSource = jsCast<JSMediaSource*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaSource->wrapped(), jsMediaSource);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaSource@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11MediaSourceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaSource* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSMediaSource>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaSource* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMediaSource>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7MediaSource@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11MediaSourceE[2];
#if COMPILER(CLANG)
    // If this fails MediaSource does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(MediaSource), MediaSource_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // MediaSource has subclasses. If MediaSource has subclasses that get passed
    // to toJS() we currently require MediaSource you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSMediaSource>(globalObject, impl);
}

MediaSource* JSMediaSource::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaSource*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_SOURCE)
