/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSMediaController.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSTimeRanges.h"
#include "TimeRanges.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionPlay(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionPause(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionUnpause(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsMediaControllerBuffered(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControllerSeekable(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControllerDuration(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControllerCurrentTime(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaControllerCurrentTime(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaControllerPaused(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControllerPlayed(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControllerPlaybackState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControllerDefaultPlaybackRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaControllerDefaultPlaybackRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaControllerPlaybackRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaControllerPlaybackRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaControllerVolume(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaControllerVolume(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaControllerMuted(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaControllerMuted(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaControllerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMediaControllerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaControllerPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMediaControllerPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaControllerPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaControllerPrototype>(vm.heap)) JSMediaControllerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaControllerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSMediaController> JSMediaControllerConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSMediaControllerConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSMediaControllerConstructor*>(state->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "MediaController");
    RefPtr<MediaController> object = MediaController::create(*context);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSMediaControllerConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaControllerConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaController::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MediaController"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSMediaControllerConstructor::s_info = { "MediaController", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaControllerConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaControllerPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaControllerConstructor) } },
    { "buffered", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerBuffered), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "seekable", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerSeekable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "duration", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerDuration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentTime", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerCurrentTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaControllerCurrentTime) } },
    { "paused", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerPaused), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "played", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerPlayed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "playbackState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerPlaybackState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "defaultPlaybackRate", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerDefaultPlaybackRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaControllerDefaultPlaybackRate) } },
    { "playbackRate", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerPlaybackRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaControllerPlaybackRate) } },
    { "volume", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerVolume), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaControllerVolume) } },
    { "muted", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControllerMuted), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaControllerMuted) } },
    { "play", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaControllerPrototypeFunctionPlay), (intptr_t) (0) } },
    { "pause", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaControllerPrototypeFunctionPause), (intptr_t) (0) } },
    { "unpause", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMediaControllerPrototypeFunctionUnpause), (intptr_t) (0) } },
};

const ClassInfo JSMediaControllerPrototype::s_info = { "MediaControllerPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaControllerPrototype) };

void JSMediaControllerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaControllerPrototypeTableValues, *this);
}

const ClassInfo JSMediaController::s_info = { "MediaController", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMediaController) };

JSMediaController::JSMediaController(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaController>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMediaController::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMediaControllerPrototype::create(vm, globalObject, JSMediaControllerPrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSMediaController::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaController>(vm, globalObject);
}

EncodedJSValue jsMediaControllerBuffered(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "buffered");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.buffered()));
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerSeekable(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "seekable");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.seekable()));
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerDuration(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "duration");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.duration());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerCurrentTime(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "currentTime");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.currentTime());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerPaused(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "paused");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.paused());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerPlayed(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "played");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.played()));
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerPlaybackState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "playbackState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.playbackState());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerDefaultPlaybackRate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "defaultPlaybackRate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.defaultPlaybackRate());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerPlaybackRate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "playbackRate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.playbackRate());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerVolume(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "volume");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.volume());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerMuted(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMediaController*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MediaController", "muted");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.muted());
    return JSValue::encode(result);
}


EncodedJSValue jsMediaControllerConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSMediaControllerPrototype* domObject = jsDynamicCast<JSMediaControllerPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSMediaController::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSMediaControllerConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMediaControllerPrototype* domObject = jsDynamicCast<JSMediaControllerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSMediaControllerCurrentTime(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSMediaController* castedThis = jsDynamicCast<JSMediaController*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "MediaController", "currentTime");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setCurrentTime(nativeValue);
}


void setJSMediaControllerDefaultPlaybackRate(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSMediaController* castedThis = jsDynamicCast<JSMediaController*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "MediaController", "defaultPlaybackRate");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDefaultPlaybackRate(nativeValue);
}


void setJSMediaControllerPlaybackRate(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSMediaController* castedThis = jsDynamicCast<JSMediaController*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "MediaController", "playbackRate");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPlaybackRate(nativeValue);
}


void setJSMediaControllerVolume(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSMediaController* castedThis = jsDynamicCast<JSMediaController*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "MediaController", "volume");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setVolume(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSMediaControllerMuted(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSMediaController* castedThis = jsDynamicCast<JSMediaController*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "MediaController", "muted");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMuted(nativeValue);
}


JSValue JSMediaController::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaControllerConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionPlay(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaController*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaController", "play");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaController::info());
    auto& impl = castedThis->wrapped();
    impl.play();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionPause(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaController*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaController", "pause");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaController::info());
    auto& impl = castedThis->wrapped();
    impl.pause();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionUnpause(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMediaController*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MediaController", "unpause");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMediaController::info());
    auto& impl = castedThis->wrapped();
    impl.unpause();
    return JSValue::encode(jsUndefined());
}

void JSMediaController::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSMediaController*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaController@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15MediaControllerE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaController* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSMediaController>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, MediaController* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMediaController>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7MediaController@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15MediaControllerE[2];
#if COMPILER(CLANG)
    // If this fails MediaController does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(MediaController), MediaController_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // MediaController has subclasses. If MediaController has subclasses that get passed
    // to toJS() we currently require MediaController you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSMediaController>(globalObject, impl);
}

MediaController* JSMediaController::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaController*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
