/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSKeyboardEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMWindow.h"
#include "JSDictionary.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsKeyboardEventPrototypeFunctionInitKeyboardEvent(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsKeyboardEventKeyIdentifier(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventLocation(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventKeyLocation(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventCtrlKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventShiftKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventAltKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventMetaKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventAltGraphKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSKeyboardEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSKeyboardEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSKeyboardEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSKeyboardEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSKeyboardEventPrototype>(vm.heap)) JSKeyboardEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSKeyboardEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSKeyboardEvent> JSKeyboardEventConstructor;

/* Hash table for constructor */

static const HashTableValue JSKeyboardEventConstructorTableValues[] =
{
    { "DOM_KEY_LOCATION_STANDARD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00) } },
    { "DOM_KEY_LOCATION_LEFT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x01) } },
    { "DOM_KEY_LOCATION_RIGHT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x02) } },
    { "DOM_KEY_LOCATION_NUMPAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x03) } },
};


COMPILE_ASSERT(0x00 == KeyboardEvent::DOM_KEY_LOCATION_STANDARD, KeyboardEventEnumDOM_KEY_LOCATION_STANDARDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x01 == KeyboardEvent::DOM_KEY_LOCATION_LEFT, KeyboardEventEnumDOM_KEY_LOCATION_LEFTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x02 == KeyboardEvent::DOM_KEY_LOCATION_RIGHT, KeyboardEventEnumDOM_KEY_LOCATION_RIGHTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x03 == KeyboardEvent::DOM_KEY_LOCATION_NUMPAD, KeyboardEventEnumDOM_KEY_LOCATION_NUMPADIsWrongUseDoNotCheckConstants);

template<> EncodedJSValue JSC_HOST_CALL JSKeyboardEventConstructor::construct(ExecState* state)
{
    auto* jsConstructor = jsCast<JSKeyboardEventConstructor*>(state->callee());

    if (!jsConstructor->scriptExecutionContext())
        return throwVMError(state, createReferenceError(state, "Constructor associated execution context is unavailable"));

    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));

    AtomicString eventType = state->argument(0).toString(state)->toAtomicString(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    KeyboardEventInit eventInit;

    JSValue initializerValue = state->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(state);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(state, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillKeyboardEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<KeyboardEvent> event = KeyboardEvent::createForBindings(eventType, eventInit);
    return JSValue::encode(toJS(state, jsConstructor->globalObject(), event.get()));
}

bool fillKeyboardEventInit(KeyboardEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillUIEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("keyIdentifier", eventInit.keyIdentifier))
        return false;
    if (!dictionary.tryGetProperty("location", eventInit.location))
        return false;
    if (!dictionary.tryGetProperty("keyLocation", eventInit.location))
        return false;
    if (!dictionary.tryGetProperty("ctrlKey", eventInit.ctrlKey))
        return false;
    if (!dictionary.tryGetProperty("shiftKey", eventInit.shiftKey))
        return false;
    if (!dictionary.tryGetProperty("altKey", eventInit.altKey))
        return false;
    if (!dictionary.tryGetProperty("metaKey", eventInit.metaKey))
        return false;
    return true;
}

template<> JSValue JSKeyboardEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSKeyboardEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSKeyboardEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("KeyboardEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSKeyboardEventConstructorTableValues, *this);
}

template<> ConstructType JSKeyboardEventConstructor::getConstructData(JSCell* cell, ConstructData& constructData)
{
#if ENABLE(DOM4_EVENTS_CONSTRUCTOR)
    UNUSED_PARAM(cell);
    constructData.native.function = construct;
    return ConstructTypeHost;
#else
    return Base::getConstructData(cell, constructData);
#endif
}

template<> const ClassInfo JSKeyboardEventConstructor::s_info = { "KeyboardEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSKeyboardEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSKeyboardEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSKeyboardEventConstructor) } },
    { "keyIdentifier", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventKeyIdentifier), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "location", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventLocation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "keyLocation", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventKeyLocation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ctrlKey", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventCtrlKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shiftKey", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventShiftKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "altKey", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventAltKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "metaKey", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventMetaKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "altGraphKey", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventAltGraphKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initKeyboardEvent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsKeyboardEventPrototypeFunctionInitKeyboardEvent), (intptr_t) (0) } },
    { "DOM_KEY_LOCATION_STANDARD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x00) } },
    { "DOM_KEY_LOCATION_LEFT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x01) } },
    { "DOM_KEY_LOCATION_RIGHT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x02) } },
    { "DOM_KEY_LOCATION_NUMPAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x03) } },
};

const ClassInfo JSKeyboardEventPrototype::s_info = { "KeyboardEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSKeyboardEventPrototype) };

void JSKeyboardEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSKeyboardEventPrototypeTableValues, *this);
}

const ClassInfo JSKeyboardEvent::s_info = { "KeyboardEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSKeyboardEvent) };

JSKeyboardEvent::JSKeyboardEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<KeyboardEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSKeyboardEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSKeyboardEventPrototype::create(vm, globalObject, JSKeyboardEventPrototype::createStructure(vm, globalObject, JSUIEvent::getPrototype(vm, globalObject)));
}

JSObject* JSKeyboardEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSKeyboardEvent>(vm, globalObject);
}

EncodedJSValue jsKeyboardEventKeyIdentifier(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSKeyboardEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "KeyboardEvent", "keyIdentifier");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.keyIdentifier());
    return JSValue::encode(result);
}


EncodedJSValue jsKeyboardEventLocation(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSKeyboardEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "KeyboardEvent", "location");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.location());
    return JSValue::encode(result);
}


EncodedJSValue jsKeyboardEventKeyLocation(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSKeyboardEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "KeyboardEvent", "keyLocation");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.location());
    return JSValue::encode(result);
}


EncodedJSValue jsKeyboardEventCtrlKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSKeyboardEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "KeyboardEvent", "ctrlKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.ctrlKey());
    return JSValue::encode(result);
}


EncodedJSValue jsKeyboardEventShiftKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSKeyboardEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "KeyboardEvent", "shiftKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.shiftKey());
    return JSValue::encode(result);
}


EncodedJSValue jsKeyboardEventAltKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSKeyboardEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "KeyboardEvent", "altKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.altKey());
    return JSValue::encode(result);
}


EncodedJSValue jsKeyboardEventMetaKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSKeyboardEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "KeyboardEvent", "metaKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.metaKey());
    return JSValue::encode(result);
}


EncodedJSValue jsKeyboardEventAltGraphKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSKeyboardEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "KeyboardEvent", "altGraphKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.altGraphKey());
    return JSValue::encode(result);
}


EncodedJSValue jsKeyboardEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSKeyboardEventPrototype* domObject = jsDynamicCast<JSKeyboardEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSKeyboardEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSKeyboardEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSKeyboardEventPrototype* domObject = jsDynamicCast<JSKeyboardEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSKeyboardEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSKeyboardEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsKeyboardEventPrototypeFunctionInitKeyboardEvent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSKeyboardEvent*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "KeyboardEvent", "initKeyboardEvent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSKeyboardEvent::info());
    auto& impl = castedThis->wrapped();
    String type = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool canBubble = state->argument(1).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool cancelable = state->argument(2).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    DOMWindow* view = JSDOMWindow::toWrapped(state->argument(3));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String keyIdentifier = state->argument(4).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned location = toUInt32(state, state->argument(5), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool ctrlKey = state->argument(6).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool altKey = state->argument(7).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool shiftKey = state->argument(8).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool metaKey = state->argument(9).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool altGraphKey = state->argument(10).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.initKeyboardEvent(type, canBubble, cancelable, view, keyIdentifier, location, ctrlKey, altKey, shiftKey, metaKey, altGraphKey);
    return JSValue::encode(jsUndefined());
}


}
