/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageData.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsImageDataWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsImageDataHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsImageDataConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSImageDataConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSImageDataPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSImageDataPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSImageDataPrototype* ptr = new (NotNull, JSC::allocateCell<JSImageDataPrototype>(vm.heap)) JSImageDataPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSImageDataPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSImageData> JSImageDataConstructor;

static inline EncodedJSValue constructJSImageData1(ExecState* state)
{
    auto* castedThis = jsCast<JSImageDataConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    RefPtr<Uint8ClampedArray> data = toUint8ClampedArray(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned sw = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned sh = toUInt32(state, state->argument(2), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<ImageData> object = ImageData::create(data, sw, sh, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

static inline EncodedJSValue constructJSImageData2(ExecState* state)
{
    auto* castedThis = jsCast<JSImageDataConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned sw = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    unsigned sh = toUInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<ImageData> object = ImageData::create(sw, sh, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> EncodedJSValue JSC_HOST_CALL JSImageDataConstructor::construct(ExecState* state)
{
    size_t argsCount = std::min<size_t>(3, state->argumentCount());
    JSValue arg0(state->argument(0));
    if ((argsCount == 2 && ((arg0.isObject() && asObject(arg0)->inherits(JSUint8ClampedArray::info())))) || (argsCount == 3 && ((arg0.isObject() && asObject(arg0)->inherits(JSUint8ClampedArray::info())))))
        return constructJSImageData1(state);
    if (argsCount == 2)
        return constructJSImageData2(state);
    if (argsCount < 2)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

template<> JSValue JSImageDataConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSImageDataConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSImageData::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ImageData"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(2), ReadOnly | DontEnum);
}

template<> const ClassInfo JSImageDataConstructor::s_info = { "ImageData", &Base::s_info, 0, CREATE_METHOD_TABLE(JSImageDataConstructor) };

/* Hash table for prototype */

static const HashTableValue JSImageDataPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageDataConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSImageDataConstructor) } },
    { "width", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageDataWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "height", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageDataHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSImageDataPrototype::s_info = { "ImageDataPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSImageDataPrototype) };

void JSImageDataPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSImageDataPrototypeTableValues, *this);
}

const ClassInfo JSImageData::s_info = { "ImageData", &Base::s_info, 0, CREATE_METHOD_TABLE(JSImageData) };

JSImageData::JSImageData(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ImageData>&& impl)
    : JSDOMWrapper<ImageData>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSImageData::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSImageDataPrototype::create(vm, globalObject, JSImageDataPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSImageData::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSImageData>(vm, globalObject);
}

void JSImageData::destroy(JSC::JSCell* cell)
{
    JSImageData* thisObject = static_cast<JSImageData*>(cell);
    thisObject->JSImageData::~JSImageData();
}

EncodedJSValue jsImageDataWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSImageData*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ImageData", "width");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.width());
    return JSValue::encode(result);
}


EncodedJSValue jsImageDataHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSImageData*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ImageData", "height");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.height());
    return JSValue::encode(result);
}


EncodedJSValue jsImageDataConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSImageDataPrototype* domObject = jsDynamicCast<JSImageDataPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSImageData::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSImageDataConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSImageDataPrototype* domObject = jsDynamicCast<JSImageDataPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSImageData::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSImageDataConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSImageDataOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSImageDataOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsImageData = jsCast<JSImageData*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsImageData->wrapped(), jsImageData);
}

ImageData* JSImageData::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSImageData*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
