/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLSelectElement.h"

#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "HTMLOptionElement.h"
#include "HTMLOptionsCollection.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLFormElement.h"
#include "JSHTMLOptionElement.h"
#include "JSHTMLOptionsCollection.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "URL.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionNamedItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionAdd(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionRemove(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionCheckValidity(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionSetCustomValidity(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsHTMLSelectElementAutofocus(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementAutofocus(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSelectElementDisabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementDisabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSelectElementForm(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLSelectElementMultiple(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementMultiple(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSelectElementName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementName(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSelectElementRequired(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementRequired(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSelectElementSize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementSize(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSelectElementType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLSelectElementOptions(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLSelectElementLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSelectElementSelectedOptions(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLSelectElementSelectedIndex(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementSelectedIndex(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSelectElementValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSelectElementWillValidate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLSelectElementValidity(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLSelectElementValidationMessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLSelectElementLabels(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLSelectElementAutocomplete(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementAutocomplete(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSelectElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSelectElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLSelectElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLSelectElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLSelectElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLSelectElementPrototype>(vm.heap)) JSHTMLSelectElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLSelectElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLSelectElement> JSHTMLSelectElementConstructor;

template<> JSValue JSHTMLSelectElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLSelectElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLSelectElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLSelectElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLSelectElementConstructor::s_info = { "HTMLSelectElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLSelectElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLSelectElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementConstructor) } },
    { "autofocus", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementAutofocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementAutofocus) } },
    { "disabled", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementDisabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementDisabled) } },
    { "form", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementForm), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "multiple", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementMultiple), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementMultiple) } },
    { "name", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementName) } },
    { "required", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementRequired), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementRequired) } },
    { "size", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementSize) } },
    { "type", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "options", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementOptions), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "length", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementLength) } },
    { "selectedOptions", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementSelectedOptions), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "selectedIndex", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementSelectedIndex), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementSelectedIndex) } },
    { "value", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementValue) } },
    { "willValidate", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementWillValidate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validity", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementValidity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validationMessage", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementValidationMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "labels", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementLabels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "autocomplete", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementAutocomplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSelectElementAutocomplete) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionItem), (intptr_t) (1) } },
    { "namedItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionNamedItem), (intptr_t) (0) } },
    { "add", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionAdd), (intptr_t) (1) } },
    { "remove", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionRemove), (intptr_t) (0) } },
    { "checkValidity", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionCheckValidity), (intptr_t) (0) } },
    { "setCustomValidity", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionSetCustomValidity), (intptr_t) (1) } },
};

const ClassInfo JSHTMLSelectElementPrototype::s_info = { "HTMLSelectElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLSelectElementPrototype) };

void JSHTMLSelectElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLSelectElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLSelectElement::s_info = { "HTMLSelectElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLSelectElement) };

JSHTMLSelectElement::JSHTMLSelectElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLSelectElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLSelectElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLSelectElementPrototype::create(vm, globalObject, JSHTMLSelectElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLSelectElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLSelectElement>(vm, globalObject);
}

bool JSHTMLSelectElement::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLSelectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex && optionalIndex.value() < thisObject->wrapped().length()) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    return false;
}

bool JSHTMLSelectElement::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLSelectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index < thisObject->wrapped().length()) {
        unsigned attributes = DontDelete;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsHTMLSelectElementAutofocus(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "autofocus");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.fastHasAttribute(WebCore::HTMLNames::autofocusAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementDisabled(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "disabled");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.fastHasAttribute(WebCore::HTMLNames::disabledAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementForm(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "form");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.form()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementMultiple(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "multiple");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.multiple());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getNameAttribute());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementRequired(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "required");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.fastHasAttribute(WebCore::HTMLNames::requiredAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementSize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "size");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.size());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementOptions(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "options");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.options()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementSelectedOptions(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "selectedOptions");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.selectedOptions()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementSelectedIndex(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "selectedIndex");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.selectedIndex());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "value");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.value());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementWillValidate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "willValidate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.willValidate());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementValidity(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "validity");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.validity()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementValidationMessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "validationMessage");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.validationMessage());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementLabels(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "labels");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.labels()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementAutocomplete(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSelectElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSelectElement", "autocomplete");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.autocomplete());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSelectElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLSelectElementPrototype* domObject = jsDynamicCast<JSHTMLSelectElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLSelectElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLSelectElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLSelectElementPrototype* domObject = jsDynamicCast<JSHTMLSelectElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSHTMLSelectElement::put(JSCell* cell, ExecState* state, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLSelectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (Optional<uint32_t> index = parseIndex(propertyName)) {
        thisObject->indexSetter(state, index.value(), value);
        return;
    }
    Base::put(thisObject, state, propertyName, value, slot);
}

void JSHTMLSelectElement::putByIndex(JSCell* cell, ExecState* state, unsigned index, JSValue value, bool shouldThrow)
{
    auto* thisObject = jsCast<JSHTMLSelectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index <= MAX_ARRAY_INDEX) {
        thisObject->indexSetter(state, index, value);
        return;
    }
    Base::putByIndex(cell, state, index, value, shouldThrow);
}

void setJSHTMLSelectElementAutofocus(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSelectElement* castedThis = jsDynamicCast<JSHTMLSelectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSelectElement", "autofocus");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, nativeValue);
}


void setJSHTMLSelectElementDisabled(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSelectElement* castedThis = jsDynamicCast<JSHTMLSelectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSelectElement", "disabled");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBooleanAttribute(WebCore::HTMLNames::disabledAttr, nativeValue);
}


void setJSHTMLSelectElementMultiple(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSelectElement* castedThis = jsDynamicCast<JSHTMLSelectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSelectElement", "multiple");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMultiple(nativeValue);
}


void setJSHTMLSelectElementName(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSelectElement* castedThis = jsDynamicCast<JSHTMLSelectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSelectElement", "name");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, nativeValue);
}


void setJSHTMLSelectElementRequired(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSelectElement* castedThis = jsDynamicCast<JSHTMLSelectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSelectElement", "required");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBooleanAttribute(WebCore::HTMLNames::requiredAttr, nativeValue);
}


void setJSHTMLSelectElementSize(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSelectElement* castedThis = jsDynamicCast<JSHTMLSelectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSelectElement", "size");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSize(nativeValue);
}


void setJSHTMLSelectElementLength(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSelectElement* castedThis = jsDynamicCast<JSHTMLSelectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSelectElement", "length");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    unsigned nativeValue = toUInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLength(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLSelectElementSelectedIndex(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSelectElement* castedThis = jsDynamicCast<JSHTMLSelectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSelectElement", "selectedIndex");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSelectedIndex(nativeValue);
}


void setJSHTMLSelectElementValue(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSelectElement* castedThis = jsDynamicCast<JSHTMLSelectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSelectElement", "value");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setValue(nativeValue);
}


void setJSHTMLSelectElementAutocomplete(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSelectElement* castedThis = jsDynamicCast<JSHTMLSelectElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSelectElement", "autocomplete");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAutocomplete(nativeValue);
}


void JSHTMLSelectElement::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSHTMLSelectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

JSValue JSHTMLSelectElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLSelectElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLSelectElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLSelectElement", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLSelectElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionNamedItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLSelectElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLSelectElement", "namedItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLSelectElement::info());
    auto& impl = castedThis->wrapped();
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.namedItem(name)));
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionAdd1(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLSelectElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLSelectElement", "add");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLSelectElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLElement* element = JSHTMLElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    HTMLElement* before = JSHTMLElement::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.add(element, before, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionAdd2(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLSelectElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLSelectElement", "add");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLSelectElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    HTMLElement* element = JSHTMLElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int index = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.add(element, index, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionAdd(ExecState* state)
{
    size_t argsCount = std::min<size_t>(2, state->argumentCount());
    JSValue arg0(state->argument(0));
    JSValue arg1(state->argument(1));
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSHTMLElement::info())))) || (argsCount == 2 && ((arg0.isObject() && asObject(arg0)->inherits(JSHTMLElement::info()))) && (arg1.isUndefined() || arg1.isNull() || (arg1.isObject() && asObject(arg1)->inherits(JSHTMLElement::info())))))
        return jsHTMLSelectElementPrototypeFunctionAdd1(state);
    if ((argsCount == 1 && ((arg0.isObject() && asObject(arg0)->inherits(JSHTMLElement::info())))) || (argsCount == 2 && ((arg0.isObject() && asObject(arg0)->inherits(JSHTMLElement::info())))))
        return jsHTMLSelectElementPrototypeFunctionAdd2(state);
    if (argsCount < 1)
        return throwVMError(state, createNotEnoughArgumentsError(state));
    return throwVMTypeError(state);
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionRemove(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLSelectElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLSelectElement", "remove");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLSelectElement::info());
    return JSValue::encode(castedThis->remove(*state));
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionCheckValidity(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLSelectElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLSelectElement", "checkValidity");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLSelectElement::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionSetCustomValidity(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLSelectElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLSelectElement", "setCustomValidity");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLSelectElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String error = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}

void JSHTMLSelectElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLSelectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
