/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(METER_ELEMENT)

#include "JSHTMLMeterElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNodeList.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLMeterElementValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMeterElementValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementMin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMeterElementMin(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementMax(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMeterElementMax(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementLow(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMeterElementLow(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementHigh(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMeterElementHigh(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementOptimum(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMeterElementOptimum(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementLabels(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMeterElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMeterElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLMeterElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLMeterElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLMeterElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLMeterElementPrototype>(vm.heap)) JSHTMLMeterElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLMeterElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLMeterElement> JSHTMLMeterElementConstructor;

template<> JSValue JSHTMLMeterElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLMeterElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLMeterElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLMeterElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLMeterElementConstructor::s_info = { "HTMLMeterElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMeterElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLMeterElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementConstructor) } },
    { "value", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementValue) } },
    { "min", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementMin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementMin) } },
    { "max", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementMax), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementMax) } },
    { "low", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementLow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementLow) } },
    { "high", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementHigh), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementHigh) } },
    { "optimum", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementOptimum), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementOptimum) } },
    { "labels", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementLabels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSHTMLMeterElementPrototype::s_info = { "HTMLMeterElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMeterElementPrototype) };

void JSHTMLMeterElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLMeterElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLMeterElement::s_info = { "HTMLMeterElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMeterElement) };

JSHTMLMeterElement::JSHTMLMeterElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLMeterElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLMeterElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLMeterElementPrototype::create(vm, globalObject, JSHTMLMeterElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLMeterElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLMeterElement>(vm, globalObject);
}

EncodedJSValue jsHTMLMeterElementValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMeterElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMeterElement", "value");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.value());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMeterElementMin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMeterElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMeterElement", "min");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.min());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMeterElementMax(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMeterElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMeterElement", "max");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.max());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMeterElementLow(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMeterElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMeterElement", "low");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.low());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMeterElementHigh(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMeterElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMeterElement", "high");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.high());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMeterElementOptimum(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMeterElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMeterElement", "optimum");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.optimum());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMeterElementLabels(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMeterElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMeterElement", "labels");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.labels()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMeterElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLMeterElementPrototype* domObject = jsDynamicCast<JSHTMLMeterElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLMeterElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLMeterElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLMeterElementPrototype* domObject = jsDynamicCast<JSHTMLMeterElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLMeterElementValue(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMeterElement* castedThis = jsDynamicCast<JSHTMLMeterElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMeterElement", "value");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setValue(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLMeterElementMin(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMeterElement* castedThis = jsDynamicCast<JSHTMLMeterElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMeterElement", "min");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMin(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLMeterElementMax(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMeterElement* castedThis = jsDynamicCast<JSHTMLMeterElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMeterElement", "max");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMax(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLMeterElementLow(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMeterElement* castedThis = jsDynamicCast<JSHTMLMeterElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMeterElement", "low");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLow(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLMeterElementHigh(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMeterElement* castedThis = jsDynamicCast<JSHTMLMeterElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMeterElement", "high");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHigh(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLMeterElementOptimum(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMeterElement* castedThis = jsDynamicCast<JSHTMLMeterElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMeterElement", "optimum");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setOptimum(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSHTMLMeterElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMeterElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHTMLMeterElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLMeterElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}

#endif // ENABLE(METER_ELEMENT)
