/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeolocation.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionGetCurrentPosition(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionWatchPosition(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionClearWatch(JSC::ExecState*);

class JSGeolocationPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSGeolocationPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGeolocationPrototype* ptr = new (NotNull, JSC::allocateCell<JSGeolocationPrototype>(vm.heap)) JSGeolocationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGeolocationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSGeolocationPrototypeTableValues[] =
{
    { "getCurrentPosition", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsGeolocationPrototypeFunctionGetCurrentPosition), (intptr_t) (1) } },
    { "watchPosition", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsGeolocationPrototypeFunctionWatchPosition), (intptr_t) (1) } },
    { "clearWatch", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsGeolocationPrototypeFunctionClearWatch), (intptr_t) (1) } },
};

const ClassInfo JSGeolocationPrototype::s_info = { "GeolocationPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSGeolocationPrototype) };

void JSGeolocationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGeolocationPrototypeTableValues, *this);
}

const ClassInfo JSGeolocation::s_info = { "Geolocation", &Base::s_info, 0, CREATE_METHOD_TABLE(JSGeolocation) };

JSGeolocation::JSGeolocation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Geolocation>&& impl)
    : JSDOMWrapper<Geolocation>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSGeolocation::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSGeolocationPrototype::create(vm, globalObject, JSGeolocationPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSGeolocation::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSGeolocation>(vm, globalObject);
}

void JSGeolocation::destroy(JSC::JSCell* cell)
{
    JSGeolocation* thisObject = static_cast<JSGeolocation*>(cell);
    thisObject->JSGeolocation::~JSGeolocation();
}

EncodedJSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionGetCurrentPosition(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSGeolocation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Geolocation", "getCurrentPosition");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSGeolocation::info());
    return JSValue::encode(castedThis->getCurrentPosition(*state));
}

EncodedJSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionWatchPosition(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSGeolocation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Geolocation", "watchPosition");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSGeolocation::info());
    return JSValue::encode(castedThis->watchPosition(*state));
}

EncodedJSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionClearWatch(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSGeolocation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Geolocation", "clearWatch");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSGeolocation::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    int watchID = toInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.clearWatch(watchID);
    return JSValue::encode(jsUndefined());
}

bool JSGeolocationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsGeolocation = jsCast<JSGeolocation*>(handle.slot()->asCell());
    Frame* root = WTF::getPtr(jsGeolocation->wrapped().frame());
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSGeolocationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGeolocation = jsCast<JSGeolocation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGeolocation->wrapped(), jsGeolocation);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Geolocation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11GeolocationE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Geolocation* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSGeolocation>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Geolocation* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSGeolocation>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Geolocation@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11GeolocationE[2];
#if COMPILER(CLANG)
    // If this fails Geolocation does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Geolocation), Geolocation_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Geolocation has subclasses. If Geolocation has subclasses that get passed
    // to toJS() we currently require Geolocation you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSGeolocation>(globalObject, impl);
}

Geolocation* JSGeolocation::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGeolocation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GEOLOCATION)
