/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFontFace.h"

#include "Dictionary.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <bindings/ScriptValue.h>
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFontFacePrototypeFunctionLoad(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsFontFaceFamily(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceFamily(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceStyle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceStyle(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceWeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceWeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceStretch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceStretch(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceUnicodeRange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceUnicodeRange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceVariant(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceVariant(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceFeatureSettings(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceFeatureSettings(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceStatus(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFontFaceLoaded(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFontFaceConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFontFaceConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSFontFacePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSFontFacePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFontFacePrototype* ptr = new (NotNull, JSC::allocateCell<JSFontFacePrototype>(vm.heap)) JSFontFacePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFontFacePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSFontFace> JSFontFaceConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSFontFaceConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSFontFaceConstructor*>(state->callee());
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String family = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue source = { state->vm(), state->argument(1) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Dictionary descriptors = { state, state->argument(2) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "FontFace");
    RefPtr<FontFace> object = FontFace::create(*state, *context, family, source, descriptors, ec);
    if (ec) {
        setDOMException(state, ec);
        return JSValue::encode(JSValue());
    }
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSFontFaceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFontFaceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFontFace::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("FontFace"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(3), ReadOnly | DontEnum);
}

template<> const ClassInfo JSFontFaceConstructor::s_info = { "FontFace", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFontFaceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFontFacePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceConstructor) } },
    { "family", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceFamily), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceFamily) } },
    { "style", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceStyle) } },
    { "weight", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceWeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceWeight) } },
    { "stretch", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceStretch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceStretch) } },
    { "unicodeRange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceUnicodeRange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceUnicodeRange) } },
    { "variant", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceVariant), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceVariant) } },
    { "featureSettings", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceFeatureSettings), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceFeatureSettings) } },
    { "status", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceStatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "loaded", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceLoaded), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "load", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsFontFacePrototypeFunctionLoad), (intptr_t) (0) } },
};

const ClassInfo JSFontFacePrototype::s_info = { "FontFacePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFontFacePrototype) };

void JSFontFacePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFontFacePrototypeTableValues, *this);
}

const ClassInfo JSFontFace::s_info = { "FontFace", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFontFace) };

JSFontFace::JSFontFace(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FontFace>&& impl)
    : JSDOMWrapper<FontFace>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSFontFace::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSFontFacePrototype::create(vm, globalObject, JSFontFacePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSFontFace::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFontFace>(vm, globalObject);
}

void JSFontFace::destroy(JSC::JSCell* cell)
{
    JSFontFace* thisObject = static_cast<JSFontFace*>(cell);
    thisObject->JSFontFace::~JSFontFace();
}

EncodedJSValue jsFontFaceFamily(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFace*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFace", "family");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.family());
    return JSValue::encode(result);
}


EncodedJSValue jsFontFaceStyle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFace*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFace", "style");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.style());
    return JSValue::encode(result);
}


EncodedJSValue jsFontFaceWeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFace*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFace", "weight");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.weight());
    return JSValue::encode(result);
}


EncodedJSValue jsFontFaceStretch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFace*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFace", "stretch");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.stretch());
    return JSValue::encode(result);
}


EncodedJSValue jsFontFaceUnicodeRange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFace*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFace", "unicodeRange");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.unicodeRange());
    return JSValue::encode(result);
}


EncodedJSValue jsFontFaceVariant(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFace*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFace", "variant");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.variant());
    return JSValue::encode(result);
}


EncodedJSValue jsFontFaceFeatureSettings(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFace*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFace", "featureSettings");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.featureSettings());
    return JSValue::encode(result);
}


EncodedJSValue jsFontFaceStatus(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFace*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFace", "status");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.status());
    return JSValue::encode(result);
}


EncodedJSValue jsFontFaceLoaded(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFontFace*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "FontFace", "loaded");
    }
    return JSValue::encode(castedThis->loaded(*state));
}


EncodedJSValue jsFontFaceConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSFontFacePrototype* domObject = jsDynamicCast<JSFontFacePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSFontFace::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSFontFaceConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSFontFacePrototype* domObject = jsDynamicCast<JSFontFacePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSFontFaceFamily(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSFontFace* castedThis = jsDynamicCast<JSFontFace*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "FontFace", "family");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setFamily(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSFontFaceStyle(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSFontFace* castedThis = jsDynamicCast<JSFontFace*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "FontFace", "style");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setStyle(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSFontFaceWeight(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSFontFace* castedThis = jsDynamicCast<JSFontFace*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "FontFace", "weight");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setWeight(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSFontFaceStretch(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSFontFace* castedThis = jsDynamicCast<JSFontFace*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "FontFace", "stretch");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setStretch(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSFontFaceUnicodeRange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSFontFace* castedThis = jsDynamicCast<JSFontFace*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "FontFace", "unicodeRange");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setUnicodeRange(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSFontFaceVariant(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSFontFace* castedThis = jsDynamicCast<JSFontFace*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "FontFace", "variant");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setVariant(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSFontFaceFeatureSettings(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSFontFace* castedThis = jsDynamicCast<JSFontFace*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "FontFace", "featureSettings");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setFeatureSettings(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSFontFace::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFontFaceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFontFacePrototypeFunctionLoad(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSFontFace*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "FontFace", "load");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSFontFace::info());
    return JSValue::encode(castedThis->load(*state));
}

void JSFontFace::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSFontFace*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(&thisObject->m_loaded);
}

bool JSFontFaceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSFontFaceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFontFace = jsCast<JSFontFace*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFontFace->wrapped(), jsFontFace);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FontFace@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8FontFaceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, FontFace* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSFontFace>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, FontFace* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSFontFace>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7FontFace@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore8FontFaceE[2];
#if COMPILER(CLANG)
    // If this fails FontFace does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(FontFace), FontFace_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // FontFace has subclasses. If FontFace has subclasses that get passed
    // to toJS() we currently require FontFace you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSFontFace>(globalObject, impl);
}

FontFace* JSFontFace::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFontFace*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
