/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDataTransfer.h"

#include "ExceptionCode.h"
#include "FileList.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSElement.h"
#include "JSFileList.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(DATA_TRANSFER_ITEMS)
#include "DataTransferItemList.h"
#include "JSDataTransferItemList.h"
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionClearData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionGetData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionSetData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionSetDragImage(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDataTransferDropEffect(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDataTransferDropEffect(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDataTransferEffectAllowed(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDataTransferEffectAllowed(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDataTransferTypes(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDataTransferFiles(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(DATA_TRANSFER_ITEMS)
JSC::EncodedJSValue jsDataTransferItems(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsDataTransferConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDataTransferConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDataTransferPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDataTransferPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDataTransferPrototype* ptr = new (NotNull, JSC::allocateCell<JSDataTransferPrototype>(vm.heap)) JSDataTransferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDataTransferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSDataTransfer> JSDataTransferConstructor;

template<> JSValue JSDataTransferConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDataTransferConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDataTransfer::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("DataTransfer"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDataTransferConstructor::s_info = { "DataTransfer", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDataTransferConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDataTransferPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDataTransferConstructor) } },
    { "dropEffect", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferDropEffect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDataTransferDropEffect) } },
    { "effectAllowed", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferEffectAllowed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDataTransferEffectAllowed) } },
    { "types", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferTypes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "files", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferFiles), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(DATA_TRANSFER_ITEMS)
    { "items", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferItems), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "clearData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDataTransferPrototypeFunctionClearData), (intptr_t) (0) } },
    { "getData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDataTransferPrototypeFunctionGetData), (intptr_t) (1) } },
    { "setData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDataTransferPrototypeFunctionSetData), (intptr_t) (2) } },
    { "setDragImage", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDataTransferPrototypeFunctionSetDragImage), (intptr_t) (3) } },
};

const ClassInfo JSDataTransferPrototype::s_info = { "DataTransferPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDataTransferPrototype) };

void JSDataTransferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDataTransferPrototypeTableValues, *this);
}

const ClassInfo JSDataTransfer::s_info = { "DataTransfer", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDataTransfer) };

JSDataTransfer::JSDataTransfer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DataTransfer>&& impl)
    : JSDOMWrapper<DataTransfer>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDataTransfer::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDataTransferPrototype::create(vm, globalObject, JSDataTransferPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSDataTransfer::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDataTransfer>(vm, globalObject);
}

void JSDataTransfer::destroy(JSC::JSCell* cell)
{
    JSDataTransfer* thisObject = static_cast<JSDataTransfer*>(cell);
    thisObject->JSDataTransfer::~JSDataTransfer();
}

EncodedJSValue jsDataTransferDropEffect(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDataTransfer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DataTransfer", "dropEffect");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.dropEffect());
    return JSValue::encode(result);
}


EncodedJSValue jsDataTransferEffectAllowed(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDataTransfer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DataTransfer", "effectAllowed");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.effectAllowed());
    return JSValue::encode(result);
}


EncodedJSValue jsDataTransferTypes(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDataTransfer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DataTransfer", "types");
    }
    return JSValue::encode(castedThis->types(*state));
}


EncodedJSValue jsDataTransferFiles(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDataTransfer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DataTransfer", "files");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.files()));
    return JSValue::encode(result);
}


#if ENABLE(DATA_TRANSFER_ITEMS)
EncodedJSValue jsDataTransferItems(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDataTransfer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DataTransfer", "items");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.items()));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsDataTransferConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDataTransferPrototype* domObject = jsDynamicCast<JSDataTransferPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDataTransfer::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDataTransferConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDataTransferPrototype* domObject = jsDynamicCast<JSDataTransferPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSDataTransferDropEffect(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDataTransfer* castedThis = jsDynamicCast<JSDataTransfer*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DataTransfer", "dropEffect");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDropEffect(nativeValue);
}


void setJSDataTransferEffectAllowed(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDataTransfer* castedThis = jsDynamicCast<JSDataTransfer*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DataTransfer", "effectAllowed");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setEffectAllowed(nativeValue);
}


JSValue JSDataTransfer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDataTransferConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionClearData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDataTransfer*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DataTransfer", "clearData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDataTransfer::info());
    auto& impl = castedThis->wrapped();

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.clearData();
        return JSValue::encode(jsUndefined());
    }

    String type = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.clearData(type);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionGetData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDataTransfer*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DataTransfer", "getData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDataTransfer::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String type = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.getData(type));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionSetData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDataTransfer*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DataTransfer", "setData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDataTransfer::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String type = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String data = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setData(type, data);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionSetDragImage(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDataTransfer*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DataTransfer", "setDragImage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDataTransfer::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    Element* image = JSElement::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int x = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int y = toInt32(state, state->argument(2), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setDragImage(image, x, y);
    return JSValue::encode(jsUndefined());
}

bool JSDataTransferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSDataTransferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDataTransfer = jsCast<JSDataTransfer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDataTransfer->wrapped(), jsDataTransfer);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DataTransfer* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDataTransfer>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DataTransfer* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDataTransfer>(globalObject, impl))
        return result;
    return createNewWrapper<JSDataTransfer>(globalObject, impl);
}

DataTransfer* JSDataTransfer::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDataTransfer*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
